/*
 * Decompiled with CFR 0.152.
 */
package imcode.external.chat;

import imcode.external.chat.Chat;
import imcode.external.chat.ChatConstants;
import imcode.external.chat.ChatGroup;
import imcode.external.chat.ChatMember;
import imcode.external.chat.ChatSessionsSingleton;
import imcode.external.chat.ChatSystemMessage;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.WebAppGlobalConstants;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import imcode.util.log.DailyRollingFileAppender;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;

public class ChatBase
extends HttpServlet
implements ChatConstants {
    private static final String DATE_PATTERN = ".yyyy-MM-dd";
    private static final int CHAT_PROPERTY_USER_MAY_CHOOSE = 3;
    private static final int CHAT_PROPERTY_DISABLED = 2;

    private LoggingEvent getLoggingEvent(String msg) {
        return new LoggingEvent(MockLogger.class.getName(), (Category)new MockLogger("mock"), Priority.INFO, (Object)msg, null);
    }

    private static DailyRollingFileAppender createAppender(File filePath) throws IOException {
        String fileName = filePath.getPath();
        PatternLayout layout = new PatternLayout("%d{ISO8601} %m%n");
        DailyRollingFileAppender appender = new DailyRollingFileAppender((Layout)layout, fileName, DATE_PATTERN);
        return appender;
    }

    private static File getLogFile(String metaId) {
        File filePath = new File(WebAppGlobalConstants.getInstance().getAbsoluteWebAppPath() + "/WEB-INF/logs/", "chat-" + metaId + ".log");
        return filePath;
    }

    protected void chatlog(String metaId, String msg) throws IOException {
        File logFile = ChatBase.getLogFile(metaId);
        DailyRollingFileAppender appender = ChatBase.createAppender(logFile);
        appender.doAppend(this.getLoggingEvent(msg));
    }

    protected Chat createChat(int metaId) {
        String[] params;
        ImcmsServices imcref = Imcms.getServices();
        Vector msgTypes = this.convert2Vector(imcref.sqlProcedureMulti("C_GetTheMsgTypesBase", new String[0]));
        Vector autTypes = this.convert2Vector(imcref.sqlProcedureMulti("C_GetAuthorizationTypes", new String[0]));
        Chat myChat = new Chat(metaId, autTypes, msgTypes);
        String[] selAuto = imcref.sqlProcedure("C_GetChatAutoTypes", new String[]{"" + metaId});
        if (selAuto == null) {
            selAuto = new String[]{"1"};
        } else if (selAuto.length == 0) {
            selAuto = new String[]{"1"};
        }
        myChat.setSelectedAuto(selAuto);
        String[][] messages = imcref.sqlProcedureMulti("C_GetMsgTypes", new String[]{"" + metaId});
        if (messages != null && messages.length > 0) {
            myChat.setMsgTypes(this.convert2Vector(messages));
        }
        if ((params = imcref.sqlProcedure("C_GetChatParameters ", new String[]{"" + metaId})) != null && params.length == 7) {
            myChat.setRefreshTime(Integer.parseInt(params[0]));
            myChat.setAutoRefreshEnabled(Integer.parseInt(params[1]));
            myChat.setShowEnterAndLeaveMessagesEnabled(Integer.parseInt(params[2]));
            myChat.setShowPrivateMessagesEnabled(Integer.parseInt(params[3]));
            myChat.setShowDateTimesEnabled(Integer.parseInt(params[5]));
            myChat.setFontSize(Integer.parseInt(params[6]));
        }
        return myChat;
    }

    protected static String createOptionCode(Vector selected, Vector data) {
        StringBuffer buff = new StringBuffer("");
        for (int i = 0; i < data.size(); i += 2) {
            buff.append("<option value=\"" + data.elementAt(i).toString() + "\"");
            for (int e = 0; e < selected.size(); ++e) {
                String sel = selected.elementAt(e).toString();
                if (sel == null || !data.elementAt(i).toString().equals(sel)) continue;
                buff.append(" selected ");
            }
            buff.append(">");
            buff.append(data.elementAt(i + 1).toString() + "</option>\n");
        }
        return buff.toString();
    }

    protected static String createOptionCode(String selected, Vector data) {
        StringBuffer buff = new StringBuffer("");
        for (int i = 0; i < data.size(); i += 2) {
            buff.append("<option value=\"" + data.elementAt(i).toString() + "\"");
            if (selected != null && data.elementAt(i).toString().equals(selected)) {
                buff.append(" selected ");
            }
            buff.append(">");
            buff.append(data.elementAt(i + 1).toString() + "</option>");
        }
        return buff.toString();
    }

    protected static String createRadioButton(String buttonName, Vector data, String selected) {
        StringBuffer buff = new StringBuffer("");
        for (int i = 0; i < data.size(); ++i) {
            buff.append("<input type=\"radio\" name=\"" + buttonName + "\" value=\"");
            buff.append(data.elementAt(i).toString() + "\"");
            if (selected == null) {
                selected = "3";
            }
            if (data.elementAt(i).toString().equals(selected)) {
                buff.append(" checked ");
            }
            buff.append(">\n");
        }
        return buff.toString();
    }

    protected int getMetaId(HttpServletRequest req) {
        HttpSession session;
        String metaId = req.getParameter("meta_id");
        if (metaId == null && (session = req.getSession(false)) != null) {
            metaId = (String)session.getAttribute("Chat.meta_id");
        }
        return Integer.parseInt(metaId);
    }

    protected UserDomainObject getUserObj(HttpServletRequest req) {
        UserDomainObject user = Utility.getLoggedOnUser(req);
        return user;
    }

    protected Properties getSessionParameters(HttpServletRequest req) {
        HttpSession session = req.getSession(true);
        String metaId = (String)session.getAttribute("Chat.meta_id") == null ? "" : (String)session.getAttribute("Chat.meta_id");
        String parentId = (String)session.getAttribute("Chat.parent_meta_id") == null ? "" : (String)session.getAttribute("Chat.parent_meta_id");
        Properties reqParams = new Properties();
        reqParams.setProperty("META_ID", metaId);
        reqParams.setProperty("PARENT_META_ID", parentId);
        return reqParams;
    }

    protected void getExtSessionParameters(HttpServletRequest req, Properties params) {
        String discId;
        HttpSession session = req.getSession(true);
        String forumId = (String)session.getAttribute("Chat.forum_id") == null ? "" : (String)session.getAttribute("Chat.forum_id");
        String string = discId = (String)session.getAttribute("Chat.disc_id") == null ? "" : (String)session.getAttribute("Chat.disc_id");
        if (params == null) {
            params = new Properties();
        }
        params.setProperty("FORUM_ID", forumId);
        params.setProperty("DISC_ID", discId);
    }

    protected static String getTemplateSetDirectoryName(int meta_id) {
        String libName = Imcms.getServices().sqlProcedureStr("C_GetTemplateLib", new String[]{"" + meta_id});
        if (libName == null) {
            libName = "original";
        }
        return libName;
    }

    protected void sendHtml(HttpServletRequest req, HttpServletResponse res, Vector vect, String template, Chat chat) throws IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        int metaId = chat != null ? chat.getChatId() : this.getMetaId(req);
        String templateSet = ChatBase.getTemplateSetDirectoryName(metaId);
        Utility.setDefaultHtmlContentType(res);
        ServletOutputStream out = res.getOutputStream();
        String htmlStr = imcref.getTemplateFromSubDirectoryOfDirectory(template, user, vect, "103", templateSet);
        out.print(htmlStr);
        out.flush();
        out.close();
    }

    protected Vector convert2Vector(String[] arr) {
        Vector<String> rolesV = new Vector<String>();
        for (int i = 0; i < arr.length; ++i) {
            rolesV.add(arr[i]);
        }
        return rolesV;
    }

    protected synchronized Vector convert2Vector(String[][] arr) {
        Vector<String> rolesV = new Vector<String>();
        for (int i = 0; i < arr.length; ++i) {
            for (int e = 0; e < arr[i].length; ++e) {
                rolesV.add(arr[i][e]);
            }
        }
        return rolesV;
    }

    protected String getExternalImageFolder(HttpServletRequest req) {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        String lang_prefix = imcref.getDefaultLanguage();
        if (user != null) {
            lang_prefix = user.getLanguageIso639_2();
        }
        int metaId = this.getMetaId(req);
        String extFolder = "/imcms/" + lang_prefix + "/images/" + imcref.getDocType(metaId) + '/';
        extFolder = extFolder + ChatBase.getTemplateSetDirectoryName(metaId);
        return extFolder;
    }

    protected boolean isUserAuthorized(HttpServletRequest req, HttpServletResponse res, UserDomainObject user) throws IOException {
        boolean authorized;
        HttpSession session = req.getSession(true);
        String stringMetaId = (String)session.getAttribute("Chat.meta_id");
        if (stringMetaId == null) {
            authorized = false;
            Utility.redirectToStartDocument(req, res);
        } else {
            int metaId = Integer.parseInt(stringMetaId);
            authorized = this.isUserAuthorized(res, metaId, user, req);
        }
        return authorized;
    }

    protected boolean isUserAuthorized(HttpServletResponse res, int metaId, UserDomainObject user, HttpServletRequest req) throws IOException {
        ImcmsServices imcref = Imcms.getServices();
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        DocumentDomainObject document = documentMapper.getDocument(metaId);
        boolean authorized = user.canAccess(document);
        if (!authorized) {
            Utility.redirectToStartDocument(req, res);
        }
        return authorized;
    }

    protected boolean userHasAdminRights(ImcmsServices imcref, int metaId, UserDomainObject user) {
        return imcref.checkDocAdminRights(metaId, user) && imcref.checkDocAdminRights(metaId, user, 65536);
    }

    protected synchronized void prepareChatBoardSettings(ChatMember member, HttpServletRequest req, boolean memberIsInChat) {
        HttpSession session = req.getSession(true);
        Chat chat = member.getParent();
        member.setShowDateTimesEnabled(ChatBase.isShowDateTimesEnabled(chat, memberIsInChat, req));
        member.setShowPrivateMessagesEnabled(ChatBase.isShowPrivateMessagesEnabled(chat, memberIsInChat, req));
        member.setShowEnterAndLeaveMessagesEnabled(ChatBase.isShowEnterAndLeaveMessagesEnabled(chat, memberIsInChat, req));
        member.setAutoRefreshEnabled(ChatBase.isAutoRefreshEnabled(chat, memberIsInChat, req));
        if (member.isAutoRefreshEnabled() && req.getParameter("updateinterval") != null) {
            member.setRefreshTime(Integer.parseInt(req.getParameter("updateinterval")));
        }
        member.setFontSize(ChatBase.getFontSize(chat, req));
        session.setAttribute("theChatMember", (Object)member);
    }

    private static int getFontSize(Chat chat, HttpServletRequest req) {
        int fonSize = chat.getfontSize();
        if (req.getParameter("font") != null) {
            fonSize = Integer.parseInt(req.getParameter("font"));
        }
        return fonSize;
    }

    private static boolean isAutoRefreshEnabled(Chat chat, boolean memberIsInChat, HttpServletRequest req) {
        int reload = chat.isAutoRefreshEnabled();
        boolean onOff = reload == 2 ? false : (memberIsInChat ? (reload == 3 ? req.getParameter("reload") != null : false) : true);
        return onOff;
    }

    private static boolean isShowEnterAndLeaveMessagesEnabled(Chat chat, boolean bool, HttpServletRequest req) {
        int inOut = chat.isShowEnterAndLeaveMessagesEnabled();
        boolean onOff = inOut == 2 ? false : (bool ? (inOut == 3 ? req.getParameter("inOut") != null : true) : true);
        return onOff;
    }

    private static boolean isShowDateTimesEnabled(Chat chat, boolean bool, HttpServletRequest req) {
        int dateTime = chat.isShowDateTimesEnabled();
        boolean onOff = dateTime == 2 ? false : (bool ? (dateTime == 3 ? req.getParameter("dateTime") != null : true) : false);
        return onOff;
    }

    private static boolean isShowPrivateMessagesEnabled(Chat chat, boolean bool, HttpServletRequest req) {
        int privat = chat.isShowPrivateMessagesEnabled();
        boolean onOff = privat == 2 ? false : (bool ? (privat == 3 ? req.getParameter("private") != null : true) : true);
        return onOff;
    }

    protected static void cleanUpSessionParams(HttpSession session) {
        if (session.getAttribute("theChatMember") != null) {
            ChatMember myMember = (ChatMember)session.getAttribute("theChatMember");
            Chat myChat = myMember.getParent();
            ChatGroup myGroup = myMember.getGroup();
            int senderNr = myMember.getMemberId();
            ChatSessionsSingleton.removeSession(myMember);
            myGroup.removeGroupMember(myMember);
            myChat.removeChatMember(senderNr);
        }
        try {
            session.removeAttribute("theChatMember");
            session.removeAttribute("theRoom");
            session.removeAttribute("myChat");
            session.removeAttribute("Chat.meta_id");
            session.removeAttribute("Chat.parent_meta_id");
            session.removeAttribute("Chat.forum_id");
            session.removeAttribute("Chat.disc_id");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    void createLeaveMessageAndAddToGroup(ChatMember myMember, ChatSystemMessage systemMessage, ImcmsServices imcref) throws ServletException, IOException {
        Chat theChat = myMember.getParent();
        UserDomainObject user = myMember.getUser();
        ChatGroup myGroup = myMember.getGroup();
        String metaId = "" + theChat.getChatId();
        myGroup.addNewMsg(this, systemMessage, imcref);
        String libName = ChatBase.getTemplateSetDirectoryName(theChat.getChatId());
        this.chatlog(metaId, systemMessage.getLogMsg(imcref, user, libName));
    }

    protected void createEnterMessageAndAddToGroup(Chat theChat, ImcmsServices imcref, UserDomainObject user, ChatMember myMember, ChatGroup myGroup, String metaId) throws ServletException, IOException {
        ChatSystemMessage systemMessage = new ChatSystemMessage(myMember, 1);
        myGroup.addNewMsg(this, systemMessage, imcref);
        String libName = ChatBase.getTemplateSetDirectoryName(theChat.getChatId());
        this.chatlog(metaId, systemMessage.getLogMsg(imcref, user, libName));
    }

    protected void createKickOutMessageAndAddToGroup(ChatMember kickedOutPerson, Chat myChat, ImcmsServices imcref, UserDomainObject user, ChatGroup myGroup, String metaId) throws ServletException, IOException {
        ChatSystemMessage systemMessage = new ChatSystemMessage(kickedOutPerson, 3);
        myGroup.addNewMsg(this, systemMessage, imcref);
        String libName = ChatBase.getTemplateSetDirectoryName(myChat.getChatId());
        this.chatlog(metaId, systemMessage.getLogMsg(imcref, user, libName));
    }

    protected void logOutMember(ChatMember myMember, ChatSystemMessage systemMessage, ImcmsServices imcref) throws IOException, ServletException {
        HttpSession session = ChatSessionsSingleton.removeSession(myMember);
        if (session != null) {
            ChatBase.cleanUpSessionParams(session);
            if (systemMessage != null) {
                this.createLeaveMessageAndAddToGroup(myMember, systemMessage, imcref);
            }
        }
    }

    protected String getTemplate(String htmlFile, UserDomainObject user, List tagsAndData) {
        return Imcms.getServices().getTemplateFromSubDirectoryOfDirectory(htmlFile, user, tagsAndData, "103", "original");
    }

    private class MockLogger
    extends Logger {
        private MockLogger(String name) {
            super(name);
        }
    }
}

