/*
 * Decompiled with CFR 0.152.
 */
package imcode.external.chat;

import imcode.external.chat.ChatGroup;
import imcode.external.chat.ChatMember;
import imcode.external.chat.Counter;
import imcode.server.user.UserDomainObject;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Chat {
    private int _chatId;
    private String _name = "";
    private Hashtable _chatMembers;
    private Vector _chatMsgTypes;
    private ChatGroup chatGroup = new ChatGroup();
    private static Counter _memberCounter = new Counter();
    private static Counter _msgTypeCounter;
    private int _updateTime = 30;
    private int _reload = 3;
    private int _inOut = 3;
    private int _privat = 3;
    private int _publik = 3;
    private int _dateTime = 3;
    private int _font = 3;
    private int _fontSize = 2;
    private Vector _authorization;
    private Vector _authorizationSelected;

    public Chat(int metaId, Vector authorization, Vector msgTypes) {
        this._chatId = metaId;
        this._authorization = authorization;
        this._chatMsgTypes = msgTypes;
        this._chatMembers = new Hashtable();
        this._authorizationSelected = new Vector();
        _msgTypeCounter = new Counter();
        _msgTypeCounter.setStartValue(200);
    }

    public void setSelectedAuto(String[] arr) {
        this._authorizationSelected.clear();
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                this._authorizationSelected.add(arr[i]);
            }
        }
    }

    public Vector getSelectedAuto() {
        return (Vector)this._authorizationSelected.clone();
    }

    public boolean settingsPage() {
        return this._reload == 3 || this._inOut == 3 || this._privat == 3 || this._publik == 3 || this._dateTime == 3 || this._font == 3;
    }

    public int getRefreshTime() {
        return this._updateTime;
    }

    public void setRefreshTime(int time) {
        this._updateTime = time;
    }

    public int isAutoRefreshEnabled() {
        return this._reload;
    }

    public void setAutoRefreshEnabled(int reload) {
        this._reload = reload;
    }

    public int isShowEnterAndLeaveMessagesEnabled() {
        return this._inOut;
    }

    public void setShowEnterAndLeaveMessagesEnabled(int inOut) {
        this._inOut = inOut;
    }

    public int isShowPrivateMessagesEnabled() {
        return this._privat;
    }

    public void setShowPrivateMessagesEnabled(int privat) {
        this._privat = privat;
    }

    public int isShowPublicMessagesEnabled() {
        return this._publik;
    }

    public int isShowDateTimesEnabled() {
        return this._dateTime;
    }

    public void setShowDateTimesEnabled(int dateTime) {
        this._dateTime = dateTime;
    }

    public int getfont() {
        return this._font;
    }

    public void setFontSize(int font) {
        this._font = font;
    }

    public int getfontSize() {
        return this._fontSize;
    }

    public Vector getAuthorizations() {
        return (Vector)this._authorization.clone();
    }

    public String getChatName() {
        return this._name == null ? "" : this._name;
    }

    public int getChatId() {
        return this._chatId;
    }

    public ChatMember createChatMember(UserDomainObject user, int referrerMetaId) {
        _memberCounter.increment();
        int memberNumber = _memberCounter.getValue();
        ChatMember newMember = new ChatMember(memberNumber, this, user, referrerMetaId);
        this._chatMembers.put(String.valueOf(memberNumber), newMember);
        return newMember;
    }

    public boolean hasMemberName(String name) {
        Enumeration enumeration = this._chatMembers.elements();
        while (enumeration.hasMoreElements()) {
            ChatMember temp = (ChatMember)enumeration.nextElement();
            if (!name.equalsIgnoreCase(temp.getName())) continue;
            return true;
        }
        return false;
    }

    public void removeChatMember(int memberNumber) {
        String memberNumberString = String.valueOf(memberNumber);
        this._chatMembers.remove(memberNumberString);
    }

    public ChatMember getChatMember(int memberNumber) {
        String memberNumberString = String.valueOf(memberNumber);
        return (ChatMember)this._chatMembers.get(memberNumberString);
    }

    public ChatGroup getChatGroup() {
        return this.chatGroup;
    }

    public String toString() {
        return "ChatId: " + this._chatId + " ChatName: " + this._name;
    }

    public Vector getMsgTypes() {
        return this._chatMsgTypes;
    }

    public void setMsgTypes(Vector v) {
        this._chatMsgTypes = v;
    }

    public void removeMsgType(int msgTypeId) {
        int nr = this._chatMsgTypes.indexOf(Integer.toString(msgTypeId));
        this._chatMsgTypes.remove(nr);
        this._chatMsgTypes.remove(nr);
    }

    public void addMsgType(String newType) {
        _msgTypeCounter.increment();
        this._chatMsgTypes.add(Integer.toString(_msgTypeCounter.getValue()));
        this._chatMsgTypes.add(newType);
    }
}

