/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class ImageSize
implements Serializable {
    private int width;
    private int height;

    public ImageSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        return this.width + "*" + this.height;
    }

    public static ImageSize fromInputStream(InputStream inputStream) throws IOException {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
        Iterator<ImageReader> imageReadersIterator = ImageIO.getImageReaders(imageInputStream);
        if (!imageReadersIterator.hasNext()) {
            throw new IOException("Can't read image format.");
        }
        ImageReader imageReader = imageReadersIterator.next();
        imageReader.setInput(imageInputStream, true, true);
        int width = imageReader.getWidth(0);
        int height = imageReader.getHeight(0);
        imageReader.dispose();
        return new ImageSize(width, height);
    }
}

