/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.servlet.superadmin.AdminError;
import com.imcode.imcms.servlet.superadmin.Administrator;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.RolePermissionDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Html;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AdminRoles
extends Administrator {
    private static final Logger log = Logger.getLogger((String)AdminRoles.class.getName());
    private String HTML_TEMPLATE;
    private String HTML_ADMIN_ROLES;
    private String HTML_ADD_ROLE;
    private String HTML_RENAME_ROLE;
    private String HTML_DELETE_ROLE_1;
    private String HTML_DELETE_ROLE_2;
    private String HTML_EDIT_ROLE;
    private String HTML_EDIT_ROLE_TABLE;
    private String HTML_EDIT_ROLE_TABLE_ROW;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            String header = "Error in AdminRoles.";
            Properties langproperties = imcref.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/global/no_administrator") + "<br>";
            log.debug((Object)(header + "- user is not an administrator"));
            new AdminError(req, res, header, msg);
            return;
        }
        if (req.getParameter("ADD_NEW_ROLE") != null || req.getParameter("RENAME_ROLE") != null || req.getParameter("DELETE_ROLE") != null || req.getParameter("UPDATE_ROLE_PERMISSIONS") != null || req.getParameter("CANCEL_ROLE") != null) {
            String[] rolesArr = imcref.sqlProcedure("RoleAdminGetAll", new String[0]);
            Vector<String> rolesV = new Vector<String>(Arrays.asList(rolesArr));
            VariableManager vm = new VariableManager();
            String opt = Html.createOptionList(rolesV, Arrays.asList(""));
            vm.addProperty("ROLES_MENU", opt);
            this.sendHtml(req, res, vm, this.HTML_ADMIN_ROLES);
            return;
        }
        VariableManager vm = new VariableManager();
        this.sendHtml(req, res, vm, this.HTML_TEMPLATE);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String msg;
        Properties langproperties;
        String header;
        Properties params;
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            String header2 = "Error in AdminRoles.";
            Properties langproperties2 = imcref.getLanguageProperties(user);
            String msg2 = langproperties2.getProperty("error/servlet/global/no_administrator") + "<br>";
            log.debug((Object)(header2 + "- user is not an administrator"));
            new AdminError(req, res, header2, msg2);
            return;
        }
        if (req.getParameter("VIEW_ADMIN_ROLES") != null) {
            String[] rolesArr = imcref.sqlProcedure("RoleAdminGetAll", new String[0]);
            Vector<String> rolesV = new Vector<String>(Arrays.asList(rolesArr));
            VariableManager vm = new VariableManager();
            String opt = Html.createOptionList("", rolesV);
            vm.addProperty("ROLES_MENU", opt);
            this.sendHtml(req, res, vm, this.HTML_ADMIN_ROLES);
            return;
        }
        if (req.getParameter("VIEW_ADMIN_ROLE_BELONGINGS") != null) {
            res.sendRedirect("AdminRoleBelongings");
            return;
        }
        if (req.getParameter("CANCEL") != null) {
            res.sendRedirect("AdminManager");
            return;
        }
        if (req.getParameter("CANCEL_ROLE") != null) {
            this.doGet(req, res);
            return;
        }
        if (req.getParameter("CANCEL_ROLE_ADMIN") != null) {
            this.doGet(req, res);
            return;
        }
        if (req.getParameter("VIEW_ADD_NEW_ROLE") != null) {
            String languagePrefix = user.getLanguageIso639_2();
            RolePermissionDomainObject[] allRolePermissions = RoleDomainObject.getAllRolePermissions();
            String[][] permissionList = new String[allRolePermissions.length][];
            for (int i = 0; i < permissionList.length; ++i) {
                RolePermissionDomainObject rolePermission = allRolePermissions[i];
                permissionList[i] = new String[]{"0", "" + rolePermission.getId(), rolePermission.getDescription().toLocalizedString(req)};
            }
            String permissionComponent = this.createPermissionComponent(req, permissionList);
            VariableManager vm = new VariableManager();
            vm.addProperty("ROLE_PERMISSIONS", permissionComponent);
            this.sendHtml(req, res, vm, this.HTML_ADD_ROLE);
            return;
        }
        if (req.getParameter("VIEW_RENAME_ROLE") != null) {
            String roleId = req.getParameter("ROLE_ID");
            if (roleId == null) {
                String header3 = "Roles error";
                Properties langproperties3 = imcref.getLanguageProperties(user);
                String msg3 = langproperties3.getProperty("error/servlet/AdminRoles/rolename_missing") + "<BR>";
                log.debug((Object)"Error in rename roles, no role selected for rename");
                new AdminError(req, res, header3, msg3);
                return;
            }
            String currRoleName = imcref.sqlProcedureStr("RoleGetName", new String[]{roleId});
            VariableManager vm = new VariableManager();
            vm.addProperty("CURRENT_ROLE_ID", roleId);
            vm.addProperty("CURRENT_ROLE_NAME", "" + currRoleName);
            this.sendHtml(req, res, vm, this.HTML_RENAME_ROLE);
            return;
        }
        if (req.getParameter("VIEW_EDIT_ROLE") != null) {
            String roleIdStr = req.getParameter("ROLE_ID");
            if (roleIdStr == null) {
                String header4 = "Error in AdminRoles, edit role";
                Properties langproperties4 = imcref.getLanguageProperties(user);
                String msg4 = langproperties4.getProperty("error/servlet/AdminRoles/role_missing") + "<br>";
                log.debug((Object)(header4 + "- select the role to be changed"));
                new AdminError(req, res, header4, msg4);
                return;
            }
            if (roleIdStr.equals("0")) {
                String header5 = "Error in AdminRoles, edit role";
                String msg5 = "<BR>";
                log.debug((Object)"Error in checking roles: Trying to look att superadmin permissions");
                new AdminError(req, res, header5, msg5);
                return;
            }
            String languagePrefix = user.getLanguageIso639_2();
            int roleId = Integer.parseInt(roleIdStr);
            ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserAndRoleMapper = Imcms.getServices().getImcmsAuthenticatorAndUserAndRoleMapper();
            RoleDomainObject role = imcmsAuthenticatorAndUserAndRoleMapper.getRoleById(roleId);
            RolePermissionDomainObject[] allRolePermissions = RoleDomainObject.getAllRolePermissions();
            String[][] permissionList = new String[allRolePermissions.length][];
            for (int i = 0; i < permissionList.length; ++i) {
                RolePermissionDomainObject rolePermission = allRolePermissions[i];
                int rolePermissionId = rolePermission.getId();
                permissionList[i] = new String[3];
                permissionList[i][0] = role.hasPermission(rolePermission) ? "" + rolePermissionId : "0";
                permissionList[i][1] = "" + rolePermissionId;
                permissionList[i][2] = "" + rolePermission.getDescription().toLocalizedString(req);
            }
            String permissionComponent = this.createPermissionComponent(req, permissionList);
            VariableManager vm = new VariableManager();
            vm.addProperty("CURRENT_ROLE_NAME", imcref.sqlProcedureStr("RoleGetName", new String[]{roleIdStr}));
            vm.addProperty("CURRENT_ROLE_ID", roleIdStr);
            vm.addProperty("ROLE_PERMISSIONS", permissionComponent);
            this.sendHtml(req, res, vm, this.HTML_EDIT_ROLE);
            return;
        }
        if (req.getParameter("ADD_NEW_ROLE") != null) {
            Properties params2 = this.getAddRoleParameters(req);
            if (!super.assertNoEmptyStringsInPropertyValues(params2)) {
                String header6 = "Error in AdminRoles ";
                Properties langproperties5 = imcref.getLanguageProperties(user);
                String msg6 = langproperties5.getProperty("error/servlet/AdminRoles/new_rolename_missing") + "<br>";
                log.debug((Object)(header6 + "- new rolename missing"));
                new AdminError(req, res, header6, msg6);
                return;
            }
            String foundRoleName = imcref.sqlProcedureStr("RoleFindName", new String[]{(String)params2.get("ROLE_NAME")});
            if (!foundRoleName.equalsIgnoreCase("-1")) {
                String header7 = "Error in AdminRoles.";
                Properties langproperties6 = imcref.getLanguageProperties(user);
                String msg7 = langproperties6.getProperty("error/servlet/AdminRoles/rolename_already_exists") + "<br>";
                log.debug((Object)(header7 + "- role name already exists"));
                new AdminError(req, res, header7, msg7);
                return;
            }
            String[] checkedPermissions = req.getParameterValues("PERMISSION_CHECKBOX");
            int permissionValue = this.collectPermissionsState(checkedPermissions);
            RoleDomainObject role = new RoleDomainObject(params2.getProperty("ROLE_NAME"));
            role.addUnionOfPermissionIdsToRole(permissionValue);
            imcref.getImcmsAuthenticatorAndUserAndRoleMapper().saveRole(role);
            this.doGet(req, res);
            return;
        }
        if (req.getParameter("RENAME_ROLE") != null) {
            Properties params3 = this.getRenameRoleParameters(req);
            if (!super.assertNoEmptyStringsInPropertyValues(params3)) {
                String header8 = "Error in AdminRoles, rename role ";
                Properties langproperties7 = imcref.getLanguageProperties(user);
                String msg8 = langproperties7.getProperty("error/servlet/AdminRoles/new_rolename_missing") + "<br>";
                log.debug((Object)(header8 + "- new role name is missing"));
                new AdminError(req, res, header8, msg8);
                return;
            }
            String foundRoleName = imcref.sqlProcedureStr("RoleFindName", new String[]{params3.getProperty("ROLE_NAME")});
            if (!foundRoleName.equalsIgnoreCase("-1")) {
                String header9 = "Error in AdminRoles.";
                Properties langproperties8 = imcref.getLanguageProperties(user);
                String msg9 = langproperties8.getProperty("error/servlet/AdminRoles/rolename_already_exists") + "<br>";
                log.debug((Object)(header9 + "- rolename already exists"));
                new AdminError(req, res, header9, msg9);
                return;
            }
            String sqlQ = "RoleUpdateName";
            log.debug((Object)("Sql: " + sqlQ));
            imcref.sqlUpdateProcedure(sqlQ, new String[]{params3.getProperty("ROLE_ID"), params3.getProperty("ROLE_NAME")});
            this.doGet(req, res);
            return;
        }
        boolean warnDelRole = false;
        if (req.getParameter("VIEW_DELETE_ROLE") != null) {
            params = this.getDeleteRoleParameters(req);
            if (!super.assertNoEmptyStringsInPropertyValues(params)) {
                String header10 = "Error in AdminRoles ";
                Properties langproperties9 = imcref.getLanguageProperties(user);
                String msg10 = langproperties9.getProperty("error/servlet/AdminRoles/role_to_delete_missing") + "<br>";
                log.debug((Object)(header10 + "- no role was selected for delete"));
                new AdminError(req, res, header10, msg10);
                return;
            }
            String[] affectedMetaIds = imcref.sqlProcedure("RoleDeleteViewAffectedMetaIds", new String[]{params.getProperty("ROLE_ID")});
            String roleCount = imcref.sqlProcedureStr("RoleCount", new String[]{params.getProperty("ROLE_ID")});
            String[] affectedUsers = imcref.sqlProcedure("RoleDeleteViewAffectedUsers", new String[]{params.getProperty("ROLE_ID")});
            int userCount = affectedUsers.length / 2;
            if (affectedUsers.length != 0 || affectedMetaIds.length != 0) {
                String opt = Html.createOptionList("", new Vector<String>(Arrays.asList(affectedMetaIds)));
                String users = Html.createOptionList("", new Vector<String>(Arrays.asList(affectedUsers)));
                VariableManager vm = new VariableManager();
                vm.addProperty("META_ID_LIST", opt);
                vm.addProperty("USER_ID_LIST", users);
                vm.addProperty("USER_COUNT", "" + userCount);
                vm.addProperty("ROLE_COUNT", roleCount);
                vm.addProperty("CURRENT_ROLE_ID", params.get("ROLE_ID"));
                this.sendHtml(req, res, vm, this.HTML_DELETE_ROLE_1);
                return;
            }
            warnDelRole = true;
        }
        if (req.getParameter("WARN_DELETE_ROLE") != null || warnDelRole) {
            params = this.getDeleteRoleParameters(req);
            if (!super.assertNoEmptyStringsInPropertyValues(params)) {
                header = "Error in AdminRoles, delete ";
                langproperties = imcref.getLanguageProperties(user);
                msg = langproperties.getProperty("error/servlet/AdminRoles/role_to_delete_missing") + "<br>";
                log.debug((Object)(header + "- no role was selected for delete"));
                new AdminError(req, res, header, msg);
                return;
            }
            VariableManager vm = new VariableManager();
            vm.addProperty("CURRENT_ROLE_ID", params.get("ROLE_ID"));
            this.sendHtml(req, res, vm, this.HTML_DELETE_ROLE_2);
            return;
        }
        if (req.getParameter("DELETE_ROLE") != null) {
            params = this.getDeleteRoleParameters(req);
            if (!super.assertNoEmptyStringsInPropertyValues(params)) {
                header = "Error in AdminRoles, delete";
                langproperties = imcref.getLanguageProperties(user);
                msg = langproperties.getProperty("error/servlet/AdminRoles/role_to_delete_missing") + "<br>";
                log.debug((Object)(header + "- no role was selected for delete"));
                new AdminError(req, res, header, msg);
                return;
            }
            imcref.sqlUpdateProcedure("RoleDelete", new String[]{params.getProperty("ROLE_ID")});
            this.doGet(req, res);
            return;
        }
        if (req.getParameter("UPDATE_ROLE_PERMISSIONS") != null) {
            params = this.getEditRoleParameters(req);
            String[] checkedPermissions = req.getParameterValues("PERMISSION_CHECKBOX");
            if (!super.assertNoEmptyStringsInPropertyValues(params)) {
                String header11 = "Error in AdminRoles ";
                Properties langproperties10 = imcref.getLanguageProperties(user);
                String msg11 = langproperties10.getProperty("error/servlet/AdminRoles/role_to_delete_missing") + "<br>";
                log.debug((Object)(header11 + "- no role was selected for delete"));
                new AdminError(req, res, header11, msg11);
                return;
            }
            int permissionValue = this.collectPermissionsState(checkedPermissions);
            imcref.sqlUpdateProcedure("RoleUpdatePermissions", new String[]{params.getProperty("ROLE_ID"), "" + permissionValue});
            this.doGet(req, res);
        }
    }

    private Properties getAddRoleParameters(HttpServletRequest req) {
        Properties roleInfoP = new Properties();
        String roleInfo = req.getParameter("ROLE_NAME") == null ? "" : req.getParameter("ROLE_NAME");
        roleInfoP.setProperty("ROLE_NAME", roleInfo);
        return roleInfoP;
    }

    private Properties getRenameRoleParameters(HttpServletRequest req) {
        Properties roleInfoP = new Properties();
        String roleId = req.getParameter("ROLE_ID") == null ? "" : req.getParameter("ROLE_ID");
        String roleInfo = req.getParameter("ROLE_NAME") == null ? "" : req.getParameter("ROLE_NAME");
        roleInfoP.setProperty("ROLE_ID", roleId);
        roleInfoP.setProperty("ROLE_NAME", roleInfo);
        return roleInfoP;
    }

    private Properties getDeleteRoleParameters(HttpServletRequest req) {
        Properties roleInfoP = new Properties();
        String roleInfo = req.getParameter("ROLE_ID") == null ? "" : req.getParameter("ROLE_ID");
        roleInfoP.setProperty("ROLE_ID", roleInfo);
        return roleInfoP;
    }

    private Properties getEditRoleParameters(HttpServletRequest req) {
        Properties roleInfoP = new Properties();
        String roleInfo = req.getParameter("ROLE_ID") == null ? "" : req.getParameter("ROLE_ID");
        roleInfoP.put("ROLE_ID", roleInfo);
        return roleInfoP;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.HTML_TEMPLATE = "AdminRoles.htm";
        this.HTML_ADMIN_ROLES = "AdminRoles_roles.htm";
        this.HTML_ADD_ROLE = "AdminRoles_Add.htm";
        this.HTML_RENAME_ROLE = "AdminRoles_Rename.htm";
        this.HTML_DELETE_ROLE_1 = "AdminRoles_Delete1.htm";
        this.HTML_DELETE_ROLE_2 = "AdminRoles_Delete2.htm";
        this.HTML_EDIT_ROLE = "AdminRoles_Edit.html";
        this.HTML_EDIT_ROLE_TABLE = "AdminRoles_Edit_Permissions_List.html";
        this.HTML_EDIT_ROLE_TABLE_ROW = "AdminRoles_Edit_Permission.html";
    }

    private String createPermissionComponent(HttpServletRequest req, String[][] permissionList) throws IOException {
        StringBuffer permissionTableRows = new StringBuffer();
        for (int i = 0; i < permissionList.length; ++i) {
            String permissionId = permissionList[i][1];
            String description = permissionList[i][2];
            boolean isChecked = !permissionList[i][0].equals("0");
            VariableManager vm = new VariableManager();
            vm.addProperty("PERMISSION_DESCRIPTION", description);
            vm.addProperty("PERMISSON_ID", permissionId);
            if (isChecked) {
                vm.addProperty("PERMISSION_CHECKED", "checked");
            } else {
                vm.addProperty("PERMISSION_CHECKED", "");
            }
            String rowString = this.createHtml(req, vm, this.HTML_EDIT_ROLE_TABLE_ROW);
            permissionTableRows.append(rowString);
        }
        VariableManager vmTable = new VariableManager();
        vmTable.addProperty("PERMISSION_ROWS", permissionTableRows.toString());
        return this.createHtml(req, vmTable, this.HTML_EDIT_ROLE_TABLE);
    }

    private int collectPermissionsState(String[] checkedPermissions) {
        int permissionValue = 0;
        if (checkedPermissions != null) {
            for (int i = 0; i < checkedPermissions.length; ++i) {
                int permissionId = 0;
                try {
                    permissionId = Integer.parseInt(checkedPermissions[i]);
                }
                catch (NumberFormatException e) {
                    log.debug((Object)"Error in checking roles: NumberFormatException");
                }
                permissionValue |= permissionId;
            }
        }
        return permissionValue;
    }
}

