/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.servlet.superadmin.Administrator;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import imcode.util.fortune.DateRange;
import imcode.util.fortune.Quote;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AdminRandomTextsFile
extends Administrator {
    private static final String HTML_TEMPLATE = "admin_random_texts_file.html";
    private static final String DATE_ERROR = "date_err_msg.frag";
    private static final String TEXT_ERROR = "text_err_msg.frag";
    private static final SimpleDateFormat dateForm = new SimpleDateFormat("yyMMdd");
    private static final long ONE_DAY = 86400000L;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        HttpSession session = req.getSession();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        String whichFile = (String)session.getAttribute("file");
        if (req.getParameter("back") != null || whichFile == null || "".equals(whichFile)) {
            res.sendRedirect("AdminRandomTexts");
            return;
        }
        ArrayList lines = (ArrayList)session.getAttribute("lines");
        String date1 = "";
        String date2 = "";
        String text = "";
        String errMsgDate = imcref.getTemplateFromDirectory(DATE_ERROR, user, null, "106");
        String errMsgTxt = imcref.getTemplateFromDirectory(TEXT_ERROR, user, null, "106");
        if (req.getParameter("save") != null) {
            this.addLineToList(req, lines);
            imcref.setQuoteList(whichFile + ".txt", lines);
            res.sendRedirect("AdminRandomTexts");
            return;
        }
        if (req.getParameter("add").equals("add")) {
            date1 = req.getParameter("date1").trim();
            date2 = req.getParameter("date2").trim();
            text = req.getParameter("text").trim();
            boolean ok = true;
            if (!this.checkDate(date1)) {
                date1 = errMsgDate;
                ok = false;
            }
            if (!this.checkDate(date2)) {
                date2 = errMsgDate;
                ok = false;
            }
            if (text.length() < 1) {
                text = errMsgTxt;
                ok = false;
            }
            if (ok) {
                this.addLineToList(req, lines);
                date1 = "";
                date2 = "";
                text = "";
            }
        } else if (req.getParameter("edit") != null) {
            String row = req.getParameter("AdminFile");
            if (row != null) {
                this.addLineToList(req, lines);
                int theRow = Integer.parseInt(row);
                Quote quote = (Quote)lines.get(theRow);
                DateRange dates = quote.getDateRange();
                date1 = dateForm.format(dates.getStartDate());
                date2 = dateForm.format(new Date(dates.getEndDate().getTime() - 86400000L));
                text = quote.getText();
                lines.remove(quote);
            } else {
                date1 = req.getParameter("date1").trim();
                date2 = req.getParameter("date2").trim();
                text = req.getParameter("text").trim();
            }
        } else if (req.getParameter("remove") != null) {
            String[] rows = req.getParameterValues("AdminFile");
            try {
                int i;
                HashMap rowMap = new HashMap();
                for (i = 0; i < lines.size(); ++i) {
                    rowMap.put(new Integer(i), lines.get(i));
                }
                for (i = 0; i < rows.length; ++i) {
                    if ("".equals(rows[i])) continue;
                    rowMap.remove(Integer.decode(rows[i]));
                }
                Object[] listIndexes = new Integer[rowMap.size()];
                listIndexes = rowMap.keySet().toArray(listIndexes);
                Arrays.sort(listIndexes);
                lines = new ArrayList(rowMap.size());
                for (int i2 = 0; i2 < listIndexes.length; ++i2) {
                    lines.add(rowMap.get(listIndexes[i2]));
                }
            }
            catch (NullPointerException ignored) {
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
        }
        session.setAttribute("lines", (Object)lines);
        StringBuffer buff = this.createOptionList(lines);
        Vector<String> values = new Vector<String>();
        values.add("#date1#");
        values.add(date1);
        values.add("#date2#");
        values.add(date2);
        values.add("#text#");
        values.add(text);
        values.add("#file#");
        values.add(whichFile);
        values.add("#options#");
        values.add(buff.toString());
        String parsed = imcref.getTemplateFromDirectory(HTML_TEMPLATE, user, values, "106");
        out.print(parsed);
    }

    private void addLineToList(HttpServletRequest req, List lines) {
        String date1 = req.getParameter("date1").trim();
        String date2 = req.getParameter("date2").trim();
        String text = req.getParameter("text").trim();
        if (text.length() > 1) {
            try {
                DateRange range = new DateRange(dateForm.parse(date1), new Date(dateForm.parse(date2).getTime() + 86400000L));
                Quote quote = new Quote(text, range);
                lines.add(quote);
            }
            catch (ParseException ignored) {
                // empty catch block
            }
        }
    }

    private boolean checkDate(String dateStr) {
        try {
            dateForm.parse(dateStr);
        }
        catch (ParseException pe) {
            return false;
        }
        return true;
    }

    private StringBuffer createOptionList(List lines) {
        StringBuffer buff = new StringBuffer();
        int counter = 0;
        Iterator iter = lines.iterator();
        while (iter.hasNext()) {
            Quote quote = (Quote)iter.next();
            DateRange dates = quote.getDateRange();
            buff.append("<option value=\"" + counter++ + "\">" + dateForm.format(dates.getStartDate()) + " " + dateForm.format(new Date(dates.getEndDate().getTime() - 86400000L)) + " " + quote.getText() + "</option>");
        }
        return buff;
    }
}

