/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.flow.DispatchCommand;
import com.imcode.imcms.flow.DocumentPageFlow;
import com.imcode.imcms.servlet.AdminManagerSearchPage;
import com.imcode.imcms.servlet.DocumentFinder;
import com.imcode.imcms.servlet.admin.AddDoc;
import com.imcode.imcms.servlet.beans.AdminManagerExpandableDatesBean;
import com.imcode.imcms.servlet.beans.AdminManagerSubreport;
import com.imcode.imcms.servlet.superadmin.Administrator;
import com.imcode.util.ChainableReversibleNullComparator;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentComparator;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.document.index.DocumentIndex;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.LocalizedMessage;
import imcode.util.Utility;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class AdminManager
extends Administrator {
    private static final String HTML_ADMINTASK = "AdminManager_adminTask_element.htm";
    private static final String HTML_USERADMINTASK = "AdminManager_useradminTask_element.htm";
    public static final String REQUEST_PARAMETER__SHOW = "show";
    public static final String PARAMETER_VALUE__SHOW_NEW = "new";
    public static final String PARAMETER_VALUE__SHOW_REMINDERS = "reminders";
    public static final String PARAMETER_VALUE__SHOW_SUMMARY = "summary";
    public static final String PARAMETER_VALUE__SHOW_SEARCH = "search";
    public static final int DEFAULT_DOCUMENTS_PER_LIST = 5;
    public static final String REQUEST_PARAMETER__FROMPAGE = "frompage";
    public static final String REQUEST_PARAMETER__CREATE_NEW_DOCUMENT = "create_new_document";
    public static final String REQUEST_PARAMETER__NEW_DOCUMENT_PARENT_ID = "parent_id";
    public static final String REQUEST_PARAMETER__CREATE_DOCUMENT_ACTION = "new_document_type_id";
    public static final String REQUEST_PARAMETER__ACTION__COPY = "copy";
    public static final String PAGE_SEARCH = "search";
    private static final LocalizedMessage ERROR_MESSAGE__NO_CREATE_PERMISSION = new LocalizedMessage("error/servlet/AdminManager/no_create_permission");
    private static final LocalizedMessage ERROR_MESSAGE__NO_PARENT_ID = new LocalizedMessage("error/servlet/AdminManager/no_parent_id");
    private static final LocalizedMessage ERROR_MESSAGE__PARENT_MUST_BE_TEXT_DOCUMENT = new LocalizedMessage("error/servlet/AdminManager/parent_must_be_text_document");

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.doPost(req, res);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block11: {
            ImcmsServices service = Imcms.getServices();
            UserDomainObject user = Utility.getLoggedOnUser(request);
            String whichButton = request.getParameter("AdminTask");
            if (null != whichButton) {
                String url = this.getAdminTaskUrl(whichButton);
                if (!user.isSuperAdmin() && !user.isUserAdmin()) {
                    Utility.forwardToLogin(request, response);
                    return;
                }
                if (StringUtils.isNotBlank((String)url)) {
                    response.sendRedirect(url);
                    return;
                }
            }
            if (!user.canAccessAdminPages()) {
                Utility.forwardToLogin(request, response);
                return;
            }
            DocumentMapper documentMapper = service.getDocumentMapper();
            if (Utility.parameterIsSet(request, REQUEST_PARAMETER__CREATE_NEW_DOCUMENT)) {
                try {
                    int parentId = Integer.parseInt(request.getParameter(REQUEST_PARAMETER__NEW_DOCUMENT_PARENT_ID));
                    DocumentDomainObject parentDocument = documentMapper.getDocument(parentId);
                    String createDocumentAction = request.getParameter(REQUEST_PARAMETER__CREATE_DOCUMENT_ACTION);
                    if (REQUEST_PARAMETER__ACTION__COPY.equals(createDocumentAction)) {
                        documentMapper.copyDocument(parentDocument, user);
                        this.createAndShowAdminManagerPage(request, response, null);
                        break block11;
                    }
                    if (!(parentDocument instanceof TextDocumentDomainObject)) {
                        this.createAndShowAdminManagerPage(request, response, ERROR_MESSAGE__PARENT_MUST_BE_TEXT_DOCUMENT);
                        return;
                    }
                    int documentTypeId = Integer.parseInt(createDocumentAction);
                    SaveNewDocumentCommand saveNewDocumentCommand = new SaveNewDocumentCommand();
                    ShowAdminManagerPageCommand returnCommand = new ShowAdminManagerPageCommand();
                    AddDoc.DocumentCreator documentCreator = new AddDoc.DocumentCreator(saveNewDocumentCommand, returnCommand, this.getServletContext());
                    documentCreator.createDocumentAndDispatchToCreatePageFlow(documentTypeId, parentDocument, request, response);
                }
                catch (NumberFormatException nfe) {
                    this.createAndShowAdminManagerPage(request, response, ERROR_MESSAGE__NO_PARENT_ID);
                }
                catch (SecurityException ex) {
                    this.createAndShowAdminManagerPage(request, response, ERROR_MESSAGE__NO_CREATE_PERMISSION);
                }
            } else {
                this.createAndShowAdminManagerPage(request, response, null);
            }
        }
    }

    private void createAndShowAdminManagerPage(HttpServletRequest request, HttpServletResponse response, LocalizedMessage errorMessage) throws IOException, ServletException {
        UserDomainObject loggedOnUser = Utility.getLoggedOnUser(request);
        ImcmsServices service = Imcms.getServices();
        DocumentMapper documentMapper = service.getDocumentMapper();
        String tabToShow = null != request.getParameter(REQUEST_PARAMETER__SHOW) ? request.getParameter(REQUEST_PARAMETER__SHOW) : PARAMETER_VALUE__SHOW_NEW;
        String html_admin_part = "";
        if (loggedOnUser.isSuperAdmin()) {
            html_admin_part = service.getAdminTemplate(HTML_ADMINTASK, loggedOnUser, null);
        } else if (loggedOnUser.isUserAdmin()) {
            html_admin_part = service.getAdminTemplate(HTML_USERADMINTASK, loggedOnUser, null);
        }
        DocumentIndex index = documentMapper.getDocumentIndex();
        TermQuery query = new TermQuery(new Term("creator_id", loggedOnUser.getId() + ""));
        DocumentDomainObject[] documentsFound = index.search((Query)query, loggedOnUser);
        AdminManagerSubreport newDocumentsSubreport = this.createNewDocumentsSubreport(documentsFound);
        AdminManagerSubreport modifiedDocumentsSubreport = this.createModifiedDocumentsSubreport(documentsFound);
        AdminManagerSubreport documentsArchivedWithinOneWeekSubreport = this.createDocumentsArchivedWithinOneWeekSubreport(documentsFound);
        AdminManagerSubreport documentsUnpublishedWithinOneWeekSubreport = this.createDocumentsUnpublishedWithinOneWeekSubreport(documentsFound);
        AdminManagerSubreport documentsUnmodifiedForSixMonthsSubreport = this.createDocumentsUnmodifiedForSixMonthsSubreport(documentsFound);
        AdminManagerSubreport[] subreports = new AdminManagerSubreport[]{newDocumentsSubreport, modifiedDocumentsSubreport, documentsArchivedWithinOneWeekSubreport, documentsUnpublishedWithinOneWeekSubreport, documentsUnmodifiedForSixMonthsSubreport};
        for (int i = 0; i < subreports.length; ++i) {
            AdminManagerSubreport subreport = subreports[i];
            String newSortOrder = request.getParameter(subreport.getName() + "_sortorder");
            if (null != newSortOrder) {
                subreport.setSortorder(newSortOrder);
            }
            Collections.sort(subreport.getDocuments(), AdminManager.getComparator(subreport.getSortorder()));
            boolean expanded = Utility.parameterIsSet(request, subreport.getName() + "_expand") && !Utility.parameterIsSet(request, subreport.getName() + "_unexpand");
            subreport.setExpanded(expanded);
        }
        AdminManagerPage adminManagerPage = null;
        if (tabToShow.equals(PARAMETER_VALUE__SHOW_NEW)) {
            newDocumentsSubreport.setMaxDocumentCount(10);
            AdminManagerPage newDocumentsAdminManagerPage = new AdminManagerPage();
            newDocumentsAdminManagerPage.setTabName(PARAMETER_VALUE__SHOW_NEW);
            newDocumentsAdminManagerPage.setHeading(new LocalizedMessage("web/imcms/lang/jsp/admin/admin_manager.jsp/tab_name/0"));
            newDocumentsAdminManagerPage.addSubreport(newDocumentsSubreport);
            modifiedDocumentsSubreport.setMaxDocumentCount(10);
            newDocumentsAdminManagerPage.addSubreport(modifiedDocumentsSubreport);
            adminManagerPage = newDocumentsAdminManagerPage;
        } else if (tabToShow.equals(PARAMETER_VALUE__SHOW_REMINDERS)) {
            AdminManagerPage reminderAdminManagerPage = new AdminManagerPage();
            reminderAdminManagerPage.setTabName(PARAMETER_VALUE__SHOW_REMINDERS);
            reminderAdminManagerPage.setHeading(new LocalizedMessage("web/imcms/lang/jsp/admin/admin_manager.jsp/tab_name/1"));
            documentsArchivedWithinOneWeekSubreport.setMaxDocumentCount(10);
            reminderAdminManagerPage.addSubreport(documentsArchivedWithinOneWeekSubreport);
            documentsUnpublishedWithinOneWeekSubreport.setMaxDocumentCount(10);
            reminderAdminManagerPage.addSubreport(documentsUnpublishedWithinOneWeekSubreport);
            documentsUnmodifiedForSixMonthsSubreport.setMaxDocumentCount(10);
            reminderAdminManagerPage.addSubreport(documentsUnmodifiedForSixMonthsSubreport);
            adminManagerPage = reminderAdminManagerPage;
        } else if (tabToShow.equals(PARAMETER_VALUE__SHOW_SUMMARY)) {
            AdminManagerPage summaryAdminManagerPage = new AdminManagerPage();
            summaryAdminManagerPage.setTabName(PARAMETER_VALUE__SHOW_SUMMARY);
            summaryAdminManagerPage.setHeading(new LocalizedMessage("web/imcms/lang/jsp/admin/admin_manager.jsp/tab_name/2"));
            summaryAdminManagerPage.addSubreport(newDocumentsSubreport);
            summaryAdminManagerPage.addSubreport(modifiedDocumentsSubreport);
            summaryAdminManagerPage.addSubreport(documentsArchivedWithinOneWeekSubreport);
            summaryAdminManagerPage.addSubreport(documentsUnpublishedWithinOneWeekSubreport);
            summaryAdminManagerPage.addSubreport(documentsUnmodifiedForSixMonthsSubreport);
            adminManagerPage = summaryAdminManagerPage;
        } else if (tabToShow.equals("search")) {
            AdminManagerPage searchAdminManagerPage = new AdminManagerPage(){

                public void forward(HttpServletRequest request, HttpServletResponse response, UserDomainObject user) throws IOException, ServletException {
                    AdminManagerSearchPage page = new AdminManagerSearchPage(this);
                    DocumentFinder documentFinder = new DocumentFinder(page);
                    documentFinder.setDocumentComparator(AdminManager.getComparator(null));
                    page.updateFromRequest(request);
                    documentFinder.addExtraSearchResultColumn(new DatesSummarySearchResultColumn());
                    documentFinder.forward(request, response);
                }
            };
            searchAdminManagerPage.setTabName("search");
            searchAdminManagerPage.setHeading(new LocalizedMessage("global/Search"));
            adminManagerPage = searchAdminManagerPage;
        }
        adminManagerPage.setErrorMessage(errorMessage);
        adminManagerPage.setHtmlAdminPart("".equals(html_admin_part) ? null : html_admin_part);
        adminManagerPage.forward(request, response, loggedOnUser);
    }

    private AdminManagerSubreport createModifiedDocumentsSubreport(DocumentDomainObject[] documentsFound) {
        ArrayList<DocumentDomainObject> modifiedDocuments = new ArrayList<DocumentDomainObject>();
        Date oneWeekAgo = this.getDateOneWeekAgo();
        for (int i = 0; i < documentsFound.length; ++i) {
            boolean modifiedInPastWeek;
            DocumentDomainObject document = documentsFound[i];
            boolean createdInPastWeek = !document.getCreatedDatetime().before(oneWeekAgo);
            boolean bl = modifiedInPastWeek = !document.getModifiedDatetime().before(oneWeekAgo);
            if (!modifiedInPastWeek || createdInPastWeek) continue;
            modifiedDocuments.add(document);
        }
        AdminManagerSubreport modifiedDocumentsSubreport = new AdminManagerSubreport();
        modifiedDocumentsSubreport.setName("modified");
        modifiedDocumentsSubreport.setDocuments(modifiedDocuments);
        modifiedDocumentsSubreport.setHeading(new LocalizedMessage("web/imcms/lang/jsp/admin/admin_manager.jsp/subreport_heading/5"));
        String dateSearchQueryString = this.createDateSearchQueryString("modified", oneWeekAgo, null, null);
        modifiedDocumentsSubreport.setSearchQueryString(dateSearchQueryString);
        return modifiedDocumentsSubreport;
    }

    private AdminManagerSubreport createNewDocumentsSubreport(DocumentDomainObject[] documentsFound) {
        ArrayList<DocumentDomainObject> newDocuments = new ArrayList<DocumentDomainObject>();
        Date oneWeekAgo = this.getDateOneWeekAgo();
        for (int i = 0; i < documentsFound.length; ++i) {
            boolean createdInPastWeek;
            DocumentDomainObject document = documentsFound[i];
            boolean bl = createdInPastWeek = !document.getCreatedDatetime().before(oneWeekAgo);
            if (!createdInPastWeek) continue;
            newDocuments.add(document);
        }
        AdminManagerSubreport newDocumentsSubreport = new AdminManagerSubreport();
        newDocumentsSubreport.setName(PARAMETER_VALUE__SHOW_NEW);
        newDocumentsSubreport.setDocuments(newDocuments);
        newDocumentsSubreport.setHeading(new LocalizedMessage("web/imcms/lang/jsp/admin/admin_manager.jsp/subreport_heading/1"));
        String dateSearchQueryString = this.createDateSearchQueryString("created", oneWeekAgo, null, null);
        newDocumentsSubreport.setSearchQueryString(dateSearchQueryString);
        return newDocumentsSubreport;
    }

    private AdminManagerSubreport createDocumentsUnmodifiedForSixMonthsSubreport(DocumentDomainObject[] documentsFound) {
        Object[] phases = new DocumentDomainObject.LifeCyclePhase[]{DocumentDomainObject.LifeCyclePhase.APPROVED, DocumentDomainObject.LifeCyclePhase.NEW, DocumentDomainObject.LifeCyclePhase.PUBLISHED, DocumentDomainObject.LifeCyclePhase.ARCHIVED};
        Date sixMonthsAgo = this.getDateSixMonthsAgo();
        ArrayList<DocumentDomainObject> documentsUnchangedForSixMonths = new ArrayList<DocumentDomainObject>();
        for (int i = 0; i < documentsFound.length; ++i) {
            DocumentDomainObject document = documentsFound[i];
            DocumentDomainObject.LifeCyclePhase phase = document.getLifeCyclePhase();
            if (!ArrayUtils.contains((Object[])phases, (Object)phase) || !document.getModifiedDatetime().before(sixMonthsAgo)) continue;
            documentsUnchangedForSixMonths.add(document);
        }
        AdminManagerSubreport documentsUnchangedForSixMonthsSubreport = new AdminManagerSubreport();
        documentsUnchangedForSixMonthsSubreport.setName("unchangedForSixMonths");
        documentsUnchangedForSixMonthsSubreport.setDocuments(documentsUnchangedForSixMonths);
        documentsUnchangedForSixMonthsSubreport.setHeading(new LocalizedMessage("web/imcms/lang/jsp/admin/admin_manager.jsp/subreport_heading/4"));
        documentsUnchangedForSixMonthsSubreport.setSortorder("MODR");
        String dateSearchQueryString = this.createDateSearchQueryString("modified", null, sixMonthsAgo, (DocumentDomainObject.LifeCyclePhase[])phases);
        documentsUnchangedForSixMonthsSubreport.setSearchQueryString(dateSearchQueryString);
        return documentsUnchangedForSixMonthsSubreport;
    }

    private AdminManagerSubreport createDocumentsArchivedWithinOneWeekSubreport(DocumentDomainObject[] documentsFound) {
        Object[] phases = new DocumentDomainObject.LifeCyclePhase[]{DocumentDomainObject.LifeCyclePhase.APPROVED, DocumentDomainObject.LifeCyclePhase.PUBLISHED};
        ArrayList<DocumentDomainObject> documentsArchivedWithinOneWeek = new ArrayList<DocumentDomainObject>();
        Date lastMidnight = this.getDateLastMidnight();
        Date oneWeekAhead = this.getDateOneWeekAhead();
        for (int i = 0; i < documentsFound.length; ++i) {
            DocumentDomainObject document = documentsFound[i];
            DocumentDomainObject.LifeCyclePhase phase = document.getLifeCyclePhase();
            Date archivedDatetime = document.getArchivedDatetime();
            if (!ArrayUtils.contains((Object[])phases, (Object)phase) || null == archivedDatetime || archivedDatetime.before(lastMidnight) || !archivedDatetime.before(oneWeekAhead)) continue;
            documentsArchivedWithinOneWeek.add(document);
        }
        AdminManagerSubreport documentsArchivedWithinOneWeekSubreport = new AdminManagerSubreport();
        documentsArchivedWithinOneWeekSubreport.setName("archivedWithinOneWeek");
        documentsArchivedWithinOneWeekSubreport.setDocuments(documentsArchivedWithinOneWeek);
        documentsArchivedWithinOneWeekSubreport.setHeading(new LocalizedMessage("web/imcms/lang/jsp/admin/admin_manager.jsp/subreport_heading/2"));
        documentsArchivedWithinOneWeekSubreport.setSortorder("ARCR");
        String dateSearchQueryString = this.createDateSearchQueryString("archived", lastMidnight, oneWeekAhead, (DocumentDomainObject.LifeCyclePhase[])phases);
        documentsArchivedWithinOneWeekSubreport.setSearchQueryString(dateSearchQueryString);
        return documentsArchivedWithinOneWeekSubreport;
    }

    private AdminManagerSubreport createDocumentsUnpublishedWithinOneWeekSubreport(DocumentDomainObject[] documentsFound) {
        Object[] phases = new DocumentDomainObject.LifeCyclePhase[]{DocumentDomainObject.LifeCyclePhase.APPROVED, DocumentDomainObject.LifeCyclePhase.ARCHIVED, DocumentDomainObject.LifeCyclePhase.PUBLISHED};
        Date lastMidnight = this.getDateLastMidnight();
        Date oneWeekAhead = this.getDateOneWeekAhead();
        ArrayList<DocumentDomainObject> documentsUnpublishedWithinOneWeek = new ArrayList<DocumentDomainObject>();
        for (int i = 0; i < documentsFound.length; ++i) {
            DocumentDomainObject document = documentsFound[i];
            DocumentDomainObject.LifeCyclePhase phase = document.getLifeCyclePhase();
            Date publicationEndDatetime = document.getPublicationEndDatetime();
            if (!ArrayUtils.contains((Object[])phases, (Object)phase) || null == publicationEndDatetime || publicationEndDatetime.before(lastMidnight) || !publicationEndDatetime.before(oneWeekAhead)) continue;
            documentsUnpublishedWithinOneWeek.add(document);
        }
        AdminManagerSubreport documentsUnpublishedWithinOneWeekSubreport = new AdminManagerSubreport();
        documentsUnpublishedWithinOneWeekSubreport.setName("unpublishedWithinOneWeek");
        documentsUnpublishedWithinOneWeekSubreport.setDocuments(documentsUnpublishedWithinOneWeek);
        documentsUnpublishedWithinOneWeekSubreport.setHeading(new LocalizedMessage("web/imcms/lang/jsp/admin/admin_manager.jsp/subreport_heading/3"));
        documentsUnpublishedWithinOneWeekSubreport.setSortorder("PUBER");
        String dateSearchQueryString = this.createDateSearchQueryString("publication_end", lastMidnight, oneWeekAhead, (DocumentDomainObject.LifeCyclePhase[])phases);
        documentsUnpublishedWithinOneWeekSubreport.setSearchQueryString(dateSearchQueryString);
        return documentsUnpublishedWithinOneWeekSubreport;
    }

    private String createDateSearchQueryString(String dateType, Date startDate, Date endDate, DocumentDomainObject.LifeCyclePhase[] lifeCyclePhases) {
        String result = "date_type=" + dateType;
        result = result + "&permission=created";
        if (null != startDate) {
            result = result + "&start_date=" + Utility.formatDate(startDate);
        }
        if (null != endDate) {
            result = result + "&end_date=" + Utility.formatDate(endDate);
        }
        if (null != lifeCyclePhases) {
            for (int i = 0; i < lifeCyclePhases.length; ++i) {
                DocumentDomainObject.LifeCyclePhase phase = lifeCyclePhases[i];
                result = result + "&phase=" + phase;
            }
        }
        return result;
    }

    private Date getDateTruncated(int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, days);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private Date getDateLastMidnight() {
        return this.getDateTruncated(0);
    }

    private Date getDateSixMonthsAgo() {
        return this.getDateTruncated(-182);
    }

    private Date getDateOneWeekAhead() {
        return this.getDateTruncated(7);
    }

    private Date getDateOneWeekAgo() {
        return this.getDateTruncated(-7);
    }

    public static ChainableReversibleNullComparator getComparator(String sortorder) {
        ChainableReversibleNullComparator comparator = DocumentComparator.MODIFIED_DATETIME.reversed();
        if ("MODR".equals(sortorder)) {
            comparator = DocumentComparator.MODIFIED_DATETIME;
        } else if ("PUBS".equals(sortorder)) {
            comparator = DocumentComparator.PUBLICATION_START_DATETIME.reversed();
        } else if ("PUBSR".equals(sortorder)) {
            comparator = DocumentComparator.PUBLICATION_START_DATETIME;
        } else if ("PUBE".equals(sortorder)) {
            comparator = DocumentComparator.PUBLICATION_END_DATETIME.reversed().nullsLast();
        } else if ("PUBER".equals(sortorder)) {
            comparator = DocumentComparator.PUBLICATION_END_DATETIME.nullsLast();
        } else if ("ARC".equals(sortorder)) {
            comparator = DocumentComparator.ARCHIVED_DATETIME.reversed().nullsLast();
        } else if ("ARCR".equals(sortorder)) {
            comparator = DocumentComparator.ARCHIVED_DATETIME.nullsLast();
        } else if ("HEADL".equals(sortorder)) {
            comparator = DocumentComparator.HEADLINE;
        } else if ("HEADLR".equals(sortorder)) {
            comparator = DocumentComparator.HEADLINE.reversed();
        } else if ("ID".equals(sortorder)) {
            comparator = DocumentComparator.ID;
        } else if ("IDR".equals(sortorder)) {
            comparator = DocumentComparator.ID.reversed();
        }
        return comparator;
    }

    private String getAdminTaskUrl(String whichButton) {
        String url = "";
        if (whichButton.equalsIgnoreCase("UserStart")) {
            url = url + "AdminUser";
        } else if (whichButton.equalsIgnoreCase("CounterStart")) {
            url = url + "AdminCounter";
        } else if (whichButton.equalsIgnoreCase("AddTemplates")) {
            url = url + "TemplateAdmin";
        } else if (whichButton.equalsIgnoreCase("DeleteDocs")) {
            url = url + "AdminDeleteDoc";
        } else if (whichButton.equalsIgnoreCase("IP-access")) {
            url = url + "AdminIpAccess";
        } else if (whichButton.equalsIgnoreCase("SystemMessage")) {
            url = url + "AdminSystemInfo";
        } else if (whichButton.equalsIgnoreCase("AdminRoles")) {
            url = url + "AdminRoles";
        } else if (whichButton.equalsIgnoreCase("LinkCheck")) {
            url = url + "LinkCheck";
        } else if (whichButton.equalsIgnoreCase("ListDocuments")) {
            url = url + "ListDocuments";
        } else if (whichButton.equalsIgnoreCase("FileAdmin")) {
            url = url + "FileAdmin";
        } else if (whichButton.equalsIgnoreCase("AdminListDocs")) {
            url = url + "AdminListDocs";
        } else if (whichButton.equalsIgnoreCase("AdminConference")) {
            url = url + "AdminConference";
        } else if (whichButton.equalsIgnoreCase("AdminRandomTexts")) {
            url = url + "AdminRandomTexts";
        } else if (whichButton.equalsIgnoreCase("AdminQuestions")) {
            url = url + "AdminQuestions";
        } else if (whichButton.equalsIgnoreCase("AdminSection")) {
            url = url + "AdminSection";
        } else if (whichButton.equalsIgnoreCase("AdminCategories")) {
            url = url + "AdminCategories";
        }
        return url;
    }

    private class ShowAdminManagerPageCommand
    implements DispatchCommand {
        private ShowAdminManagerPageCommand() {
        }

        public void dispatch(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            AdminManager.this.createAndShowAdminManagerPage(request, response, null);
        }
    }

    private static class SaveNewDocumentCommand
    implements DocumentPageFlow.SaveDocumentCommand {
        private SaveNewDocumentCommand() {
        }

        public void saveDocument(DocumentDomainObject document, UserDomainObject user) {
            Imcms.getServices().getDocumentMapper().saveNewDocument(document, user);
        }
    }

    public static class AdminManagerPage
    implements Serializable {
        LocalizedMessage heading;
        String tabName;
        List subreports = new ArrayList();
        String htmlAdminPart;
        public static final String REQUEST_ATTRIBUTE__PAGE = "ampage";
        private LocalizedMessage errorMessage;

        public LocalizedMessage getHeading() {
            return this.heading;
        }

        public void setHeading(LocalizedMessage heading) {
            this.heading = heading;
        }

        public List getSubreports() {
            return this.subreports;
        }

        public String getTabName() {
            return this.tabName;
        }

        public void setTabName(String tabName) {
            this.tabName = tabName;
        }

        public void addSubreport(AdminManagerSubreport newDocumentsSubreport) {
            this.subreports.add(newDocumentsSubreport);
        }

        public String getHtmlAdminPart() {
            return this.htmlAdminPart;
        }

        public void setHtmlAdminPart(String htmlAdminPart) {
            this.htmlAdminPart = htmlAdminPart;
        }

        public void forward(HttpServletRequest request, HttpServletResponse response, UserDomainObject user) throws IOException, ServletException {
            this.putInRequest(request);
            String forwardPath = "/imcms/" + user.getLanguageIso639_2() + "/jsp/admin/admin_manager.jsp";
            request.getRequestDispatcher(forwardPath).forward((ServletRequest)request, (ServletResponse)response);
        }

        public void putInRequest(HttpServletRequest request) {
            request.setAttribute(REQUEST_ATTRIBUTE__PAGE, (Object)this);
        }

        public LocalizedMessage getErrorMessage() {
            return this.errorMessage;
        }

        public void setErrorMessage(LocalizedMessage errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    public static class DatesSummarySearchResultColumn
    implements DocumentFinder.SearchResultColumn {
        public String render(DocumentDomainObject document, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            UserDomainObject user = Utility.getLoggedOnUser(request);
            AdminManagerExpandableDatesBean expandableDatesBean = new AdminManagerExpandableDatesBean();
            expandableDatesBean.setExpanded(true);
            expandableDatesBean.setDocument(document);
            request.setAttribute("expandableDatesBean", (Object)expandableDatesBean);
            return Utility.getContents("/imcms/" + user.getLanguageIso639_2() + "/jsp/admin/admin_manager_expandable_dates.jsp", request, response);
        }

        public LocalizedMessage getName() {
            return new LocalizedMessage("global/Dates");
        }
    }
}

