/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.misc;

import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import imcode.util.fortune.Poll;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.NumberFormat;
import java.util.List;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class QuestionResult
extends HttpServlet {
    private static final String RESULTTEMPLATE = "QuestionResult.htm";
    private static final Logger log = Logger.getLogger((String)QuestionResult.class.getName());

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        String file = req.getParameter("file");
        String answer = req.getParameter("answer");
        if (file == null) {
            file = "poll";
        }
        if (answer == null) {
            return;
        }
        List currentPollList = imcref.getPollList(file + ".current.txt");
        if (currentPollList.isEmpty()) {
            log.error((Object)"QuestionResult: No current poll!");
            return;
        }
        Poll thePoll = (Poll)currentPollList.get(0);
        thePoll.addAnswer(answer);
        imcref.setPollList(file + ".current.txt", currentPollList);
        double totalAnswerCount = thePoll.getTotalAnswerCount();
        double yesRatio = (double)thePoll.getAnswerCount("yes") / totalAnswerCount;
        double noRatio = (double)thePoll.getAnswerCount("no") / totalAnswerCount;
        NumberFormat pf = NumberFormat.getPercentInstance();
        pf.setMaximumFractionDigits(0);
        String yesProcent = pf.format(yesRatio);
        String noProcent = pf.format(noRatio);
        Vector<String> values = new Vector<String>(8);
        values.add("#question#");
        values.add(thePoll.getQuestion());
        values.add("#yesProcent#");
        values.add(yesProcent);
        values.add("#noProcent#");
        values.add(noProcent);
        values.add("#total#");
        values.add("" + (int)totalAnswerCount);
        String parsed = imcref.getTemplateFromDirectory(RESULTTEMPLATE, user, values, "106");
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        ((Writer)out).write(parsed);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        this.doGet(req, res);
    }
}

