/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.misc;

import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.parser.MapSubstitution;
import imcode.server.user.UserDomainObject;
import imcode.util.Prefs;
import imcode.util.Utility;
import imcode.util.net.SMTP;
import imcode.util.shop.ShoppingCart;
import imcode.util.shop.ShoppingItem;
import imcode.util.shop.ShoppingOrder;
import imcode.util.shop.ShoppingOrderSystem;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Substitution;
import org.apache.oro.text.regex.Util;

public class PutInShoppingCart
extends HttpServlet {
    private static final String SHOP_CONFIG = "shop.properties";
    private static final String MAIL_ITEM_FORMAT = "shop/mailitemformat.txt";
    private static final String MAIL_FORMAT = "shop/mailformat.txt";
    private static Pattern HASHTAG_PATTERN = null;
    private static Logger log;

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        String forwardTo;
        DecimalFormat priceFormat = this.createDecimalFormat(req.getParameter("priceformatpattern"), req.getParameter("priceformatgroupingseparator"), req.getParameter("priceformatdecimalseparator"));
        HashMap<String, ShoppingItemQuantity> formItems = new HashMap<String, ShoppingItemQuantity>();
        log.debug((Object)("Using format " + priceFormat.toPattern() + " which means " + priceFormat.toLocalizedPattern()));
        Perl5Util perl = new Perl5Util();
        Enumeration paramEnum = req.getParameterNames();
        while (paramEnum.hasMoreElements()) {
            String aParameter = (String)paramEnum.nextElement();
            if (!perl.match("/^(\\w+?)(\\d*)_(\\d+)$/", aParameter)) continue;
            String field = perl.group(1);
            String fieldno = perl.group(2);
            String formitemno = perl.group(3);
            String paramValue = req.getParameter(aParameter);
            ShoppingItemQuantity quantity = (ShoppingItemQuantity)formItems.get(formitemno);
            try {
                if (null == quantity) {
                    quantity = new ShoppingItemQuantity();
                    int number = -1;
                    if (null != req.getParameter("number_" + formitemno)) {
                        number = Integer.parseInt(req.getParameter("number_" + formitemno));
                    } else if (null != req.getParameter("add_" + formitemno)) {
                        number = Integer.parseInt(req.getParameter("add_" + formitemno));
                        quantity.setAdd(true);
                    }
                    quantity.setQuantity(number);
                    formItems.put(formitemno, quantity);
                }
                if ("number".equals(field)) continue;
                if (!"".equals(paramValue)) {
                    log.debug((Object)("Parsing '" + paramValue + "' for parameter " + aParameter));
                }
                if ("remove".equals(field)) {
                    quantity.setRemove(true);
                    continue;
                }
                if ("price".equals(field)) {
                    quantity.getItem().setPrice(priceFormat.parse(paramValue).doubleValue());
                    continue;
                }
                if (!"desc".equals(field) || fieldno.length() <= 0) continue;
                quantity.getItem().getDescriptions().put(Integer.valueOf(fieldno), paramValue);
            }
            catch (NumberFormatException nfe) {
                if ("".equals(paramValue)) continue;
                log.debug((Object)("Failed to parse number: " + nfe));
            }
            catch (ParseException pe) {
                if ("".equals(paramValue)) continue;
                log.debug((Object)("Failed to parse price: " + pe));
            }
        }
        HttpSession session = req.getSession(true);
        ShoppingCart cart = (ShoppingCart)((Object)session.getAttribute("imcode.ShoppingCart"));
        if (null == cart) {
            cart = new ShoppingCart();
            session.setAttribute("imcode.ShoppingCart", (Object)cart);
        }
        Iterator formItemsIterator = formItems.values().iterator();
        while (formItemsIterator.hasNext()) {
            ShoppingItemQuantity itemQuantity = (ShoppingItemQuantity)formItemsIterator.next();
            if (itemQuantity.getRemove() || 0 == itemQuantity.getQuantity()) {
                cart.removeItem(itemQuantity.getItem());
                continue;
            }
            if (itemQuantity.getQuantity() <= 0) continue;
            if (itemQuantity.getAdd()) {
                cart.addItem(itemQuantity.getItem(), itemQuantity.getQuantity());
                continue;
            }
            cart.putItem(itemQuantity.getItem(), itemQuantity.getQuantity());
        }
        if (null != req.getParameter("send") || null != req.getParameter("send.x")) {
            ImcmsServices imcref = Imcms.getServices();
            UserDomainObject user = Utility.getLoggedOnUser(req);
            this.sendMail(req, user);
            ShoppingOrderSystem shoppingOrderSystem = imcref.getShoppingOrderSystem();
            ShoppingOrder theOrder = new ShoppingOrder(cart);
            theOrder.setUser(user);
            theOrder.setDatetime(new Date());
            shoppingOrderSystem.addShoppingOrder(theOrder);
            session.setAttribute("imcode.ShoppingCart", (Object)new ShoppingCart());
            forwardTo = req.getParameter("send_next");
        } else {
            forwardTo = req.getParameter("next");
        }
        if (null == forwardTo || "".equals(forwardTo)) {
            forwardTo = req.getHeader("referer");
        }
        log.debug((Object)("Redirecting to " + forwardTo));
        res.sendRedirect(forwardTo);
    }

    private DecimalFormat createDecimalFormat(String pattern, String groupingseparator, String decimalseparator) {
        DecimalFormat theDecimalFormat = null != pattern ? new DecimalFormat(pattern) : new DecimalFormat();
        DecimalFormatSymbols theSymbols = theDecimalFormat.getDecimalFormatSymbols();
        if (null != groupingseparator && !"".equals(groupingseparator)) {
            theSymbols.setGroupingSeparator(groupingseparator.charAt(0));
        }
        if (null != decimalseparator && !"".equals(decimalseparator)) {
            theSymbols.setDecimalSeparator(decimalseparator.charAt(0));
        }
        theDecimalFormat.setDecimalFormatSymbols(theSymbols);
        return theDecimalFormat;
    }

    private void sendMail(HttpServletRequest req, UserDomainObject user) throws IOException {
        ImcmsServices imcref = Imcms.getServices();
        String mailFromAddress = Prefs.get("mail-from-address", SHOP_CONFIG);
        String mailToAddress = Prefs.get("mail-to-address", SHOP_CONFIG);
        String mailSubject = Prefs.get("mail-subject", SHOP_CONFIG);
        String mailFormat = imcref.getAdminTemplate(MAIL_FORMAT, user, null);
        String mailItemFormat = imcref.getAdminTemplate(MAIL_ITEM_FORMAT, user, null);
        Perl5Matcher patternMatcher = new Perl5Matcher();
        StringBuffer mailItems = new StringBuffer();
        ShoppingCart cart = (ShoppingCart)((Object)req.getSession(true).getAttribute("imcode.ShoppingCart"));
        ShoppingItem[] items = cart.getItems();
        DecimalFormat priceFormat = this.createDecimalFormat(null, ".", null);
        double totalPrice = 0.0;
        for (int i = 0; i < items.length; ++i) {
            ShoppingItem item = items[i];
            HashMap itemStringMap = new HashMap();
            Iterator itemDescriptionIterator = item.getDescriptions().entrySet().iterator();
            while (itemDescriptionIterator.hasNext()) {
                Map.Entry itemDescriptionEntry = itemDescriptionIterator.next();
                itemStringMap.put("#desc" + itemDescriptionEntry.getKey() + "#", itemDescriptionEntry.getValue());
            }
            itemStringMap.put("#price#", priceFormat.format(item.getPrice()));
            int quantity = cart.countItem(item);
            itemStringMap.put("#quantity#", "" + quantity);
            itemStringMap.put("#total_price#", priceFormat.format((double)quantity * item.getPrice()));
            totalPrice += (double)quantity * item.getPrice();
            String mailItem = Util.substitute((PatternMatcher)patternMatcher, (Pattern)HASHTAG_PATTERN, (Substitution)new MapSubstitution(itemStringMap, false), (String)mailItemFormat, (int)-1);
            mailItems.append(mailItem);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        HashMap<String, String> mailStringMap = new HashMap<String, String>();
        mailStringMap.put("#items#", mailItems.toString());
        mailStringMap.put("#datetime#", dateFormat.format(new Date()));
        mailStringMap.put("#user_login_name#", user.getLoginName());
        mailStringMap.put("#user_title#", user.getTitle());
        mailStringMap.put("#user_full_name#", user.getFullName());
        mailStringMap.put("#user_first_name#", user.getFirstName());
        mailStringMap.put("#user_last_name#", user.getLastName());
        mailStringMap.put("#user_email#", user.getEmailAddress());
        mailStringMap.put("#user_workphone#", user.getWorkPhone());
        mailStringMap.put("#user_mobilephone#", user.getMobilePhone());
        mailStringMap.put("#user_homephone#", user.getHomePhone());
        mailStringMap.put("#user_company#", user.getCompany());
        mailStringMap.put("#user_address#", user.getAddress());
        mailStringMap.put("#user_zip#", user.getZip());
        mailStringMap.put("#user_city#", user.getCity());
        mailStringMap.put("#user_country#", user.getCountry());
        mailStringMap.put("#user_county_council#", user.getCountyCouncil());
        mailStringMap.put("#total_price#", priceFormat.format(totalPrice));
        String mail = Util.substitute((PatternMatcher)patternMatcher, (Pattern)HASHTAG_PATTERN, (Substitution)new MapSubstitution(mailStringMap, false), (String)mailFormat, (int)-1);
        log.debug((Object)("Sending mail to " + mailToAddress));
        SMTP smtp = imcref.getSMTP();
        smtp.sendMail(new SMTP.Mail(mailFromAddress, new String[]{mailToAddress}, mailSubject, mail));
    }

    static {
        Perl5Compiler patComp = new Perl5Compiler();
        try {
            HASHTAG_PATTERN = patComp.compile("#(\\w+?)(\\d*)#", 32768);
        }
        catch (MalformedPatternException malformedPatternException) {
            // empty catch block
        }
        log = Logger.getLogger((String)PutInShoppingCart.class.getName());
    }

    private class ShoppingItemQuantity {
        private ShoppingItem item = new ShoppingItem();
        private int quantity = -1;
        private boolean remove = false;
        private boolean add = false;

        private ShoppingItemQuantity() {
        }

        private ShoppingItem getItem() {
            return this.item;
        }

        private int getQuantity() {
            return this.quantity;
        }

        private void setQuantity(int quantity) {
            this.quantity = quantity;
        }

        private boolean getRemove() {
            return this.remove;
        }

        private void setRemove(boolean remove) {
            this.remove = remove;
        }

        private boolean getAdd() {
            return this.add;
        }

        private void setAdd(boolean add) {
            this.add = add;
        }
    }
}

