/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.misc;

import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.util.net.SMTP;
import imcode.util.poll.PollHandlingSystem;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class PollHandler
extends HttpServlet {
    private static Logger log = Logger.getLogger((String)PollHandler.class.getName());

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        Cookie[] cookies;
        String cookieName;
        ImcmsServices imcref = Imcms.getServices();
        PollHandlingSystem poll = imcref.getPollHandlingSystem();
        String meta_id = req.getParameter("meta_id");
        Enumeration paramEnum = req.getParameterNames();
        String confirmation_template = req.getParameter("confirmation_template");
        String result_template = req.getParameter("result_template");
        String[] poll_param = poll.getPollParameters(meta_id);
        int set_cookie = Integer.parseInt(poll_param[5]);
        int hide_result = Integer.parseInt(poll_param[6]);
        boolean saveAnswers = true;
        if (set_cookie == 1 && meta_id != null) {
            cookieName = "imcms.poll" + meta_id;
            cookies = req.getCookies();
            for (int i = 0; cookies != null && i < cookies.length; ++i) {
                if (!cookieName.equals(cookies[i].getName()) || !"true".equals(cookies[i].getValue())) continue;
                saveAnswers = false;
            }
            if (saveAnswers) {
                Cookie resCookie = new Cookie(cookieName, "true");
                resCookie.setMaxAge(31500000);
                resCookie.setPath("/");
                res.addCookie(resCookie);
            }
        } else if (set_cookie == 0 && meta_id != null) {
            cookieName = "imcms.poll" + meta_id;
            cookies = req.getCookies();
            for (int i = 0; cookies != null && i < cookies.length; ++i) {
                if (!cookieName.equals(cookies[i].getName())) continue;
                Cookie currentCookie = new Cookie(cookieName, "false");
                currentCookie.setMaxAge(0);
                currentCookie.setPath("/");
                res.addCookie(currentCookie);
            }
        }
        TreeMap<String, String> textAnswers = new TreeMap<String, String>();
        TreeMap<String, String> textQuestions = new TreeMap<String, String>();
        if (saveAnswers) {
            while (paramEnum.hasMoreElements() && meta_id != null) {
                int question_no;
                String aParameter = (String)paramEnum.nextElement();
                if (aParameter.startsWith("textAnswer")) {
                    question_no = Integer.parseInt(aParameter.substring("textAnswer".length()));
                    String text = req.getParameter(aParameter);
                    if ("".equals(text.trim())) continue;
                    textAnswers.put("" + question_no, text);
                    String questionText = this.getText(imcref, Integer.parseInt(meta_id), question_no);
                    textQuestions.put("" + question_no, questionText);
                    continue;
                }
                if (!aParameter.startsWith("optionAnswer")) continue;
                question_no = Integer.parseInt(aParameter.substring("optionAnswer".length()));
                String[] option_no = req.getParameterValues(aParameter);
                if (option_no == null || question_no <= 0) continue;
                for (int i = 0; i < option_no.length; ++i) {
                    poll.increasePollAnswer(meta_id, "" + question_no, option_no[i]);
                }
            }
        }
        String forwardTo = null;
        if (meta_id != null) {
            forwardTo = hide_result == 1 ? "../poll/pollResult.jsp?meta_id=" + meta_id + "&template=" + confirmation_template : "../poll/pollResult.jsp?meta_id=" + meta_id + "&template=" + result_template;
            log.debug((Object)("Redirecting to " + forwardTo));
            res.sendRedirect(forwardTo);
            if (textAnswers != null && textAnswers.size() > 0 && poll_param[8] != null) {
                this.sendMail(imcref, poll_param, meta_id, textQuestions, textAnswers);
            }
        }
    }

    private void sendMail(ImcmsServices imcref, String[] poll_param, String meta_id, TreeMap textQuestions, TreeMap textAnswers) throws IOException {
        String mailFromAddress = this.getText(imcref, Integer.parseInt(meta_id), Integer.parseInt(poll_param[9]));
        String mailToAddress = this.getText(imcref, Integer.parseInt(meta_id), Integer.parseInt(poll_param[8]));
        String mailSubject = this.getText(imcref, Integer.parseInt(meta_id), Integer.parseInt(poll_param[10]));
        TextDomainObject poll_name = new TextDomainObject("", 0);
        if (poll_param != null && poll_param.length != 0 && poll_param[1] != null) {
            int text_no = Integer.parseInt(poll_param[1]);
            poll_name = imcref.getText(Integer.parseInt(meta_id), text_no);
        }
        StringBuffer mail = new StringBuffer();
        mail.append("Enk\u00e4tsvar \n");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        Date toDay = new Date();
        mail.append(formatter.format(toDay) + "\n");
        mail.append("Enk\u00e4t: " + poll_name + "\n");
        mail.append("Meta_Id: " + meta_id + "\n");
        Set answers = textAnswers.entrySet();
        Iterator answersIter = answers.iterator();
        while (answersIter.hasNext()) {
            Map.Entry questionNo = answersIter.next();
            mail.append("___________________________________________\n");
            mail.append("Fr\u00e5ga: \n");
            mail.append(textQuestions.get(questionNo.getKey()) + "\n\n");
            mail.append("Svar: \n" + (String)questionNo.getValue() + "\n");
            mail.append("\n");
        }
        SMTP smtp = imcref.getSMTP();
        smtp.sendMail(new SMTP.Mail(mailFromAddress, new String[]{mailToAddress}, mailSubject, mail.toString()));
        log.debug((Object)("Sending mail to " + mailToAddress));
    }

    private String getText(ImcmsServices imcref, int meta_id, int text_no) {
        TextDomainObject text = imcref.getText(meta_id, text_no);
        if (text != null) {
            return text.getText();
        }
        return "";
    }
}

