/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.conference;

import com.imcode.imcms.servlet.conference.ConfError;
import com.imcode.imcms.servlet.conference.Conference;
import com.imcode.imcms.servlet.superadmin.Administrator;
import imcode.external.diverse.FileManager;
import imcode.external.diverse.MetaInfo;
import imcode.external.diverse.RmiConf;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Html;
import imcode.util.Utility;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ConfAdmin
extends Conference {
    private static final String FORUM_UNADMIN_LINK_TEMPLATE = "conf_forum_unadmin_link.htm";
    private static final String FORUM_TEMPLATE1_UNADMIN_LINK_TEMPLATE = "conf_forum_template1_unadmin_link.htm";
    private static final String FORUM_TEMPLATE2_UNADMIN_LINK_TEMPLATE = "conf_forum_template2_unadmin_link.htm";
    private static final String DISC_UNADMIN_LINK_TEMPLATE = "conf_disc_unadmin_link.htm";
    private static final String REPLY_UNADMIN_LINK_TEMPLATE = "conf_reply_unadmin_link.htm";

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        Properties params = this.getStandardParameters(req);
        ImcmsServices imcref = Imcms.getServices();
        if (!super.userHasAdminRights(imcref, Integer.parseInt(params.getProperty("META_ID")), user)) {
            String header = "ConfAdmin servlet. ";
            new ConfError(req, res, header, 6, user);
            return;
        }
        if (req.getParameter("ADD_SELF_REG_ROLE") != null) {
            if (!Administrator.checkAdminRights(req)) {
                new ConfError(req, res, "ConfAdmin", 64, user);
                return;
            }
            String selfRegRoleId = req.getParameter("ALL_SELF_REGISTER_ROLES");
            if (selfRegRoleId == null) {
                String header = "ConfAdmin servlet. ";
                new ConfError(req, res, header, 86, user);
                return;
            }
            String roleName = imcref.sqlProcedureStr("RoleGetName", new String[]{selfRegRoleId});
            imcref.sqlUpdateProcedure("A_SelfRegRoles_AddNew", new String[]{params.getProperty("META_ID"), selfRegRoleId, roleName});
            res.sendRedirect("ConfAdmin?ADMIN_TYPE=SELF_REGISTER");
            return;
        }
        if (req.getParameter("DEL_SELF_REG_ROLE") != null) {
            if (!Administrator.checkAdminRights(req)) {
                new ConfError(req, res, "ConfAdmin", 64, user);
                return;
            }
            String selfRegRoleId = req.getParameter("CURR_SELF_REGISTER_ROLES");
            if (selfRegRoleId == null) {
                String header = "ConfAdmin servlet. ";
                new ConfError(req, res, header, 87, user);
                return;
            }
            imcref.sqlUpdateProcedure("A_SelfRegRoles_Delete", new String[]{params.getProperty("META_ID"), selfRegRoleId});
            res.sendRedirect("ConfAdmin?ADMIN_TYPE=SELF_REGISTER");
            return;
        }
        if (req.getParameter("REGISTER_TEMPLATE_LIB") != null) {
            this.log("Nu l\u00e4gger vi till ett nytt set");
            String newLibName = req.getParameter("TEMPLATE_LIB_NAME");
            if (newLibName == null) {
                String header = "ConfAdmin servlet. ";
                new ConfError(req, res, header, 80, user);
                return;
            }
            String libNameExists = imcref.sqlProcedureStr("A_FindTemplateLib", new String[]{newLibName = super.verifySqlText(newLibName)});
            if (!libNameExists.equalsIgnoreCase("-1")) {
                String header = "ConfAdmin servlet. ";
                new ConfError(req, res, header, 84, user);
                return;
            }
            imcref.sqlUpdateProcedure("A_AddTemplateLib", new String[]{newLibName});
            int metaId = this.getMetaId(req);
            FileManager fileObj = new FileManager();
            File templateSrc = new File(imcref.getExternalTemplateFolder(metaId, user), "original");
            File imageSrc = new File(RmiConf.getImagePathForExternalDocument(imcref, metaId, user), "original");
            File templateTarget = new File(imcref.getExternalTemplateFolder(metaId, user), newLibName);
            File imageTarget = new File(RmiConf.getImagePathForExternalDocument(imcref, metaId, user), newLibName);
            fileObj.copyDirectory(templateSrc, templateTarget);
            fileObj.copyDirectory(imageSrc, imageTarget);
            res.sendRedirect("ConfAdmin?ADMIN_TYPE=META");
            return;
        }
        if (req.getParameter("UPLOAD_CONF") != null) {
            String libName = req.getParameter("TEMPLATE_NAME") == null ? "" : req.getParameter("TEMPLATE_NAME");
            String uploadType = req.getParameter("UPLOAD_TYPE") == null ? "" : req.getParameter("UPLOAD_TYPE");
            params.setProperty("TEMPLATE_NAME", libName);
            params.setProperty("UPLOAD_TYPE", uploadType);
            String url = "ConfAdmin?ADMIN_TYPE=META";
            url = url + "&setname=" + libName + "&UPLOAD_TYPE=" + uploadType;
            res.sendRedirect(url);
            return;
        }
        if (req.getParameter("SET_TEMPLATE_LIB") != null) {
            this.log("Lets set a new template set for the conference");
            String newLibName = req.getParameter("TEMPLATE_ID");
            if (newLibName == null) {
                String header = "ConfAdmin servlet. ";
                new ConfError(req, res, header, 80, user);
                return;
            }
            String templateId = imcref.sqlProcedureStr("A_GetTemplateIdFromName", new String[]{newLibName});
            if (templateId.equalsIgnoreCase("-1")) {
                String header = "ConfAdmin servlet. ";
                new ConfError(req, res, header, 81, user);
                return;
            }
            imcref.sqlUpdateProcedure("A_SetTemplateLib", new String[]{params.getProperty("META_ID"), templateId});
            res.sendRedirect("ConfAdmin?ADMIN_TYPE=META");
            return;
        }
        if (req.getParameter("DELETE_REPLY") != null) {
            this.log("Nu tar vi bort inl\u00e4gg");
            String discId = params.getProperty("DISC_ID");
            String[] repliesIds = this.getDelReplyParameters(req);
            if (repliesIds != null) {
                for (int i = 0; i < repliesIds.length; ++i) {
                    imcref.sqlUpdateProcedure("A_DeleteReply", new String[]{discId, repliesIds[i]});
                }
            }
            res.sendRedirect("ConfAdmin?ADMIN_TYPE=REPLY");
            return;
        }
        if (req.getParameter("RESAVE_REPLY") != null) {
            String[] repliesIds = this.getDelReplyParameters(req);
            if (repliesIds != null) {
                for (int i = 0; i < repliesIds.length; ++i) {
                    String newHeader;
                    String newText = req.getParameter("TEXT_BOX_" + repliesIds[i]);
                    if (newText == null || newText.equals("")) {
                        ConfError err = new ConfError();
                        newText = err.getErrorMessage(req, 70);
                    }
                    if ((newHeader = req.getParameter("REPLY_HEADER_" + repliesIds[i])) == null || newHeader.equals("")) {
                        ConfError err = new ConfError();
                        newHeader = err.getErrorMessage(req, 71);
                    }
                    newHeader = super.verifySqlText(newHeader);
                    newText = super.verifySqlText(newText);
                    imcref.sqlUpdateProcedure("A_UpdateReply", new String[]{repliesIds[i], newHeader, newText});
                }
            }
            res.sendRedirect("ConfAdmin?ADMIN_TYPE=REPLY");
            return;
        }
        if (req.getParameter("DELETE_DISCUSSION") != null) {
            String[] discIds = this.getDelDiscParameters(req);
            if (discIds != null) {
                for (int i = 0; i < discIds.length; ++i) {
                    imcref.sqlUpdateProcedure("A_DeleteDiscussion", new String[]{discIds[i]});
                }
            }
            res.sendRedirect("ConfAdmin?ADMIN_TYPE=DISCUSSION");
            return;
        }
        if (req.getParameter("DELETE_FORUM") != null) {
            this.log("Nu tar vi bort ett forum");
            params = this.getDelForumParameters(req, params);
            String aForumId = params.getProperty("FORUM_ID");
            String[] discs = imcref.sqlProcedure("A_GetAllDiscsInForum", new String[]{aForumId});
            if (discs != null) {
                for (int i = 0; i < discs.length; ++i) {
                    imcref.sqlUpdateProcedure("A_DeleteDiscussion", new String[]{discs[i]});
                }
            }
            imcref.sqlUpdateProcedure("A_DeleteForum", new String[]{params.getProperty("FORUM_ID")});
            this.doGet(req, res);
            return;
        }
        if (req.getParameter("ADD_FORUM") != null) {
            this.log("Lets add a forum");
            params = this.getAddForumParameters(req, params);
            params = super.verifyForSql(params);
            String foundIt = imcref.sqlProcedureStr("A_FindForumName", new String[]{params.getProperty("META_ID"), params.getProperty("NEW_FORUM_NAME")});
            if (!foundIt.equalsIgnoreCase("-1")) {
                String header = "ConfAdmin servlet. ";
                new ConfError(req, res, header, 85, user);
                return;
            }
            String archiveMode = "A";
            String archiveTime = "30";
            imcref.sqlUpdateProcedure("A_AddNewForum", new String[]{params.getProperty("META_ID"), params.getProperty("NEW_FORUM_NAME"), "A", "30"});
            this.doGet(req, res);
            return;
        }
        if (req.getParameter("CHANGE_FORUM_NAME") != null) {
            params = this.getRenameForumParameters(req, params);
            params = super.verifyForSql(params);
            imcref.sqlUpdateProcedure("A_RenameForum", new String[]{params.getProperty("FORUM_ID"), params.getProperty("NEW_FORUM_NAME")});
            this.doGet(req, res);
            return;
        }
        if (req.getParameter("SHOW_DISCUSSION_NBR") != null) {
            this.log("Lets set the nbr of discussions to show");
            params = this.getShowDiscussionNbrParameters(req, params);
            imcref.sqlUpdateProcedure("A_SetNbrOfDiscsToShow", new String[]{params.getProperty("FORUM_ID"), params.getProperty("NBR_OF_DISCS_TO_SHOW")});
            res.sendRedirect("ConfAdmin?ADMIN_TYPE=FORUM");
            return;
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Vector tagsV;
        String[] sqlAnswer;
        Properties params = this.getStandardParameters(req);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        ImcmsServices imcref = Imcms.getServices();
        if (!super.userHasAdminRights(imcref, Integer.parseInt(params.getProperty("META_ID")), user)) {
            String header = "ConfAdmin servlet. ";
            new ConfError(req, res, header, 6, user);
            return;
        }
        String adminWhat = req.getParameter("ADMIN_TYPE") == null ? "" : req.getParameter("ADMIN_TYPE");
        VariableManager vm = new VariableManager();
        String htmlFile = "";
        if (adminWhat.equalsIgnoreCase("SELF_REGISTER")) {
            if (!Administrator.checkAdminRights(req)) {
                new ConfError(req, res, "ConfAdmin", 64, user);
                return;
            }
            sqlAnswer = imcref.sqlProcedure("A_SelfRegRoles_GetAll", new String[]{params.getProperty("META_ID")});
            Vector selfRegV = super.convert2Vector(sqlAnswer);
            String selfRegList = Html.createOptionList("", (List)selfRegV);
            String langPrefix = user.getLanguageIso639_2();
            ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserAndRoleMapper = Imcms.getServices().getImcmsAuthenticatorAndUserAndRoleMapper();
            RoleDomainObject[] rolesWithPermission = imcmsAuthenticatorAndUserAndRoleMapper.getAllRolesWithPermission(RoleDomainObject.CONFERENCE_REGISTRATION_PERMISSION);
            String[] sqlAnswer2 = new String[rolesWithPermission.length * 2];
            for (int i = 0; i < rolesWithPermission.length; ++i) {
                RoleDomainObject role = rolesWithPermission[i];
                sqlAnswer2[i * 2] = "" + role.getId();
                sqlAnswer2[i * 2 + 1] = "" + role.getName();
            }
            Vector allSelfRegV = super.convert2Vector(sqlAnswer2);
            String allSelfRegList = Html.createOptionList("", (List)allSelfRegV);
            vm.addProperty("SELFREG_ROLES_LIST", selfRegList);
            vm.addProperty("ALL_SELFREG_ROLES_LIST", allSelfRegList);
            vm.addProperty("UNADMIN_LINK_HTML", FORUM_TEMPLATE2_UNADMIN_LINK_TEMPLATE);
            htmlFile = "conf_admin_template3.htm";
        }
        if (adminWhat.equalsIgnoreCase("META")) {
            String setName = req.getParameter("setname");
            if (setName != null) {
                String uploadType = req.getParameter("UPLOAD_TYPE");
                if (uploadType == null) {
                    String header = "ConfAdmin servlet. ";
                    new ConfError(req, res, header, 83, user);
                    return;
                }
                String metaId = params.getProperty("META_ID");
                vm.addProperty("UPLOAD_TYPE", uploadType);
                vm.addProperty("FOLDER_NAME", setName);
                vm.addProperty("META_ID", metaId);
                vm.addProperty("UNADMIN_LINK_HTML", FORUM_TEMPLATE2_UNADMIN_LINK_TEMPLATE);
                htmlFile = "conf_admin_template2.htm";
            } else {
                String currTemplateSet = imcref.sqlProcedureStr("A_GetTemplateLib", new String[]{params.getProperty("META_ID")});
                String[] sqlAnswer2 = imcref.sqlProcedure("A_GetAllTemplateLibs", new String[0]);
                Vector templateV = super.convert2Vector(sqlAnswer2);
                String templateList = Html.createOptionList("", (List)templateV);
                vm.addProperty("TEMPLATE_LIST", templateList);
                vm.addProperty("A_META_ID", params.getProperty("META_ID"));
                vm.addProperty("CURRENT_TEMPLATE_SET", currTemplateSet);
                vm.addProperty("UNADMIN_LINK_HTML", FORUM_TEMPLATE1_UNADMIN_LINK_TEMPLATE);
                htmlFile = "conf_admin_template1.htm";
            }
        }
        if (adminWhat.equalsIgnoreCase("FORUM")) {
            sqlAnswer = imcref.sqlProcedure("A_GetAllForum", new String[]{params.getProperty("META_ID")});
            Vector forumV = super.convert2Vector(sqlAnswer);
            String forumList = Html.createOptionList("", (List)forumV);
            String[] sqlAllDiscs = imcref.sqlProcedure("A_GetAllNbrOfDiscsToShow", new String[]{params.getProperty("META_ID")});
            Vector sqlAllDiscsV = new Vector();
            if (sqlAllDiscs != null) {
                sqlAllDiscsV = super.convert2Vector(sqlAllDiscs);
            }
            String discToShowList = Html.createOptionList("", sqlAllDiscsV);
            vm.addProperty("FORUM_LIST", forumList);
            vm.addProperty("NBR_OF_DISCS_TO_SHOW_LIST", discToShowList);
            vm.addProperty("UNADMIN_LINK_HTML", FORUM_UNADMIN_LINK_TEMPLATE);
            htmlFile = "conf_admin_forum.htm";
        }
        if (adminWhat.equalsIgnoreCase("DISCUSSION")) {
            String adminDiscList = "conf_admin_disc_list.htm";
            this.log("OK, Administrera Discussions");
            String aMetaId = params.getProperty("META_ID");
            String aForumId = params.getProperty("FORUM_ID");
            String aLoginDate = params.getProperty("LAST_LOGIN_DATE");
            File aHrefHtmlFile = new File(super.getExternalTemplateFolder(req), adminDiscList);
            String[][] sqlAnswerNew = imcref.sqlProcedureMulti("A_GetAllNewDiscussions", new String[]{aMetaId, aForumId, aLoginDate});
            String[][] sqlAnswerOld = imcref.sqlProcedureMulti("A_GetAllOldDiscussions", new String[]{aMetaId, aForumId, aLoginDate});
            tagsV = this.buildAdminTags();
            String allNewRecs = "";
            if (sqlAnswerNew != null && sqlAnswerNew.length > 0) {
                allNewRecs = this.discPreParse(sqlAnswerNew, tagsV, aHrefHtmlFile);
            }
            String allOldRecs = "";
            if (sqlAnswerOld != null && sqlAnswerOld.length > 0) {
                allOldRecs = this.discPreParse(sqlAnswerOld, tagsV, aHrefHtmlFile);
            }
            vm.addProperty("NEW_A_HREF_LIST", allNewRecs);
            vm.addProperty("OLD_A_HREF_LIST", allOldRecs);
            vm.addProperty("UNADMIN_LINK_HTML", DISC_UNADMIN_LINK_TEMPLATE);
            htmlFile = "conf_admin_disc.htm";
        }
        if (adminWhat.equalsIgnoreCase("REPLY")) {
            String adminReplyList = "conf_admin_reply_list.htm";
            String userId = "" + user.getId();
            String discId = params.getProperty("DISC_ID");
            String[][] sqlAnswer3 = imcref.sqlProcedureMulti("A_GetAllRepliesInDiscAdmin", new String[]{discId, userId});
            String metaId = params.getProperty("META_ID");
            String sortOrderVal = imcref.sqlProcedureStr("A_ConfUsersGetReplyOrderSel", new String[]{metaId, userId});
            String checkBoxStr = "";
            if (sortOrderVal.equalsIgnoreCase("1")) {
                checkBoxStr = "checked";
            }
            tagsV = new Vector();
            tagsV.add("#REPLY_DATE#");
            tagsV.add("#FIRST_NAME#");
            tagsV.add("#LAST_NAME#");
            tagsV.add("#REPLY_HEADER#");
            tagsV.add("#REPLY_TEXT#");
            tagsV.add("#REPLY_LEVEL#");
            tagsV.add("#REPLY_ID#");
            tagsV.add("#REPLY_ID2#");
            tagsV.add("#REPLY_ID3#");
            String imagePath = super.getExternalImageFolder(req) + "ConfExpert.gif";
            File templateLib = super.getExternalTemplateFolder(req);
            File aSnippetFile = new File(templateLib, adminReplyList);
            String allRecs = " ";
            if (sqlAnswer3 != null) {
                allRecs = this.replyPreParse(sqlAnswer3, tagsV, aSnippetFile, imagePath);
            }
            vm.addProperty("USER_SORT_ORDER", sortOrderVal);
            vm.addProperty("CHECKBOX_STATE", checkBoxStr);
            vm.addProperty("REPLIES_RECORDS", allRecs);
            vm.addProperty("UNADMIN_LINK_HTML", REPLY_UNADMIN_LINK_TEMPLATE);
            htmlFile = "conf_admin_reply.htm";
        }
        this.sendHtml(req, res, vm, htmlFile);
    }

    private String replyPreParse(String[][] DBArr, Vector tagsV, File htmlCodeFile, String imagePath) throws IOException {
        String htmlStr = "";
        for (int i = 0; i < DBArr.length; ++i) {
            Vector<String> dataV = new Vector<String>();
            for (int j = 0; j < DBArr[i].length; ++j) {
                dataV.add(DBArr[i][j]);
            }
            dataV.set(5, this.getReplyLevelCode(dataV, imagePath));
            dataV.add((String)dataV.get(6));
            dataV.add((String)dataV.get(6));
            htmlStr = htmlStr + this.parseOneRecord(tagsV, dataV, htmlCodeFile);
        }
        return htmlStr;
    }

    private String getReplyLevelCode(Vector dataV, String ImagePath) {
        int index = 5;
        String replyLevel = (String)dataV.elementAt(index);
        String imageStart = "<img src=\"";
        String imageEnd = "\">";
        String htmlCode = replyLevel.equals("1") ? imageStart + ImagePath + imageEnd : "";
        return htmlCode;
    }

    private String discPreParse(String[][] DBArr, Vector tagsV, File htmlCodeFile) throws IOException {
        String htmlStr = "";
        for (int i = 0; i < DBArr.length; ++i) {
            Vector<String> dataV = new Vector<String>();
            for (int j = 0; j < DBArr[i].length; ++j) {
                dataV.add(DBArr[i][j]);
            }
            htmlStr = htmlStr + this.parseOneRecord(tagsV, dataV, htmlCodeFile);
        }
        return htmlStr;
    }

    private Properties getShowDiscussionNbrParameters(HttpServletRequest req, Properties params) {
        if (params == null) {
            params = new Properties();
        }
        String newNbr = req.getParameter("NBR_OF_DISCS_TO_SHOW") == null ? "" : req.getParameter("NBR_OF_DISCS_TO_SHOW");
        String forumId = req.getParameter("FORUM_ID") == null ? "" : req.getParameter("FORUM_ID");
        params.setProperty("FORUM_ID", forumId);
        params.setProperty("NBR_OF_DISCS_TO_SHOW", newNbr);
        return params;
    }

    private Properties getAddForumParameters(HttpServletRequest req, Properties params) {
        if (params == null) {
            params = new Properties();
        }
        String newConfName = req.getParameter("NEW_FORUM_NAME") == null ? "" : req.getParameter("NEW_FORUM_NAME");
        params.setProperty("NEW_FORUM_NAME", newConfName);
        return params;
    }

    private Properties getRenameForumParameters(HttpServletRequest req, Properties params) {
        if (params == null) {
            params = new Properties();
        }
        String newConfName = req.getParameter("NEW_FORUM_NAME") == null ? "" : req.getParameter("NEW_FORUM_NAME");
        String renForumId = req.getParameter("FORUM_ID") == null ? "" : req.getParameter("FORUM_ID");
        params.setProperty("NEW_FORUM_NAME", newConfName);
        params.setProperty("FORUM_ID", renForumId);
        return params;
    }

    private Properties getDelForumParameters(HttpServletRequest req, Properties params) {
        if (params == null) {
            params = new Properties();
        }
        String forumId = req.getParameter("FORUM_ID") == null ? "" : req.getParameter("FORUM_ID");
        params.setProperty("FORUM_ID", forumId);
        return params;
    }

    private String[] getDelDiscParameters(HttpServletRequest req) {
        String[] discId = req.getParameterValues("DISC_DEL_BOX");
        return discId;
    }

    private String[] getDelReplyParameters(HttpServletRequest req) {
        String[] replyId = req.getParameterValues("REPLY_DEL_BOX");
        return replyId;
    }

    private Properties getStandardParameters(HttpServletRequest req) {
        Properties reqParams = MetaInfo.createPropertiesFromMetaInfoParameters(super.getConferenceSessionParameters(req));
        HttpSession session = req.getSession(false);
        if (session != null) {
            String forumId = (String)session.getAttribute("Conference.forum_id") == null ? "" : (String)session.getAttribute("Conference.forum_id");
            String discId = (String)session.getAttribute("Conference.disc_id") == null ? "" : (String)session.getAttribute("Conference.disc_id");
            String lastLogindate = (String)session.getAttribute("Conference.last_login_date") == null ? "" : (String)session.getAttribute("Conference.last_login_date");
            reqParams.setProperty("LAST_LOGIN_DATE", lastLogindate);
            reqParams.setProperty("FORUM_ID", forumId);
            reqParams.setProperty("DISC_ID", discId);
        }
        return reqParams;
    }

    private Vector buildAdminTags() {
        Vector<String> tagsV = new Vector<String>();
        tagsV.add("#DISC_DEL_ID#");
        tagsV.add("#ARCHIVE_DATE#");
        tagsV.add("#HEADLINE#");
        tagsV.add("#COUNT_REPLIES#");
        tagsV.add("#FIRST_NAME#");
        tagsV.add("#LAST_NAME#");
        return tagsV;
    }

    public void log(String str) {
        super.log(str);
        System.out.println("ConfAdmin: " + str);
    }
}

