/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.chat;

import imcode.external.chat.ChatBase;
import imcode.external.chat.ChatError;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import java.io.IOException;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ChatHelp
extends ChatBase {
    private static final String USER_TEMPLATE = "conf_help_user.htm";
    private static final String ADMIN_TEMPLATE = "conf_help_admin.htm";
    private static final String ADMIN_TEMPLATE2 = "conf_help_admin2.htm";

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Properties params = this.getParameters(req);
        UserDomainObject user = super.getUserObj(req);
        if (user == null) {
            return;
        }
        if (this.isUserAuthorized(req, res, user)) {
            String file = "";
            if (params.getProperty("HELP_MODE").equalsIgnoreCase("USER")) {
                file = USER_TEMPLATE;
            } else if (params.getProperty("HELP_MODE").equalsIgnoreCase("ADMIN")) {
                int metaId = this.getMetaId(req);
                ImcmsServices imcref = Imcms.getServices();
                if (this.userHasAdminRights(imcref, metaId, user)) {
                    file = ADMIN_TEMPLATE;
                    if (params.getProperty("HELP_AREA").equalsIgnoreCase("TEMPLATESPEC")) {
                        file = ADMIN_TEMPLATE2;
                    }
                } else {
                    String header = "ConfHelp servlet. ";
                    new ChatError(req, res, header, 6);
                    return;
                }
            }
            this.sendHtml(req, res, new Vector(), file, null);
            return;
        }
    }

    private Properties getParameters(HttpServletRequest req) {
        Properties params = super.getSessionParameters(req);
        super.getExtSessionParameters(req, params);
        String helpInfo = req.getParameter("helparea") == null ? "" : req.getParameter("helparea");
        String helpMode = req.getParameter("helpmode") == null ? "" : req.getParameter("helpmode");
        params.setProperty("HELP_AREA", helpInfo);
        params.setProperty("HELP_MODE", helpMode);
        return params;
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String action = req.getMethod();
        if (action.equals("POST")) {
            this.doPost(req, res);
        } else {
            this.doPost(req, res);
        }
    }

    public void log(String str) {
        super.log("ChatHelp: " + str);
    }
}

