/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.chat;

import imcode.external.chat.Chat;
import imcode.external.chat.ChatBase;
import imcode.external.chat.ChatError;
import imcode.external.diverse.FileManager;
import imcode.external.diverse.RmiConf;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ChatCreator
extends ChatBase {
    private static final String HTML_TEMPLATE = "admin_chat.html";
    private static final String HTML_TEMPLATES_BUTTON = "chat_template_admin.html";
    private static final String ADMIN_TEMPLATES_TEMPLATE = "chat_admin_template1.html";
    private static final String ADMIN_TEMPLATES_TEMPLATE_2 = "chat_admin_template2.html";
    private static final String MSG_TYPE_SAYS_TO = "100";
    private static final String MSG_TYPE_ASKS = "102";
    private static final int MAX_REFRESH_TIME = 180;

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session = req.getSession(false);
        UserDomainObject user = super.getUserObj(req);
        if (user == null) {
            return;
        }
        if (!this.isUserAuthorized(req, res, user)) {
            this.log("isUserAuthorized==false");
            return;
        }
        String action = req.getParameter("action");
        if (action == null) {
            String header = "ChatCreator servlet. ";
            ChatError err = new ChatError(req, res, header, 3);
            this.log(header + err.getErrorMsg());
            return;
        }
        Chat myChat = (Chat)session.getAttribute("myChat");
        if (myChat == null) {
            myChat = this.createChat(this.getMetaId(req));
        }
        int metaId = myChat.getChatId();
        if (action.equalsIgnoreCase("admin_chat")) {
            int type;
            this.log("admin_chat");
            if (req.getParameter("addMsgType") != null && !req.getParameter("msgType").trim().equals("")) {
                myChat.addMsgType(req.getParameter("msgType"));
            }
            if (req.getParameter("removeMsgType") != null && req.getParameter("msgTypes") != null && ((type = Integer.parseInt(req.getParameter("msgTypes"))) < 100 || type >= 104)) {
                myChat.removeMsgType(type);
            }
            if (req.getParameterValues("authorized") != null) {
                myChat.setSelectedAuto(req.getParameterValues("authorized"));
            }
            if (req.getParameter("update") != null) {
                myChat.setRefreshTime(Integer.parseInt(req.getParameter("update")));
            }
            if (req.getParameter("reload") != null) {
                myChat.setAutoRefreshEnabled(Integer.parseInt(req.getParameter("reload")));
            }
            if (req.getParameter("inOut") != null) {
                myChat.setShowEnterAndLeaveMessagesEnabled(Integer.parseInt(req.getParameter("inOut")));
            }
            if (req.getParameter("private") != null) {
                myChat.setShowPrivateMessagesEnabled(Integer.parseInt(req.getParameter("private")));
            }
            if (req.getParameter("dateTime") != null) {
                myChat.setShowDateTimesEnabled(Integer.parseInt(req.getParameter("dateTime")));
            }
            if (req.getParameter("font") != null) {
                myChat.setFontSize(Integer.parseInt(req.getParameter("font")));
            }
            ImcmsServices imcref = Imcms.getServices();
            if (req.getParameter("okChat") != null) {
                this.createChat(metaId, myChat, imcref, user, res);
                return;
            }
            if (req.getParameter("admin_templates_meta") != null) {
                String newLibName;
                this.log("admin_templates_meta");
                if (req.getParameter("add_templates") != null) {
                    newLibName = req.getParameter("template_lib_name");
                    if (newLibName == null) {
                        String header = "ChatCreator servlet. ";
                        new ChatError(req, res, header, 80);
                        return;
                    }
                    String libNameExists = imcref.sqlProcedureStr("C_FindTemplateLib", new String[]{newLibName});
                    if (!libNameExists.equalsIgnoreCase("-1")) {
                        String header = "ChatCreator servlet. ";
                        new ChatError(req, res, header, 84);
                        return;
                    }
                    this.log("lang_prefix for External Template Folder = " + user.getLanguageIso639_2());
                    imcref.sqlUpdateProcedure("C_AddTemplateLib", new String[]{newLibName});
                    FileManager fileObj = new FileManager();
                    File templateSrc = new File(imcref.getExternalTemplateFolder(metaId, user), "original");
                    File imageSrc = new File(RmiConf.getImagePathForExternalDocument(imcref, metaId, user), "original");
                    File templateTarget = new File(imcref.getExternalTemplateFolder(metaId, user), newLibName);
                    File imageTarget = new File(RmiConf.getImagePathForExternalDocument(imcref, metaId, user), newLibName);
                    fileObj.copyDirectory(templateSrc, templateTarget);
                    fileObj.copyDirectory(imageSrc, imageTarget);
                }
                if (req.getParameter("change_templatelib") != null) {
                    this.log("change_templatelib");
                    newLibName = req.getParameter("new_templateset_name");
                    if (newLibName == null) {
                        String header = "ChatCreator servlet. ";
                        new ChatError(req, res, header, 80);
                        return;
                    }
                    String templateId = imcref.sqlProcedureStr("C_GetTemplateIdFromName", new String[]{newLibName});
                    if (templateId.equalsIgnoreCase("-1")) {
                        String header = "ChatCreator servlet. ";
                        new ChatError(req, res, header, 81);
                        return;
                    }
                    imcref.sqlUpdateProcedure("C_deleteChatTemplateset", new String[]{"" + metaId});
                    imcref.sqlUpdateProcedure("C_SetNewTemplateLib", new String[]{"" + metaId, newLibName});
                }
                if (req.getParameter("UPLOAD_CHAT") != null) {
                    this.log("UPLOAD_CHAT");
                    String folderName = req.getParameter("TEMPLATE_NAME");
                    String uploadType = req.getParameter("UPLOAD_TYPE");
                    if (folderName == null || uploadType == null) {
                        return;
                    }
                    Vector<String> tags = new Vector<String>();
                    tags.add("#META_ID#");
                    tags.add(metaId + "");
                    tags.add("#UPLOAD_TYPE#");
                    tags.add(uploadType);
                    tags.add("#FOLDER_NAME#");
                    tags.add(folderName);
                    this.sendHtml(req, res, tags, ADMIN_TEMPLATES_TEMPLATE_2, null);
                    return;
                }
            }
            if (req.getParameter("adminTemplates") != null) {
                this.log("adminTemplates");
                String templateSetName = imcref.sqlProcedureStr("C_GetTemplateLib", new String[]{"" + metaId});
                if (templateSetName == null) {
                    templateSetName = "";
                }
                String[] templateLibs = imcref.sqlProcedure("C_GetAllTemplateLibs", new String[0]);
                Vector vect = new Vector();
                if (templateLibs != null) {
                    vect = super.convert2Vector(templateLibs);
                }
                Vector<String> tags = new Vector<String>();
                tags.add("#TEMPLATE_LIST#");
                tags.add(ChatCreator.createOptionCode(templateSetName, vect));
                tags.add("#CURRENT_TEMPLATE_SET#");
                tags.add(templateSetName);
                this.sendHtml(req, res, tags, ADMIN_TEMPLATES_TEMPLATE, null);
                return;
            }
        }
        this.log("default k\u00f6ret");
        this.sendHtml(req, res, this.createTaggs(myChat, user), HTML_TEMPLATE, myChat);
    }

    private void createChat(int metaId, Chat myChat, ImcmsServices imcref, UserDomainObject user, HttpServletResponse res) throws IOException {
        this.log("okChat");
        String result = imcref.sqlProcedureStr("C_FindMetaId", new String[]{"" + metaId});
        boolean chatDoesNotExist = result.equals("1");
        if (chatDoesNotExist) {
            imcref.sqlUpdateProcedure("C_AddNewChat", new String[]{"" + metaId, myChat.getChatName(), "3"});
        }
        imcref.sqlUpdateProcedure("C_Delete_MsgTypes", new String[]{"" + metaId});
        String[] tempTypes = imcref.sqlProcedure("C_GetBaseMsgTypes", new String[0]);
        for (int i = 0; i < tempTypes.length; ++i) {
            String tempTypeId = imcref.sqlProcedureStr("C_GetMsgTypeId", new String[]{tempTypes[i]});
            if (!MSG_TYPE_SAYS_TO.equals(tempTypeId) && !MSG_TYPE_ASKS.equals(tempTypeId)) continue;
            imcref.sqlUpdateProcedure("C_AddNewChatMsg", new String[]{tempTypeId, "" + metaId});
        }
        Vector msgV = myChat.getMsgTypes();
        for (int i = 0; i < msgV.size(); i += 2) {
            imcref.sqlUpdateProcedure("C_AddMessageType", new String[]{"" + metaId, "" + msgV.get(i), "" + msgV.get(i + 1)});
        }
        imcref.sqlUpdateProcedure("C_AddChatParams", new String[]{"" + metaId, "" + myChat.getRefreshTime(), "" + myChat.isAutoRefreshEnabled(), "" + myChat.isShowEnterAndLeaveMessagesEnabled(), "" + myChat.isShowPrivateMessagesEnabled(), "" + myChat.isShowPublicMessagesEnabled(), "" + myChat.isShowDateTimesEnabled(), "" + myChat.getfont()});
        imcref.sqlUpdateProcedure("C_DeleteAuthorizations", new String[]{"" + metaId});
        Vector autoV = myChat.getSelectedAuto();
        for (int i = 0; i < autoV.size(); ++i) {
            imcref.sqlUpdateProcedure("C_ChatAutoTypes", new String[]{"" + autoV.elementAt(i), "" + metaId});
        }
        String[][] messages = imcref.sqlProcedureMulti("C_GetMsgTypes", new String[]{"" + metaId});
        if (messages != null) {
            myChat.setMsgTypes(this.convert2Vector(messages));
        }
        ServletContext myContext = this.getServletContext();
        myContext.setAttribute("theChat" + metaId, (Object)myChat);
        res.sendRedirect("ChatLogin?login_type=login&meta_id=" + metaId);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.log("startar do get");
        HttpSession session = req.getSession(false);
        UserDomainObject user = super.getUserObj(req);
        if (user == null) {
            return;
        }
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        String action = req.getParameter("action");
        if (action == null && (action = (String)req.getAttribute("action")) == null) {
            String header = "ChatCreator servlet. ";
            ChatError err = new ChatError(req, res, header, 3);
            this.log(header + err.getErrorMsg());
            return;
        }
        if (action.equalsIgnoreCase("NEW")) {
            this.log("NEW");
            int meta_id = Integer.parseInt((String)session.getAttribute("Chat.meta_id"));
            Chat myChat = this.createChat(meta_id);
            session.setAttribute("myChat", (Object)myChat);
            Vector vect = this.createTaggs(myChat, user);
            this.sendHtml(req, res, vect, HTML_TEMPLATE, myChat);
            return;
        }
        String templateAdmin = req.getParameter("ADMIN_TEMPLATES");
        if (templateAdmin != null) {
            this.doPost(req, res);
            return;
        }
        if (action.equalsIgnoreCase("admin_chat")) {
            this.log("action =  admin_chat");
            String chatName = req.getParameter("chatName");
            this.log("ChatName: " + chatName);
            Vector<String> tags = new Vector<String>();
            tags.add("#chatName#");
            tags.add(chatName);
            String metaId = (String)session.getAttribute("Chat.meta_id");
            this.log("MetaId: " + metaId);
            ServletContext myContext = this.getServletContext();
            Chat myChat = (Chat)myContext.getAttribute("theChat" + metaId);
            this.log("Chat: " + myChat);
            Vector vect = this.createTaggs(myChat, user);
            this.sendHtml(req, res, vect, HTML_TEMPLATE, myChat);
            return;
        }
    }

    private String getTemplateButtonHtml(int metaId, UserDomainObject user) {
        ImcmsServices imcref = Imcms.getServices();
        return imcref.getTemplateFromSubDirectoryOfDirectory(HTML_TEMPLATES_BUTTON, user, null, "103", ChatCreator.getTemplateSetDirectoryName(metaId));
    }

    private Vector createTaggs(Chat chat, UserDomainObject user) {
        Vector<String> bv = new Vector<String>();
        bv.add("1");
        bv.add("2");
        bv.add("3");
        Vector<String> taggs = new Vector<String>();
        taggs.add("#msgTypes#");
        taggs.add(ChatCreator.createOptionCode("s\u00e4ger till", chat.getMsgTypes()));
        taggs.add("#authorized#");
        taggs.add(ChatCreator.createOptionCode(chat.getSelectedAuto(), chat.getAuthorizations()));
        taggs.add("#msgType#");
        taggs.add("");
        taggs.add("#updateTime#");
        taggs.add(ChatCreator.createOptionCode(chat.getRefreshTime() + "", ChatCreator.createUpdateTimeV()));
        taggs.add("#reload#");
        taggs.add(ChatCreator.createRadioButton("reload", bv, chat.isAutoRefreshEnabled() + ""));
        taggs.add("#inOut#");
        taggs.add(ChatCreator.createRadioButton("inOut", bv, chat.isShowEnterAndLeaveMessagesEnabled() + ""));
        taggs.add("#private#");
        taggs.add(ChatCreator.createRadioButton("private", bv, chat.isShowPrivateMessagesEnabled() + ""));
        taggs.add("#dateTime#");
        taggs.add(ChatCreator.createRadioButton("dateTime", bv, chat.isShowDateTimesEnabled() + ""));
        taggs.add("#font#");
        taggs.add(ChatCreator.createRadioButton("font", bv, chat.getfont() + ""));
        taggs.add("#templates#");
        taggs.add(this.getTemplateButtonHtml(chat.getChatId(), user));
        return taggs;
    }

    public static Vector createUpdateTimeV() {
        Vector<String> vect = new Vector<String>();
        for (int i = 10; i < 190; i += 10) {
            vect.add(i + "");
            vect.add(i + "");
        }
        return vect;
    }
}

