/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.billboard;

import com.imcode.imcms.servlet.billboard.BillBoard;
import com.imcode.imcms.servlet.billboard.BillBoardError;
import imcode.external.diverse.MetaInfo;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BillBoardCreator
extends BillBoard {
    private static final String HTML_TEMPLATE = "billboard_creator.htm";

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Properties params = MetaInfo.createPropertiesFromMetaInfoParameters(super.getBillBoardSessionParameters(req));
        Properties confParams = this.getNewConfParameters(req);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (user == null) {
            return;
        }
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        String action = req.getParameter("action");
        if (action == null) {
            action = "";
            String header = "BillBoardCreator servlet. ";
            BillBoardError err = new BillBoardError(req, res, header, 3, user.getLanguageIso639_2(), user);
            this.log(header + err.getErrorMsg());
            return;
        }
        ImcmsServices imcref = Imcms.getServices();
        if (action.equalsIgnoreCase("ADD_BILLBOARD")) {
            String metaId = params.getProperty("META_ID");
            String foundMetaId = imcref.sqlProcedureStr("B_FindMetaId", new String[]{metaId});
            if (!foundMetaId.equals("1")) {
                action = "";
                String header = "BillBoardCreator servlet. ";
                BillBoardError err = new BillBoardError(req, res, header, 90, user.getLanguageIso639_2(), user);
                this.log(header + err.getErrorMsg());
                return;
            }
            String confName = confParams.getProperty("BILLBOARD_NAME");
            String subject = confParams.getProperty("SUBJECT_NAME");
            imcref.sqlUpdateProcedure("B_AddNewBillBoard", new String[]{metaId, confName, subject});
            String archiveMode = "A";
            String archiveTime = "30";
            String daysToShow = "14";
            imcref.sqlUpdateProcedure("B_AddNewSection", new String[]{metaId, confParams.getProperty("SECTION_NAME"), "A", "30", "14"});
            String loginPage = "BillBoardLogin?login_type=login";
            res.sendRedirect(loginPage);
            return;
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (user == null) {
            return;
        }
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        String action = req.getParameter("action");
        if (action == null) {
            action = "";
            String header = "BillBoardCreator servlet. ";
            BillBoardError err = new BillBoardError(req, res, header, 3, user.getLanguageIso639_2(), user);
            this.log(header + err.getErrorMsg());
            return;
        }
        if (action.equalsIgnoreCase("NEW")) {
            VariableManager vm = new VariableManager();
            vm.addProperty("SERVLET_URL", "");
            this.sendHtml(req, res, vm, HTML_TEMPLATE);
            return;
        }
    }

    private Properties getNewConfParameters(HttpServletRequest req) {
        Properties confP = new Properties();
        String billBoard_name = req.getParameter("billBoard_name") == null ? "" : req.getParameter("billBoard_name");
        String section_name = req.getParameter("section_name") == null ? "" : req.getParameter("section_name");
        String subject_name = req.getParameter("subject_name") == null ? "" : req.getParameter("subject_name");
        confP.setProperty("BILLBOARD_NAME", billBoard_name.trim());
        confP.setProperty("SECTION_NAME", section_name.trim());
        confP.setProperty("SUBJECT_NAME", subject_name.trim());
        return confP;
    }

    public void log(String msg) {
        super.log("BillBoardCreator: " + msg);
    }
}

