/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentMapper;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import imcode.util.poll.PollHandlingSystem;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class SaveText
extends HttpServlet {
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws IOException {
        req.setCharacterEncoding("windows-1252");
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        ImcmsServices imcref = Imcms.getServices();
        int meta_id = Integer.parseInt(req.getParameter("meta_id"));
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (imcref.checkDocAdminRights(meta_id, user, 65536) && req.getParameter("cancel") == null) {
            int txt_no = Integer.parseInt(req.getParameter("txt_no"));
            String text_string = req.getParameter("text");
            int text_format = Integer.parseInt(req.getParameter("format_type"));
            String text_type = req.getParameter("txt_type");
            if (text_type == null) {
                text_type = "";
            }
            TextDomainObject text = new TextDomainObject(text_string, text_format);
            DocumentMapper documentMapper = imcref.getDocumentMapper();
            TextDocumentDomainObject document = (TextDocumentDomainObject)documentMapper.getDocument(meta_id);
            this.saveText(documentMapper, text, document, txt_no, text_type, imcref, meta_id, user);
            if (null != req.getParameter("save")) {
                res.sendRedirect("ChangeText?meta_id=" + meta_id + "&txt=" + txt_no);
                return;
            }
        }
        res.sendRedirect("AdminDoc?meta_id=" + meta_id + "&flags=" + 65536);
    }

    private void saveText(DocumentMapper documentMapper, TextDomainObject text, TextDocumentDomainObject document, int txt_no, String text_type, ImcmsServices imcref, int meta_id, UserDomainObject user) {
        document.setText(txt_no, text);
        documentMapper.saveDocument(document, user);
        if (!"".equals(text_type) && text_type.startsWith("poll")) {
            PollHandlingSystem poll = imcref.getPollHandlingSystem();
            poll.savePollparameter(text_type, document.getId(), txt_no, text.getText());
        }
        imcref.updateMainLog("Text " + txt_no + " in [" + meta_id + "] modified by user: [" + user.getFullName() + "]");
    }
}

