/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.admin;

import com.imcode.imcms.servlet.admin.AdminDoc;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentMapper;
import imcode.server.document.MaxCategoryDomainObjectsOfTypeExceededException;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.TemplateGroupDomainObject;
import imcode.server.document.TemplateMapper;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SaveInPage
extends HttpServlet {
    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String output;
        ImcmsServices services = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        DocumentMapper documentMapper = services.getDocumentMapper();
        int documentId = Integer.parseInt(req.getParameter("meta_id"));
        TextDocumentDomainObject textDocument = (TextDocumentDomainObject)documentMapper.getDocument(documentId);
        TemplateMapper templateMapper = services.getTemplateMapper();
        TemplateDomainObject requestedTemplate = this.getRequestedTemplate(req, templateMapper);
        TemplateGroupDomainObject requestedTemplateGroup = this.getRequestedTemplateGroup(req, templateMapper);
        TextDocumentPermissionSetDomainObject textDocumentPermissionSet = (TextDocumentPermissionSetDomainObject)user.getPermissionSetFor(textDocument);
        TemplateGroupDomainObject[] allowedTemplateGroups = textDocumentPermissionSet.getAllowedTemplateGroups(services);
        boolean requestedTemplateGroupIsAllowed = null == requestedTemplateGroup;
        boolean requestedTemplateIsAllowed = null == requestedTemplate;
        for (int i = 0; i < allowedTemplateGroups.length; ++i) {
            TemplateGroupDomainObject allowedTemplateGroup = allowedTemplateGroups[i];
            if (allowedTemplateGroup.equals(requestedTemplateGroup)) {
                requestedTemplateGroupIsAllowed = true;
            }
            if (!templateMapper.templateGroupContainsTemplate(allowedTemplateGroup, requestedTemplate)) continue;
            requestedTemplateIsAllowed = true;
        }
        if (!(services.checkDocAdminRights(documentId, user, 524288) && requestedTemplateIsAllowed && requestedTemplateGroupIsAllowed)) {
            Utility.setDefaultHtmlContentType(res);
            String output2 = AdminDoc.adminDoc(documentId, user, req, res);
            if (output2 != null) {
                PrintWriter out = res.getWriter();
                ((Writer)out).write(output2);
            }
            return;
        }
        if (req.getParameter("update") != null) {
            PrintWriter out = res.getWriter();
            Utility.setDefaultHtmlContentType(res);
            user.put("flags", new Integer(0));
            if (requestedTemplate == null) {
                ArrayList<String> vec = new ArrayList<String>();
                vec.add("#meta_id#");
                vec.add(String.valueOf(documentId));
                String htmlStr = services.getAdminTemplate("inPage_admin_no_template.html", user, vec);
                ((Writer)out).write(htmlStr);
                return;
            }
            textDocument.setTemplate(requestedTemplate);
            if (null != requestedTemplateGroup) {
                textDocument.setTemplateGroupId(requestedTemplateGroup.getId());
            }
            try {
                documentMapper.saveDocument(textDocument, user);
                services.updateMainLog("Text docs  [" + textDocument.getId() + "] updated by user: [" + user.getFullName() + "]");
            }
            catch (MaxCategoryDomainObjectsOfTypeExceededException e) {
                throw new RuntimeException(e);
            }
            output = AdminDoc.adminDoc(documentId, user, req, res);
            if (output != null) {
                ((Writer)out).write(output);
            }
            return;
        }
        if (req.getParameter("preview") != null) {
            String htmlStr;
            if (requestedTemplate == null) {
                ArrayList<String> vec = new ArrayList<String>();
                vec.add("#meta_id#");
                vec.add(String.valueOf(documentId));
                Utility.setDefaultHtmlContentType(res);
                htmlStr = services.getAdminTemplate("inPage_admin_no_template.html", user, vec);
                PrintWriter out = res.getWriter();
                ((Writer)out).write(htmlStr);
                return;
            }
            Object[] temp = services.getDemoTemplate(requestedTemplate.getId());
            if (temp != null) {
                String demoTemplateName = requestedTemplate.getId() + "." + temp[0];
                res.setContentType(this.getServletContext().getMimeType(demoTemplateName));
                byte[] bytes = (byte[])temp[1];
                ServletOutputStream out = res.getOutputStream();
                res.setContentLength(bytes.length);
                out.write(bytes);
                return;
            }
            Utility.setDefaultHtmlContentType(res);
            htmlStr = services.getAdminTemplate("no_demotemplate.html", user, null);
            PrintWriter out = res.getWriter();
            ((Writer)out).write(htmlStr);
            return;
        }
        if (req.getParameter("change_group") != null) {
            Utility.setDefaultHtmlContentType(res);
            PrintWriter out = res.getWriter();
            user.put("flags", new Integer(524288));
            if (null != requestedTemplateGroup) {
                user.setTemplateGroup(requestedTemplateGroup);
            }
            if ((output = AdminDoc.adminDoc(documentId, user, req, res)) != null) {
                ((Writer)out).write(output);
            }
            return;
        }
    }

    private TemplateGroupDomainObject getRequestedTemplateGroup(HttpServletRequest req, TemplateMapper templateMapper) {
        try {
            return templateMapper.getTemplateGroupById(Integer.parseInt(req.getParameter("group")));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    private TemplateDomainObject getRequestedTemplate(HttpServletRequest req, TemplateMapper templateMapper) {
        try {
            return templateMapper.getTemplateById(Integer.parseInt(req.getParameter("template")));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }
}

