/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Stack;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BackDoc
extends HttpServlet {
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        Utility.setDefaultHtmlContentType(res);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        Stack history = (Stack)user.get("history");
        boolean useNextToLastTextDocument = req.getParameter("top") == null;
        int lastTextDocumentId = BackDoc.getLastTextDocumentFromHistory(history, useNextToLastTextDocument, imcref);
        if (lastTextDocumentId != 0) {
            user.put("history", history);
            this.redirectToDocumentId(req, res, lastTextDocumentId);
        } else {
            this.redirectToDocumentId(req, res, imcref.getSystemData().getStartDocument());
        }
    }

    private void redirectToDocumentId(HttpServletRequest request, HttpServletResponse response, int meta_id) throws IOException {
        DocumentDomainObject document = Imcms.getServices().getDocumentMapper().getDocument(meta_id);
        response.sendRedirect(Utility.getAbsolutePathToDocument(request, document));
    }

    public static int getLastTextDocumentFromHistory(Stack history, boolean useNextToLastTextDocument, ImcmsServices imcref) {
        int meta_id = 0;
        if (null != history && !history.empty()) {
            int tmp_meta_id;
            boolean docTypeIsText;
            if (useNextToLastTextDocument && (docTypeIsText = BackDoc.isTextDocument(imcref, tmp_meta_id = ((Integer)history.peek()).intValue()))) {
                meta_id = (Integer)history.pop();
            }
            while (!history.empty()) {
                tmp_meta_id = (Integer)history.pop();
                docTypeIsText = BackDoc.isTextDocument(imcref, tmp_meta_id);
                if (!docTypeIsText) continue;
                meta_id = tmp_meta_id;
                break;
            }
        }
        return meta_id;
    }

    private static boolean isTextDocument(ImcmsServices imcref, int tmp_meta_id) {
        int doc_type = imcref.getDocType(tmp_meta_id);
        boolean docTypeIsText = doc_type == 1 || doc_type == 2;
        return docTypeIsText;
    }
}

