/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.Category;
import com.imcode.imcms.api.CategoryType;
import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.DocumentPermissionSet;
import com.imcode.imcms.api.Language;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.NoSuchRoleException;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.Section;
import com.imcode.imcms.api.SecurityChecker;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.util.ChainableReversibleNullComparator;
import imcode.server.document.CategoryDomainObject;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.DocumentPermissionSetMapper;
import imcode.server.document.SectionDomainObject;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.UnhandledException;
import org.apache.log4j.Logger;

public class Document {
    private DocumentDomainObject internalDocument;
    ContentManagementSystem contentManagementSystem;
    private static final Logger log = Logger.getLogger((String)Document.class.getName());
    public static final int STATUS_NEW = 0;
    public static final int STATUS_PUBLICATION_DISAPPROVED = 1;
    public static final int STATUS_PUBLICATION_APPROVED = 2;

    protected Document(DocumentDomainObject document, ContentManagementSystem contentManagementSystem) {
        this.internalDocument = document;
        this.contentManagementSystem = contentManagementSystem;
    }

    DocumentDomainObject getInternal() {
        return this.internalDocument;
    }

    SecurityChecker getSecurityChecker() {
        return this.contentManagementSystem.getSecurityChecker();
    }

    public int getId() {
        return this.internalDocument.getId();
    }

    public Map getAllRolesMappedToPermissions() throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        Map rolesMappedToPermissionSetIds = this.internalDocument.getRolesMappedToPermissionSetIds();
        HashMap<String, DocumentPermissionSetDomainObject> result = new HashMap<String, DocumentPermissionSetDomainObject>();
        Iterator it = rolesMappedToPermissionSetIds.entrySet().iterator();
        block6: while (it.hasNext()) {
            Map.Entry rolePermissionTuple = it.next();
            RoleDomainObject role = (RoleDomainObject)rolePermissionTuple.getKey();
            int permissionType = (Integer)rolePermissionTuple.getValue();
            switch (permissionType) {
                case 0: {
                    result.put(role.getName(), DocumentPermissionSetDomainObject.FULL);
                    continue block6;
                }
                case 1: 
                case 2: {
                    result.put(role.getName(), this.getDocumentPermissionSetMapper().getRestrictedPermissionSet(this.internalDocument, permissionType, false));
                    continue block6;
                }
                case 3: {
                    result.put(role.getName(), DocumentPermissionSetDomainObject.READ);
                    continue block6;
                }
                case 4: {
                    continue block6;
                }
            }
            log.warn((Object)"A missing mapping in DocumentPermissionSetMapper");
        }
        return Document.wrapDomainObjectsInMap(result);
    }

    private DocumentPermissionSetMapper getDocumentPermissionSetMapper() {
        return this.contentManagementSystem.getInternal().getDocumentMapper().getDocumentPermissionSetMapper();
    }

    private static Map wrapDomainObjectsInMap(Map rolesMappedToPermissionsIds) {
        HashMap<String, DocumentPermissionSet> result = new HashMap<String, DocumentPermissionSet>();
        Set keys = rolesMappedToPermissionsIds.keySet();
        Iterator keyIterator = keys.iterator();
        while (keyIterator.hasNext()) {
            String roleName = (String)keyIterator.next();
            DocumentPermissionSetDomainObject documentPermissionSetDO = (DocumentPermissionSetDomainObject)rolesMappedToPermissionsIds.get(roleName);
            DocumentPermissionSet documentPermissionSet = new DocumentPermissionSet(documentPermissionSetDO);
            result.put(roleName, documentPermissionSet);
        }
        return result;
    }

    public DocumentPermissionSet getDocumentPermissionSetForUser() {
        return new DocumentPermissionSet(this.contentManagementSystem.getCurrentUser().getInternal().getPermissionSetFor(this.internalDocument));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document document = (Document)o;
        return this.internalDocument.equals(document.internalDocument);
    }

    public int hashCode() {
        return this.internalDocument.hashCode();
    }

    public DocumentPermissionSet getPermissionSetRestrictedOne() throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        DocumentPermissionSetDomainObject restrictedOne = this.getDocumentPermissionSetMapper().getPermissionSetRestrictedOne(this.internalDocument);
        DocumentPermissionSet result = new DocumentPermissionSet(restrictedOne);
        return result;
    }

    public DocumentPermissionSet getPermissionSetRestrictedTwo() throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        DocumentPermissionSetDomainObject restrictedTwo = this.getDocumentPermissionSetMapper().getPermissionSetRestrictedTwo(this.internalDocument);
        DocumentPermissionSet result = new DocumentPermissionSet(restrictedTwo);
        return result;
    }

    public String getHeadline() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return this.internalDocument.getHeadline();
    }

    public String getMenuText() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return this.internalDocument.getMenuText();
    }

    public String getMenuImageURL() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return this.internalDocument.getMenuImage();
    }

    public void setHeadline(String headline) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        this.internalDocument.setHeadline(headline);
    }

    public void setMenuText(String menuText) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        this.internalDocument.setMenuText(menuText);
    }

    public void setMenuImageURL(String imageUrl) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        this.internalDocument.setMenuImage(imageUrl);
    }

    public User getCreator() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return new User(this.internalDocument.getCreator());
    }

    public void setCreator(User creator) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        this.internalDocument.setCreator(creator.getInternal());
    }

    public Language getLanguage() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return Language.getLanguageByISO639_2(this.internalDocument.getLanguageIso639_2());
    }

    public void setLanguage(int lang_id) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        String lang_prefix = this.contentManagementSystem.getInternal().getLanguagePrefixByLangId(lang_id);
        this.internalDocument.setLanguageIso639_2(lang_prefix);
    }

    public void addCategory(Category category) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        this.internalDocument.addCategory(category.getInternal());
    }

    public void removeCategory(Category category) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        this.internalDocument.removeCategory(category.getInternal());
    }

    public Category[] getCategories() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        CategoryDomainObject[] categoryDomainObjects = this.internalDocument.getCategories();
        return this.getCategoryArrayFromCategoryDomainObjectArray(categoryDomainObjects);
    }

    private Category[] getCategoryArrayFromCategoryDomainObjectArray(CategoryDomainObject[] categoryDomainObjects) {
        Category[] categories = new Category[categoryDomainObjects.length];
        for (int i = 0; i < categories.length; ++i) {
            CategoryDomainObject categoryDomainObject = categoryDomainObjects[i];
            categories[i] = new Category(categoryDomainObject);
        }
        return categories;
    }

    public void setPermissionSetForRole(String roleName, int permissionSet) throws NoSuchRoleException, NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        RoleDomainObject role = this.contentManagementSystem.getInternal().getImcmsAuthenticatorAndUserAndRoleMapper().getRoleByName(roleName);
        if (null == role) {
            throw new NoSuchRoleException("No role by the name '" + roleName + "'.");
        }
        this.internalDocument.setPermissionSetIdForRole(role, permissionSet);
    }

    public void setPermissionSetIdForRole(Role role, int permissionSetId) throws NoSuchRoleException, NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        if (null != role) {
            this.internalDocument.setPermissionSetIdForRole(role.getInternal(), permissionSetId);
        }
    }

    public int getPermissionSetIdForRole(Role role) {
        return this.internalDocument.getPermissionSetIdForRole(role.getInternal());
    }

    public Category[] getCategoriesOfType(CategoryType categoryType) throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        CategoryDomainObject[] categoryDomainObjects = this.internalDocument.getCategoriesOfType(categoryType.getInternal());
        return this.getCategoryArrayFromCategoryDomainObjectArray(categoryDomainObjects);
    }

    public User getPublisher() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        UserDomainObject publisher = this.internalDocument.getPublisher();
        if (null != publisher) {
            return new User(publisher);
        }
        return null;
    }

    public String getTarget() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return this.internalDocument.getTarget();
    }

    public Date getActivatedDatetime() throws NoPermissionException {
        return this.getPublicationStartDatetime();
    }

    public Date getPublicationStartDatetime() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return this.internalDocument.getPublicationStartDatetime();
    }

    public void setActivatedDatetime(Date datetime) throws NoPermissionException {
        this.setPublicationStartDatetime(datetime);
    }

    public void setPublicationStartDatetime(Date datetime) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        this.internalDocument.setPublicationStartDatetime(datetime);
    }

    public Date getArchivedDatetime() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return this.internalDocument.getArchivedDatetime();
    }

    public void setArchivedDatetime(Date datetime) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        this.internalDocument.setArchivedDatetime(datetime);
    }

    public void setPublisher(User user) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        this.internalDocument.setPublisher(user.getInternal());
    }

    public Section[] getSections() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        SectionDomainObject[] sectionDomainObjects = this.internalDocument.getSections();
        Section[] sections = new Section[sectionDomainObjects.length];
        for (int i = 0; i < sectionDomainObjects.length; ++i) {
            SectionDomainObject sectionDomainObject = sectionDomainObjects[i];
            sections[i] = new Section(sectionDomainObject);
        }
        return sections;
    }

    public void setSections(Section[] sections) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        SectionDomainObject[] internalSections = new SectionDomainObject[sections.length];
        for (int i = 0; i < sections.length; ++i) {
            Section section = sections[i];
            internalSections[i] = section.internalSection;
        }
        this.internalDocument.setSections(internalSections);
    }

    public Date getModifiedDatetime() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return this.internalDocument.getModifiedDatetime();
    }

    public void setModifiedDatetime(Date date) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        this.internalDocument.setModifiedDatetime(date);
    }

    public Date getCreatedDatetime() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return this.internalDocument.getCreatedDatetime();
    }

    public void addSection(Section section) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        this.internalDocument.addSection(section.internalSection);
    }

    public void setStatus(int status) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        this.internalDocument.setStatus(status);
    }

    public void setLanguage(Language language) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        this.internalDocument.setLanguageIso639_2(language.getIsoCode639_2());
    }

    public void setPublicationEndDatetime(Date datetime) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        this.internalDocument.setPublicationEndDatetime(datetime);
    }

    public Date getPublicationEndDatetime() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return this.internalDocument.getPublicationEndDatetime();
    }

    public int getStatus() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return this.internalDocument.getStatus();
    }

    public void setVisibleInMenusForUnauthorizedUsers(boolean visibleInMenusForUnauthorizedUsers) throws NoPermissionException {
        this.getSecurityChecker().hasEditPermission(this);
        this.internalDocument.setVisibleInMenusForUnauthorizedUsers(visibleInMenusForUnauthorizedUsers);
    }

    public boolean isVisibleInMenusForUnauthorizedUsers() throws NoPermissionException {
        this.getSecurityChecker().hasAtLeastDocumentReadPermission(this);
        return this.internalDocument.isVisibleInMenusForUnauthorizedUsers();
    }

    public static abstract class Comparator
    extends ChainableReversibleNullComparator {
        public static final Comparator ID = new Comparator(){

            protected int compareDocuments(Document d1, Document d2) throws NoPermissionException {
                return d1.getId() - d2.getId();
            }
        };
        public static final Comparator HEADLINE = new Comparator(){

            protected int compareDocuments(Document d1, Document d2) throws NoPermissionException {
                return d1.getHeadline().compareToIgnoreCase(d2.getHeadline());
            }
        };
        public static final Comparator CREATED_DATETIME = new Comparator(){

            protected int compareDocuments(Document d1, Document d2) throws NoPermissionException {
                return d1.getCreatedDatetime().compareTo(d2.getCreatedDatetime());
            }
        };
        public static final Comparator MODIFIED_DATETIME = new Comparator(){

            protected int compareDocuments(Document d1, Document d2) throws NoPermissionException {
                return d1.getModifiedDatetime().compareTo(d2.getModifiedDatetime());
            }
        };
        public static final Comparator PUBLICATION_START_DATETIME = new Comparator(){

            protected int compareDocuments(Document document1, Document document2) throws NoPermissionException {
                return document1.getPublicationStartDatetime().compareTo(document2.getPublicationStartDatetime());
            }
        };
        public static final Comparator PUBLICATION_END_DATETIME = new Comparator(){

            protected int compareDocuments(Document document1, Document document2) throws NoPermissionException {
                return document1.getPublicationEndDatetime().compareTo(document2.getPublicationEndDatetime());
            }
        };
        public static final Comparator ARCHIVED_DATETIME = new Comparator(){

            protected int compareDocuments(Document document1, Document document2) throws NoPermissionException {
                return document1.getArchivedDatetime().compareTo(document2.getArchivedDatetime());
            }
        };

        public int compare(Object o1, Object o2) {
            Document d1 = (Document)o1;
            Document d2 = (Document)o2;
            try {
                return this.compareDocuments(d1, d2);
            }
            catch (NullPointerException npe) {
                throw new NullPointerException("Tried sorting on null fields! You need to call .nullsFirst() or .nullsLast() on your Comparator.");
            }
            catch (NoPermissionException e) {
                throw new UnhandledException((Throwable)e);
            }
        }

        protected abstract int compareDocuments(Document var1, Document var2) throws NoPermissionException;
    }

    public static class LifeCyclePhase {
        public static final LifeCyclePhase NEW = new LifeCyclePhase(DocumentDomainObject.LifeCyclePhase.NEW);
        public static final LifeCyclePhase DISAPPROVED = new LifeCyclePhase(DocumentDomainObject.LifeCyclePhase.DISAPPROVED);
        public static final LifeCyclePhase PUBLISHED = new LifeCyclePhase(DocumentDomainObject.LifeCyclePhase.PUBLISHED);
        public static final LifeCyclePhase UNPUBLISHED = new LifeCyclePhase(DocumentDomainObject.LifeCyclePhase.UNPUBLISHED);
        public static final LifeCyclePhase ARCHIVED = new LifeCyclePhase(DocumentDomainObject.LifeCyclePhase.ARCHIVED);
        public static final LifeCyclePhase APPROVED = new LifeCyclePhase(DocumentDomainObject.LifeCyclePhase.APPROVED);
        private DocumentDomainObject.LifeCyclePhase phase;

        private LifeCyclePhase(DocumentDomainObject.LifeCyclePhase phase) {
            this.phase = phase;
        }

        public String toString() {
            return this.phase.toString();
        }
    }
}

