/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.MockContentManagementSystem;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.Role;
import com.imcode.imcms.api.SaveException;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;
import imcode.server.ImcmsServices;
import imcode.server.MockImcmsServices;
import imcode.server.db.Database;
import imcode.server.db.MockDatabase;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import junit.framework.TestCase;

public class TestUserService
extends TestCase {
    private UserService userService;
    private MockContentManagementSystem contentManagementSystem;
    private MockImcmsServices mockImcmsServices;
    private MockDatabase database;
    private UserDomainObject internalUser;
    private static int HIGHEST_USER_ID = 3;

    protected void setUp() throws Exception {
        super.setUp();
        this.contentManagementSystem = new MockContentManagementSystem();
        this.internalUser = new UserDomainObject();
        this.internalUser.setId(HIGHEST_USER_ID);
        this.contentManagementSystem.setCurrentUser(new User(this.internalUser));
        this.mockImcmsServices = new MockImcmsServices();
        this.database = new MockDatabase();
        this.mockImcmsServices.setDatabase((Database)this.database);
        ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserAndRoleMapper = new ImcmsAuthenticatorAndUserAndRoleMapper((Database)this.mockImcmsServices, (ImcmsServices)this.mockImcmsServices);
        this.mockImcmsServices.setImcmsAuthenticatorAndUserAndRoleMapper(imcmsAuthenticatorAndUserAndRoleMapper);
        this.contentManagementSystem.setInternal((ImcmsServices)this.mockImcmsServices);
        this.userService = new UserService(this.contentManagementSystem);
    }

    public void testNewUserCanHaveRoles() throws SaveException, NoPermissionException {
        this.internalUser.addRole(RoleDomainObject.SUPERADMIN);
        this.database.addExpectedSqlCall((MockDatabase.SqlCallPredicate)new MockDatabase.EqualsSqlCallPredicate("GetHighestUserId"), (Object)("" + HIGHEST_USER_ID + 1));
        User user = this.userService.createNewUser("test", "test");
        user.addRole(new Role(RoleDomainObject.SUPERADMIN));
        this.userService.saveUser(user);
        this.database.verifyExpectedSqlCalls();
        this.database.assertCalled((MockDatabase.SqlCallPredicate)new MockDatabase.MatchesRegexSqlCallPredicate("role"));
    }

    public void testNonAdminCantCreateUser() throws SaveException, NoPermissionException {
        User user = this.userService.createNewUser("test", "test");
        user.addRole(new Role(RoleDomainObject.SUPERADMIN));
        this.database.addExpectedSqlCall((MockDatabase.SqlCallPredicate)new MockDatabase.ProcedureSqlCallPredicate("GetHighestUserId"), (Object)("" + HIGHEST_USER_ID + 1));
        try {
            this.userService.saveUser(user);
            TestUserService.fail();
        }
        catch (NoPermissionException noPermissionException) {
            // empty catch block
        }
    }

    public void testNonAdminCantEditOtherUsers() throws NoPermissionException, SaveException {
        UserDomainObject otherInternalUser = new UserDomainObject();
        otherInternalUser.setId(HIGHEST_USER_ID + 1);
        User otherUser = new User(otherInternalUser);
        try {
            this.userService.saveUser(otherUser);
            TestUserService.fail();
        }
        catch (NoPermissionException noPermissionException) {
            // empty catch block
        }
    }

    public void testUserCanEditSelf() throws SaveException, NoPermissionException {
        this.internalUser.addRole(RoleDomainObject.SUPERADMIN);
        String loginName = "loginName";
        String firstName = "firstName";
        this.internalUser.setLoginName(loginName);
        this.internalUser.setFirstName(firstName);
        this.internalUser.setLastName("lastName");
        User user = this.contentManagementSystem.getCurrentUser();
        String newLoginName = "newLoginName";
        String newFirstName = "newFirstName";
        TestUserService.assertEquals((String)loginName, (String)user.getLoginName());
        TestUserService.assertEquals((String)firstName, (String)user.getFirstName());
        user.setLoginName(newLoginName);
        user.setFirstName(newFirstName);
        this.userService.saveUser(user);
        this.database.assertCalled("User can update contents of users table.", (MockDatabase.SqlCallPredicate)new MockDatabase.UpdateTableSqlCallPredicate("users", "" + HIGHEST_USER_ID));
        this.database.assertNotCalled("Old login name set.", (MockDatabase.SqlCallPredicate)new MockDatabase.UpdateTableSqlCallPredicate("users", loginName));
        this.database.assertCalled("New login name not set.", (MockDatabase.SqlCallPredicate)new MockDatabase.UpdateTableSqlCallPredicate("users", newLoginName));
        this.database.assertNotCalled("Old first name set.", (MockDatabase.SqlCallPredicate)new MockDatabase.UpdateTableSqlCallPredicate("users", firstName));
        this.database.assertCalled("New first name not set.", (MockDatabase.SqlCallPredicate)new MockDatabase.UpdateTableSqlCallPredicate("users", newFirstName));
        this.database.assertNotCalled("User can not change own roles.", (MockDatabase.SqlCallPredicate)new MockDatabase.MatchesRegexSqlCallPredicate("role"));
    }

    public void testCreateNewRole() throws SaveException, NoPermissionException {
        this.internalUser.addRole(RoleDomainObject.SUPERADMIN);
        this.database.addExpectedSqlCall((MockDatabase.SqlCallPredicate)new MockDatabase.EqualsSqlCallPredicate("INSERT INTO roles (role_name, permissions, admin_role) VALUES(?,?,0) SELECT @@IDENTITY"), (Object)"3");
        String roleName = "test role";
        Role newRole = this.userService.createNewRole(roleName);
        this.userService.saveRole(newRole);
        this.database.verifyExpectedSqlCalls();
        this.database.assertCalled((MockDatabase.SqlCallPredicate)new MockDatabase.InsertIntoTableWithParameterSqlCallPredicate("roles", roleName));
    }

    public void testGetAllRoles() {
        try {
            this.userService.getAllRoles();
            TestUserService.fail();
        }
        catch (NoPermissionException noPermissionException) {
            // empty catch block
        }
    }

    public void testGetRoleByName() throws NoPermissionException {
        TestUserService.assertNull((Object)this.userService.getRole(""));
    }

    public void testGetRoleById() throws NoPermissionException {
        TestUserService.assertNull((Object)this.userService.getRole(1));
    }
}

