/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.ContentManagementSystemRunnable;
import com.imcode.imcms.api.DefaultContentManagementSystem;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.User;
import imcode.server.ImcmsServices;
import imcode.server.MockImcmsServices;
import imcode.server.user.UserDomainObject;
import java.security.KeyStore;
import junit.framework.TestCase;

public class TestDefaultContentManagementSystem
extends TestCase {
    private DefaultContentManagementSystem contentManagementSystem;
    private MockImcmsServices mockImcmsServices;

    protected void setUp() throws Exception {
        super.setUp();
        this.mockImcmsServices = new MockImcmsServices();
        this.contentManagementSystem = new DefaultContentManagementSystem((ImcmsServices)this.mockImcmsServices, new UserDomainObject());
    }

    public void testClonedCurrentUser() {
        User user = this.contentManagementSystem.getCurrentUser();
        TestDefaultContentManagementSystem.assertNotNull((Object)user);
        User userAgain = this.contentManagementSystem.getCurrentUser();
        TestDefaultContentManagementSystem.assertNotNull((Object)userAgain);
        TestDefaultContentManagementSystem.assertNotSame((Object)user.getInternal(), (Object)userAgain.getInternal());
    }

    public void testClone() throws CloneNotSupportedException {
        DefaultContentManagementSystem clone = (DefaultContentManagementSystem)this.contentManagementSystem.clone();
        TestDefaultContentManagementSystem.assertNotSame((Object)this.contentManagementSystem.currentUser, (Object)clone.currentUser);
    }

    public void testRunAsSuperadmin() throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(null, null);
        this.mockImcmsServices.setKeyStore(keyStore);
        try {
            this.contentManagementSystem.runAsSuperadmin(new ContentManagementSystemRunnable(){

                public void runWith(ContentManagementSystem contentManagementSystem) {
                }
            });
            TestDefaultContentManagementSystem.fail();
        }
        catch (NoPermissionException noPermissionException) {
            // empty catch block
        }
    }
}

