/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.ContentManagementSystem;
import com.imcode.imcms.api.ContentManagementSystemRunnable;
import com.imcode.imcms.api.DatabaseService;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.MailService;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.SecurityChecker;
import com.imcode.imcms.api.TemplateService;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.security.KeyStore;

public class DefaultContentManagementSystem
extends ContentManagementSystem
implements Cloneable {
    private UserService userService;
    private DocumentService documentService;
    private TemplateService templateService;
    private DatabaseService databaseService;
    private MailService mailService;
    UserDomainObject currentUser;
    protected ImcmsServices service;
    protected SecurityChecker securityChecker;

    public DefaultContentManagementSystem(ImcmsServices service, UserDomainObject accessor) {
        this.service = service;
        this.currentUser = accessor;
    }

    public static DefaultContentManagementSystem create(ImcmsServices service, UserDomainObject accessor) {
        DefaultContentManagementSystem contentManagementSystem = new DefaultContentManagementSystem(service, accessor);
        contentManagementSystem.init();
        return contentManagementSystem;
    }

    private void init() {
        this.securityChecker = new SecurityChecker(this);
        this.userService = new UserService(this);
        this.documentService = new DocumentService(this);
        this.templateService = new TemplateService(this);
        this.databaseService = new DatabaseService(Imcms.getApiConnectionPool());
        this.mailService = new MailService(this.service.getSMTP());
    }

    protected Object clone() throws CloneNotSupportedException {
        DefaultContentManagementSystem clone = (DefaultContentManagementSystem)super.clone();
        clone.currentUser = (UserDomainObject)this.currentUser.clone();
        return clone;
    }

    public UserService getUserService() {
        return this.userService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public User getCurrentUser() {
        return new User((UserDomainObject)this.currentUser.clone());
    }

    public DatabaseService getDatabaseService() {
        return this.databaseService;
    }

    public TemplateService getTemplateService() {
        return this.templateService;
    }

    public MailService getMailService() {
        return this.mailService;
    }

    ImcmsServices getInternal() {
        return this.service;
    }

    SecurityChecker getSecurityChecker() {
        return this.securityChecker;
    }

    public void runAsSuperadmin(ContentManagementSystemRunnable runnable) throws NoPermissionException {
        KeyStore keyStore = this.service.getKeyStore();
        Class<?> clazz = runnable.getClass();
        if (!Utility.classIsSignedByCertificatesInKeyStore(clazz, (KeyStore)keyStore)) {
            throw new NoPermissionException("Class " + clazz.getName() + " is not signed by certificates in keystore.");
        }
        DefaultContentManagementSystem cms = DefaultContentManagementSystem.create(this.service, (UserDomainObject)this.currentUser.clone());
        cms.currentUser.addRole(RoleDomainObject.SUPERADMIN);
        runnable.runWith(cms);
        cms.currentUser = null;
    }
}

