/*
 * Decompiled with CFR 0.152.
 */
package imcode.util.shop;

import imcode.util.shop.ShoppingItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import junit.framework.TestCase;

public class TestShoppingItem
extends TestCase {
    private ShoppingItem[] items = new ShoppingItem[8];

    public TestShoppingItem(String name) {
        super(name);
    }

    protected void setUp() {
        this.items[0] = new ShoppingItem();
        this.items[0].setDescription(2, "Desc");
        this.items[0].setPrice(0.1);
        this.items[1] = new ShoppingItem();
        this.items[1].setDescription(2, "XXX");
        this.items[1].setPrice(1.2);
        this.items[2] = new ShoppingItem();
        this.items[2].setDescription(1, "Desc");
        this.items[2].setPrice(2.3);
        this.items[3] = new ShoppingItem();
        this.items[3].setDescription(1, "Desc");
        this.items[3].setDescription(2, "Desc");
        this.items[3].setPrice(3.4);
        this.items[4] = new ShoppingItem();
        this.items[4].setDescription(1, "Desc");
        this.items[4].setDescription(2, "XXX");
        this.items[4].setPrice(4.5);
        this.items[5] = new ShoppingItem();
        this.items[5].setDescription(1, "XXX");
        this.items[5].setDescription(2, "Desc");
        this.items[5].setPrice(5.6);
        this.items[6] = new ShoppingItem();
        this.items[6].setDescription(1, "XXX");
        this.items[6].setDescription(2, "XXX");
        this.items[6].setPrice(6.7);
        this.items[7] = new ShoppingItem();
        this.items[7].setDescription(1, "XXX");
        this.items[7].setDescription(2, "XXX");
        this.items[7].setPrice(7.8);
    }

    public void testPrice() {
        ShoppingItem item1 = new ShoppingItem();
        TestShoppingItem.assertEquals((double)0.0, (double)item1.getPrice(), (double)0.0);
        item1.setPrice(1.33);
        TestShoppingItem.assertEquals((double)1.33, (double)item1.getPrice(), (double)0.0);
    }

    public void testEquals() {
        ShoppingItem item1 = new ShoppingItem();
        ShoppingItem item2 = new ShoppingItem();
        item1.setPrice(2.66);
        TestShoppingItem.assertEquals((Object)item1, (Object)item1);
        TestShoppingItem.assertTrue((!item1.equals(item2) ? 1 : 0) != 0);
        TestShoppingItem.assertTrue((!item2.equals(item1) ? 1 : 0) != 0);
        item2.setPrice(2.66);
        TestShoppingItem.assertEquals((Object)item1, (Object)item2);
        item2.setDescription(1, "Item 2 Desc 1");
        TestShoppingItem.assertTrue((!item2.equals(item1) ? 1 : 0) != 0);
    }

    public void testDescriptions() {
        ShoppingItem item1 = new ShoppingItem();
        item1.setDescription(1, "Item 1 Desc 1");
        item1.setDescription(3, "Item 1 Desc 3");
        TestShoppingItem.assertEquals((String)"Item 1 Desc 1", (String)item1.getDescription(1));
        TestShoppingItem.assertEquals((String)"Item 1 Desc 3", (String)item1.getDescription(3));
        item1.setDescription(1, null);
        TestShoppingItem.assertEquals((String)"", (String)item1.getDescription(1));
    }

    public void testCompareTo() {
        ShoppingItem item1 = new ShoppingItem();
        item1.setDescription(1, "Desc 1");
        item1.setDescription(2, "Desc 2");
        item1.setPrice(1.0);
        ShoppingItem item2 = new ShoppingItem();
        item2.setDescription(1, "Desc 1");
        item2.setDescription(2, "Desc 2");
        item2.setPrice(2.0);
        TestShoppingItem.assertEquals((int)0, (int)item1.compareTo(item1));
        TestShoppingItem.assertEquals((int)0, (int)item2.compareTo(item2));
        TestShoppingItem.assertEquals((int)-1, (int)item1.compareTo(item2));
        TestShoppingItem.assertEquals((int)1, (int)item2.compareTo(item1));
        ShoppingItem item3 = new ShoppingItem();
        item3.setDescription(1, "Desc 1");
        item3.setDescription(3, "Desc 3");
        item3.setPrice(1.0);
        TestShoppingItem.assertEquals((int)1, (int)item2.compareTo(item3));
        item1.setPrice(4.0);
        item1.setDescription(3, "Desc 3");
        TestShoppingItem.assertEquals((int)1, (int)item1.compareTo(item3));
        item1.setDescription(2, "Desc 3-1");
        item3.setDescription(2, "Desc 2");
        TestShoppingItem.assertEquals((int)1, (int)item1.compareTo(item3));
        TestShoppingItem.assertEquals((int)1, (int)item1.compareTo(item2));
        item1.setDescription(1, null);
        TestShoppingItem.assertEquals((int)-1, (int)item1.compareTo(item2));
    }

    public void testComparePriceTo() {
        ShoppingItem item1 = new ShoppingItem();
        item1.setPrice(1.33);
        ShoppingItem item2 = new ShoppingItem();
        item2.setPrice(2.66);
        TestShoppingItem.assertEquals((int)0, (int)item1.compareTo(item1));
        TestShoppingItem.assertEquals((int)0, (int)item2.compareTo(item2));
        TestShoppingItem.assertEquals((int)-1, (int)item1.compareTo(item2));
        TestShoppingItem.assertEquals((int)1, (int)item2.compareTo(item1));
    }

    public void testCompareDescriptionTo() {
        ShoppingItem item1 = new ShoppingItem();
        item1.setDescription(2, "Desc");
        ShoppingItem item2 = new ShoppingItem();
        item2.setDescription(1, "Desc");
        ShoppingItem item3 = new ShoppingItem();
        item3.setDescription(1, "Desc");
        item3.setDescription(2, "Desc");
        ShoppingItem item4 = new ShoppingItem();
        item4.setDescription(1, "XXX");
        item4.setDescription(2, "Desc");
        TestShoppingItem.assertTrue((0 > item1.compareDescriptionTo(item2) ? 1 : 0) != 0);
        TestShoppingItem.assertTrue((0 > item1.compareDescriptionTo(item3) ? 1 : 0) != 0);
        TestShoppingItem.assertTrue((0 > item1.compareDescriptionTo(item4) ? 1 : 0) != 0);
        TestShoppingItem.assertTrue((0 < item2.compareDescriptionTo(item1) ? 1 : 0) != 0);
        TestShoppingItem.assertTrue((0 > item2.compareDescriptionTo(item3) ? 1 : 0) != 0);
        TestShoppingItem.assertTrue((0 > item2.compareDescriptionTo(item4) ? 1 : 0) != 0);
        TestShoppingItem.assertTrue((0 < item3.compareDescriptionTo(item2) ? 1 : 0) != 0);
        TestShoppingItem.assertTrue((0 < item3.compareDescriptionTo(item1) ? 1 : 0) != 0);
        TestShoppingItem.assertTrue((0 > item3.compareDescriptionTo(item4) ? 1 : 0) != 0);
        TestShoppingItem.assertTrue((0 < item4.compareDescriptionTo(item1) ? 1 : 0) != 0);
        TestShoppingItem.assertTrue((0 < item4.compareDescriptionTo(item2) ? 1 : 0) != 0);
        TestShoppingItem.assertTrue((0 < item4.compareDescriptionTo(item3) ? 1 : 0) != 0);
    }

    public void testCompareToSort() {
        ArrayList<ShoppingItem> itemsList = new ArrayList<ShoppingItem>(Arrays.asList(this.items));
        Collections.reverse(itemsList);
        Object[] sortedItems = itemsList.toArray(new ShoppingItem[this.items.length]);
        Arrays.sort(sortedItems);
        for (int i = 0; i < this.items.length; ++i) {
            for (int j = 0; j < this.items.length; ++j) {
                if (i == j) {
                    TestShoppingItem.assertEquals((String)("items[" + i + "] == cartItems[" + j + "]\n" + this.itemsToString((ShoppingItem[])sortedItems)), (Object)this.items[i], (Object)sortedItems[j]);
                    continue;
                }
                TestShoppingItem.assertTrue((String)("items[" + i + "] != cartItems[" + j + "]\n" + this.itemsToString((ShoppingItem[])sortedItems)), (this.items[i] != sortedItems[j] ? 1 : 0) != 0);
            }
        }
    }

    private String itemsToString(ShoppingItem[] items) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < items.length; ++i) {
            result.append(items[i].toString());
            result.append('\n');
        }
        return result.toString();
    }
}

