/*
 * Decompiled with CFR 0.152.
 */
package imcode.util.shop;

import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.shop.ShoppingItem;
import imcode.util.shop.ShoppingOrder;
import imcode.util.shop.ShoppingOrderSystem;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ShoppingOrderSystemImpl
implements ShoppingOrderSystem {
    private ImcmsServices imcref;
    private static Logger log = Logger.getLogger((String)ShoppingOrderSystemImpl.class.getName());

    public ShoppingOrderSystemImpl(ImcmsServices imcref) {
        this.imcref = imcref;
    }

    public ShoppingOrder getShoppingOrderForUserById(UserDomainObject user, int orderId) {
        int userId = user.getId();
        String[] dbData = this.imcref.sqlProcedure("Shop_GetShoppingOrderForUserById", new String[]{String.valueOf(userId), String.valueOf(orderId)});
        return this.getShoppingOrderFromDbData(dbData);
    }

    public List getShoppingOrdersForUser(UserDomainObject user) {
        int userId = user.getId();
        String[][] dbData = this.imcref.sqlProcedureMulti("Shop_GetShoppingOrdersForUser", new String[]{String.valueOf(userId)});
        ArrayList<ShoppingOrder> theList = new ArrayList<ShoppingOrder>(dbData.length);
        for (int i = 0; i < dbData.length; ++i) {
            theList.add(this.getShoppingOrderFromDbData(dbData[i]));
        }
        return theList;
    }

    private ShoppingOrder getShoppingOrderFromDbData(String[] dbData) {
        if (dbData == null || 0 == dbData.length) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int orderId = Integer.parseInt(dbData[0]);
        int userId = Integer.parseInt(dbData[2]);
        UserDomainObject user = this.imcref.getImcmsAuthenticatorAndUserAndRoleMapper().getUser(userId);
        String datetimeStr = dbData[1];
        ShoppingOrder theOrder = new ShoppingOrder();
        try {
            Date datetime = dateFormat.parse(datetimeStr);
            theOrder.setDatetime(datetime);
        }
        catch (ParseException ex) {
            log.error((Object)("Non-parseable date from database, userId " + userId + ", orderId " + orderId + ", datetime '" + datetimeStr + "'"), (Throwable)ex);
        }
        theOrder.setId(new Integer(orderId));
        theOrder.setUser(user);
        this.addShoppingItemsToOrder(theOrder);
        return theOrder;
    }

    private void addShoppingItemsToOrder(ShoppingOrder theOrder) {
        String[][] dbData = this.imcref.sqlProcedureMulti("Shop_GetShoppingItemsForOrder", new String[]{String.valueOf(theOrder.getId())});
        for (int i = 0; i < dbData.length; ++i) {
            ShoppingItem item = new ShoppingItem();
            int itemId = Integer.parseInt(dbData[i][0]);
            double price = Double.parseDouble(dbData[i][1]);
            int quantity = Integer.parseInt(dbData[i][2]);
            item.setDescriptions(this.getDescriptionsForShoppingItem(itemId));
            item.setPrice(price);
            theOrder.addItem(item, quantity);
        }
    }

    private Map getDescriptionsForShoppingItem(int itemId) {
        String[][] dbData = this.imcref.sqlProcedureMulti("Shop_GetDescriptionsForShoppingItem", new String[]{String.valueOf(itemId)});
        HashMap<Integer, String> theDescriptions = new HashMap<Integer, String>();
        for (int i = 0; i < dbData.length; ++i) {
            Integer descriptionNumber = Integer.valueOf(dbData[i][0]);
            String description = dbData[i][1];
            theDescriptions.put(descriptionNumber, description);
        }
        return theDescriptions;
    }

    public void addShoppingOrder(ShoppingOrder theOrder) throws NullPointerException {
        UserDomainObject user = theOrder.getUser();
        Date datetime = theOrder.getDatetime();
        if (null == user) {
            throw new NullPointerException("null == user");
        }
        if (null == datetime) {
            throw new NullPointerException("null == datetime");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String orderIdStr = this.imcref.sqlProcedureStr("Shop_AddShoppingOrder", new String[]{"" + theOrder.getUser().getId(), dateFormat.format(theOrder.getDatetime())});
        this.addShoppingItemsToOrderInDb(orderIdStr, theOrder, theOrder.getItems());
    }

    private void addShoppingItemsToOrderInDb(String orderIdStr, ShoppingOrder order, ShoppingItem[] items) {
        for (int i = 0; i < items.length; ++i) {
            ShoppingItem item = items[i];
            String itemIdStr = this.imcref.sqlProcedureStr("Shop_AddShoppingItemToOrder", new String[]{orderIdStr, "" + item.getPrice(), "" + order.countItem(item)});
            this.addDescriptionsToShoppingItemInDb(itemIdStr, item.getDescriptions());
        }
    }

    private void addDescriptionsToShoppingItemInDb(String itemIdStr, Map descriptions) {
        Iterator it = descriptions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Integer descriptionNumber = (Integer)entry.getKey();
            String description = (String)entry.getValue();
            this.imcref.sqlUpdateProcedure("Shop_AddShoppingItemDescription", new String[]{itemIdStr, "" + descriptionNumber, description});
        }
    }
}

