/*
 * Decompiled with CFR 0.152.
 */
package imcode.util.poll;

import imcode.server.ImcmsServices;
import imcode.util.poll.PollHandlingSystem;
import org.apache.log4j.Logger;

public class PollHandlingSystemImpl
implements PollHandlingSystem {
    private ImcmsServices imcref;
    private static Logger log = Logger.getLogger((String)PollHandlingSystemImpl.class.getName());

    public PollHandlingSystemImpl(ImcmsServices imcref) {
        this.imcref = imcref;
    }

    public void savePollparameter(String text_type, int meta_id, int text_no, String textstring) {
        String[] poll_param = this.imcref.sqlProcedure("Poll_GetOne ", new String[]{"" + meta_id});
        if (poll_param == null || poll_param.length == 0) {
            this.imcref.sqlUpdateProcedure("Poll_AddNew ", new String[]{"" + meta_id});
            poll_param = this.imcref.sqlProcedure("Poll_GetOne ", new String[]{"" + meta_id});
        }
        int poll_id = Integer.parseInt(poll_param[0]);
        if (text_type.startsWith("pollquestion")) {
            String[] sql_data;
            int question_no = Integer.parseInt(text_type.substring(text_type.indexOf("-") + 1));
            if (question_no > 0 && ((sql_data = this.imcref.sqlProcedure("Poll_GetQuestion ", new String[]{"" + poll_id, "" + question_no})) == null || sql_data.length == 0 || "-1".equals(sql_data[3]))) {
                this.imcref.sqlUpdateProcedure("Poll_AddQuestion ", new String[]{"" + poll_id, "" + question_no, "" + text_no});
            }
        } else if (text_type.startsWith("pollanswer")) {
            int question_no = Integer.parseInt(text_type.substring(text_type.indexOf("-") + 1, text_type.lastIndexOf("-")));
            int option_no = Integer.parseInt(text_type.substring(text_type.lastIndexOf("-") + 1));
            if (question_no > 0 && option_no > 0) {
                int question_id;
                String[] sql_data = this.imcref.sqlProcedure("Poll_GetQuestion ", new String[]{"" + poll_id, "" + question_no});
                if (sql_data == null || sql_data.length == 0) {
                    this.imcref.sqlUpdateProcedure("Poll_AddQuestion ", new String[]{"" + poll_id, "" + question_no, "-1"});
                    sql_data = this.imcref.sqlProcedure("Poll_GetQuestion ", new String[]{"" + poll_id, "" + question_no});
                }
                if ((question_id = Integer.parseInt(sql_data[0])) > 0 && ((sql_data = this.imcref.sqlProcedure("Poll_GetAnswer ", new String[]{"" + question_id, "" + option_no})) == null || sql_data.length == 0)) {
                    this.imcref.sqlUpdateProcedure("Poll_AddAnswer ", new String[]{"" + question_id, "" + text_no, "" + option_no});
                }
            }
        } else if (text_type.startsWith("pollpointanswer")) {
            int question_no = Integer.parseInt(text_type.substring(text_type.indexOf("-") + 1, text_type.lastIndexOf("-")));
            int option_no = Integer.parseInt(text_type.substring(text_type.lastIndexOf("-") + 1));
            if (question_no > 0 && option_no > 0) {
                int question_id;
                String[] sql_data = this.imcref.sqlProcedure("Poll_GetQuestion ", new String[]{"" + poll_id, "" + question_no});
                if (sql_data == null || sql_data.length == 0) {
                    this.imcref.sqlUpdateProcedure("Poll_AddQuestion ", new String[]{"" + poll_id, "" + question_no, "-1"});
                    sql_data = this.imcref.sqlProcedure("Poll_GetQuestion ", new String[]{"" + poll_id, "" + question_no});
                }
                if ((question_id = Integer.parseInt(sql_data[0])) > 0 && (sql_data = this.imcref.sqlProcedure("Poll_GetAnswer ", new String[]{"" + question_id, "" + option_no})) != null && sql_data.length > 0) {
                    this.imcref.sqlUpdateProcedure("Poll_SetAnswerPoint ", new String[]{sql_data[0], textstring.trim()});
                }
            }
        } else if (text_type.startsWith("pollparameter")) {
            String[] sql_param = new String[]{"" + poll_id, "", textstring.trim()};
            if (text_type.endsWith("popup_frequency")) {
                sql_param[1] = "popup_freq";
                sql_param[2] = textstring.trim().equals("") ? "0" : "" + Integer.parseInt(textstring.trim());
            } else if (text_type.endsWith("cookie")) {
                sql_param[1] = "set_cookie";
                sql_param[2] = textstring.trim().equals("") ? "0" : "1";
            } else if (text_type.endsWith("hideresults")) {
                sql_param[1] = "hide_result";
                sql_param[2] = textstring.trim().equals("") ? "0" : "1";
            } else if (text_type.endsWith("confirmation_text")) {
                sql_param[1] = "confirmation_text";
                sql_param[2] = "" + text_no;
            } else if (text_type.endsWith("email_recipients")) {
                sql_param[1] = "email_recipients";
                sql_param[2] = "" + text_no;
            } else if (text_type.endsWith("email_from")) {
                sql_param[1] = "email_from";
                sql_param[2] = "" + text_no;
            } else if (text_type.endsWith("email_subject")) {
                sql_param[1] = "email_subject";
                sql_param[2] = "" + text_no;
            } else if (text_type.endsWith("name")) {
                sql_param[1] = "name";
                sql_param[2] = "" + text_no;
            } else if (text_type.endsWith("description")) {
                sql_param[1] = "description";
                sql_param[2] = "" + text_no;
            } else if (text_type.endsWith("result_template")) {
                sql_param[1] = "result_template";
                String string = sql_param[2] = textstring.trim().equals("") ? "0" : "" + text_no;
            }
            if (sql_param != null) {
                this.imcref.sqlUpdateProcedure("Poll_SetParameter ", sql_param);
            }
        }
    }

    public void increasePollAnswer(String meta_id, String question_no, String option_no) {
        String[] sql_data = this.imcref.sqlProcedure("Poll_GetOne ", new String[]{meta_id});
        if (sql_data != null && sql_data.length != 0) {
            String poll_id = sql_data[0];
            sql_data = this.imcref.sqlProcedure("Poll_GetQuestion ", new String[]{poll_id, question_no});
            if (sql_data != null && sql_data.length != 0) {
                String[] sql_param = new String[]{sql_data[0], option_no};
                this.imcref.sqlUpdateProcedure("Poll_IncreaseAnswerOption ", sql_param);
                log.info((Object)("Increase answer option (meta_id , question_no, option_no ): " + meta_id + ", " + question_no + ", " + option_no));
            }
        }
    }

    public String[] getPollParameters(String meta_id) {
        String[] poll_data = this.imcref.sqlProcedure("Poll_GetOne ", new String[]{meta_id});
        return poll_data;
    }

    public String[][] getAllPollQuestions(String poll_id) {
        String[][] sql_data = this.imcref.sqlProcedureMulti("Poll_GetAllQuestions ", new String[]{poll_id});
        return sql_data;
    }

    public String[][] getAllPollAnswers(String question_id) {
        String[][] sql_data = this.imcref.sqlProcedureMulti("Poll_GetAllAnswers ", new String[]{question_id});
        return sql_data;
    }
}

