/*
 * Decompiled with CFR 0.152.
 */
package imcode.util.fortune;

import imcode.util.Parser;
import imcode.util.fortune.DateRange;
import imcode.util.fortune.Quote;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class QuoteWriter {
    private Writer writer;
    private String eol;

    public QuoteWriter(Writer writer) {
        this.writer = writer;
        this.eol = System.getProperty("line.separator");
    }

    public void writeQuote(Quote theQuote) throws IOException {
        DateRange dateRange = theQuote.getDateRange();
        Date startDate = dateRange.getStartDate();
        Date endDate = dateRange.getEndDate();
        endDate = new Date(endDate.getTime() - 86400000L);
        dateRange = new DateRange(startDate, endDate);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd");
        String startDateString = dateFormat.format(dateRange.getStartDate());
        String endDateString = dateFormat.format(dateRange.getEndDate());
        String[] replacements = new String[]{"&", "&amp;", "<", "&lt;", ">", "&gt;", "\r\n", "\n", "\r", "\n", "\n", "<BR>"};
        String text = Parser.parseDoc(theQuote.getText(), replacements);
        this.writer.write(startDateString + "#" + endDateString + "#" + text + "#" + this.eol);
    }
}

