/*
 * Decompiled with CFR 0.152.
 */
package imcode.util.fortune;

import imcode.util.Parser;
import imcode.util.fortune.DateRange;
import imcode.util.fortune.Quote;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class QuoteReader
extends BufferedReader {
    public QuoteReader(Reader reader) {
        super(reader);
    }

    public Quote readQuote() throws IOException {
        try {
            return this.parseQuoteFromString(this.readLine());
        }
        catch (NullPointerException npe) {
            return null;
        }
        catch (ParseException pe) {
            return null;
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
    }

    private Quote parseQuoteFromString(String fortune) throws ParseException {
        StringTokenizer tokens = new StringTokenizer(fortune, "#", true);
        String date1string = tokens.nextToken();
        tokens.nextToken();
        String date2string = tokens.nextToken();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyMMdd");
        Date date1 = dateFormat.parse(date1string);
        Date date2 = dateFormat.parse(date2string);
        date2.setTime(date2.getTime() + 86400000L);
        DateRange dateRange = new DateRange(date1, date2);
        tokens.nextToken();
        StringBuffer textBuffer = new StringBuffer(tokens.nextToken());
        while (tokens.hasMoreTokens()) {
            textBuffer.append(tokens.nextToken());
        }
        if ('#' == textBuffer.charAt(textBuffer.length() - 1)) {
            textBuffer.deleteCharAt(textBuffer.length() - 1);
        }
        String[] replacements = new String[]{"<BR>", "\r\n", "&lt;", "<", "&gt;", ">", "&amp;", "&"};
        Parser.parseDoc(textBuffer, replacements);
        Quote theQuote = new Quote(textBuffer.toString(), dateRange);
        return theQuote;
    }
}

