/*
 * Decompiled with CFR 0.152.
 */
package imcode.util.fortune;

import java.util.Date;

public class DateRange {
    private Date startDate;
    private Date endDate;

    public DateRange(Date startDate, Date endDate) {
        if (startDate.after(endDate)) {
            this.startDate = endDate;
            this.endDate = startDate;
        } else {
            this.startDate = startDate;
            this.endDate = endDate;
        }
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public boolean contains(Date date) {
        return !this.startDate.after(date) && this.endDate.after(date);
    }

    public boolean equals(Object object) {
        if (object instanceof DateRange) {
            return this.equals((DateRange)object);
        }
        return false;
    }

    private boolean equals(DateRange dateRange) {
        return this.startDate.equals(dateRange.startDate) && this.endDate.equals(dateRange.endDate);
    }

    public boolean overlap(DateRange dateRange) {
        return this.startDate.before(dateRange.endDate) && this.endDate.after(dateRange.startDate);
    }
}

