/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import imcode.util.FileUtility;
import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;

public class TestFileUtility
extends TestCase {
    private File rootDir;
    private File subDir;
    private File subSubDir;

    public void setUp() throws Exception {
        this.rootDir = new File("test");
        FileUtils.deleteDirectory((File)this.rootDir);
        FileUtils.forceMkdir((File)this.rootDir);
        this.subDir = new File(this.rootDir, "subdir");
        FileUtils.forceMkdir((File)this.subDir);
        this.subSubDir = new File(this.subDir, "subsubdir");
        FileUtils.forceMkdir((File)this.subSubDir);
    }

    public void testUnescapeFilename() throws Exception {
        TestFileUtility.assertEquals((String)"Space", (String)" ", (String)FileUtility.unescapeFilename("_0020"));
        TestFileUtility.assertEquals((String)"\u00c5\u00c4\u00d6\u00e5\u00e4\u00f6", (String)"\u00c5\u00c4\u00d6\u00e5\u00e4\u00f6", (String)FileUtility.unescapeFilename("_00c5_00c4_00d6_00e5_00e4_00f6"));
    }

    public void testEscapeFilename() throws Exception {
        TestFileUtility.assertEquals((String)"Space", (String)"_0020", (String)FileUtility.escapeFilename(" "));
        TestFileUtility.assertEquals((String)"\u00c5\u00c4\u00d6\u00e5\u00e4\u00f6", (String)"_00c5_00c4_00d6_00e5_00e4_00f6", (String)FileUtility.escapeFilename("\u00c5\u00c4\u00d6\u00e5\u00e4\u00f6"));
    }

    public void testEscapes() {
        TestFileUtility.assertEquals((String)"Space", (String)" ", (String)FileUtility.unescapeFilename(FileUtility.escapeFilename(" ")));
        TestFileUtility.assertEquals((String)"\u00c5\u00c4\u00d6_\u00e5\u00e4\u00f6", (String)"\u00c5\u00c4\u00d6_\u00e5\u00e4\u00f6", (String)FileUtility.unescapeFilename(FileUtility.escapeFilename("\u00c5\u00c4\u00d6_\u00e5\u00e4\u00f6")));
    }

    public void testDirectoryIsAncestorOfOrEqualTo() throws IOException {
        TestFileUtility.assertTrue((boolean)FileUtility.directoryIsAncestorOfOrEqualTo(this.rootDir, this.subSubDir));
        TestFileUtility.assertTrue((boolean)FileUtility.directoryIsAncestorOfOrEqualTo(this.rootDir, this.rootDir));
        TestFileUtility.assertFalse((boolean)FileUtility.directoryIsAncestorOfOrEqualTo(this.subDir, this.rootDir));
        TestFileUtility.assertFalse((boolean)FileUtility.directoryIsAncestorOfOrEqualTo(this.subSubDir, this.subDir));
    }

    public void testRelativizeFile() throws Exception {
        File relativeFile = FileUtility.relativizeFile(this.rootDir, this.subSubDir);
        TestFileUtility.assertFalse((boolean)FileUtility.directoryIsAncestorOfOrEqualTo(this.rootDir, relativeFile));
        TestFileUtility.assertFalse((boolean)FileUtility.directoryIsAncestorOfOrEqualTo(this.subDir, relativeFile));
        TestFileUtility.assertEquals((String)this.subDir.getName(), (String)relativeFile.getParentFile().getName());
        TestFileUtility.assertNull((Object)relativeFile.getParentFile().getParentFile());
    }
}

