/*
 * Decompiled with CFR 0.152.
 */
package imcode.util;

import imcode.util.ExStringTokenizer;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

class MultipartParser {
    private static final Logger log = Logger.getLogger((String)"imcode.util.MultipartParser");
    private String[] bodies;
    private Properties[] headers;
    private Hashtable[] headparams;

    MultipartParser(byte[] data, String contenttype) {
        try {
            this.parse(new String(data, "8859_1"), contenttype);
        }
        catch (UnsupportedEncodingException ex) {
            log.debug((Object)("Exception occured" + ex));
        }
    }

    private void parse(String data, String contenttype) {
        int boundaryindex = contenttype.indexOf("boundary=");
        if (boundaryindex == -1 || contenttype.indexOf("multipart") == -1) {
            throw new IllegalArgumentException("Not given a valid Content-Type");
        }
        String boundary = contenttype.substring(boundaryindex + 9);
        if (boundary.charAt(0) == '\"') {
            boundary = boundary.substring(1, boundary.length() - 1);
        }
        String dashboundary = "--" + boundary;
        String delimiter = "\r\n" + dashboundary;
        String closedelimiter = delimiter + "--";
        String body = data.substring(data.indexOf(dashboundary) + dashboundary.length(), data.indexOf(closedelimiter));
        ExStringTokenizer est = new ExStringTokenizer(body, delimiter);
        this.bodies = new String[est.countTokens()];
        this.headers = new Properties[est.countTokens()];
        this.headparams = new Hashtable[est.countTokens()];
        int bodycounter = 0;
        while (est.hasMoreTokens()) {
            String temp = est.nextToken();
            temp = temp.substring(temp.indexOf("\r\n") + 2);
            int tempindex = temp.indexOf("\r\n\r\n");
            String head = temp.substring(0, tempindex + 2);
            this.bodies[bodycounter] = temp.substring(tempindex + 4);
            ExStringTokenizer esth = new ExStringTokenizer(head, "\r\n");
            this.headers[bodycounter] = new Properties();
            this.headparams[bodycounter] = new Hashtable();
            while (esth.hasMoreTokens()) {
                String temph = esth.nextToken();
                int headindex = temph.indexOf(":");
                StringTokenizer sth = new StringTokenizer(temph, ";");
                temph = sth.nextToken();
                String headkey = temph.substring(0, headindex).trim();
                String headvalue = temph.substring(headindex + 1).trim();
                Properties hp = new Properties();
                while (sth.hasMoreTokens()) {
                    String tempp = sth.nextToken().trim();
                    int pindex = tempp.indexOf("=");
                    String pkey = tempp.substring(0, pindex);
                    String pvalue = tempp.substring(pindex + 1);
                    if (pvalue.charAt(0) == '\"') {
                        pvalue = pvalue.substring(1, pvalue.length() - 1);
                    }
                    hp.setProperty(pkey.toLowerCase(), pvalue);
                    this.headparams[bodycounter].put(headkey.toLowerCase(), hp);
                }
                this.headers[bodycounter].setProperty(headkey.toLowerCase(), headvalue);
            }
            ++bodycounter;
        }
    }

    public int countParts() {
        return this.bodies.length;
    }

    public String getBody(int part) {
        return this.bodies[part];
    }

    public Properties getHeaderParams(int part, String name) {
        return (Properties)this.headparams[part].get(name);
    }
}

