/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.user;

import imcode.server.ImcmsServices;
import imcode.server.db.Database;
import imcode.server.user.Authenticator;
import imcode.server.user.LazilyLoadedUserDomainObject;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.RolePermissionDomainObject;
import imcode.server.user.UserAndRoleRegistry;
import imcode.server.user.UserDomainObject;
import imcode.server.user.UserMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class ImcmsAuthenticatorAndUserAndRoleMapper
implements UserMapper,
UserAndRoleRegistry,
Authenticator {
    public static final String SPROC_GET_HIGHEST_USER_ID = "GetHighestUserId";
    private static final String SPROC_ADD_USER_ROLE = "AddUserRole";
    private static final String SPROC_ROLE_DELETE = "RoleDelete";
    private static final String SPROC_GET_ALL_ROLES = "GetAllRoles";
    private static final String SPROC_GET_USER_ROLES = "GetUserRoles";
    private static final String SPROC_DEL_USER_ROLES = "DelUserRoles";
    private static final String SPROC_GET_USERS_WHO_BELONGS_TO_ROLE = "GetUsersWhoBelongsToRole";
    private static final String SPROC_PHONE_NBR_ADD = "phoneNbrAdd";
    private static final String SPROC_DEL_PHONE_NR = "DelPhoneNr";
    private static final int USER_EXTERN_ID = 2;
    private Database database;
    private Logger log = Logger.getLogger((Class)ImcmsAuthenticatorAndUserAndRoleMapper.class);
    private static final String SQL_SELECT_USERS = "SELECT user_id, login_name, login_password, first_name, last_name, title, company, address, city, zip, country, county_council, email, language, active, create_date, external FROM users";
    public static final String SQL_ROLES_COLUMNS = "roles.role_id, roles.role_name, roles.admin_role, roles.permissions";
    private static final String SQL_SELECT_ALL_ROLES = "SELECT roles.role_id, roles.role_name, roles.admin_role, roles.permissions FROM roles";
    public static final String SQL_SELECT_ROLE_BY_NAME = "SELECT roles.role_id, roles.role_name, roles.admin_role, roles.permissions FROM roles WHERE role_name = ?";
    private static final String SQL_SELECT_ROLE_BY_ID = "SELECT roles.role_id, roles.role_name, roles.admin_role, roles.permissions FROM roles WHERE role_id = ?";
    public static final String SQL_INSERT_INTO_ROLES = "INSERT INTO roles (role_name, permissions, admin_role) VALUES(?,?,0) SELECT @@IDENTITY";
    private ImcmsServices service;

    public ImcmsAuthenticatorAndUserAndRoleMapper(Database database, ImcmsServices service) {
        this.database = database;
        this.service = service;
    }

    public boolean authenticate(String loginName, String password) {
        boolean userExistsAndPasswordIsCorrect = false;
        UserDomainObject user = this.getUser(loginName);
        if (null != user) {
            String login_password_from_form;
            String login_password_from_db = user.getPassword();
            userExistsAndPasswordIsCorrect = login_password_from_db.equals(login_password_from_form = password) && user.isActive() ? true : (!user.isActive() ? false : false);
        }
        return userExistsAndPasswordIsCorrect;
    }

    public UserDomainObject getUser(String loginName) {
        String[] user_data = this.database.sqlQuery("SELECT user_id,\nlogin_name,\nlogin_password,\nfirst_name,\nlast_name,\ntitle,\ncompany,\naddress,\ncity,\nzip,\ncountry,\ncounty_council,\nemail,\nlanguage,\nactive,\ncreate_date,\n[external]\nFROM users\nWHERE login_name = ?", new String[]{loginName.trim()});
        return this.getUserFromSqlRow(user_data);
    }

    private UserDomainObject getUserFromSqlRow(String[] sqlResult) {
        LazilyLoadedUserDomainObject user;
        if (sqlResult.length == 0) {
            user = null;
        } else {
            user = new LazilyLoadedUserDomainObject(0, false);
            this.initUserFromSqlData(user, sqlResult);
        }
        return user;
    }

    void initUserFromSqlData(UserDomainObject user, String[] sqlResult) {
        user.setId(Integer.parseInt(sqlResult[0]));
        user.setLoginName(sqlResult[1]);
        user.setPassword(sqlResult[2].trim());
        user.setFirstName(sqlResult[3]);
        user.setLastName(sqlResult[4]);
        user.setTitle(sqlResult[5]);
        user.setCompany(sqlResult[6]);
        user.setAddress(sqlResult[7]);
        user.setCity(sqlResult[8]);
        user.setZip(sqlResult[9]);
        user.setCountry(sqlResult[10]);
        user.setCountyCouncil(sqlResult[11]);
        user.setEmailAddress(sqlResult[12]);
        user.setLanguageIso639_2((String)ObjectUtils.defaultIfNull((Object)sqlResult[13], (Object)this.service.getDefaultLanguage()));
        user.setActive(0 != Integer.parseInt(sqlResult[14]));
        user.setCreateDate(sqlResult[15]);
        user.setImcmsExternal(0 != Integer.parseInt(sqlResult[16]));
    }

    private RoleDomainObject[] getRolesForUser(UserDomainObject user) {
        String sqlStr = "SELECT roles.role_id, roles.role_name, roles.admin_role, roles.permissions FROM roles, user_roles_crossref WHERE user_roles_crossref.role_id = roles.role_id AND user_roles_crossref.user_id = ?";
        String[][] sqlResult = this.database.sqlQueryMulti(sqlStr, new String[]{"" + user.getId()});
        RoleDomainObject[] roles = new RoleDomainObject[sqlResult.length];
        for (int i = 0; i < sqlResult.length; ++i) {
            String[] sqlRow = sqlResult[i];
            roles[i] = this.getRoleFromSqlResult(sqlRow);
        }
        return roles;
    }

    public UserDomainObject getUser(int userId) {
        return new LazilyLoadedUserDomainObject(userId);
    }

    private String[][] sqlSelectAllUsers(boolean includeUserExtern, boolean includeInactiveUsers) {
        ArrayList<String> whereTests = new ArrayList<String>();
        if (!includeUserExtern) {
            whereTests.add("user_id != 2");
        }
        if (!includeInactiveUsers) {
            whereTests.add("active = 1");
        }
        String sqlStr = SQL_SELECT_USERS;
        if (whereTests.size() > 0) {
            sqlStr = sqlStr + " WHERE " + StringUtils.join(whereTests.iterator(), (String)" AND ");
        }
        return this.database.sqlQueryMulti(sqlStr, new String[0]);
    }

    String[] sqlSelectUserById(int userId) {
        String sqlStr = "SELECT user_id, login_name, login_password, first_name, last_name, title, company, address, city, zip, country, county_council, email, language, active, create_date, external FROM users WHERE user_id = ?";
        return this.database.sqlQuery(sqlStr, new String[]{"" + userId});
    }

    public void saveUser(String loginName, UserDomainObject tempUser, UserDomainObject currentUser) {
        UserDomainObject imcmsUser = this.getUser(loginName);
        tempUser.setId(imcmsUser.getId());
        tempUser.setLoginName(loginName);
        this.saveUser(tempUser, currentUser);
    }

    public void saveUser(UserDomainObject user, UserDomainObject currentUser) {
        String[] params = new String[]{user.getLoginName(), null == user.getPassword() ? "" : user.getPassword(), user.getFirstName(), user.getLastName(), user.getTitle(), user.getCompany(), user.getAddress(), user.getCity(), user.getZip(), user.getCountry(), user.getCountyCouncil(), user.getEmailAddress(), user.isImcmsExternal() ? "1" : "0", user.isActive() ? "1" : "0", user.getLanguageIso639_2(), "" + user.getId()};
        this.database.sqlUpdateQuery("UPDATE users \nSET login_name = ?,\nlogin_password = ?,\nfirst_name = ?,\nlast_name = ?,\ntitle = ?,\ncompany = ?,\naddress =  ?,\ncity = ?,\nzip = ?,\ncountry = ?,\ncounty_council = ?,\nemail = ?,\nexternal = ?,\nactive = ?,\nlanguage = ?\nWHERE user_id = ?", params);
        if (!user.equals(currentUser)) {
            this.sqlUpdateUserRoles(user);
        }
        this.removePhoneNumbers(user);
        this.addPhoneNumbers(user);
    }

    public synchronized void addUser(UserDomainObject user, UserDomainObject currentUser) {
        String newUserId = this.database.sqlProcedureStr(SPROC_GET_HIGHEST_USER_ID, new String[0]);
        int newIntUserId = Integer.parseInt(newUserId);
        user.setId(newIntUserId);
        Object[] usersColumns = new String[]{"user_id", "login_name", "login_password", "first_name", "last_name", "title", "company", "address", "city", "zip", "country", "county_council", "email", "external", "active", "language"};
        if (user.isImcmsExternal()) {
            user.setPassword("");
        }
        this.database.sqlUpdateQuery("INSERT INTO users (" + StringUtils.join((Object[])usersColumns, (char)',') + ", create_date)\n" + "VALUES (" + StringUtils.repeat((String)"?,", (int)usersColumns.length) + " getDate())", new String[]{"" + user.getId(), user.getLoginName(), user.getPassword(), user.getFirstName(), user.getLastName(), user.getTitle(), user.getCompany(), user.getAddress(), user.getCity(), user.getZip(), user.getCountry(), user.getCountyCouncil(), user.getEmailAddress(), user.isImcmsExternal() ? "1" : "0", user.isActive() ? "1" : "0", user.getLanguageIso639_2()});
        if (!user.equals(currentUser)) {
            this.sqlAddRolesToUser(user.getRoles(), user);
        }
        this.addPhoneNumbers(user);
    }

    private void removePhoneNumbers(UserDomainObject newUser) {
        String[] sprocParameters = new String[]{String.valueOf(newUser.getId())};
        this.database.sqlUpdateProcedure(SPROC_DEL_PHONE_NR, sprocParameters);
    }

    private void addPhoneNumbers(UserDomainObject newUser) {
        boolean PHONE_TYPE_OTHER_PHONE = false;
        boolean PHONE_TYPE_HOME_PHONE = true;
        int PHONE_TYPE_WORK_PHONE = 2;
        int PHONE_TYPE_WORK_MOBILE = 3;
        int PHONE_TYPE_FAX_PHONE = 4;
        if (newUser.getHomePhone().length() > 0) {
            ImcmsAuthenticatorAndUserAndRoleMapper.addPhoneNumber(newUser.getId(), newUser.getHomePhone(), 1, this.database);
        }
        if (newUser.getWorkPhone().length() > 0) {
            ImcmsAuthenticatorAndUserAndRoleMapper.addPhoneNumber(newUser.getId(), newUser.getWorkPhone(), 2, this.database);
        }
        if (newUser.getMobilePhone().length() > 0) {
            ImcmsAuthenticatorAndUserAndRoleMapper.addPhoneNumber(newUser.getId(), newUser.getMobilePhone(), 3, this.database);
        }
        if (newUser.getFaxPhone().length() > 0) {
            ImcmsAuthenticatorAndUserAndRoleMapper.addPhoneNumber(newUser.getId(), newUser.getFaxPhone(), 4, this.database);
        }
        if (newUser.getOtherPhone().length() > 0) {
            ImcmsAuthenticatorAndUserAndRoleMapper.addPhoneNumber(newUser.getId(), newUser.getOtherPhone(), 0, this.database);
        }
    }

    public String[] getRoleNames(UserDomainObject user) {
        String[] roleNames = this.database.sqlProcedure(SPROC_GET_USER_ROLES, new String[]{"" + user.getId()});
        return roleNames;
    }

    public String[] getAllRoleNames() {
        String[] roleNamesMinusUsers = this.database.sqlProcedure(SPROC_GET_ALL_ROLES, new String[0]);
        HashSet<String> roleNamesSet = new HashSet<String>();
        for (int i = 0; i < roleNamesMinusUsers.length; i += 2) {
            String roleName = roleNamesMinusUsers[i + 1];
            roleNamesSet.add(roleName);
        }
        roleNamesSet.add("Users");
        Object[] roleNames = roleNamesSet.toArray(new String[roleNamesSet.size()]);
        Arrays.sort(roleNames);
        return roleNames;
    }

    public void addRoleNames(String[] externalRoleNames) {
        for (int i = 0; i < externalRoleNames.length; ++i) {
            String externalRoleName = externalRoleNames[i];
            this.addRole(externalRoleName);
        }
    }

    public void addRoleToUser(UserDomainObject user, String roleName) {
        this.addRole(roleName);
        this.log.debug((Object)("Trying to assign role " + roleName + " to user " + user.getLoginName()));
        RoleDomainObject role = this.getRoleByName(roleName);
        this.sqlAddRoleToUser(role, user);
    }

    private void sqlAddRoleToUser(RoleDomainObject role, UserDomainObject user) {
        this.database.sqlUpdateProcedure(SPROC_ADD_USER_ROLE, new String[]{String.valueOf(user.getId()), "" + role.getId()});
    }

    public UserDomainObject[] getUsers(boolean includeUserExtern, boolean includeInactiveUsers) {
        String[][] allUsersSqlResult = this.sqlSelectAllUsers(includeUserExtern, includeInactiveUsers);
        return this.getUsersFromSqlRows(allUsersSqlResult);
    }

    public void setUserRoles(UserDomainObject user, String[] roleNames) {
        this.sqlRemoveAllRoles(user);
        for (int i = 0; i < roleNames.length; ++i) {
            String roleName = roleNames[i];
            this.addRoleToUser(user, roleName);
        }
    }

    private void sqlRemoveAllRoles(UserDomainObject user) {
        this.database.sqlUpdateProcedure(SPROC_DEL_USER_ROLES, new String[]{"" + user.getId(), "-1"});
    }

    public UserDomainObject[] getAllUsersWithRole(RoleDomainObject role) {
        if (null == role) {
            return new UserDomainObject[0];
        }
        String[] usersWithRole = this.database.sqlProcedure(SPROC_GET_USERS_WHO_BELONGS_TO_ROLE, new String[]{"" + role.getId()});
        UserDomainObject[] result = new UserDomainObject[usersWithRole.length / 2];
        for (int i = 0; i < result.length; ++i) {
            UserDomainObject user;
            String userIdStr = usersWithRole[i * 2];
            result[i] = user = this.getUser(Integer.parseInt(userIdStr));
        }
        return result;
    }

    public static void addPhoneNumber(int newUserId, String phoneNumber, int phoneNumberType, Database database) {
        String[] sprocParameters = new String[]{String.valueOf(newUserId), phoneNumber, String.valueOf(phoneNumberType)};
        database.sqlUpdateProcedure(SPROC_PHONE_NBR_ADD, sprocParameters);
    }

    public synchronized RoleDomainObject addRole(String roleName) {
        RoleDomainObject role = this.getRoleByName(roleName);
        if (null == role) {
            role = new RoleDomainObject(roleName);
            this.addRole(role);
        }
        return role;
    }

    void addRole(RoleDomainObject role) {
        int unionOfPermissionSetIds = this.getUnionOfRolePermissionIds(role);
        int newRoleId = Integer.parseInt(this.database.sqlQueryStr(SQL_INSERT_INTO_ROLES, new String[]{role.getName(), "" + unionOfPermissionSetIds}));
        role.setId(newRoleId);
    }

    private int getUnionOfRolePermissionIds(RoleDomainObject role) {
        int unionOfPermissionSetIds = 0;
        RolePermissionDomainObject[] rolePermissions = role.getPermissions();
        for (int i = 0; i < rolePermissions.length; ++i) {
            RolePermissionDomainObject rolePermission = rolePermissions[i];
            unionOfPermissionSetIds |= rolePermission.getId();
        }
        return unionOfPermissionSetIds;
    }

    public void deleteRole(RoleDomainObject role) {
        if (null == role) {
            return;
        }
        this.database.sqlUpdateProcedure(SPROC_ROLE_DELETE, new String[]{"" + role.getId()});
    }

    public RoleDomainObject[] getAllRoles() {
        String[][] sqlRows = this.database.sqlQueryMulti(SQL_SELECT_ALL_ROLES, new String[0]);
        RoleDomainObject[] roles = new RoleDomainObject[sqlRows.length];
        for (int i = 0; i < sqlRows.length; ++i) {
            roles[i] = this.getRoleFromSqlResult(sqlRows[i]);
        }
        return roles;
    }

    public RoleDomainObject getRoleById(int roleId) {
        String[] sqlResult = this.database.sqlQuery(SQL_SELECT_ROLE_BY_ID, new String[]{"" + roleId});
        return this.getRoleFromSqlResult(sqlResult);
    }

    public RoleDomainObject getRoleByName(String wantedRoleName) {
        String[] sqlResult = this.database.sqlQuery(SQL_SELECT_ROLE_BY_NAME, new String[]{wantedRoleName});
        return this.getRoleFromSqlResult(sqlResult);
    }

    public RoleDomainObject getRoleFromSqlResult(String[] sqlResult) {
        RoleDomainObject role = null;
        if (sqlResult.length > 0) {
            int roleId = Integer.parseInt(sqlResult[0]);
            String roleName = sqlResult[1];
            int adminRoleId = Integer.parseInt(sqlResult[2]);
            int unionOfRolePermissionIds = Integer.parseInt(sqlResult[3]);
            role = new RoleDomainObject(roleId, roleName, adminRoleId);
            role.addUnionOfPermissionIdsToRole(unionOfRolePermissionIds);
        }
        return role;
    }

    public void sqlUpdateUserRoles(UserDomainObject tempUser) {
        tempUser.addRole(RoleDomainObject.USERS);
        RoleDomainObject[] userRoles = tempUser.getRoles();
        this.sqlRemoveAllRoles(tempUser);
        this.sqlAddRolesToUser(userRoles, tempUser);
    }

    private void sqlAddRolesToUser(RoleDomainObject[] userRoles, UserDomainObject user) {
        for (int i = 0; i < userRoles.length; ++i) {
            RoleDomainObject userRole = userRoles[i];
            this.sqlAddRoleToUser(userRole, user);
        }
    }

    public UserDomainObject[] getAllUsers() {
        return this.getUsers(true, true);
    }

    public UserDomainObject[] findUsersByNamePrefix(String namePrefix, boolean includeInactiveUsers) {
        String sql = "SELECT user_id, login_name, login_password, first_name, last_name, title, company, address, city, zip, country, county_council, email, language, active, create_date, external FROM users WHERE user_id != 2 AND ( login_name LIKE ? + '%' OR first_name LIKE ? + '%' OR last_name LIKE ? + '%' )";
        if (!includeInactiveUsers) {
            sql = sql + " AND active = 1";
        }
        sql = sql + " ORDER BY last_name, first_name";
        String[][] sqlRows = this.database.sqlQueryMulti(sql, new String[]{namePrefix, namePrefix, namePrefix});
        return this.getUsersFromSqlRows(sqlRows);
    }

    private UserDomainObject[] getUsersFromSqlRows(String[][] sqlRows) {
        UserDomainObject[] users = new UserDomainObject[sqlRows.length];
        for (int i = 0; i < sqlRows.length; ++i) {
            users[i] = this.getUserFromSqlRow(sqlRows[i]);
        }
        return users;
    }

    public void initUserPhoneNumbers(UserDomainObject user) {
        String[][] phoneNbr = this.getUserPhoneNumbers(user.getId());
        String workPhone = "";
        String mobilePhone = "";
        String homePhone = "";
        if (phoneNbr != null) {
            for (int i = 0; i < phoneNbr.length; ++i) {
                if ("2".equals(phoneNbr[i][3])) {
                    workPhone = phoneNbr[i][1];
                    continue;
                }
                if ("3".equals(phoneNbr[i][3])) {
                    mobilePhone = phoneNbr[i][1];
                    continue;
                }
                if (!"1".equals(phoneNbr[i][3])) continue;
                homePhone = phoneNbr[i][1];
            }
        }
        user.setWorkPhone(workPhone);
        user.setMobilePhone(mobilePhone);
        user.setHomePhone(homePhone);
    }

    public void initUserAttributes(UserDomainObject user) {
        this.initUserFromSqlData(user, this.sqlSelectUserById(user.getId()));
    }

    public void initUserRoles(UserDomainObject user) {
        user.setRoles(this.getRolesForUser(user));
    }

    public void saveRole(RoleDomainObject role) {
        if (0 == role.getId()) {
            this.addRole(role);
        } else {
            this.saveExistingRole(role);
        }
    }

    private void saveExistingRole(RoleDomainObject role) {
        int unionOfRolePermissionIds = this.getUnionOfRolePermissionIds(role);
        this.database.sqlUpdateQuery("UPDATE roles SET role_name = ?, permissions = ? WHERE role_id = ?", new String[]{role.getName(), "" + unionOfRolePermissionIds, "" + role.getId()});
    }

    public String[][] getUserPhoneNumbers(int userToChangeId) {
        return this.database.sqlQueryMulti("SELECT phones.phone_id, phones.number, phones.user_id, phones.phonetype_id, phonetypes.typename\nFROM   phones, users, phonetypes, lang_prefixes\nWHERE  phones.user_id = users.user_id\nAND    phones.phonetype_id = phonetypes.phonetype_id\nAND\t   users.language = lang_prefixes.lang_prefix\nAND    lang_prefixes.lang_id = phonetypes.lang_id\nAND    phones.user_id = ?", new String[]{"" + userToChangeId});
    }

    public RoleDomainObject[] getUseradminPermissibleRoles(UserDomainObject loggedOnUser) {
        String[] roleIds = this.database.sqlQuery("SELECT role_id FROM roles\nWHERE roles.role_id IN\n( SELECT role_id\nFROM useradmin_role_crossref\nWHERE user_id = ? )", new String[]{"" + loggedOnUser.getId()});
        ArrayList<RoleDomainObject> useradminPermissibleRolesList = new ArrayList<RoleDomainObject>();
        for (int i = 0; i < roleIds.length; ++i) {
            useradminPermissibleRolesList.add(this.getRoleById(Integer.parseInt(roleIds[i])));
        }
        return useradminPermissibleRolesList.toArray(new RoleDomainObject[useradminPermissibleRolesList.size()]);
    }

    public RoleDomainObject[] getAllRolesWithPermission(RolePermissionDomainObject rolePermission) {
        RoleDomainObject[] allRoles = this.getAllRoles();
        ArrayList<RoleDomainObject> rolesWithPermissionList = new ArrayList<RoleDomainObject>(allRoles.length);
        for (int i = 0; i < allRoles.length; ++i) {
            RoleDomainObject role = allRoles[i];
            if (!role.hasPermission(rolePermission)) continue;
            rolesWithPermissionList.add(role);
        }
        return rolesWithPermissionList.toArray(new RoleDomainObject[rolesWithPermissionList.size()]);
    }

    public UserDomainObject getDefaultUser() {
        return this.getUser(2);
    }
}

