/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import java.io.Serializable;
import java.util.NoSuchElementException;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;

public class TreeSortKeyDomainObject
implements Comparable,
Serializable {
    private int[] keys;

    public TreeSortKeyDomainObject(String treeSortKey) {
        String[] keyStrings = treeSortKey.trim().split("\\D+", 0);
        if (1 == keyStrings.length && "".equals(keyStrings[0])) {
            keyStrings = new String[]{};
        }
        this.keys = new int[keyStrings.length];
        for (int i = 0; i < keyStrings.length; ++i) {
            String keyString = keyStrings[i];
            this.keys[i] = Integer.parseInt(keyString);
        }
    }

    public int getLevelCount() {
        return this.keys.length;
    }

    public int getLevelKey(int level) {
        try {
            return this.keys[level];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new NoSuchElementException();
        }
    }

    public String toString() {
        return StringUtils.join((Object[])ArrayUtils.toObject((int[])this.keys), (char)'.');
    }

    public int compareTo(Object o) {
        int[] keys1 = this.keys;
        int[] keys2 = ((TreeSortKeyDomainObject)o).keys;
        return this.compareIntArrays(keys1, keys2);
    }

    private int compareIntArrays(int[] keys1, int[] keys2) {
        for (int i = 0; i < keys1.length && i < keys2.length; ++i) {
            int difference = keys1[i] - keys2[i];
            if (0 == difference) continue;
            return difference;
        }
        return keys1.length - keys2.length;
    }
}

