/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.document.DocumentTypeDomainObject;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.TemplateDomainObject;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class TextDocumentDomainObject
extends DocumentDomainObject {
    private TemplateDomainObject template;
    private int templateGroupId;
    private TemplateDomainObject defaultTemplate;
    private TreeMap texts = new TreeMap();
    private TreeMap images = new TreeMap();
    private TreeMap includes = new TreeMap();
    private TreeMap menus = new TreeMap();

    public TextDocumentDomainObject() {
        this.attributes.permissionSetForRestrictedOne = new TextDocumentPermissionSetDomainObject(1);
        this.attributes.permissionSetForRestrictedTwo = new TextDocumentPermissionSetDomainObject(2);
        this.attributes.permissionSetForRestrictedOneForNewDocuments = new TextDocumentPermissionSetDomainObject(1);
        this.attributes.permissionSetForRestrictedTwoForNewDocuments = new TextDocumentPermissionSetDomainObject(2);
    }

    public Object clone() throws CloneNotSupportedException {
        TextDocumentDomainObject clone = (TextDocumentDomainObject)super.clone();
        clone.texts = (TreeMap)this.texts.clone();
        clone.images = (TreeMap)this.images.clone();
        clone.includes = (TreeMap)this.includes.clone();
        clone.menus = this.deepCloneMenus();
        return clone;
    }

    public DocumentTypeDomainObject getDocumentType() {
        return DocumentTypeDomainObject.TEXT;
    }

    private TreeMap deepCloneMenus() throws CloneNotSupportedException {
        TreeMap<Integer, Object> menusClone = new TreeMap<Integer, Object>();
        Iterator iterator = this.menus.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Integer menuIndex = (Integer)entry.getKey();
            MenuDomainObject menu = (MenuDomainObject)entry.getValue();
            menusClone.put(menuIndex, menu.clone());
        }
        return menusClone;
    }

    public Set getChildDocuments() {
        HashSet<DocumentDomainObject> childDocuments = new HashSet<DocumentDomainObject>();
        Iterator iterator = this.getMenus().values().iterator();
        while (iterator.hasNext()) {
            MenuDomainObject menu = (MenuDomainObject)iterator.next();
            MenuItemDomainObject[] menuItems = menu.getMenuItems();
            for (int i = 0; i < menuItems.length; ++i) {
                MenuItemDomainObject menuItem = menuItems[i];
                childDocuments.add(menuItem.getDocument());
            }
        }
        return childDocuments;
    }

    public ImageDomainObject getImage(int imageIndex) {
        ImageDomainObject image = (ImageDomainObject)this.images.get(new Integer(imageIndex));
        if (null == image) {
            image = new ImageDomainObject();
        }
        return image;
    }

    public Integer getIncludedDocumentId(int includeIndex) {
        return (Integer)this.includes.get(new Integer(includeIndex));
    }

    public MenuDomainObject getMenu(int menuIndex) {
        MenuDomainObject menu = (MenuDomainObject)this.menus.get(new Integer(menuIndex));
        if (null == menu) {
            menu = new MenuDomainObject();
            this.setMenu(menuIndex, menu);
        }
        return menu;
    }

    public TextDomainObject getText(int textFieldIndex) {
        return (TextDomainObject)this.texts.get(new Integer(textFieldIndex));
    }

    public void initDocument(DocumentMapper documentMapper) {
    }

    public void accept(DocumentVisitor documentVisitor) {
        documentVisitor.visitTextDocument(this);
    }

    public void removeAllImages() {
        this.images.clear();
    }

    public void removeAllIncludes() {
        this.includes.clear();
    }

    public void removeAllMenus() {
        this.menus.clear();
    }

    public void removeAllTexts() {
        this.texts.clear();
    }

    public void setInclude(int includeIndex, int includedDocumentId) {
        this.includes.put(new Integer(includeIndex), new Integer(includedDocumentId));
    }

    public void setMenu(int menuIndex, MenuDomainObject menu) {
        this.menus.put(new Integer(menuIndex), menu);
    }

    public void setText(int textIndex, TextDomainObject text) {
        this.texts.put(new Integer(textIndex), text);
    }

    public Map getImages() {
        return Collections.unmodifiableMap(this.images);
    }

    public Map getIncludes() {
        return Collections.unmodifiableMap(this.includes);
    }

    public Map getMenus() {
        return Collections.unmodifiableMap(this.menus);
    }

    public TemplateDomainObject getTemplate() {
        return this.template;
    }

    public int getTemplateGroupId() {
        return this.templateGroupId;
    }

    public Map getTexts() {
        return Collections.unmodifiableMap(this.texts);
    }

    public void setImages(Map images) {
        this.images = new TreeMap(images);
    }

    public void setTemplate(TemplateDomainObject v) {
        this.template = v;
    }

    public void setTemplateGroupId(int v) {
        this.templateGroupId = v;
    }

    public void setImage(int imageIndex, ImageDomainObject image) {
        this.images.put(new Integer(imageIndex), image);
    }

    public TemplateDomainObject getDefaultTemplate() {
        return this.defaultTemplate;
    }

    public void setDefaultTemplate(TemplateDomainObject defaultTemplate) {
        this.defaultTemplate = defaultTemplate;
    }

    public void removeInclude(int includeIndex) {
        this.includes.remove(new Integer(includeIndex));
    }
}

