/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.textdocument;

import com.imcode.util.ImageSize;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentReference;
import imcode.server.document.FileDocumentDomainObject;
import imcode.util.FileInputStreamSource;
import imcode.util.InputStreamSource;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class ImageDomainObject
implements Serializable {
    private ImageSource source;
    private String name = "";
    private int width;
    private int height;
    private int border;
    private String align = "";
    private String alternateText = "";
    private String lowResolutionUrl = "";
    private int verticalSpace;
    private int horizontalSpace;
    private String target = "";
    private String linkUrl = "";

    public String getName() {
        return this.name;
    }

    public ImageSize getDisplayImageSize() {
        ImageSize realImageSize = this.getRealImageSize();
        int wantedWidth = this.getWidth();
        int wantedHeight = this.getHeight();
        if (0 == wantedWidth && 0 != wantedHeight && 0 != realImageSize.getHeight()) {
            wantedWidth = (int)((double)realImageSize.getWidth() * ((double)wantedHeight / (double)realImageSize.getHeight()));
        } else if (0 == wantedHeight && 0 != wantedWidth && 0 != realImageSize.getWidth()) {
            wantedHeight = (int)((double)realImageSize.getHeight() * ((double)wantedWidth / (double)realImageSize.getWidth()));
        } else if (0 == wantedWidth && 0 == wantedHeight) {
            wantedWidth = realImageSize.getWidth();
            wantedHeight = realImageSize.getHeight();
        }
        return new ImageSize(wantedWidth, wantedHeight);
    }

    public ImageSize getRealImageSize() {
        ImageSize imageSize = new ImageSize(0, 0);
        if (null != this.source) {
            try {
                imageSize = this.source.getImageSize();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return imageSize;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getBorder() {
        return this.border;
    }

    public String getAlign() {
        return this.align;
    }

    public String getAlternateText() {
        return this.alternateText;
    }

    public String getLowResolutionUrl() {
        return this.lowResolutionUrl;
    }

    public int getVerticalSpace() {
        return this.verticalSpace;
    }

    public int getHorizontalSpace() {
        return this.horizontalSpace;
    }

    public String getTarget() {
        return this.target;
    }

    public String getLinkUrl() {
        return this.linkUrl;
    }

    public void setName(String image_name) {
        this.name = image_name;
    }

    public void setWidth(int image_width) {
        this.width = image_width;
    }

    public void setHeight(int image_height) {
        this.height = image_height;
    }

    public void setBorder(int image_border) {
        this.border = image_border;
    }

    public void setAlign(String image_align) {
        this.align = image_align;
    }

    public void setAlternateText(String alt_text) {
        this.alternateText = alt_text;
    }

    public void setLowResolutionUrl(String low_scr) {
        this.lowResolutionUrl = low_scr;
    }

    public void setVerticalSpace(int v_space) {
        this.verticalSpace = v_space;
    }

    public void setHorizontalSpace(int h_space) {
        this.horizontalSpace = h_space;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setLinkUrl(String image_ref_link) {
        this.linkUrl = image_ref_link;
    }

    public void setSourceAndClearSize(ImageSource source) {
        this.setSource(source);
        this.setWidth(0);
        this.setHeight(0);
    }

    public void setSource(ImageSource source) {
        this.source = source;
    }

    public boolean isEmpty() {
        return null == this.source;
    }

    public String getUrlPath(String contextPath) {
        String urlPathRelativeToContextPath = this.getUrlPathRelativeToContextPath();
        if (StringUtils.isBlank((String)urlPathRelativeToContextPath)) {
            return "";
        }
        return contextPath + urlPathRelativeToContextPath;
    }

    public String getUrlPathRelativeToContextPath() {
        if (null == this.source) {
            return "";
        }
        return this.source.getUrlPathRelativeToContextPath();
    }

    public long getSize() {
        if (null == this.source) {
            return 0L;
        }
        try {
            return this.source.getInputStreamSource().getSize();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public ImageSource getSource() {
        if (null == this.source) {
            return new NullImageSource();
        }
        return this.source;
    }

    public class NullImageSource
    extends ImageSource {
        public InputStreamSource getInputStreamSource() {
            return null;
        }

        public String getUrlPathRelativeToContextPath() {
            return "";
        }

        public String toStorageString() {
            return "";
        }

        public int getTypeId() {
            return -1;
        }

        public Date getModifiedDatetime() {
            return null;
        }
    }

    public static class ImagesPathRelativePathImageSource
    extends ImageSource {
        private String relativePath;

        public ImagesPathRelativePathImageSource(String relativePath) {
            this.relativePath = relativePath;
        }

        public InputStreamSource getInputStreamSource() {
            return new FileInputStreamSource(this.getFile());
        }

        private File getFile() {
            ImcmsServices service = Imcms.getServices();
            File imageDirectory = service.getConfig().getImagePath();
            File imageFile = new File(imageDirectory, this.relativePath);
            return imageFile;
        }

        public String getUrlPathRelativeToContextPath() {
            return Imcms.getServices().getConfig().getImageUrl() + this.relativePath;
        }

        public String toStorageString() {
            return this.relativePath;
        }

        public int getTypeId() {
            return 0;
        }

        public Date getModifiedDatetime() {
            return new Date(this.getFile().lastModified());
        }
    }

    public static class FileDocumentImageSource
    extends ImageSource {
        private DocumentReference fileDocumentReference;

        public FileDocumentImageSource(DocumentReference fileDocumentReference) {
            this.fileDocumentReference = fileDocumentReference;
            DocumentDomainObject document = fileDocumentReference.getDocument();
            if (!(document instanceof FileDocumentDomainObject)) {
                throw new IllegalArgumentException("Not a file document: " + document.getId());
            }
        }

        public InputStreamSource getInputStreamSource() {
            return this.getFileDocument().getDefaultFile().getInputStreamSource();
        }

        public FileDocumentDomainObject getFileDocument() {
            return (FileDocumentDomainObject)this.fileDocumentReference.getDocument();
        }

        public String getUrlPathRelativeToContextPath() {
            return "/servlet/GetDoc?meta_id=" + this.getFileDocument().getId();
        }

        public String toStorageString() {
            return "" + this.getFileDocument().getId();
        }

        public int getTypeId() {
            return 1;
        }

        public Date getModifiedDatetime() {
            return this.getFileDocument().getModifiedDatetime();
        }
    }

    public static abstract class ImageSource
    implements Serializable {
        static final int IMAGE_TYPE_ID__NULL = -1;
        public static final int IMAGE_TYPE_ID__IMAGES_PATH_RELATIVE_PATH = 0;
        public static final int IMAGE_TYPE_ID__FILE_DOCUMENT = 1;
        private ImageSize cachedImageSize;
        private Date cachedImageSizeTime;

        abstract InputStreamSource getInputStreamSource();

        abstract String getUrlPathRelativeToContextPath();

        public abstract String toStorageString();

        public abstract int getTypeId();

        public abstract Date getModifiedDatetime();

        ImageSize getImageSize() throws IOException {
            Date modifiedDatetime = this.getModifiedDatetime();
            if (this.cachedImageSizeTime == null || modifiedDatetime.after(this.cachedImageSizeTime)) {
                this.cachedImageSize = this.getNonCachedImageSize();
                this.cachedImageSizeTime = modifiedDatetime;
            }
            return this.cachedImageSize;
        }

        ImageSize getNonCachedImageSize() throws IOException {
            return ImageSize.fromInputStream(this.getInputStreamSource().getInputStream());
        }
    }
}

