/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document.index;

import imcode.server.Imcms;
import imcode.server.document.CategoryDomainObject;
import imcode.server.document.CategoryTypeDomainObject;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.SectionDomainObject;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.util.Utility;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;
import org.apache.lucene.document.DateField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

class IndexDocumentFactory {
    private static final Logger log = Logger.getLogger((String)IndexDocumentFactory.class.getName());

    IndexDocumentFactory() {
    }

    public Document createIndexDocument(DocumentDomainObject document) {
        Document indexDocument = new Document();
        int documentId = document.getId();
        indexDocument.add(Field.Keyword((String)"meta_id", (String)("" + documentId)));
        indexDocument.add(Field.UnStored((String)"meta_headline", (String)document.getHeadline()));
        indexDocument.add(Field.UnStored((String)"meta_text", (String)document.getMenuText()));
        indexDocument.add(IndexDocumentFactory.unStoredKeyword("doc_type_id", "" + document.getDocumentTypeId()));
        indexDocument.add(IndexDocumentFactory.unStoredKeyword("creator_id", "" + document.getCreator().getId()));
        if (null != document.getPublisher()) {
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("publisher_id", "" + document.getPublisher().getId()));
        }
        SectionDomainObject[] sections = document.getSections();
        for (int i = 0; i < sections.length; ++i) {
            SectionDomainObject section = sections[i];
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("section", section.getName()));
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("section_id", "" + section.getId()));
        }
        this.addDateFieldToIndexDocument(documentId, indexDocument, "created_datetime", document.getCreatedDatetime());
        this.addDateFieldToIndexDocument(documentId, indexDocument, "modified_datetime", document.getModifiedDatetime());
        this.addDateFieldToIndexDocument(documentId, indexDocument, "activated_datetime", document.getPublicationStartDatetime());
        this.addDateFieldToIndexDocument(documentId, indexDocument, "publication_start_datetime", document.getPublicationStartDatetime());
        this.addDateFieldToIndexDocument(documentId, indexDocument, "publication_end_datetime", document.getPublicationEndDatetime());
        this.addDateFieldToIndexDocument(documentId, indexDocument, "archived_datetime", document.getArchivedDatetime());
        indexDocument.add(IndexDocumentFactory.unStoredKeyword("status", "" + document.getStatus()));
        indexDocument.add(IndexDocumentFactory.unStoredKeyword("phase", "" + document.getLifeCyclePhase()));
        DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
        try {
            document.accept(new IndexDocumentAdaptingVisitor(indexDocument));
        }
        catch (RuntimeException re) {
            log.error((Object)("Error indexing document-type-specific data of document " + document.getId()), (Throwable)re);
        }
        CategoryDomainObject[] categories = document.getCategories();
        for (int i = 0; i < categories.length; ++i) {
            CategoryDomainObject category = categories[i];
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("category", category.getName()));
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("category_id", "" + category.getId()));
            CategoryTypeDomainObject categoryType = category.getType();
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("category_type", categoryType.getName()));
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("category_type_id", "" + categoryType.getId()));
        }
        String[] documentKeywords = document.getKeywords();
        for (int i = 0; i < documentKeywords.length; ++i) {
            String documentKeyword = documentKeywords[i];
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("keyword", documentKeyword));
        }
        String[][] parentDocumentAndMenuIds = documentMapper.getParentDocumentAndMenuIdsForDocument(document);
        for (int i = 0; i < parentDocumentAndMenuIds.length; ++i) {
            String parentId = parentDocumentAndMenuIds[i][0];
            String menuId = parentDocumentAndMenuIds[i][1];
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("parent_id", parentId));
            indexDocument.add(IndexDocumentFactory.unStoredKeyword("parent_menu_id", parentId + "_" + menuId));
        }
        return indexDocument;
    }

    private void addDateFieldToIndexDocument(int documentId, Document indexDocument, String fieldName, Date date) {
        if (null != date) {
            try {
                indexDocument.add(IndexDocumentFactory.unStoredKeyword(fieldName, date));
            }
            catch (RuntimeException re) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                log.warn((Object)("Failed to index datetime '" + dateFormat.format(date) + "' in field '" + fieldName + "' of document " + documentId), (Throwable)re);
            }
        }
    }

    private static Field unStoredKeyword(String fieldName, String fieldValue) {
        return new Field(fieldName, fieldValue.toLowerCase(), false, true, false);
    }

    private static Field unStoredKeyword(String fieldName, Date fieldValue) {
        Date truncatedDate = Utility.truncateDateToMinutePrecision(fieldValue);
        return new Field(fieldName, DateField.dateToString((Date)truncatedDate), false, true, false);
    }

    private static class IndexDocumentAdaptingVisitor
    extends DocumentVisitor {
        Document indexDocument;

        private IndexDocumentAdaptingVisitor(Document indexDocument) {
            this.indexDocument = indexDocument;
        }

        public void visitTextDocument(TextDocumentDomainObject textDocument) {
            Iterator textsIterator = textDocument.getTexts().entrySet().iterator();
            while (textsIterator.hasNext()) {
                Map.Entry textEntry = textsIterator.next();
                Integer textIndex = (Integer)textEntry.getKey();
                TextDomainObject text = (TextDomainObject)textEntry.getValue();
                this.indexDocument.add(Field.UnStored((String)"nonstripped_text", (String)text.getText()));
                String htmlStrippedText = this.stripHtml(text);
                this.indexDocument.add(Field.UnStored((String)"text", (String)htmlStrippedText));
                this.indexDocument.add(Field.UnStored((String)("text" + textIndex), (String)htmlStrippedText));
            }
            Iterator imagesIterator = textDocument.getImages().values().iterator();
            while (imagesIterator.hasNext()) {
                ImageDomainObject image = (ImageDomainObject)imagesIterator.next();
                String imageLinkUrl = image.getLinkUrl();
                if (null == imageLinkUrl || imageLinkUrl.length() <= 0) continue;
                this.indexDocument.add(IndexDocumentFactory.unStoredKeyword("image_link_url", imageLinkUrl));
            }
        }

        private String stripHtml(TextDomainObject text) {
            String string = text.getText();
            if (1 == text.getType()) {
                string = string.replaceAll("<[^>]+?>", "");
            }
            return string;
        }

        public void visitFileDocument(FileDocumentDomainObject fileDocument) {
            FileDocumentDomainObject.FileDocumentFile file = fileDocument.getDefaultFile();
            if (null != file) {
                this.indexDocument.add(IndexDocumentFactory.unStoredKeyword("mime_type", file.getMimeType()));
            }
        }
    }
}

