/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.Imcms;
import imcode.server.db.Database;
import imcode.server.db.DatabaseConnection;
import imcode.server.document.BrowserDocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.textdocument.ImageDomainObject;
import imcode.server.document.textdocument.MenuDomainObject;
import imcode.server.document.textdocument.MenuItemDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.document.textdocument.TextDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.FileInputStreamSource;
import imcode.util.FileUtility;
import imcode.util.InputStreamSource;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.UnhandledException;

public class DocumentStoringVisitor
extends DocumentVisitor {
    protected Database database;
    protected UserDomainObject user;
    private static final int FILE_BUFFER_LENGTH = 2048;
    private static final int DB_FIELD_MAX_LENGTH__FILENAME = 255;

    public DocumentStoringVisitor(UserDomainObject user, Database database) {
        this.database = database;
        this.user = user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFileDocumentFile(int fileDocumentId, FileDocumentDomainObject.FileDocumentFile fileDocumentFile, String fileId) {
        try {
            boolean sameFileOnDisk;
            InputStream in;
            InputStreamSource inputStreamSource = fileDocumentFile.getInputStreamSource();
            try {
                in = inputStreamSource.getInputStream();
            }
            catch (FileNotFoundException e) {
                throw new UnhandledException("The file for filedocument " + fileDocumentId + " has disappeared.", (Throwable)e);
            }
            if (null == in) {
                return;
            }
            File file = DocumentStoringVisitor.getFileForFileDocument(fileDocumentId, fileId);
            boolean bl = sameFileOnDisk = inputStreamSource instanceof FileInputStreamSource && ((FileInputStreamSource)inputStreamSource).getFile().equals(file) && file.exists();
            if (sameFileOnDisk) {
                return;
            }
            byte[] buffer = new byte[2048];
            FileOutputStream out = new FileOutputStream(file);
            try {
                int bytesRead;
                while (-1 != (bytesRead = in.read(buffer))) {
                    ((OutputStream)out).write(buffer, 0, bytesRead);
                }
            }
            finally {
                ((OutputStream)out).close();
                in.close();
            }
        }
        catch (IOException e) {
            throw new UnhandledException((Throwable)e);
        }
    }

    public static File getFileForFileDocument(int fileDocumentId, String fileId) {
        File filePath = Imcms.getServices().getConfig().getFilePath();
        String filename = "" + fileDocumentId;
        if (StringUtils.isNotBlank((String)fileId)) {
            filename = filename + "." + FileUtility.escapeFilename(fileId);
        }
        File file = new File(filePath, filename);
        return file;
    }

    static String makeSqlInsertString(String tableName, String[] columnNames) {
        return "INSERT INTO " + tableName + " (" + StringUtils.join((Object[])columnNames, (String)",") + ")" + "VALUES(?" + StringUtils.repeat((String)",?", (int)(columnNames.length - 1)) + ")";
    }

    void updateTextDocumentMenus(DatabaseConnection connection, TextDocumentDomainObject textDocument) {
        Map menuMap = textDocument.getMenus();
        Iterator iterator = menuMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Integer menuIndex = (Integer)entry.getKey();
            MenuDomainObject menu = (MenuDomainObject)entry.getValue();
            this.updateTextDocumentMenu(connection, textDocument, menuIndex, menu);
        }
        this.deleteUnusedMenus(connection, textDocument);
    }

    private void deleteUnusedMenus(DatabaseConnection connection, TextDocumentDomainObject textDocument) {
        Collection menus = textDocument.getMenus().values();
        if (!menus.isEmpty()) {
            Collection menuIds = CollectionUtils.collect(menus, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    return new Integer(((MenuDomainObject)input).getId());
                }
            });
            String sqlInMenuIds = StringUtils.join(menuIds.iterator(), (String)",");
            String whereClause = "menu_id NOT IN (" + sqlInMenuIds + ")";
            String sqlDeleteUnusedMenuItems = "DELETE FROM childs WHERE menu_id IN (SELECT menu_id FROM menus WHERE meta_id = ?) AND " + whereClause;
            connection.executeUpdateQuery(sqlDeleteUnusedMenuItems, new String[]{"" + textDocument.getId()});
            String sqlDeleteUnusedMenus = "DELETE FROM menus WHERE meta_id = ? AND " + whereClause;
            connection.executeUpdateQuery(sqlDeleteUnusedMenus, new String[]{"" + textDocument.getId()});
        }
    }

    private void updateTextDocumentMenu(DatabaseConnection connection, TextDocumentDomainObject textDocument, Integer menuIndex, MenuDomainObject menu) {
        this.deleteTextDocumentMenu(connection, textDocument, menuIndex);
        this.insertTextDocumentMenu(connection, textDocument, menuIndex, menu);
    }

    private void insertTextDocumentMenu(DatabaseConnection connection, TextDocumentDomainObject textDocument, Integer menuIndex, MenuDomainObject menu) {
        this.sqlInsertMenu(connection, textDocument, menuIndex, menu);
        this.insertTextDocumentMenuItems(connection, menu);
    }

    private void deleteTextDocumentMenu(DatabaseConnection connection, TextDocumentDomainObject textDocument, Integer menuIndex) {
        this.deleteTextDocumentMenuItems(connection, textDocument, menuIndex);
        String sqlDeleteMenu = "DELETE FROM menus WHERE meta_id = ? AND menu_index = ?";
        connection.executeUpdateQuery(sqlDeleteMenu, new String[]{"" + textDocument.getId(), "" + menuIndex});
    }

    private void deleteTextDocumentMenuItems(DatabaseConnection connection, TextDocumentDomainObject textDocument, Integer menuIndex) {
        String sqlDeleteMenuItems = "DELETE FROM childs WHERE menu_id IN (SELECT menu_id FROM menus WHERE meta_id = ? AND menu_index = ?)";
        connection.executeUpdateQuery(sqlDeleteMenuItems, new String[]{"" + textDocument.getId(), "" + menuIndex});
    }

    void updateTextDocumentTexts(TextDocumentDomainObject textDocument) {
        this.deleteTextDocumentTexts(textDocument);
        this.insertTextDocumentTexts(textDocument);
    }

    void updateTextDocumentImages(TextDocumentDomainObject textDocument) {
        this.deleteTextDocumentImages(textDocument);
        this.insertTextDocumentImages(textDocument);
    }

    void updateTextDocumentIncludes(TextDocumentDomainObject textDocument) {
        this.deleteTextDocumentIncludes(textDocument);
        this.insertTextDocumentIncludes(textDocument);
    }

    private void deleteTextDocumentIncludes(TextDocumentDomainObject textDocument) {
        String sqlDeleteDocumentIncludes = "DELETE FROM includes WHERE meta_id = ?";
        this.database.sqlUpdateQuery(sqlDeleteDocumentIncludes, new String[]{"" + textDocument.getId()});
    }

    private void insertTextDocumentImages(TextDocumentDomainObject textDocument) {
        Map images = textDocument.getImages();
        Iterator iterator = images.keySet().iterator();
        while (iterator.hasNext()) {
            Integer imageIndex = (Integer)iterator.next();
            ImageDomainObject image = (ImageDomainObject)images.get(imageIndex);
            DocumentStoringVisitor.saveDocumentImage(textDocument.getId(), imageIndex, image);
        }
    }

    private void deleteTextDocumentImages(TextDocumentDomainObject textDocument) {
        String sqlDeleteImages = "DELETE FROM images WHERE meta_id = ?";
        this.database.sqlUpdateQuery(sqlDeleteImages, new String[]{"" + textDocument.getId()});
    }

    private void insertTextDocumentTexts(TextDocumentDomainObject textDocument) {
        Map texts = textDocument.getTexts();
        Iterator iterator = texts.keySet().iterator();
        while (iterator.hasNext()) {
            Integer textIndex = (Integer)iterator.next();
            TextDomainObject text = (TextDomainObject)texts.get(textIndex);
            this.sqlInsertText(textDocument, textIndex, text);
        }
    }

    private void sqlInsertText(TextDocumentDomainObject textDocument, Integer textIndex, TextDomainObject text) {
        this.database.sqlUpdateQuery("INSERT INTO texts (meta_id, name, text, type) VALUES(?,?,?,?)", new String[]{"" + textDocument.getId(), "" + textIndex, text.getText(), "" + text.getType()});
    }

    private void deleteTextDocumentTexts(TextDocumentDomainObject textDocument) {
        String sqlDeleteTexts = "DELETE FROM texts WHERE meta_id = ?";
        this.database.sqlUpdateQuery(sqlDeleteTexts, new String[]{"" + textDocument.getId()});
    }

    private void insertTextDocumentMenuItems(DatabaseConnection connection, MenuDomainObject menu) {
        MenuItemDomainObject[] menuItems = menu.getMenuItems();
        for (int i = 0; i < menuItems.length; ++i) {
            MenuItemDomainObject menuItem = menuItems[i];
            this.sqlInsertMenuItem(connection, menu, menuItem);
        }
    }

    private void sqlInsertMenuItem(DatabaseConnection connection, MenuDomainObject menu, MenuItemDomainObject menuItem) {
        String sqlInsertMenuItem = "INSERT INTO childs (menu_id, to_meta_id, manual_sort_order, tree_sort_index) VALUES(?,?,?,?)";
        String[] parameters = new String[]{"" + menu.getId(), "" + menuItem.getDocument().getId(), "" + menuItem.getSortKey(), "" + menuItem.getTreeSortKey()};
        connection.executeUpdateQuery(sqlInsertMenuItem, parameters);
    }

    private void sqlInsertMenu(DatabaseConnection connection, TextDocumentDomainObject textDocument, int menuIndex, MenuDomainObject menu) {
        String sqlInsertMenu = "INSERT INTO menus (meta_id, menu_index, sort_order) VALUES(?,?,?) SELECT @@IDENTITY";
        String[] parameters = new String[]{"" + textDocument.getId(), "" + menuIndex, "" + menu.getSortOrder()};
        int menuId = Integer.parseInt(connection.executeUpdateAndSelectString(sqlInsertMenu, parameters));
        menu.setId(menuId);
    }

    private void insertTextDocumentIncludes(TextDocumentDomainObject textDocument) {
        Map includes = textDocument.getIncludes();
        Iterator iterator = includes.keySet().iterator();
        while (iterator.hasNext()) {
            Integer includeIndex = (Integer)iterator.next();
            Integer includedDocumentId = (Integer)includes.get(includeIndex);
            this.sqlInsertTextDocumentInclude(textDocument, includeIndex, includedDocumentId);
        }
    }

    private void sqlInsertTextDocumentInclude(TextDocumentDomainObject textDocument, Integer includeIndex, Integer includedDocumentId) {
        this.database.sqlUpdateQuery("INSERT INTO includes (meta_id, include_id, included_meta_id) VALUES(?,?,?)", new String[]{"" + textDocument.getId(), "" + includeIndex, "" + includedDocumentId});
    }

    public static void saveDocumentImage(int meta_id, int img_no, ImageDomainObject image) {
        String sqlStr = "update images\nset imgurl  = ?, \nwidth       = ?, \nheight      = ?, \nborder      = ?, \nv_space     = ?, \nh_space     = ?, \nimage_name  = ?, \ntarget      = ?, \nalign       = ?, \nalt_text    = ?, \nlow_scr     = ?, \nlinkurl     = ?, \ntype        = ?  \nwhere meta_id = ? \nand name = ? \n";
        int rowUpdateCount = DocumentStoringVisitor.sqlImageUpdateQuery(sqlStr, image, meta_id, img_no);
        if (0 == rowUpdateCount) {
            sqlStr = "insert into images (imgurl, width, height, border, v_space, h_space, image_name, target, align, alt_text, low_scr, linkurl, type, meta_id, name) values(?,?,?,?,?, ?,?,?,?,?, ?,?,?,?,?)";
            DocumentStoringVisitor.sqlImageUpdateQuery(sqlStr, image, meta_id, img_no);
        }
    }

    private static int sqlImageUpdateQuery(String sqlStr, ImageDomainObject image, int meta_id, int img_no) {
        ImageDomainObject.ImageSource imageSource = image.getSource();
        return Imcms.getServices().sqlUpdateQuery(sqlStr, new String[]{imageSource.toStorageString(), "" + image.getWidth(), "" + image.getHeight(), "" + image.getBorder(), "" + image.getVerticalSpace(), "" + image.getHorizontalSpace(), image.getName(), image.getTarget(), image.getAlign(), image.getAlternateText(), image.getLowResolutionUrl(), image.getLinkUrl(), "" + imageSource.getTypeId(), "" + meta_id, "" + img_no});
    }

    public void visitFileDocument(FileDocumentDomainObject fileDocument) {
        Map fileDocumentFiles = fileDocument.getFiles();
        String sqlDelete = "DELETE FROM fileupload_docs WHERE meta_id = ?";
        this.database.sqlUpdateQuery(sqlDelete, new String[]{"" + fileDocument.getId()});
        Iterator iterator = fileDocumentFiles.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String fileId = (String)entry.getKey();
            FileDocumentDomainObject.FileDocumentFile fileDocumentFile = (FileDocumentDomainObject.FileDocumentFile)entry.getValue();
            String filename = fileDocumentFile.getFilename();
            if (filename.length() > 255) {
                filename = this.truncateFilename(filename, 255);
            }
            String sqlInsert = "INSERT INTO fileupload_docs (meta_id, variant_name, filename, mime, created_as_image, default_variant) VALUES(?,?,?,?,?,?)";
            boolean isDefaultFile = fileId.equals(fileDocument.getDefaultFileId());
            this.database.sqlUpdateQuery(sqlInsert, new String[]{"" + fileDocument.getId(), fileId, filename, fileDocumentFile.getMimeType(), fileDocumentFile.isCreatedAsImage() ? "1" : "0", isDefaultFile ? "1" : "0"});
            this.saveFileDocumentFile(fileDocument.getId(), fileDocumentFile, fileId);
        }
        DocumentMapper.deleteOtherFileDocumentFiles(fileDocument);
    }

    private String truncateFilename(String filename, int length) {
        String truncatedFilename = StringUtils.left((String)filename, (int)length);
        String extensions = this.getExtensionsFromFilename(filename);
        if (extensions.length() > length) {
            return truncatedFilename;
        }
        String basename = StringUtils.chomp((String)filename, (String)extensions);
        String truncatedBasename = StringUtils.substring((String)basename, (int)0, (int)(length - extensions.length()));
        truncatedFilename = truncatedBasename + extensions;
        return truncatedFilename;
    }

    private String getExtensionsFromFilename(String filename) {
        String extensions = "";
        Matcher matcher = Pattern.compile("(?:\\.\\w+)+$").matcher(filename);
        if (matcher.find()) {
            extensions = matcher.group();
        }
        return extensions;
    }

    public void visitBrowserDocument(BrowserDocumentDomainObject browserDocument) {
        this.deleteBrowserDocument(browserDocument);
        this.saveNewBrowserDocument(browserDocument);
    }

    private void deleteBrowserDocument(BrowserDocumentDomainObject browserDocument) {
        String sqlStr = "DELETE FROM browser_docs WHERE meta_id = ?";
        this.database.sqlUpdateQuery(sqlStr, new String[]{"" + browserDocument.getId()});
    }

    public void saveNewBrowserDocument(BrowserDocumentDomainObject document) {
        String[] browserDocumentColumns = new String[]{"meta_id", "to_meta_id", "browser_id"};
        String sqlBrowserDocsInsertStr = DocumentStoringVisitor.makeSqlInsertString("browser_docs", browserDocumentColumns);
        Map browserDocumentMap = document.getBrowserDocumentIdMap();
        Iterator iterator = browserDocumentMap.keySet().iterator();
        while (iterator.hasNext()) {
            BrowserDocumentDomainObject.Browser browser = (BrowserDocumentDomainObject.Browser)iterator.next();
            Integer metaIdForBrowser = (Integer)browserDocumentMap.get(browser);
            this.database.sqlUpdateQuery(sqlBrowserDocsInsertStr, new String[]{"" + document.getId(), "" + metaIdForBrowser, "" + browser.getId()});
        }
    }
}

