/*
 * Decompiled with CFR 0.152.
 */
package imcode.server.document;

import imcode.server.document.BillboardDocumentDomainObject;
import imcode.server.document.BrowserDocumentDomainObject;
import imcode.server.document.CategoryDomainObject;
import imcode.server.document.CategoryTypeDomainObject;
import imcode.server.document.ChatDocumentDomainObject;
import imcode.server.document.ConferenceDocumentDomainObject;
import imcode.server.document.DocumentPermissionSetDomainObject;
import imcode.server.document.DocumentTypeDomainObject;
import imcode.server.document.DocumentVisitor;
import imcode.server.document.FileDocumentDomainObject;
import imcode.server.document.HtmlDocumentDomainObject;
import imcode.server.document.SectionDomainObject;
import imcode.server.document.TextDocumentPermissionSetDomainObject;
import imcode.server.document.UrlDocumentDomainObject;
import imcode.server.document.textdocument.TextDocumentDomainObject;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.LocalizedMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.map.TypedMap;
import org.apache.log4j.Logger;

public abstract class DocumentDomainObject
implements Cloneable,
Serializable {
    public static final int STATUS_NEW = 0;
    public static final int STATUS_PUBLICATION_DISAPPROVED = 1;
    public static final int STATUS_PUBLICATION_APPROVED = 2;
    public static final int ID_NEW = 0;
    protected Attributes attributes = new Attributes();
    private static Logger log = Logger.getLogger((Class)DocumentDomainObject.class);

    protected DocumentDomainObject() {
        this.attributes.permissionSetForRestrictedOne = new TextDocumentPermissionSetDomainObject(1);
        this.attributes.permissionSetForRestrictedTwo = new TextDocumentPermissionSetDomainObject(2);
        this.attributes.permissionSetForRestrictedOneForNewDocuments = new TextDocumentPermissionSetDomainObject(1);
        this.attributes.permissionSetForRestrictedTwoForNewDocuments = new TextDocumentPermissionSetDomainObject(2);
    }

    public Object clone() throws CloneNotSupportedException {
        DocumentDomainObject clone = (DocumentDomainObject)super.clone();
        if (null != this.attributes) {
            clone.attributes = (Attributes)this.attributes.clone();
        }
        return clone;
    }

    /*
     * WARNING - void declaration
     */
    public static DocumentDomainObject fromDocumentTypeId(int documentTypeId) {
        void var1_1;
        switch (documentTypeId) {
            case 2: {
                DocumentDomainObject document = new TextDocumentDomainObject();
                break;
            }
            case 5: {
                DocumentDomainObject document = new UrlDocumentDomainObject();
                break;
            }
            case 6: {
                DocumentDomainObject document = new BrowserDocumentDomainObject();
                break;
            }
            case 8: {
                DocumentDomainObject document = new FileDocumentDomainObject();
                break;
            }
            case 7: {
                DocumentDomainObject document = new HtmlDocumentDomainObject();
                break;
            }
            case 103: {
                DocumentDomainObject document = new ChatDocumentDomainObject();
                break;
            }
            case 102: {
                DocumentDomainObject document = new ConferenceDocumentDomainObject();
                break;
            }
            case 104: {
                DocumentDomainObject document = new BillboardDocumentDomainObject();
                break;
            }
            default: {
                String errorMessage = "Unknown document-type-id: " + documentTypeId;
                log.error((Object)errorMessage);
                throw new IllegalArgumentException(errorMessage);
            }
        }
        return var1_1;
    }

    public Date getArchivedDatetime() {
        return this.attributes.archivedDatetime;
    }

    public void setArchivedDatetime(Date v) {
        this.attributes.archivedDatetime = v;
    }

    public CategoryDomainObject[] getCategories() {
        return this.attributes.categories.toArray(new CategoryDomainObject[this.attributes.categories.size()]);
    }

    public Date getCreatedDatetime() {
        return this.attributes.createdDatetime;
    }

    public void setCreatedDatetime(Date v) {
        this.attributes.createdDatetime = v;
    }

    public UserDomainObject getCreator() {
        return this.attributes.creator;
    }

    public void setCreator(UserDomainObject creator) {
        this.attributes.creator = creator;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public String getHeadline() {
        return this.attributes.headline;
    }

    public void setHeadline(String v) {
        this.attributes.headline = v;
    }

    public int getId() {
        return this.attributes.id;
    }

    public void setId(int v) {
        this.attributes.id = v;
    }

    public String getMenuImage() {
        return this.attributes.image;
    }

    public void setMenuImage(String v) {
        this.attributes.image = v;
    }

    public String[] getKeywords() {
        return this.attributes.keywords.toArray(new String[this.attributes.keywords.size()]);
    }

    public void setKeywords(String[] keywords) {
        this.attributes.keywords = new HashSet<String>(Arrays.asList(keywords));
    }

    public String getLanguageIso639_2() {
        return this.attributes.languageIso639_2;
    }

    public void setLanguageIso639_2(String languageIso639_2) {
        this.attributes.languageIso639_2 = languageIso639_2;
    }

    public String getMenuText() {
        return this.attributes.menuText;
    }

    public void setMenuText(String v) {
        this.attributes.menuText = v;
    }

    public Date getModifiedDatetime() {
        return this.attributes.modifiedDatetime;
    }

    public void setModifiedDatetime(Date v) {
        this.attributes.modifiedDatetime = v;
    }

    void setLastModifiedDatetime(Date modifiedDatetime) {
        this.attributes.lastModifiedDatetime = modifiedDatetime;
    }

    Date getLastModifiedDatetime() {
        return this.attributes.lastModifiedDatetime;
    }

    public Date getPublicationEndDatetime() {
        return this.attributes.publicationEndDatetime;
    }

    public void setPublicationEndDatetime(Date datetime) {
        this.attributes.publicationEndDatetime = datetime;
    }

    public Date getPublicationStartDatetime() {
        return this.attributes.publicationStartDatetime;
    }

    public void setPublicationStartDatetime(Date v) {
        this.attributes.publicationStartDatetime = v;
    }

    public UserDomainObject getPublisher() {
        return this.attributes.publisher;
    }

    public void setPublisher(UserDomainObject user) {
        this.attributes.publisher = user;
    }

    public Map getRolesMappedToPermissionSetIds() {
        return Collections.unmodifiableMap(this.attributes.rolesMappedToDocumentPermissionSetIds);
    }

    public void setRolesMappedToPermissionSetIds(Map rolesMappedToPermissionSetIds) {
        this.attributes.rolesMappedToDocumentPermissionSetIds = TypedMap.decorate(new HashMap(), (Class)RoleDomainObject.class, (Class)Integer.class);
        this.attributes.rolesMappedToDocumentPermissionSetIds.putAll(rolesMappedToPermissionSetIds);
    }

    public SectionDomainObject[] getSections() {
        return this.attributes.sections.toArray(new SectionDomainObject[this.attributes.sections.size()]);
    }

    public void setSections(SectionDomainObject[] sections) {
        this.attributes.sections = new HashSet<SectionDomainObject>(Arrays.asList(sections));
    }

    public int getStatus() {
        return this.attributes.status;
    }

    public void setStatus(int status) {
        switch (status) {
            case 0: 
            case 1: 
            case 2: {
                this.attributes.status = status;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad status.");
            }
        }
    }

    public String getTarget() {
        return this.attributes.target;
    }

    public void setTarget(String v) {
        this.attributes.target = v;
    }

    public boolean isArchived() {
        return this.isArchivedAtTime(new Date());
    }

    public boolean isLinkableByOtherUsers() {
        return this.attributes.linkableByOtherUsers;
    }

    public void setLinkableByOtherUsers(boolean linkableByOtherUsers) {
        this.attributes.linkableByOtherUsers = linkableByOtherUsers;
    }

    public boolean isRestrictedOneMorePrivilegedThanRestrictedTwo() {
        return this.attributes.restrictedOneMorePrivilegedThanRestrictedTwo;
    }

    public void setRestrictedOneMorePrivilegedThanRestrictedTwo(boolean b) {
        this.attributes.restrictedOneMorePrivilegedThanRestrictedTwo = b;
    }

    public boolean isPublished() {
        return this.isPublishedAtTime(new Date());
    }

    public boolean isActive() {
        return this.isPublished() && !this.isArchived();
    }

    public boolean isNoLongerPublished() {
        return this.isNoLongerPublishedAtTime(new Date());
    }

    private boolean isNoLongerPublishedAtTime(Date date) {
        Date publicationEndDatetime = this.attributes.publicationEndDatetime;
        return publicationEndDatetime != null && publicationEndDatetime.before(date);
    }

    public boolean isSearchDisabled() {
        return this.attributes.searchDisabled;
    }

    public void setSearchDisabled(boolean searchDisabled) {
        this.attributes.searchDisabled = searchDisabled;
    }

    public boolean isVisibleInMenusForUnauthorizedUsers() {
        return this.attributes.visibleInMenusForUnauthorizedUsers;
    }

    public void setVisibleInMenusForUnauthorizedUsers(boolean visibleInMenusForUnauthorizedUsers) {
        this.attributes.visibleInMenusForUnauthorizedUsers = visibleInMenusForUnauthorizedUsers;
    }

    public void addCategory(CategoryDomainObject category) {
        this.attributes.categories.add(category);
    }

    public void addSection(SectionDomainObject section) {
        this.attributes.sections.add(section);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DocumentDomainObject)) {
            return false;
        }
        DocumentDomainObject document = (DocumentDomainObject)o;
        return this.attributes.id == document.attributes.id;
    }

    public CategoryDomainObject[] getCategoriesOfType(CategoryTypeDomainObject type) {
        CategoryDomainObject[] categories = this.attributes.categories.toArray(new CategoryDomainObject[this.attributes.categories.size()]);
        ArrayList<CategoryDomainObject> categoriesOfType = new ArrayList<CategoryDomainObject>();
        for (int i = 0; i < categories.length; ++i) {
            CategoryDomainObject category = categories[i];
            if (!type.equals(category.getType())) continue;
            categoriesOfType.add(category);
        }
        CategoryDomainObject[] arrayOfCategoriesOfType = new CategoryDomainObject[categoriesOfType.size()];
        return categoriesOfType.toArray(arrayOfCategoriesOfType);
    }

    public abstract DocumentTypeDomainObject getDocumentType();

    public final int getDocumentTypeId() {
        return this.getDocumentType().getId();
    }

    public final LocalizedMessage getDocumentTypeName() {
        return this.getDocumentType().getName();
    }

    public int hashCode() {
        return this.attributes.id;
    }

    private boolean isArchivedAtTime(Date time) {
        Attributes documentProperties = this.attributes;
        return documentProperties.archivedDatetime != null && documentProperties.archivedDatetime.before(time);
    }

    public void removeAllCategories() {
        this.attributes.categories.clear();
    }

    public void removeAllSections() {
        this.attributes.sections.clear();
    }

    public void removeCategory(CategoryDomainObject category) {
        this.attributes.categories.remove(category);
    }

    public void setPermissionSetIdForRole(RoleDomainObject role, int permissionSetId) {
        this.attributes.rolesMappedToDocumentPermissionSetIds.put(role, new Integer(permissionSetId));
    }

    public int getPermissionSetIdForRole(RoleDomainObject role) {
        int permissionSetId = 4;
        Integer permissionSetIdInteger = (Integer)this.attributes.rolesMappedToDocumentPermissionSetIds.get(role);
        if (null != permissionSetIdInteger) {
            permissionSetId = permissionSetIdInteger;
        }
        return permissionSetId;
    }

    private boolean isPublishedAtTime(Date date) {
        Attributes documentProperties = this.attributes;
        boolean publicationStartDatetimeIsNotNullAndInThePast = documentProperties.publicationStartDatetime != null && documentProperties.publicationStartDatetime.before(date);
        boolean publicationEndDatetimeIsNullOrInTheFuture = documentProperties.publicationEndDatetime == null || documentProperties.publicationEndDatetime.after(date);
        boolean statusIsApproved = documentProperties.status == 2;
        boolean isPublished = statusIsApproved && publicationStartDatetimeIsNotNullAndInThePast && publicationEndDatetimeIsNullOrInTheFuture;
        return isPublished;
    }

    public void setPermissionSetForRestrictedOne(DocumentPermissionSetDomainObject permissionSetForRestrictedOne) {
        this.attributes.permissionSetForRestrictedOne = permissionSetForRestrictedOne;
    }

    public void setPermissionSetForRestrictedTwo(DocumentPermissionSetDomainObject permissionSetForRestrictedTwo) {
        this.attributes.permissionSetForRestrictedTwo = permissionSetForRestrictedTwo;
    }

    public void setPermissionSetForRestrictedOneForNewDocuments(DocumentPermissionSetDomainObject permissionSetForRestrictedOneForNewDocuments) {
        this.attributes.permissionSetForRestrictedOneForNewDocuments = permissionSetForRestrictedOneForNewDocuments;
    }

    public void setPermissionSetForRestrictedTwoForNewDocuments(DocumentPermissionSetDomainObject permissionSetForRestrictedTwoForNewDocuments) {
        this.attributes.permissionSetForRestrictedTwoForNewDocuments = permissionSetForRestrictedTwoForNewDocuments;
    }

    public DocumentPermissionSetDomainObject getPermissionSetForRestrictedOne() {
        return this.attributes.permissionSetForRestrictedOne;
    }

    public DocumentPermissionSetDomainObject getPermissionSetForRestrictedOneForNewDocuments() {
        return this.attributes.permissionSetForRestrictedOneForNewDocuments;
    }

    public DocumentPermissionSetDomainObject getPermissionSetForRestrictedTwo() {
        return this.attributes.permissionSetForRestrictedTwo;
    }

    public DocumentPermissionSetDomainObject getPermissionSetForRestrictedTwoForNewDocuments() {
        return this.attributes.permissionSetForRestrictedTwoForNewDocuments;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public abstract void accept(DocumentVisitor var1);

    public String getUrl(HttpServletRequest request) {
        return request.getContextPath() + "/servlet/GetDoc?meta_id=" + this.getId();
    }

    public LifeCyclePhase getLifeCyclePhase() {
        LifeCyclePhase lifeCyclePhase = null;
        lifeCyclePhase = 0 == this.getStatus() ? LifeCyclePhase.NEW : (1 == this.getStatus() ? LifeCyclePhase.DISAPPROVED : (this.isActive() ? LifeCyclePhase.PUBLISHED : (this.isNoLongerPublished() ? LifeCyclePhase.UNPUBLISHED : (this.isArchived() ? LifeCyclePhase.ARCHIVED : LifeCyclePhase.APPROVED))));
        return lifeCyclePhase;
    }

    public static class LifeCyclePhase {
        public static final LifeCyclePhase NEW = new LifeCyclePhase("new");
        public static final LifeCyclePhase DISAPPROVED = new LifeCyclePhase("disapproved");
        public static final LifeCyclePhase PUBLISHED = new LifeCyclePhase("published");
        public static final LifeCyclePhase UNPUBLISHED = new LifeCyclePhase("unpublished");
        public static final LifeCyclePhase ARCHIVED = new LifeCyclePhase("archived");
        public static final LifeCyclePhase APPROVED = new LifeCyclePhase("approved");
        private final String name;

        private LifeCyclePhase(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class Attributes
    implements Cloneable,
    Serializable {
        private Date archivedDatetime;
        private Date createdDatetime;
        private UserDomainObject creator;
        private String headline;
        private String image;
        private String languageIso639_2;
        private boolean linkableByOtherUsers;
        private String menuText;
        private int id;
        private Date modifiedDatetime;
        private Date lastModifiedDatetime;
        private boolean restrictedOneMorePrivilegedThanRestrictedTwo;
        private Date publicationStartDatetime;
        private Date publicationEndDatetime;
        private UserDomainObject publisher;
        private boolean searchDisabled;
        private int status;
        private String target;
        private boolean visibleInMenusForUnauthorizedUsers;
        private Set categories = new HashSet();
        private Set keywords = new HashSet();
        private Set sections = new HashSet();
        public DocumentPermissionSetDomainObject permissionSetForRestrictedOne;
        public DocumentPermissionSetDomainObject permissionSetForRestrictedTwo;
        public DocumentPermissionSetDomainObject permissionSetForRestrictedOneForNewDocuments;
        public DocumentPermissionSetDomainObject permissionSetForRestrictedTwoForNewDocuments;
        private Map rolesMappedToDocumentPermissionSetIds = new HashMap();

        public Object clone() throws CloneNotSupportedException {
            Attributes clone = (Attributes)super.clone();
            clone.keywords = new HashSet(this.keywords);
            clone.sections = new HashSet(this.sections);
            clone.categories = new HashSet(this.categories);
            clone.rolesMappedToDocumentPermissionSetIds = new HashMap(this.rolesMappedToDocumentPermissionSetIds);
            return clone;
        }
    }
}

