/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.servlet.superadmin.AdminError;
import com.imcode.imcms.servlet.superadmin.AdminError2;
import com.imcode.imcms.servlet.superadmin.Administrator;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.db.Database;
import imcode.server.user.ImcmsAuthenticatorAndUserAndRoleMapper;
import imcode.server.user.RoleDomainObject;
import imcode.server.user.UserDomainObject;
import imcode.util.Html;
import imcode.util.Utility;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class AdminUserProps
extends Administrator {
    private static final String HTML_RESPONSE = "AdminUserResp.htm";
    private static final String HTML_RESPONSE_ADMIN_PART = "AdminUserResp_admin_part.htm";
    private static final String HTML_RESPONSE_SUPERADMIN_PART = "AdminUserResp_superadmin_part.htm";
    private static Logger log = Logger.getLogger((String)AdminUserProps.class.getName());
    private static final String REQUEST_PARAMETER__LOGIN_NAME = "login_name";
    private static final String REQUEST_PARAMETER__PASSWORD1 = "password1";
    private static final String REQUEST_PARAMETER__FIRST_NAME = "first_name";
    private static final String REQUEST_PARAMETER__LAST_NAME = "last_name";
    private static final String REQUEST_PARAMETER__TITLE = "title";
    private static final String REQUEST_PARAMETER__COMPANY = "company";
    private static final String REQUEST_PARAMETER__ADDRESS = "address";
    private static final String REQUEST_PARAMETER__CITY = "city";
    private static final String REQUEST_PARAMETER__ZIP = "zip";
    private static final String REQUEST_PARAMETER__COUNTRY = "country";
    private static final String REQUEST_PARAMETER__COUNTY_COUNCIL = "country_council";
    private static final String REQUEST_PARAMETER__EMAIL = "email";
    private static final String REQUEST_PARAMETER__LANGUAGE = "lang_id";
    private static final String REQUEST_PARAMETER__ACTIVE = "active";
    private static final String REQUEST_PARAMETER__PASSWORD2 = "password2";
    private static final String REQUEST_PARAMETER__ROLES = "roles";

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        HttpSession session = req.getSession(false);
        Properties tmp_userInfo = (Properties)session.getAttribute("tempUser");
        Vector tmp_phones = (Vector)session.getAttribute("Ok_phoneNumbers");
        if (tmp_phones == null) {
            tmp_phones = new Vector();
        }
        String[] phonetypesA = this.getPhoneTypes(imcref, user);
        Vector<String> phoneTypesV = new Vector<String>(Arrays.asList(phonetypesA));
        if (req.getParameter("ADD_USER") != null) {
            if (!user.isSuperAdmin() && !user.isUserAdmin()) {
                this.showErrorPageUserNotAnAdministrator(req, res, imcref, user);
                return;
            }
            this.showAddUserPage(tmp_userInfo, res, phoneTypesV, tmp_phones, user, imcref, req, session);
            return;
        }
        if (req.getParameter("CHANGE_USER") != null) {
            log.debug((Object)"Changeuser");
            String userToChangeId = this.getCurrentUserId(req, res, imcref, user);
            if (!(user.isSuperAdmin() || user.isUserAdmin() || userToChangeId.equals("" + user.getId()))) {
                this.showErrorPageUserHasNoRightsToChangeUserValues(req, res, imcref, user);
                return;
            }
            this.showChangeUserPage(userToChangeId, imcref, tmp_userInfo, tmp_phones, user, res, session, phoneTypesV, user.isSuperAdmin(), user.isUserAdmin(), req);
            return;
        }
    }

    private String[] getPhoneTypes(ImcmsServices imcref, UserDomainObject user) {
        return imcref.sqlQuery("SELECT  phonetype_id, typename\nFROM phonetypes, lang_prefixes\nWHERE  phonetypes.lang_id = lang_prefixes.lang_id AND lang_prefixes.lang_prefix = ?\nORDER BY phonetype_id", new String[]{"" + user.getLanguageIso639_2()});
    }

    private void showChangeUserPage(String userToChangeId, ImcmsServices imcref, Properties tmp_userInfo, Vector tmp_phones, UserDomainObject user, HttpServletResponse res, HttpSession session, Vector phoneTypesV, boolean superadmin, boolean useradmin, HttpServletRequest req) throws IOException {
        String email;
        String country_council;
        String country;
        String zip;
        String city;
        String address;
        String company;
        String title;
        String last_name;
        String first_name;
        String password1;
        String login_name;
        UserDomainObject userToChange = null;
        if (null != userToChangeId) {
            userToChange = imcref.getImcmsAuthenticatorAndUserAndRoleMapper().getUser(Integer.parseInt(userToChangeId));
        }
        String new_pwd1 = "";
        String new_pwd2 = "";
        if (tmp_userInfo != null) {
            login_name = tmp_userInfo.getProperty(REQUEST_PARAMETER__LOGIN_NAME);
            password1 = tmp_userInfo.getProperty(REQUEST_PARAMETER__PASSWORD1);
            new_pwd1 = tmp_userInfo.getProperty("new_pwd1");
            new_pwd2 = tmp_userInfo.getProperty("new_pwd2");
            first_name = tmp_userInfo.getProperty(REQUEST_PARAMETER__FIRST_NAME);
            last_name = tmp_userInfo.getProperty(REQUEST_PARAMETER__LAST_NAME);
            title = tmp_userInfo.getProperty(REQUEST_PARAMETER__TITLE);
            company = tmp_userInfo.getProperty(REQUEST_PARAMETER__COMPANY);
            address = tmp_userInfo.getProperty(REQUEST_PARAMETER__ADDRESS);
            city = tmp_userInfo.getProperty(REQUEST_PARAMETER__CITY);
            zip = tmp_userInfo.getProperty(REQUEST_PARAMETER__ZIP);
            country = tmp_userInfo.getProperty(REQUEST_PARAMETER__COUNTRY);
            country_council = tmp_userInfo.getProperty(REQUEST_PARAMETER__COUNTY_COUNCIL);
            email = tmp_userInfo.getProperty(REQUEST_PARAMETER__EMAIL);
        } else {
            login_name = userToChange.getLoginName();
            password1 = userToChange.getPassword();
            first_name = userToChange.getFirstName();
            last_name = userToChange.getLastName();
            title = userToChange.getTitle();
            company = userToChange.getCompany();
            address = userToChange.getAddress();
            city = userToChange.getCity();
            zip = userToChange.getZip();
            country = userToChange.getCountry();
            country_council = userToChange.getCountyCouncil();
            email = userToChange.getEmailAddress();
        }
        String[][] phonesArr = imcref.getImcmsAuthenticatorAndUserAndRoleMapper().getUserPhoneNumbers(userToChange.getId());
        Vector phoneNumbers = this.getPhonesArrayVector(phonesArr);
        if (tmp_phones.size() > 0) {
            phoneNumbers = tmp_phones;
        }
        Vector phonesV = this.getPhonesVector(phoneNumbers, user, imcref);
        String selected = "";
        if (phonesV.size() > 0) {
            selected = (String)phonesV.get(0);
        }
        String phones = Html.createOptionList(selected, (List)phonesV);
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        Vector<Object> vec = new Vector<Object>();
        vec.add("#CURR_USER_ID#");
        vec.add(userToChangeId);
        vec.add("#LOGIN_NAME#");
        vec.add(login_name);
        vec.add("#PWD1#");
        vec.add(this.doPasswordString(password1));
        vec.add("#PWD2#");
        vec.add(this.doPasswordString(password1));
        vec.add("#NEW_PWD1#");
        vec.add(new_pwd1);
        vec.add("#NEW_PWD2#");
        vec.add(new_pwd2);
        vec.add("#FIRST_NAME#");
        vec.add(first_name);
        vec.add("#LAST_NAME#");
        vec.add(last_name);
        vec.add("#TITLE#");
        vec.add(title);
        vec.add("#COMPANY#");
        vec.add(company);
        vec.add("#ADDRESS#");
        vec.add(address);
        vec.add("#ZIP#");
        vec.add(zip);
        vec.add("#CITY#");
        vec.add(city);
        vec.add("#COUNTRY_COUNCIL#");
        vec.add(country_council);
        vec.add("#COUNTRY#");
        vec.add(country);
        vec.add("#EMAIL#");
        vec.add(email);
        vec.add("#NEXT_URL#");
        if (null != session.getAttribute("next_url")) {
            vec.add(session.getAttribute("next_url"));
        } else {
            vec.add("");
        }
        vec.add("#PHONE_ID#");
        vec.add("");
        vec.add("#COUNTRY_CODE#");
        vec.add("");
        vec.add("#AREA_CODE#");
        vec.add("");
        vec.add("#NUMBER#");
        vec.add("");
        String phonetypes = Html.createOptionList("1", (List)phoneTypesV);
        vec.add("#PHONETYPES_MENU#");
        vec.add(phonetypes);
        vec.add("#PHONES_MENU#");
        vec.add(phones);
        vec.add("#ADMIN_PART#");
        if (superadmin || useradmin && user.getId() != userToChange.getId()) {
            vec.add(this.createAdminPartHtml(user, userToChange, imcref, req, session));
        } else {
            vec.add("");
        }
        String adminTask = req.getParameter("adminTask");
        if (adminTask == null) {
            adminTask = "SAVE_CHANGED_USER";
        }
        vec.add("#ADMIN_TASK#");
        vec.add(adminTask);
        String languagesHtmlOptionList = this.getLanguagesHtmlOptionList(user, imcref, userToChange);
        vec.add("#LANG_TYPES#");
        vec.add(languagesHtmlOptionList);
        session.setAttribute("userToChange", (Object)userToChangeId);
        session.setAttribute("Ok_phoneNumbers", (Object)phoneNumbers);
        try {
            session.removeAttribute("tempUserRoles");
            session.removeAttribute("tempUseradminRoles");
            session.removeAttribute("tempUser");
        }
        catch (IllegalStateException ise) {
            log.debug((Object)"session has been invalidated so no need to remove parameters");
        }
        String outputString = imcref.getAdminTemplate(HTML_RESPONSE, user, vec);
        ((Writer)out).write(outputString);
    }

    private String getLanguagesHtmlOptionList(UserDomainObject user, ImcmsServices imcref, UserDomainObject userToChange) {
        String[] langList = imcref.sqlQuery("SELECT lang_prefix, language FROM languages WHERE user_prefix = ?", new String[]{user.getLanguageIso639_2()});
        Vector<String> selectedLangV = new Vector<String>();
        selectedLangV.add(userToChange.getLanguageIso639_2());
        String languagesHtmlOptionList = Html.createOptionList(new Vector<String>(Arrays.asList(langList)), selectedLangV);
        return languagesHtmlOptionList;
    }

    private void showErrorPageUserHasNoRightsToChangeUserValues(HttpServletRequest req, HttpServletResponse res, ImcmsServices imcref, UserDomainObject user) throws IOException {
        String header = "Error in AdminUserProps. ";
        Properties langproperties = imcref.getLanguageProperties(user);
        String msg = langproperties.getProperty("error/servlet/AdminUser/user_have_no_permission") + "<br>";
        log.debug((Object)(header + "- user have no permission to change user values"));
        new AdminError(req, res, header, msg);
    }

    private void showAddUserPage(Properties tmp_userInfo, HttpServletResponse res, Vector phoneTypesV, Vector tmp_phones, UserDomainObject user, ImcmsServices imcref, HttpServletRequest req, HttpSession session) throws IOException {
        String login_name = "";
        String password1 = "";
        String password2 = "";
        String new_pwd1 = "";
        String new_pwd2 = "";
        String first_name = "";
        String last_name = "";
        String title = "";
        String company = "";
        String address = "";
        String city = "";
        String zip = "";
        String country = "";
        String country_council = "";
        String email = "";
        if (tmp_userInfo != null) {
            login_name = tmp_userInfo.getProperty(REQUEST_PARAMETER__LOGIN_NAME);
            password1 = tmp_userInfo.getProperty(REQUEST_PARAMETER__PASSWORD1);
            password2 = tmp_userInfo.getProperty(REQUEST_PARAMETER__PASSWORD2);
            new_pwd1 = tmp_userInfo.getProperty("new_pwd1");
            new_pwd2 = tmp_userInfo.getProperty("new_pwd2");
            first_name = tmp_userInfo.getProperty(REQUEST_PARAMETER__FIRST_NAME);
            last_name = tmp_userInfo.getProperty(REQUEST_PARAMETER__LAST_NAME);
            title = tmp_userInfo.getProperty(REQUEST_PARAMETER__TITLE);
            company = tmp_userInfo.getProperty(REQUEST_PARAMETER__COMPANY);
            address = tmp_userInfo.getProperty(REQUEST_PARAMETER__ADDRESS);
            city = tmp_userInfo.getProperty(REQUEST_PARAMETER__CITY);
            zip = tmp_userInfo.getProperty(REQUEST_PARAMETER__ZIP);
            country = tmp_userInfo.getProperty(REQUEST_PARAMETER__COUNTRY);
            country_council = tmp_userInfo.getProperty(REQUEST_PARAMETER__COUNTY_COUNCIL);
            email = tmp_userInfo.getProperty(REQUEST_PARAMETER__EMAIL);
        }
        Vector<String> vec = new Vector<String>();
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        vec.add("#LOGIN_NAME#");
        vec.add(login_name);
        vec.add("#PWD1#");
        vec.add(password1);
        vec.add("#PWD2#");
        vec.add(password2);
        vec.add("#NEW_PWD1#");
        vec.add(new_pwd1);
        vec.add("#NEW_PWD2#");
        vec.add(new_pwd2);
        vec.add("#FIRST_NAME#");
        vec.add(first_name);
        vec.add("#LAST_NAME#");
        vec.add(last_name);
        vec.add("#TITLE#");
        vec.add(title);
        vec.add("#COMPANY#");
        vec.add(company);
        vec.add("#ADDRESS#");
        vec.add(address);
        vec.add("#CITY#");
        vec.add(city);
        vec.add("#ZIP#");
        vec.add(zip);
        vec.add("#COUNTRY#");
        vec.add(country);
        vec.add("#COUNTRY_COUNCIL#");
        vec.add(country_council);
        vec.add("#EMAIL#");
        vec.add(email);
        vec.add("#ADMIN_TASK#");
        vec.add("ADD_USER");
        vec.add("#PHONE_ID#");
        vec.add("");
        vec.add("#NUMBER#");
        vec.add("");
        String phonetypes = Html.createOptionList("1", (List)phoneTypesV);
        vec.add("#PHONETYPES_MENU#");
        vec.add(phonetypes);
        vec.add("#ADMIN_PART#");
        vec.add(this.createAdminPartHtml(user, null, imcref, req, session));
        String languagesHtmlOptionList = this.getLanguagesHtmlOptionList(user, imcref, user);
        vec.add("#LANG_TYPES#");
        vec.add(languagesHtmlOptionList);
        session.setAttribute("Ok_phoneNumbers", (Object)tmp_phones);
        String outputString = imcref.getAdminTemplate(HTML_RESPONSE, user, vec);
        ((Writer)out).write(outputString);
    }

    private void showErrorPageUserNotAnAdministrator(HttpServletRequest req, HttpServletResponse res, ImcmsServices imcref, UserDomainObject user) throws IOException {
        String header = "Error in AdminUserProps. ";
        Properties langproperties = imcref.getLanguageProperties(user);
        String msg = langproperties.getProperty("error/servlet/global/no_administrator") + "<br>";
        log.debug((Object)(header + "- user is not an administrator"));
        new AdminError(req, res, header, msg);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        ImcmsServices imcref = Imcms.getServices();
        HttpSession session = req.getSession(false);
        if (session == null) {
            return;
        }
        UserDomainObject user = Utility.getLoggedOnUser(req);
        boolean isAdmin = user.isSuperAdmin() || user.isUserAdmin();
        String adminTask = req.getParameter("adminTask");
        if (adminTask == null) {
            adminTask = "";
        }
        String userToChangeIdStr = null;
        if (req.getParameter("userTemplate") != null && "SAVE_CHANGED_USER".equals(adminTask)) {
            userToChangeIdStr = "" + user.getId();
        }
        if (req.getParameter("userTemplate") == null && !"ADD_USER".equals(adminTask)) {
            userToChangeIdStr = this.getCurrentUserId(req, res, imcref, user);
        }
        UserDomainObject userFromRequest = this.getUserFromRequest(req);
        UserDomainObject userToChange = null;
        if (null != userToChangeIdStr) {
            int userToChangeId = Integer.parseInt(userToChangeIdStr);
            userToChange = imcref.getImcmsAuthenticatorAndUserAndRoleMapper().getUser(userToChangeId);
            userFromRequest.setId(userToChange.getId());
            if (!user.isSuperAdmin()) {
                userFromRequest.setActive(userToChange.isActive());
            }
        }
        String password2 = req.getParameter(REQUEST_PARAMETER__PASSWORD2);
        String[] phonetypesA = this.getPhoneTypes(imcref, user);
        Vector<String> phoneTypesV = new Vector<String>(Arrays.asList(phonetypesA));
        VariableManager vm = new VariableManager();
        vm.addProperty("LOGIN_NAME", userFromRequest.getLoginName());
        vm.addProperty("FIRST_NAME", userFromRequest.getFirstName());
        vm.addProperty("LAST_NAME", userFromRequest.getLastName());
        vm.addProperty("TITLE", userFromRequest.getTitle());
        vm.addProperty("COMPANY", userFromRequest.getCompany());
        vm.addProperty("ADDRESS", userFromRequest.getAddress());
        vm.addProperty("CITY", userFromRequest.getCity());
        vm.addProperty("ZIP", userFromRequest.getZip());
        vm.addProperty("COUNTRY", userFromRequest.getCountry());
        vm.addProperty("COUNTRY_COUNCIL", userFromRequest.getCountyCouncil());
        vm.addProperty("EMAIL", userFromRequest.getEmailAddress());
        vm.addProperty("LANG_TYPES", this.getLanguagesHtmlOptionList(user, imcref, userFromRequest));
        if (null != req.getParameter("useradmin_settings")) {
            String[] theUserRoles = req.getParameterValues(REQUEST_PARAMETER__ROLES);
            String[] theUseradminRoles = req.getParameterValues("useradmin_roles");
            if (null != theUserRoles) {
                session.setAttribute("tempUserRoles", (Object)theUserRoles);
            }
            if (null != theUseradminRoles) {
                session.setAttribute("tempUseradminRoles", (Object)theUseradminRoles);
            }
            session.setAttribute("tempUser", (Object)userFromRequest);
            res.sendRedirect("AdminUserUseradminSettings");
            return;
        }
        if (req.getParameter("RESET_FORM") != null) {
            if (adminTask.equals("ADD_USER")) {
                res.sendRedirect("AdminUserProps?ADD_USER=true&adminTask=" + adminTask);
            } else if (adminTask.equals("SAVE_CHANGED_USER")) {
                res.sendRedirect("AdminUserProps?CHANGE_USER=true&adminTask=" + adminTask);
            }
            return;
        }
        if (req.getParameter("ok_phones") != null || req.getParameter("delete_phones") != null || req.getParameter("edit_phones") != null) {
            this.phoneHandling(adminTask, user, userToChangeIdStr, imcref, req, res, session, vm, phoneTypesV, userFromRequest, password2, userToChange);
            return;
        }
        if (req.getParameter("SAVE_USER") != null && adminTask.equalsIgnoreCase("ADD_USER")) {
            AdminUserProps.addUser(this, session, req, userFromRequest, password2, res, imcref, user);
            return;
        }
        if (req.getParameter("SAVE_USER") != null && adminTask.equalsIgnoreCase("SAVE_CHANGED_USER")) {
            this.changeExistingUser(session, userToChange, isAdmin, user, Integer.parseInt(userToChangeIdStr), imcref, req, res, userFromRequest, password2);
            return;
        }
        if (req.getParameter("CANCEL") != null) {
            String url = "AdminUser";
            if (null != session.getAttribute("next_url")) {
                url = (String)session.getAttribute("next_url");
            }
            this.removeSessionParams(req);
            res.sendRedirect(url);
            return;
        }
        log.debug((Object)"Unidentified argument was sent!");
        this.doGet(req, res);
    }

    private void changeExistingUser(HttpSession session, UserDomainObject userFromDatabase, boolean admin, UserDomainObject user, int userToChangeId, ImcmsServices imcref, HttpServletRequest req, HttpServletResponse res, UserDomainObject userFromRequest, String password2) throws IOException {
        boolean processingDataFromAdminTemplate;
        ImcmsAuthenticatorAndUserAndRoleMapper userMapperAndRole;
        String newLogin;
        log.debug((Object)"SAVE EXISTING USER TO DB");
        if (session == null) {
            return;
        }
        if (userFromDatabase == null) {
            return;
        }
        if (!admin && user.getId() != userToChangeId) {
            String header = "Error in AdminUserProps. ";
            Properties langproperties = imcref.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/AdminUserProps/user_has_no_admin_permission") + "<br>";
            new AdminError(req, res, header, msg);
            return;
        }
        String currentLogin = userFromDatabase.getLoginName();
        Properties langproperties = imcref.getLanguageProperties(user);
        String msg = langproperties.getProperty("error/servlet/AdminUserProps/username_already_exists") + "<br>";
        if (null != req.getParameter(REQUEST_PARAMETER__LOGIN_NAME)) {
            newLogin = userFromRequest.getLoginName();
        } else {
            newLogin = req.getParameter(REQUEST_PARAMETER__EMAIL);
            if (!userFromDatabase.getEmailAddress().equalsIgnoreCase(currentLogin)) {
                newLogin = currentLogin;
            }
            msg = langproperties.getProperty("error/servlet/AdminUserProps/username_or_email_already_exists") + "<br>";
        }
        if (!newLogin.equalsIgnoreCase(currentLogin) && null != (userMapperAndRole = Imcms.getServices().getImcmsAuthenticatorAndUserAndRoleMapper()).getUser(newLogin)) {
            String header = "Error in AdminUserProps.";
            log.debug((Object)(header + "- username already exists"));
            new AdminError(req, res, header, msg);
            return;
        }
        userFromRequest.setLoginName(newLogin);
        String currPwd = userFromDatabase.getPassword();
        if (currPwd.equals("")) {
            String header = "Error in AdminUserProps ";
            msg = langproperties.getProperty("error/servlet/AdminUserProps/password_missing") + "<br>";
            log.debug((Object)(header + "- password is missing"));
            new AdminError(req, res, header, msg);
            log.debug((Object)"innan return i currPwd.equals");
            return;
        }
        String newPwd = userFromRequest.getPassword();
        boolean isChanged = false;
        for (int i = 0; i < newPwd.length(); ++i) {
            if (newPwd.charAt(i) == '*') continue;
            isChanged = true;
        }
        if (!isChanged) {
            userFromRequest.setPassword(currPwd);
            password2 = currPwd;
        }
        if (null != req.getParameter("new_pwd1") && !"".equals(req.getParameter("new_pwd1"))) {
            userFromRequest.setPassword(req.getParameter("new_pwd1"));
        }
        if (req.getParameter("password_current") != null && isChanged && !currPwd.equals(req.getParameter("password_current"))) {
            String header = "Error in AdminUserProps ";
            msg = langproperties.getProperty("error/servlet/AdminUserProps/verify_old_password") + "<br>";
            log.debug((Object)(header + "- could not verify old password "));
            new AdminError(req, res, header, msg);
            log.debug((Object)"innan return i currPwd.equals");
            return;
        }
        if (!AdminUserProps.verifyPassword(userFromRequest.getPassword(), password2, req, res)) {
            return;
        }
        if (!this.validateParameters(req, res, user)) {
            return;
        }
        Vector phonesV = (Vector)session.getAttribute("Ok_phoneNumbers");
        if (null == req.getParameter("userTemplate")) {
            if (null != phonesV && phonesV.size() > 0) {
                this.updateUserPhones(userFromRequest, phonesV);
            }
        } else {
            String[][] phoneNbr = imcref.getImcmsAuthenticatorAndUserAndRoleMapper().getUserPhoneNumbers(userToChangeId);
            String workPhoneId = "";
            String mobilePhoneId = "";
            if (phoneNbr != null) {
                for (int i = 0; i < phoneNbr.length; ++i) {
                    if ("2".equals(phoneNbr[i][3])) {
                        workPhoneId = phoneNbr[i][0];
                    }
                    if (!"3".equals(phoneNbr[i][3])) continue;
                    mobilePhoneId = phoneNbr[i][0];
                }
            }
            String workPhone = req.getParameter("workphone");
            String mobilePhone = req.getParameter("mobilephone");
            if (null != workPhoneId) {
                userFromRequest.setWorkPhone(workPhone);
            }
            if (null != mobilePhoneId) {
                userFromRequest.setMobilePhone(mobilePhone);
            }
        }
        ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserAndRoleMapperAndRole = imcref.getImcmsAuthenticatorAndUserAndRoleMapper();
        boolean bl = processingDataFromAdminTemplate = null != req.getParameter("userTemplate");
        if (!processingDataFromAdminTemplate) {
            int[] roleIdsFromRequest = this.getRoleIdsFromRequest(REQUEST_PARAMETER__ROLES, req);
            if (user.isSuperAdmin()) {
                boolean useradminRoleIsSelected = false;
                for (int i = 0; i < roleIdsFromRequest.length; ++i) {
                    int roleId = roleIdsFromRequest[i];
                    RoleDomainObject role = imcmsAuthenticatorAndUserAndRoleMapperAndRole.getRoleById(roleId);
                    userFromRequest.addRole(role);
                    if (!role.equals(RoleDomainObject.USERADMIN)) continue;
                    useradminRoleIsSelected = true;
                }
                this.updateUserAdminRolesFromRequest(imcref, userToChangeId, useradminRoleIsSelected, req);
            } else if (user.isUserAdmin()) {
                RoleDomainObject[] rolesFromDatabase = userFromDatabase.getRoles();
                userFromRequest.setRoles(rolesFromDatabase);
                String[][] userAdminEditableRoleIdStrings = imcref.sqlProcedureMulti("GetUseradminPermissibleRoles", new String[]{"" + user.getId()});
                for (int i = 0; i < userAdminEditableRoleIdStrings.length; ++i) {
                    int userAdminEditableRoleId = Integer.parseInt(userAdminEditableRoleIdStrings[i][0]);
                    RoleDomainObject role = imcmsAuthenticatorAndUserAndRoleMapperAndRole.getRoleById(userAdminEditableRoleId);
                    boolean userAdminEditableRoleIsSelectedInRequest = ArrayUtils.contains((int[])roleIdsFromRequest, (int)userAdminEditableRoleId);
                    if (userAdminEditableRoleIsSelectedInRequest) {
                        userFromRequest.addRole(role);
                        continue;
                    }
                    userFromRequest.removeRole(role);
                }
            }
        }
        userFromRequest.setId(userFromDatabase.getId());
        imcmsAuthenticatorAndUserAndRoleMapperAndRole.saveUser(userFromRequest, user);
        this.goNext(req, res, session);
    }

    private void updateUserAdminRolesFromRequest(ImcmsServices imcref, int userToChangeId, boolean useradminRoleIsSelected, HttpServletRequest req) {
        imcref.sqlUpdateProcedure("DeleteUseradminPermissibleRoles", new String[]{"" + userToChangeId});
        if (useradminRoleIsSelected) {
            int[] useradminRolesV = this.getRoleIdsFromRequest("useradmin_roles", req);
            this.addUserAdminRoles(imcref, userToChangeId, useradminRolesV);
        }
    }

    private static void addUser(AdminUserProps adminUserProps, HttpSession session, HttpServletRequest req, UserDomainObject userFromRequest, String password2, HttpServletResponse res, ImcmsServices imcref, UserDomainObject user) throws IOException {
        int i;
        log.debug((Object)"Lets add a new user to db");
        if (session == null) {
            return;
        }
        if (StringUtils.isNotEmpty((String)req.getParameter("new_pwd1"))) {
            userFromRequest.setPassword(req.getParameter("new_pwd1"));
            password2 = req.getParameter("new_pwd2");
        }
        if (!AdminUserProps.verifyPassword(userFromRequest.getPassword(), password2, req, res)) {
            return;
        }
        Properties langproperties = imcref.getLanguageProperties(user);
        String msg = langproperties.getProperty("error/servlet/AdminUserProps/username_already_exists") + "<br>";
        if (null != req.getParameter(REQUEST_PARAMETER__LOGIN_NAME)) {
            userFromRequest.getLoginName();
        } else {
            String userName = req.getParameter(REQUEST_PARAMETER__EMAIL);
            userFromRequest.setLoginName(userName);
            msg = langproperties.getProperty("error/servlet/AdminUserProps/username_or_email_already_exists") + "<br>";
        }
        ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserAndRoleMapperAndRole = imcref.getImcmsAuthenticatorAndUserAndRoleMapper();
        if (null != imcmsAuthenticatorAndUserAndRoleMapperAndRole.getUser(userFromRequest.getLoginName())) {
            String header = "Error in AdminUserProps. ";
            log.debug((Object)(header + "- username already exists"));
            new AdminError(req, res, header, msg);
            return;
        }
        if (!adminUserProps.validateParameters(req, res, user)) {
            return;
        }
        Vector phonesV = (Vector)session.getAttribute("Ok_phoneNumbers");
        int[] roleIdsFromRequest = adminUserProps.getRoleIdsFromRequest(REQUEST_PARAMETER__ROLES, req);
        boolean useradminRoleIsSelected = false;
        for (i = 0; roleIdsFromRequest != null && i < roleIdsFromRequest.length; ++i) {
            int roleId = roleIdsFromRequest[i];
            RoleDomainObject role = imcmsAuthenticatorAndUserAndRoleMapperAndRole.getRoleById(roleId);
            userFromRequest.addRole(role);
            if (!role.equals(RoleDomainObject.USERADMIN)) continue;
            useradminRoleIsSelected = true;
        }
        imcmsAuthenticatorAndUserAndRoleMapperAndRole.addUser(userFromRequest, user);
        if (useradminRoleIsSelected) {
            int[] userAdminRoleIdsFromRequest = adminUserProps.getRoleIdsFromRequest("useradmin_roles", req);
            adminUserProps.addUserAdminRoles(imcref, userFromRequest.getId(), userAdminRoleIdsFromRequest);
        }
        if (null == req.getParameter("userTemplate")) {
            if (null != phonesV && phonesV.size() > 0) {
                for (i = 0; i < phonesV.size(); ++i) {
                    String[] aPhone = (String[])phonesV.elementAt(i);
                    imcref.sqlUpdateProcedure("PhoneNbrAdd", new String[]{"" + userFromRequest.getId(), aPhone[1], aPhone[3]});
                }
            }
        } else {
            int phoneNumberType;
            String workPhone = req.getParameter("workphone");
            String mobilePhone = req.getParameter("mobilephone");
            Database database = imcref.getDatabase();
            if (!"".equals(workPhone)) {
                phoneNumberType = 2;
                ImcmsAuthenticatorAndUserAndRoleMapper.addPhoneNumber(userFromRequest.getId(), workPhone, phoneNumberType, database);
            }
            if (!"".equals(mobilePhone)) {
                phoneNumberType = 3;
                ImcmsAuthenticatorAndUserAndRoleMapper.addPhoneNumber(userFromRequest.getId(), workPhone, phoneNumberType, database);
            }
        }
        if (null != req.getParameter("userTemplate")) {
            String nexturl = "VerifyUser?name=" + userFromRequest.getLoginName();
            nexturl = nexturl + "&passwd=" + userFromRequest.getPassword();
            if (null != req.getParameter("next_meta")) {
                nexturl = nexturl + "&next_meta=" + req.getParameter("next_meta");
            } else if (null != req.getParameter("next_url")) {
                nexturl = nexturl + "&next_url=" + req.getParameter("next_url");
            }
            res.sendRedirect(nexturl);
            return;
        }
        adminUserProps.goNext(req, res, session);
    }

    private void phoneHandling(String adminTask, UserDomainObject user, String userToChangeId, ImcmsServices imcref, HttpServletRequest req, HttpServletResponse res, HttpSession session, VariableManager vm, Vector phoneTypesV, UserDomainObject userFromRequest, String password2, UserDomainObject userToChange) throws IOException {
        String selectedPhoneId;
        String[] temp;
        Enumeration enumeration;
        boolean found;
        if (adminTask == null) {
            adminTask = "";
        }
        if (!(user.isSuperAdmin() || user.isUserAdmin() || userToChangeId.equals("" + user.getId()))) {
            String header = "Error in AdminUserProps.";
            Properties langproperties = imcref.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/AdminUser/user_have_no_permission") + "<br>";
            log.debug((Object)(header + "- user have no permission to change user values"));
            new AdminError(req, res, header, msg);
            return;
        }
        Vector phoneNumbers = session.getAttribute("Ok_phoneNumbers") != null ? (Vector)session.getAttribute("Ok_phoneNumbers") : new Vector();
        log.debug((Object)("test" + req.getParameter("edit_phones")));
        if (req.getParameter("ok_phones") != null) {
            log.debug((Object)"ok_phones in doPost");
            found = false;
            int tempId = 1;
            enumeration = phoneNumbers.elements();
            while (enumeration.hasMoreElements()) {
                temp = (String[])enumeration.nextElement();
                if (temp[0].equals(req.getParameter("phone_id"))) {
                    selectedPhoneId = temp[0];
                    phoneNumbers.remove(temp);
                    temp[1] = req.getParameter("local_code");
                    temp[3] = req.getParameter("phonetype");
                    phoneNumbers.addElement(temp);
                    found = true;
                }
                try {
                    if (Integer.parseInt(temp[0]) < tempId) continue;
                    tempId = Integer.parseInt(temp[0]) + 1;
                }
                catch (NumberFormatException ignored) {}
            }
            if (!found) {
                temp = new String[5];
                temp[0] = "" + tempId;
                selectedPhoneId = temp[0];
                temp[1] = req.getParameter("local_code");
                temp[2] = userToChangeId;
                temp[3] = req.getParameter("phonetype");
                phoneNumbers.addElement(temp);
            }
        }
        found = false;
        String phonetypes_id = "";
        if (req.getParameter("edit_phones") != null) {
            log.debug((Object)"edit_phones");
            enumeration = phoneNumbers.elements();
            while (enumeration.hasMoreElements() && !found) {
                temp = (String[])enumeration.nextElement();
                if (!temp[0].equals(req.getParameter("user_phones"))) continue;
                vm.addProperty("PHONE_ID", temp[0]);
                vm.addProperty("NUMBER", temp[1]);
                phonetypes_id = temp[3];
                found = true;
            }
        }
        if (!found) {
            vm.addProperty("PHONE_ID", "");
            vm.addProperty("NUMBER", "");
            phonetypes_id = "1";
        }
        String phonetypes = Html.createOptionList(phonetypes_id, (List)phoneTypesV);
        vm.addProperty("PHONETYPES_MENU", phonetypes);
        selectedPhoneId = req.getParameter("user_phones");
        log.debug((Object)("Number: " + selectedPhoneId));
        if (req.getParameter("delete_phones") != null) {
            String[] temp2;
            log.debug((Object)"lets delete_phones from templist");
            Enumeration enumeration2 = phoneNumbers.elements();
            found = false;
            while (enumeration2.hasMoreElements() && !found) {
                temp2 = (String[])enumeration2.nextElement();
                log.debug((Object)(temp2[0] + " == " + req.getParameter("user_phones")));
                if (!temp2[0].equals(req.getParameter("user_phones"))) continue;
                phoneNumbers.remove(temp2);
                found = true;
            }
            if (phoneNumbers.size() > 0) {
                temp2 = (String[])phoneNumbers.firstElement();
                selectedPhoneId = temp2[0];
            }
        }
        String newPwd = userFromRequest.getPassword();
        boolean isChanged = false;
        for (int i = 0; i < newPwd.length(); ++i) {
            if (newPwd.charAt(i) == "*".charAt(0)) continue;
            isChanged = true;
        }
        if (isChanged) {
            vm.addProperty("NEW_PWD1", userFromRequest.getPassword());
            vm.addProperty("NEW_PWD2", password2);
        } else {
            vm.addProperty("NEW_PWD1", "");
            vm.addProperty("NEW_PWD2", "");
        }
        vm.addProperty("PWD1", this.doPasswordString(userFromRequest.getPassword()));
        vm.addProperty("PWD2", this.doPasswordString(password2));
        if (user.isSuperAdmin() || user.isUserAdmin() && !userToChangeId.equals("" + user.getId())) {
            vm.addProperty("ADMIN_PART", this.createAdminPartHtml(user, userToChange, imcref, req, session));
        } else {
            vm.addProperty("ADMIN_PART", "");
        }
        Vector phonesV = this.getPhonesVector(phoneNumbers, user, imcref);
        if (phonesV == null) {
            this.sendErrorMsg(req, res, "Add/edit user", "An eror occured!");
            return;
        }
        phonesV = this.getPhonesVector(phoneNumbers, user, imcref);
        String phones = Html.createOptionList(selectedPhoneId, (List)phonesV);
        log.debug((Object)("phones stringen: " + phones));
        vm.addProperty("PHONES_MENU", phones);
        vm.addProperty("ADMIN_TASK", adminTask);
        vm.addProperty("CURR_USER_ID", userToChangeId == null ? "" : userToChangeId);
        session.setAttribute("Ok_phoneNumbers", (Object)phoneNumbers);
        this.sendHtml(req, res, vm, HTML_RESPONSE);
    }

    private void addUserAdminRoles(ImcmsServices imcref, int userIdToAddUserAdminRolesTo, int[] useradminRoleIds) {
        ImcmsAuthenticatorAndUserAndRoleMapper imcmsAuthenticatorAndUserMapperAndRole = imcref.getImcmsAuthenticatorAndUserAndRoleMapper();
        for (int i = 0; i < useradminRoleIds.length; ++i) {
            int roleId = useradminRoleIds[i];
            RoleDomainObject role = imcmsAuthenticatorAndUserMapperAndRole.getRoleById(roleId);
            if (RoleDomainObject.SUPERADMIN.equals(role) || RoleDomainObject.USERADMIN.equals(role)) continue;
            imcref.sqlUpdateProcedure("AddUseradminPermissibleRoles", new String[]{"" + userIdToAddUserAdminRolesTo, "" + role.getId()});
        }
    }

    private void removeSessionParams(HttpServletRequest req) {
        HttpSession session = req.getSession(false);
        if (session == null) {
            return;
        }
        try {
            session.removeAttribute("Ok_phoneNumbers");
            session.removeAttribute("userToChange");
            session.removeAttribute("tempRRUserData");
            session.removeAttribute("next_url");
            session.removeAttribute("tempUser");
            session.removeAttribute("tempUserRoles");
            session.removeAttribute("tempUseradminRoles");
        }
        catch (IllegalStateException ise) {
            log.debug((Object)"session has been invalidated so no need to remove parameters");
        }
    }

    private void sendErrorMsg(HttpServletRequest req, HttpServletResponse res, String header, String msg) throws IOException {
        new AdminError(req, res, header, msg);
    }

    private int[] getRoleIdsFromRequest(String name, HttpServletRequest req) {
        String[] roleIdStrings = req.getParameterValues(name) == null ? new String[]{} : req.getParameterValues(name);
        int[] roleIds = new int[roleIdStrings.length];
        for (int i = 0; i < roleIdStrings.length; ++i) {
            String roleIdString = roleIdStrings[i];
            roleIds[i] = Integer.parseInt(roleIdString);
        }
        return roleIds;
    }

    private void goNext(HttpServletRequest req, HttpServletResponse res, HttpSession session) throws IOException {
        String nexturl = "AdminUser";
        if (null != req.getParameter("next_url")) {
            nexturl = req.getParameter("next_url");
        }
        if (null != session.getAttribute("next_url")) {
            nexturl = (String)session.getAttribute("next_url");
        }
        if (null != req.getParameter("next_meta")) {
            nexturl = "GetDoc?meta_id=" + req.getParameter("next_meta");
        }
        this.removeSessionParams(req);
        res.sendRedirect(nexturl);
    }

    private UserDomainObject getUserFromRequest(HttpServletRequest req) {
        UserDomainObject userFromRequest = new UserDomainObject();
        userFromRequest.setLoginName(req.getParameter(REQUEST_PARAMETER__LOGIN_NAME));
        userFromRequest.setPassword(req.getParameter(REQUEST_PARAMETER__PASSWORD1));
        userFromRequest.setFirstName(req.getParameter(REQUEST_PARAMETER__FIRST_NAME));
        userFromRequest.setLastName(req.getParameter(REQUEST_PARAMETER__LAST_NAME));
        userFromRequest.setTitle(req.getParameter(REQUEST_PARAMETER__TITLE));
        userFromRequest.setCompany(req.getParameter(REQUEST_PARAMETER__COMPANY));
        userFromRequest.setAddress(req.getParameter(REQUEST_PARAMETER__ADDRESS));
        userFromRequest.setCity(req.getParameter(REQUEST_PARAMETER__CITY));
        userFromRequest.setZip(req.getParameter(REQUEST_PARAMETER__ZIP));
        userFromRequest.setCountry(req.getParameter(REQUEST_PARAMETER__COUNTRY));
        userFromRequest.setCountyCouncil(req.getParameter(REQUEST_PARAMETER__COUNTY_COUNCIL));
        userFromRequest.setEmailAddress(req.getParameter(REQUEST_PARAMETER__EMAIL));
        userFromRequest.setLanguageIso639_2(req.getParameter(REQUEST_PARAMETER__LANGUAGE));
        userFromRequest.setActive(null != req.getParameter(REQUEST_PARAMETER__ACTIVE));
        return userFromRequest;
    }

    private boolean validateParameters(HttpServletRequest req, HttpServletResponse res, UserDomainObject user) throws IOException {
        if (!this.assertRequiredFieldsFilledIn(req)) {
            String header = "Error in AdminUserProps ";
            Properties langproperties = Imcms.getServices().getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/AdminUserProps/vaidate_form_parameters") + "<br>";
            log.debug((Object)(header + "Error in checkingparameters"));
            new AdminError(req, res, header, msg);
            return false;
        }
        return true;
    }

    private boolean assertRequiredFieldsFilledIn(HttpServletRequest req) {
        String[] requiredFields = new String[]{REQUEST_PARAMETER__LOGIN_NAME, REQUEST_PARAMETER__FIRST_NAME, REQUEST_PARAMETER__LAST_NAME, REQUEST_PARAMETER__PASSWORD1, REQUEST_PARAMETER__PASSWORD2};
        for (int i = 0; i < requiredFields.length; ++i) {
            String requiredField = requiredFields[i];
            String requiredFieldValue = req.getParameter(requiredField);
            if (!StringUtils.isBlank((String)requiredFieldValue)) continue;
            return false;
        }
        String[] rolesParameterValues = req.getParameterValues(REQUEST_PARAMETER__ROLES);
        return null == rolesParameterValues || 0 != rolesParameterValues.length;
    }

    private Vector getPhonesArrayVector(String[][] phoneNr) {
        Vector<String[]> phonesArrV = new Vector<String[]>();
        for (int i = 0; i < phoneNr.length; ++i) {
            phonesArrV.addElement(phoneNr[i]);
        }
        return phonesArrV;
    }

    private Vector getPhonesVector(Vector phonesArrV, UserDomainObject user, ImcmsServices imcref) {
        Vector<String> phonesV = new Vector<String>();
        Enumeration enumeration = phonesArrV.elements();
        while (enumeration.hasMoreElements()) {
            String[] tempPhone = (String[])enumeration.nextElement();
            String[] typename = imcref.sqlQuery("select typename from phonetypes, lang_prefixes\nwhere phonetype_id = ? and phonetypes.lang_id = lang_prefixes.lang_id\nAND lang_prefix = ?", new String[]{tempPhone[3], user.getLanguageIso639_2()});
            String temp = "(" + typename[0] + ") " + tempPhone[1];
            phonesV.addElement(tempPhone[0]);
            phonesV.addElement(temp);
        }
        return phonesV;
    }

    private String createAdminPartHtml(UserDomainObject user, UserDomainObject userToChange, ImcmsServices imcref, HttpServletRequest req, HttpSession session) {
        String active;
        Vector<String> vec_admin_part = new Vector<String>();
        String[] userRoles = null;
        String[] useradminRoles = null;
        Properties userInfo = null;
        String rolesMenuUseradminStr = "";
        if (null != session.getAttribute("tempUser")) {
            userRoles = (String[])session.getAttribute("tempUserRoles");
            useradminRoles = (String[])session.getAttribute("tempUseradminRoles");
            userInfo = (Properties)session.getAttribute("tempUser");
        }
        String[] rolesArr = user.isSuperAdmin() ? imcref.sqlProcedure("GetAllRoles", new String[0]) : imcref.sqlProcedure("GetUseradminPermissibleRoles", new String[]{"" + user.getId()});
        for (int i = 0; i < rolesArr.length; ++i) {
            rolesArr[i] = rolesArr[i].trim();
        }
        Vector<String> allRolesV = new Vector<String>(Arrays.asList(rolesArr));
        Vector rolesV = (Vector)allRolesV.clone();
        ListIterator listiter = rolesV.listIterator();
        while (listiter.hasNext()) {
            listiter.next();
            String rolename = listiter.next().toString();
            if (!"Superadmin".equalsIgnoreCase(rolename) && !"Useradmin".equalsIgnoreCase(rolename)) continue;
            listiter.remove();
            listiter.previous();
            listiter.remove();
        }
        if (userToChange == null) {
            if (userRoles == null) {
                userRoles = req.getParameterValues(REQUEST_PARAMETER__ROLES) == null ? new String[]{} : req.getParameterValues(REQUEST_PARAMETER__ROLES);
            }
            Vector<String> userRolesV = new Vector<String>(Arrays.asList(userRoles));
            String rolesMenuStr = Html.createOptionList(allRolesV, userRolesV);
            if (user.isSuperAdmin()) {
                if (useradminRoles == null) {
                    useradminRoles = req.getParameterValues("useradmin_roles") == null ? new String[]{} : req.getParameterValues("useradmin_roles");
                }
                Vector<String> useradminRolesV = new Vector<String>(Arrays.asList(useradminRoles));
                rolesMenuUseradminStr = Html.createOptionList(rolesV, useradminRolesV);
            }
            active = "1";
            if (userInfo != null) {
                active = userInfo.getProperty(REQUEST_PARAMETER__ACTIVE);
            }
            vec_admin_part.add("#ACTIVE#");
            vec_admin_part.add("1");
            vec_admin_part.add("#ACTIVE_FLAG#");
            if (active.equals("1")) {
                vec_admin_part.add("checked");
            } else {
                vec_admin_part.add("");
            }
            vec_admin_part.add("#USER_CREATE_DATE#");
            vec_admin_part.add("&nbsp;");
            vec_admin_part.add("#ROLES_MENU#");
            vec_admin_part.add(rolesMenuStr);
            vec_admin_part.add("#ROLES_MENU_USERADMIN#");
            if (user.isSuperAdmin()) {
                vec_admin_part.add(rolesMenuUseradminStr);
            } else {
                vec_admin_part.add("");
            }
        } else {
            active = "";
            if (req.getParameter("ok_phones") != null || req.getParameter("delete_phones") != null || req.getParameter("edit_phones") != null) {
                if ("1".equals(req.getParameter(REQUEST_PARAMETER__ACTIVE))) {
                    active = "1";
                }
                userRoles = req.getParameterValues(REQUEST_PARAMETER__ROLES) == null ? new String[]{} : req.getParameterValues(REQUEST_PARAMETER__ROLES);
                useradminRoles = req.getParameterValues("useradmin_roles") == null ? new String[]{} : req.getParameterValues("useradmin_roles");
            } else {
                if (userRoles == null) {
                    userRoles = imcref.sqlProcedure("GetUserRolesIds", new String[]{"" + userToChange.getId()});
                }
                if (user.isSuperAdmin() && useradminRoles == null) {
                    useradminRoles = imcref.sqlProcedure("GetUseradminPermissibleRoles", new String[]{"" + userToChange.getId()});
                }
                active = userToChange.isActive() ? "1" : "0";
            }
            Vector<String> userRolesV = new Vector<String>(Arrays.asList(userRoles));
            String rolesMenuStr = Html.createOptionList(allRolesV, userRolesV);
            if (user.isSuperAdmin()) {
                Vector<String> useradminRolesV = new Vector<String>(Arrays.asList(useradminRoles));
                rolesMenuUseradminStr = Html.createOptionList(rolesV, useradminRolesV);
            }
            vec_admin_part.add("#ACTIVE#");
            vec_admin_part.add("1");
            vec_admin_part.add("#ACTIVE_FLAG#");
            if ("1".equals(active)) {
                vec_admin_part.add("checked");
            } else {
                vec_admin_part.add("");
            }
            vec_admin_part.add("#USER_CREATE_DATE#");
            vec_admin_part.add(userToChange.getCreateDate());
            vec_admin_part.add("#ROLES_MENU#");
            vec_admin_part.add(rolesMenuStr);
            vec_admin_part.add("#ROLES_MENU_USERADMIN#");
            if (user.isSuperAdmin()) {
                vec_admin_part.add(rolesMenuUseradminStr);
            } else {
                vec_admin_part.add("");
            }
        }
        String html_admin_part = user.isSuperAdmin() ? imcref.getAdminTemplate(HTML_RESPONSE_SUPERADMIN_PART, user, vec_admin_part) : imcref.getAdminTemplate(HTML_RESPONSE_ADMIN_PART, user, vec_admin_part);
        return html_admin_part;
    }

    private String getCurrentUserId(HttpServletRequest req, HttpServletResponse res, ImcmsServices imcref, UserDomainObject user) throws IOException {
        String userId = req.getParameter("CURR_USER_ID");
        HttpSession session = req.getSession(false);
        if (userId == null) {
            userId = (String)session.getAttribute("userToChange");
        }
        if (userId == null) {
            String header = "Error in AdminUserProps ";
            Properties langproperties = imcref.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/AdminUser/user_to_change_id_missing") + "<br>";
            log.debug((Object)(header + "- user id for user to change was missing"));
            new AdminError(req, res, header, msg);
            return null;
        }
        log.debug((Object)("userToChangeId =  " + userId));
        return userId;
    }

    private String doPasswordString(String pwd) {
        return StringUtils.repeat((String)"*", (int)(null != pwd ? pwd.length() : 0));
    }

    public static boolean verifyPassword(String password1, String password2, HttpServletRequest req, HttpServletResponse res) throws IOException {
        if (!password1.equals(password2)) {
            String header = req.getServletPath();
            new AdminError2(req, res, header, 52);
            return false;
        }
        if (password1.length() < 4) {
            String header = req.getServletPath();
            new AdminError2(req, res, header, 53);
            return false;
        }
        return true;
    }

    public static String[] extractUpdateUserSprocParametersFromProperties(Properties props) {
        Logger log = Logger.getLogger((Class)AdminUserProps.class);
        log.debug((Object)("extractUpdateUserSprocParametersFromProperties + props: " + props.toString()));
        String[] params = new String[]{props.getProperty("user_id"), props.getProperty(REQUEST_PARAMETER__LOGIN_NAME).trim(), props.getProperty(REQUEST_PARAMETER__PASSWORD1).trim(), props.getProperty(REQUEST_PARAMETER__FIRST_NAME).trim(), props.getProperty(REQUEST_PARAMETER__LAST_NAME).trim(), props.getProperty(REQUEST_PARAMETER__TITLE).trim(), props.getProperty(REQUEST_PARAMETER__COMPANY).trim(), props.getProperty(REQUEST_PARAMETER__ADDRESS).trim(), props.getProperty(REQUEST_PARAMETER__CITY).trim(), props.getProperty(REQUEST_PARAMETER__ZIP).trim(), props.getProperty(REQUEST_PARAMETER__COUNTRY).trim(), props.getProperty(REQUEST_PARAMETER__COUNTY_COUNCIL).trim(), props.getProperty(REQUEST_PARAMETER__EMAIL).trim(), "0", "1001", "0", props.getProperty(REQUEST_PARAMETER__LANGUAGE), props.getProperty(REQUEST_PARAMETER__ACTIVE)};
        return params;
    }

    private void updateUserPhones(UserDomainObject userToChange, Vector phonesV) {
        boolean PHONE_TYPE_OTHER_PHONE = false;
        boolean PHONE_TYPE_HOME_PHONE = true;
        int PHONE_TYPE_WORK_PHONE = 2;
        int PHONE_TYPE_WORK_MOBILE = 3;
        int PHONE_TYPE_FAX_PHONE = 4;
        userToChange.setOtherPhone("");
        userToChange.setHomePhone("");
        userToChange.setWorkPhone("");
        userToChange.setFaxPhone("");
        userToChange.setMobilePhone("");
        block7: for (int i = 0; i < phonesV.size(); ++i) {
            String[] aPhone = (String[])phonesV.elementAt(i);
            switch (Integer.parseInt(aPhone[3])) {
                case 0: {
                    userToChange.setOtherPhone(aPhone[1]);
                    continue block7;
                }
                case 1: {
                    userToChange.setHomePhone(aPhone[1]);
                    continue block7;
                }
                case 2: {
                    userToChange.setWorkPhone(aPhone[1]);
                    continue block7;
                }
                case 3: {
                    userToChange.setMobilePhone(aPhone[1]);
                    continue block7;
                }
                case 4: {
                    userToChange.setFaxPhone(aPhone[1]);
                }
            }
        }
    }
}

