/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.servlet.superadmin.AdminError;
import com.imcode.imcms.servlet.superadmin.Administrator;
import imcode.server.Imcms;
import imcode.server.ImcmsConstants;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import imcode.util.fortune.DateRange;
import imcode.util.fortune.Poll;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class AdminQuestions
extends Administrator
implements ImcmsConstants {
    private static final Logger log = Logger.getLogger((String)AdminQuestions.class.getName());
    private static final String ADMIN_QUESTION_FILE = "admin_questions_file.html";
    private static final String ADMIN_QUESTION = "admin_questions.html";
    private static final String QUESTION_RESULT = "show_questions.html";
    private static final String RESULT_ERR_MSG = "qustion_result_err_msg.frag";
    private static final long ONE_DAY = 86400000L;

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            String header = "Error in AdminQuestions.";
            Properties langproperties = imcref.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/global/no_administrator") + "<br>";
            log.debug((Object)(header + "- user is not an administrator"));
            new AdminError(req, res, header, msg);
            return;
        }
        File fortune_path = imcref.getConfig().getFortunePath();
        File[] files = fortune_path.listFiles();
        StringBuffer options = new StringBuffer();
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i].getName();
            int index = filename.lastIndexOf(".");
            if (!(filename = filename.substring(0, index)).endsWith(".poll")) continue;
            options.append("<option value=\"" + filename.substring(0, filename.lastIndexOf(".poll")) + "\">" + filename.substring(0, filename.lastIndexOf(".poll")) + "</option>");
        }
        Vector<String> values = new Vector<String>();
        values.add("#options#");
        values.add(options.toString());
        String parsed = imcref.getTemplateFromDirectory(ADMIN_QUESTION, user, values, "106");
        ((Writer)out).write(parsed);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        ImcmsServices imcref = Imcms.getServices();
        HttpSession session = req.getSession();
        String whichFile = req.getParameter("AdminFile");
        if (req.getParameter("back") != null) {
            res.sendRedirect("AdminManager");
            return;
        }
        if (null == whichFile || "".equals(whichFile)) {
            res.sendRedirect("AdminQuestions");
            return;
        }
        session.setAttribute("file", (Object)whichFile);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (req.getParameter("result") != null) {
            StringBuffer buff = new StringBuffer();
            try {
                List list = imcref.getPollList(whichFile + ".stat.txt");
                Iterator iter = list.iterator();
                int counter = 0;
                SimpleDateFormat dateForm = new SimpleDateFormat("yyMMdd");
                while (iter.hasNext()) {
                    Poll poll = (Poll)iter.next();
                    DateRange dates = poll.getDateRange();
                    buff.append("<option value=\"" + counter++ + "\">" + dateForm.format(dates.getStartDate()) + " " + dateForm.format(new Date(dates.getEndDate().getTime() - 86400000L)) + " " + poll.getQuestion());
                    Iterator answerIter = poll.getAnswersIterator();
                    while (answerIter.hasNext()) {
                        String answer = (String)answerIter.next();
                        buff.append(" " + answer + " = ");
                        buff.append(poll.getAnswerCount(answer) + " ");
                    }
                    buff.append("</option>");
                }
                Vector<String> values = new Vector<String>();
                values.add("#options#");
                values.add(buff.toString());
                String parsed = imcref.getTemplateFromDirectory(QUESTION_RESULT, user, values, "106");
                out.print(parsed);
                session.setAttribute("results", (Object)list);
                return;
            }
            catch (NoSuchElementException ex) {
                StringBuffer buff2 = new StringBuffer("<option>");
                buff.append(imcref.getTemplateFromDirectory(RESULT_ERR_MSG, user, null, "106"));
                buff2.append("</option>");
                Vector<String> values = new Vector<String>();
                values.add("#options#");
                values.add(buff2.toString());
                String parsed = imcref.getTemplateFromDirectory(QUESTION_RESULT, user, values, "106");
                out.print(parsed);
                return;
            }
        }
        if (req.getParameter("edit") != null) {
            StringBuffer buff = new StringBuffer();
            List lines = imcref.getPollList(whichFile + ".poll.txt");
            Iterator iter = lines.iterator();
            int counter = 0;
            SimpleDateFormat dateForm = new SimpleDateFormat("yyMMdd");
            while (iter.hasNext()) {
                Poll poll = (Poll)iter.next();
                DateRange dates = poll.getDateRange();
                buff.append("<option value=\"" + counter++ + "\">" + dateForm.format(dates.getStartDate()) + " " + dateForm.format(new Date(dates.getEndDate().getTime() - 86400000L)) + " " + poll.getQuestion() + "</option>");
            }
            String date1 = "";
            String date2 = "";
            String text = "";
            Vector<String> values = new Vector<String>();
            values.add("#date1#");
            values.add(date1);
            values.add("#date2#");
            values.add(date2);
            values.add("#text#");
            values.add(text);
            values.add("#file#");
            values.add(whichFile);
            values.add("#options#");
            values.add(buff.toString());
            String parsed = imcref.getTemplateFromDirectory(ADMIN_QUESTION_FILE, user, values, "106");
            out.print(parsed);
            session.setAttribute("lines", (Object)lines);
            return;
        }
    }
}

