/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.superadmin;

import com.imcode.imcms.servlet.superadmin.AdminError;
import com.imcode.imcms.servlet.superadmin.Administrator;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class AdminFortunes
extends Administrator {
    private static final Logger log = Logger.getLogger((String)AdminFortunes.class.getName());

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!user.isSuperAdmin()) {
            String header = "Error in AdminFortunes.";
            Properties langproperties = imcref.getLanguageProperties(user);
            String msg = langproperties.getProperty("error/servlet/global/no_administrator") + "<br>";
            log.debug((Object)(header + msg));
            new AdminError(req, res, header, msg);
            return;
        }
        File fortune_path = imcref.getConfig().getFortunePath();
        File[] files = fortune_path.listFiles();
        String options = "<option value=\"No_Choice\" selected>-- V&auml;lj Fil --</option>";
        for (int i = 0; i < files.length; ++i) {
            String totalFile = files[i].toString();
            int index = totalFile.lastIndexOf("\\");
            String filename = totalFile.substring(index + 1);
            String name = filename.substring(0, index = filename.lastIndexOf("."));
            if (name.endsWith("current") || name.endsWith("statistics")) continue;
            options = options + "<option value=\"" + name + "\" > " + name + "</option>";
        }
        Vector<String> values = new Vector<String>();
        values.add("#options#");
        values.add(options);
        values.add("#SERVLET_URL#");
        values.add("");
        String parsed = imcref.getAdminTemplate("AdminFortunes.htm", user, values);
        out.print(parsed);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Utility.setDefaultHtmlContentType(res);
        PrintWriter out = res.getWriter();
        ImcmsServices imcref = Imcms.getServices();
        HttpSession session = req.getSession();
        Map<Integer, String> lines = Collections.synchronizedMap(new TreeMap());
        Map<Integer, String> results = Collections.synchronizedMap(new TreeMap());
        String whichFile = req.getParameter("AdminFile");
        if (req.getParameter("back") != null) {
            res.sendRedirect("AdminManager");
            return;
        }
        if (whichFile.equals("No_Choice")) {
            res.sendRedirect("AdminFortunes");
            return;
        }
        session.setAttribute("file", (Object)whichFile);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (req.getParameter("result") != null) {
            String options = "";
            File fortune_path = imcref.getConfig().getFortunePath();
            File file = new File(fortune_path, whichFile + "statistics.txt");
            if (file.exists()) {
                String openFile = imcref.getFortune(whichFile + "statistics.txt");
                BufferedReader readFile = new BufferedReader(new StringReader(openFile));
                String line = readFile.readLine();
                int row = 0;
                while (line != null && line.length() > 12) {
                    String fullLine = line.replace('#', ' ');
                    options = options + "<option value=\"" + row + "\" > " + fullLine + "</option>";
                    results.put(new Integer(row), fullLine);
                    line = readFile.readLine();
                    ++row;
                }
                Vector<String> values = new Vector<String>();
                values.add("#options#");
                values.add(options);
                String parsed = imcref.getAdminTemplate("ShowQuestions.htm", user, values);
                out.print(parsed);
                session.setAttribute("results", results);
                return;
            }
            res.sendRedirect("AdminFortunes");
            return;
        }
        if (req.getParameter("edit") != null) {
            String options = "<option value=\"No_Choice\" selected>-- V&auml;lj Rad --</option>";
            String openFile = imcref.getFortune(whichFile + ".txt");
            BufferedReader readFile = new BufferedReader(new StringReader(openFile));
            String line = readFile.readLine();
            int row = 0;
            while (line != null && line.length() > 12) {
                String fullLine = line.replace('#', ' ');
                int stop = fullLine.length();
                if (fullLine.indexOf("<BR>") != -1) {
                    stop = fullLine.indexOf("<BR>");
                }
                if (fullLine.indexOf("<br>") != -1) {
                    stop = fullLine.indexOf("<br>");
                }
                options = options + "<option value=\"" + row + "\" > " + fullLine.substring(0, stop) + "</option>";
                lines.put(new Integer(row), fullLine);
                line = readFile.readLine();
                ++row;
            }
            String date1 = " ";
            String date2 = " ";
            String text = " ";
            Vector<String> values = new Vector<String>();
            values.add("#date1#");
            values.add(date1);
            values.add("#date2#");
            values.add(date2);
            values.add("#text#");
            values.add(text);
            values.add("#file#");
            values.add(whichFile);
            values.add("#options#");
            values.add(options);
            String parsed = imcref.getAdminTemplate("AdminFortuneFile.htm", user, values);
            out.print(parsed);
            session.setAttribute("lines", lines);
            return;
        }
    }
}

