/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.conference;

import com.imcode.imcms.servlet.conference.ConfError;
import com.imcode.imcms.servlet.conference.Conference;
import imcode.external.diverse.MetaInfo;
import imcode.external.diverse.ParsedTextFile;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ConfDisc
extends Conference {
    private static final String NEW_DISC_FLAG_TEMPLATE = "conf_disc_list_new.htm";
    private static final String PREVIOUS_DISC_LIST_TEMPLATE = "conf_disc_list_previous.htm";
    private static final String NEXT_DISC_LIST_TEMPLATE = "conf_disc_list_next.htm";
    private static final String NEW_DISC_TEMPLATE = "conf_disc_new_button.htm";
    private static final String ADMIN_LINK_TEMPLATE = "conf_disc_admin_link.htm";
    private static final String HTML_TEMPLATE = "conf_disc.htm";
    private static final String A_HREF_HTML = "conf_disc_list.htm";

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        Properties params = this.getPropertiesOfConferenceSessionParameters(req);
        ImcmsServices imcref = Imcms.getServices();
        if (req.getParameter("Quit") != null) {
            res.sendRedirect("BackDoc");
            return;
        }
        if (req.getParameter("UPDATE") != null) {
            Properties reqParams = this.getRequestParameters(req);
            String aForumId = reqParams.getProperty("FORUM_ID");
            String discIndex = params.getProperty("DISC_INDEX");
            String changeForum = req.getParameter("CHANGE_FORUM");
            HttpSession session = req.getSession(false);
            if (session != null) {
                String latestDiscId = imcref.sqlProcedureStr("A_GetLastDiscussionId", new String[]{params.getProperty("META_ID"), aForumId});
                if (latestDiscId == null) {
                    this.log("LatestDiscID saknas, det kan saknas diskussioner i forumet:" + aForumId);
                    latestDiscId = "-1";
                }
                if (discIndex == null) {
                    this.log("DiscIndex var null:" + discIndex);
                    discIndex = "0";
                } else if (changeForum != null) {
                    discIndex = "0";
                }
                session.setAttribute("Conference.disc_id", (Object)latestDiscId);
                session.setAttribute("Conference.forum_id", (Object)aForumId);
                session.setAttribute("Conference.disc_index", (Object)discIndex);
            }
            res.sendRedirect("ConfDiscView");
            return;
        }
        if (req.getParameter("ADD") != null) {
            res.sendRedirect("ConfAdd?ADDTYPE=Discussion");
            return;
        }
        if (req.getParameter("NEXT") != null || req.getParameter("NEXT.x") != null) {
            int nbrOfDiscs;
            String nbrOfDiscsStr = imcref.sqlProcedureStr("A_GetNbrOfDiscs", new String[]{params.getProperty("FORUM_ID")});
            String showDiscsStr = imcref.sqlProcedureStr("A_GetNbrOfDiscsToShow", new String[]{params.getProperty("FORUM_ID")});
            int showDiscsCounter = Integer.parseInt(showDiscsStr);
            try {
                nbrOfDiscs = Integer.parseInt(nbrOfDiscsStr);
            }
            catch (NumberFormatException e) {
                nbrOfDiscs = 0;
                this.log("GetNbrOfDiscs returned null");
            }
            int currIndex = this.getDiscIndex(req);
            if (currIndex + showDiscsCounter < nbrOfDiscs) {
                this.increaseDiscIndex(req, showDiscsCounter);
            }
            res.sendRedirect("ConfDiscView");
            return;
        }
        if (req.getParameter("PREVIOUS") != null || req.getParameter("PREVIOUS.x") != null) {
            String showDiscsStr = imcref.sqlProcedureStr("A_GetNbrOfDiscsToShow", new String[]{params.getProperty("FORUM_ID")});
            int showDiscsCounter = Integer.parseInt(showDiscsStr);
            this.decreaseDiscIndex(req, showDiscsCounter);
            res.sendRedirect("ConfDiscView");
            return;
        }
        if (req.getParameter("SEARCH") != null) {
            ConfError msgErr;
            boolean itsOk;
            params = this.getSearchParameters(req, params);
            String searchMsg = "";
            String[][] sqlAnswer = null;
            boolean searchParamsOk = true;
            String aForumId = params.getProperty("FORUM_ID");
            String currForum = imcref.sqlProcedureStr("A_GetForumName", new String[]{aForumId});
            String metaId = params.getProperty("META_ID");
            if ((params = this.buildSearchDateParams(params)) == null) {
                this.log("An illegal searchdateparameter was sent to server");
                ConfError msgErr2 = new ConfError();
                searchMsg = msgErr2.getErrorMessage(req, 42);
                searchParamsOk = false;
            }
            if (searchParamsOk && !(itsOk = this.checkSearchWords(params))) {
                ConfError msgErr3 = new ConfError();
                searchMsg = msgErr3.getErrorMessage(req, 40);
                searchParamsOk = false;
            }
            if (searchParamsOk) {
                String searchW = params.getProperty("SEARCH");
                String category = params.getProperty("CATEGORY");
                String frDate = params.getProperty("FR_DATE");
                String toDate = params.getProperty("TO_DATE");
                if (params.getProperty("CATEGORY").equals("2")) {
                    StringBuffer sqlQ = new StringBuffer("SELECT DISTINCT '0' as 'newflag', disc.discussion_id, SUBSTRING( CONVERT(char(16), rep.create_date,20), 6, 16) AS 'create_date',\nrep.headline, disc.count_replies, usr.first_name, usr.last_name, SUBSTRING( CONVERT(char(20), disc.last_mod_date,20),1, 20) as 'updated_date'\nFROM A_replies rep, A_discussion disc, A_conf_users usr, A_conference conf, A_conf_forum cf, A_forum, A_conf_users_crossref crossref \nWHERE  rep.parent_id = disc.discussion_id \nAND disc.forum_id = A_forum.forum_id \nAND A_forum.forum_id = ? \nAND A_forum.forum_id = cf.forum_id \nAND cf.conf_id = ? \nAND rep.create_date > ? AND rep.create_date <= ? \nAND rep.user_id = usr.user_id \nAND usr.user_id = crossref.user_id \nAND crossref.conf_id = " + metaId + "\n" + "AND (\n");
                    ArrayList<String> sqlParameters = new ArrayList<String>();
                    sqlParameters.add(aForumId);
                    sqlParameters.add(metaId);
                    sqlParameters.add(frDate);
                    sqlParameters.add(toDate + " 23:59:59");
                    StringTokenizer st = new StringTokenizer(searchW);
                    while (st.hasMoreTokens()) {
                        String tmpItem = st.nextToken();
                        sqlQ.append("usr.first_name LIKE ? OR usr.last_name LIKE ? \n");
                        sqlParameters.add(tmpItem + '%');
                        sqlParameters.add(tmpItem + '%');
                        if (!st.hasMoreTokens()) continue;
                        sqlQ.append(" OR ");
                    }
                    sqlQ.append(')');
                    sqlAnswer = imcref.sqlQueryMulti(sqlQ.toString(), sqlParameters.toArray(new String[sqlParameters.size()]));
                } else {
                    sqlAnswer = imcref.sqlProcedureMulti("A_SearchText", new String[]{metaId, aForumId, category, searchW, frDate, toDate + " 23:59:59"});
                }
            }
            File templateLib = super.getExternalTemplateFolder(req);
            File aHreHtmlFile = new File(templateLib, A_HREF_HTML);
            Vector tagsV = this.buildTags();
            String allRecs = "";
            if (sqlAnswer != null) {
                if (sqlAnswer.length > 0 && (allRecs = this.preParse(req, sqlAnswer, tagsV, aHreHtmlFile, "", user)) == null) {
                    msgErr = new ConfError();
                    allRecs = msgErr.getErrorMessage(req, 41);
                }
            } else if (searchParamsOk) {
                msgErr = new ConfError();
                allRecs = msgErr.getErrorMessage(req, 41);
            }
            VariableManager vm = new VariableManager();
            if (allRecs == null || allRecs.equals("")) {
                vm.addProperty("A_HREF_LIST", searchMsg);
            } else {
                vm.addProperty("A_HREF_LIST", allRecs);
            }
            String newDiscButton = "&nbsp;";
            int intMetaId = Integer.parseInt(metaId);
            DocumentMapper documentMapper = imcref.getDocumentMapper();
            DocumentDomainObject document = documentMapper.getDocument(intMetaId);
            if (user.canAccess(document) && imcref.checkDocAdminRights(intMetaId, user)) {
                VariableManager vmButtons = new VariableManager();
                vmButtons.addProperty("#SERVLET_URL#", "");
                vmButtons.addProperty("#IMAGE_URL#", this.getExternalImageFolder(req));
                newDiscButton = this.getTemplate(NEW_DISC_TEMPLATE, user, vmButtons.getTagsAndData());
            }
            vm.addProperty("CURRENT_FORUM_NAME", currForum);
            vm.addProperty("PREVIOUS_BUTTON", "&nbsp;");
            vm.addProperty("NEXT_BUTTON", "&nbsp;");
            vm.addProperty("NEW_DISC_BUTTON", newDiscButton);
            vm.addProperty("ADMIN_LINK_HTML", ADMIN_LINK_TEMPLATE);
            this.sendHtml(req, res, vm, HTML_TEMPLATE);
            return;
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Properties params = this.getPropertiesOfConferenceSessionParameters(req);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        ImcmsServices imcref = Imcms.getServices();
        String aMetaId = params.getProperty("META_ID");
        int metaId = Integer.parseInt(aMetaId);
        String aForumId = params.getProperty("FORUM_ID");
        String aLoginDate = params.getProperty("LAST_LOGIN_DATE");
        String imagePath = super.getExternalImageFolder(req) + "ConfDiscNew.gif";
        File aHrefHtmlFile = new File(super.getExternalTemplateFolder(req), A_HREF_HTML);
        String[][] sqlAnswer = imcref.sqlProcedureMulti("A_GetAllDiscussions", new String[]{aMetaId, aForumId, aLoginDate});
        File templateLib = this.getExternalTemplateFolder(req);
        String previousButton = "&nbsp;";
        String nextButton = "&nbsp;";
        String newDiscButton = "&nbsp;";
        VariableManager vmButtons = new VariableManager();
        vmButtons.addProperty("#SERVLET_URL#", "");
        vmButtons.addProperty("#IMAGE_URL#", this.getExternalImageFolder(req));
        String allRecs = "";
        int discIndexPos = this.getDiscIndex(req);
        if (sqlAnswer.length > 0) {
            Vector tagsV = this.buildTags();
            String showDiscsStr = imcref.sqlProcedureStr("A_GetNbrOfDiscsToShow", new String[]{params.getProperty("FORUM_ID")});
            int showDiscsCounter = Integer.parseInt(showDiscsStr);
            String[][] newArr = sqlAnswer;
            allRecs = this.preParse(req, newArr, tagsV, aHrefHtmlFile, imagePath, user);
            if (discIndexPos != 0) {
                previousButton = this.getTemplate(PREVIOUS_DISC_LIST_TEMPLATE, user, vmButtons.getTagsAndData());
            }
            if (sqlAnswer.length / 8 - 1 > discIndexPos + showDiscsCounter) {
                nextButton = this.getTemplate(NEXT_DISC_LIST_TEMPLATE, user, vmButtons.getTagsAndData());
            }
        }
        String currForum = imcref.sqlProcedureStr("A_GetForumName", new String[]{params.getProperty("FORUM_ID")});
        DocumentMapper documentMapper = imcref.getDocumentMapper();
        DocumentDomainObject document = documentMapper.getDocument(metaId);
        if (user.canAccess(document) && imcref.checkDocAdminRights(metaId, user)) {
            newDiscButton = this.getTemplate(NEW_DISC_TEMPLATE, user, vmButtons.getTagsAndData());
        }
        VariableManager vm = new VariableManager();
        vm.addProperty("PREVIOUS_BUTTON", previousButton);
        vm.addProperty("NEXT_BUTTON", nextButton);
        vm.addProperty("NEW_DISC_BUTTON", newDiscButton);
        vm.addProperty("A_HREF_LIST", allRecs);
        vm.addProperty("CURRENT_FORUM_NAME", currForum);
        vm.addProperty("ADMIN_LINK_HTML", ADMIN_LINK_TEMPLATE);
        this.sendHtml(req, res, vm, HTML_TEMPLATE);
    }

    private String preParse(HttpServletRequest req, String[][] DBArr, Vector tagsV, File htmlCodeFile, String imagePath, UserDomainObject user) throws IOException {
        String htmlStr = "";
        for (int i = 0; i < DBArr.length; ++i) {
            Vector<String> dataV = new Vector<String>();
            for (int j = 0; j < DBArr[i].length; ++j) {
                dataV.add(DBArr[i][j]);
            }
            dataV.add("ConfReply?");
            if (this.discViewStatus(req, dataV)) {
                VariableManager newFlagVM = new VariableManager();
                newFlagVM.addProperty("#IMAGE_URL#", imagePath);
                String newFlag = this.getTemplate(NEW_DISC_FLAG_TEMPLATE, user, newFlagVM.getTagsAndData());
                dataV.setElementAt(newFlag, 0);
            } else {
                dataV.setElementAt("", 0);
            }
            htmlStr = htmlStr + this.parseOneRecord(tagsV, dataV, htmlCodeFile);
        }
        return htmlStr;
    }

    private boolean discViewStatus(HttpServletRequest req, Vector dataV) {
        HttpSession session = req.getSession(true);
        Properties viewedDiscs = (Properties)session.getAttribute("Conference.viewedDiscList");
        String sqlNewDiscFlag = dataV.get(0).toString();
        String sqlDiscId = dataV.get(1).toString();
        String sqlDiscDate = dataV.get(7).toString();
        if (sqlNewDiscFlag.equals("1")) {
            if (viewedDiscs.get(sqlDiscId) == null) {
                return true;
            }
            boolean newerDisc = this.compareDates(viewedDiscs.getProperty(sqlDiscId), sqlDiscDate);
            return newerDisc;
        }
        return false;
    }

    private boolean compareDates(String date1, String date2) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        GregorianCalendar firstDate = new GregorianCalendar();
        GregorianCalendar secDate = new GregorianCalendar();
        try {
            firstDate.setTime(formatter.parse(date1));
            secDate.setTime(formatter.parse(date2));
            firstDate.set(13, this.getDateItem(date1, ":", 3));
            secDate.set(13, this.getDateItem(date2, ":", 3));
        }
        catch (ParseException e) {
            this.log(e.getMessage());
            this.log("Invalid date1: " + date1);
            this.log("Invalid date2: " + date2);
            return true;
        }
        return firstDate.before(secDate);
    }

    private int getDateItem(String str, String delim, int itemNbr) {
        int retVal;
        String tmpVal = "";
        --itemNbr;
        StringTokenizer st = new StringTokenizer(str, delim);
        int counter = 0;
        while (st.hasMoreTokens()) {
            String tmp = st.nextToken();
            if (counter == itemNbr) {
                tmpVal = tmp;
            }
            ++counter;
        }
        try {
            retVal = Integer.parseInt(tmpVal);
        }
        catch (NumberFormatException e) {
            this.log("Error in getDateItem!");
            retVal = 0;
        }
        return retVal;
    }

    private void increaseDiscIndex(HttpServletRequest req, int incFactor) {
        HttpSession session = null;
        session = req.getSession(false);
        if (session != null) {
            String indexStr = (String)session.getAttribute("Conference.disc_index");
            int anInt = Integer.parseInt(indexStr) + incFactor;
            session.setAttribute("Conference.disc_index", (Object)("" + anInt));
        }
    }

    private void decreaseDiscIndex(HttpServletRequest req, int incFactor) {
        HttpSession session = null;
        session = req.getSession(false);
        if (session != null) {
            String indexStr = (String)session.getAttribute("Conference.disc_index");
            int anInt = Integer.parseInt(indexStr) - incFactor;
            if (anInt < 0) {
                anInt = 0;
            }
            session.setAttribute("Conference.disc_index", (Object)("" + anInt));
        }
    }

    private int getDiscIndex(HttpServletRequest req) {
        try {
            HttpSession session = req.getSession(false);
            if (session != null) {
                String indexStr = (String)session.getAttribute("Conference.disc_index");
                int anInt = Integer.parseInt(indexStr);
                return anInt;
            }
        }
        catch (Exception e) {
            this.log("GetDiscIndex failed!");
            return 0;
        }
        return 0;
    }

    String parseOneRecord(Vector tagsV, Vector dataV, File htmlCodeFile) throws IOException {
        ParsedTextFile parser = new ParsedTextFile(htmlCodeFile, tagsV, dataV);
        String oneRecordsHtmlCode = parser.toString();
        return oneRecordsHtmlCode;
    }

    private Properties getPropertiesOfConferenceSessionParameters(HttpServletRequest req) {
        Properties reqParams = MetaInfo.createPropertiesFromMetaInfoParameters(super.getConferenceSessionParameters(req));
        HttpSession session = req.getSession(false);
        if (session != null) {
            String forumId = (String)session.getAttribute("Conference.forum_id") == null ? "" : (String)session.getAttribute("Conference.forum_id");
            String discId = (String)session.getAttribute("Conference.disc_id") == null ? "" : (String)session.getAttribute("Conference.disc_id");
            String lastLogindate = (String)session.getAttribute("Conference.last_login_date") == null ? "" : (String)session.getAttribute("Conference.last_login_date");
            String discIndex = (String)session.getAttribute("Conference.disc_index") == null ? "" : (String)session.getAttribute("Conference.disc_index");
            reqParams.setProperty("DISC_INDEX", discIndex);
            reqParams.setProperty("LAST_LOGIN_DATE", lastLogindate);
            reqParams.setProperty("FORUM_ID", forumId);
            reqParams.setProperty("DISC_ID", discId);
        }
        return reqParams;
    }

    private Properties getRequestParameters(HttpServletRequest req) {
        Properties reqParams = new Properties();
        String confForumId = req.getParameter("forum_id");
        String discIndex = "";
        HttpSession session = req.getSession(false);
        if (session != null) {
            if (confForumId == null) {
                confForumId = (String)session.getAttribute("Conference.forum_id");
            }
            if ((discIndex = (String)session.getAttribute("Conference.disc_index")) == null || discIndex.equalsIgnoreCase("null")) {
                discIndex = "0";
            }
        }
        reqParams.setProperty("FORUM_ID", confForumId);
        reqParams.setProperty("DISC_INDEX", discIndex);
        return reqParams;
    }

    private Properties getSearchParameters(HttpServletRequest req, Properties params) {
        String cat = req.getParameter("CATEGORY") == null ? "" : req.getParameter("CATEGORY");
        String search = req.getParameter("SEARCH") == null ? "" : req.getParameter("SEARCH");
        String fromDate = req.getParameter("FR_DATE") == null ? "" : req.getParameter("FR_DATE");
        String fromVal = req.getParameter("FR_VALUE") == null ? "" : req.getParameter("FR_VALUE");
        String toDate = req.getParameter("TO_DATE") == null ? "" : req.getParameter("TO_DATE");
        String toVal = req.getParameter("TO_VALUE") == null ? "" : req.getParameter("TO_VALUE");
        params.setProperty("CATEGORY", super.verifySqlText(cat.trim()));
        params.setProperty("SEARCH", super.verifySqlText(search.trim()));
        params.setProperty("FR_DATE", super.verifySqlText(fromDate.trim()));
        params.setProperty("TO_DATE", super.verifySqlText(toDate.trim()));
        params.setProperty("FR_VALUE", super.verifySqlText(fromVal.trim()));
        params.setProperty("TO_VALUE", super.verifySqlText(toVal.trim()));
        return params;
    }

    private Vector buildTags() {
        Vector<String> tagsV = new Vector<String>();
        tagsV.add("#NEW_DISC_FLAG#");
        tagsV.add("#DISC_ID#");
        tagsV.add("#A_DATE#");
        tagsV.add("#HEADLINE#");
        tagsV.add("#C_REPLIES#");
        tagsV.add("#FIRST_NAME#");
        tagsV.add("#LAST_NAME#");
        tagsV.add("#LAST_UPDATED#");
        tagsV.add("#REPLY_URL#");
        return tagsV;
    }

    private Properties buildSearchDateParams(Properties p) {
        GregorianCalendar today = new GregorianCalendar();
        today.set(5, today.get(5));
        int tYear = today.get(1);
        int tMonth = 1 + today.get(2);
        int tDay = today.get(5);
        today.set(5, today.get(5) - 2);
        int yYear = today.get(1);
        int yMonth = 1 + today.get(2);
        int yDay = today.get(5);
        if (p.getProperty("TO_DATE").equals("") || p.getProperty("TO_DATE").equalsIgnoreCase(p.getProperty("TO_VALUE"))) {
            p.setProperty("TO_DATE", "" + tYear + "-" + tMonth + "-" + tDay);
        }
        if (p.getProperty("FR_DATE").equals("") || p.getProperty("FR_DATE").equalsIgnoreCase(p.getProperty("FR_VALUE"))) {
            p.setProperty("FR_DATE", "" + yYear + "-" + yMonth + "-" + yDay);
        }
        Date fromDate = null;
        Date toDate = null;
        try {
            fromDate = Date.valueOf(p.getProperty("FR_DATE"));
            toDate = Date.valueOf(p.getProperty("TO_DATE"));
        }
        catch (Exception e) {
            this.log("Invalid FROM date: " + fromDate);
            this.log("Invalid TO date: " + toDate);
            return null;
        }
        return p;
    }

    private boolean checkSearchWords(Properties p) {
        String str = p.getProperty("SEARCH").trim();
        if (str.equalsIgnoreCase("")) {
            return false;
        }
        return str.length() > 2;
    }
}

