/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.conference;

import com.imcode.imcms.servlet.conference.ConfError;
import com.imcode.imcms.servlet.conference.Conference;
import imcode.external.diverse.MetaInfo;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConfCreator
extends Conference {
    private static final String HTML_TEMPLATE = "conf_creator.htm";

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Properties params = MetaInfo.createPropertiesFromMetaInfoParameters(super.getConferenceSessionParameters(req));
        Properties confParams = this.getNewConfParameters(req);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        String action = req.getParameter("action");
        if (action == null) {
            String header = "ConfCreator servlet. ";
            ConfError err = new ConfError(req, res, header, 3, user);
            this.log(header + err.getErrorMsg());
            return;
        }
        ImcmsServices imcref = Imcms.getServices();
        if (action.equalsIgnoreCase("ADD_CONF")) {
            this.log("OK, nu skapar vi konferens");
            String metaId = params.getProperty("META_ID");
            String foundMetaId = imcref.sqlProcedureStr("A_FindMetaId", new String[]{metaId});
            if (!foundMetaId.equals("1")) {
                String header = "ConfCreator servlet. ";
                ConfError err = new ConfError(req, res, header, 90, user);
                this.log(header + err.getErrorMsg());
                return;
            }
            String confName = confParams.getProperty("CONF_NAME");
            imcref.sqlUpdateProcedure("A_AddNewConf", new String[]{metaId, confName});
            String archiveMode = "A";
            String archiveTime = "30";
            imcref.sqlUpdateProcedure("A_AddNewForum", new String[]{metaId, confParams.getProperty("FORUM_NAME"), "A", "30"});
            String user_id = "" + user.getId();
            this.addUserToOneConference(user, metaId + "", imcref);
            String loginPage = "ConfLogin?login_type=login";
            res.sendRedirect(loginPage);
            return;
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        String action = req.getParameter("action");
        if (action == null) {
            String header = "ConfCreator servlet. ";
            ConfError err = new ConfError(req, res, header, 3, user);
            this.log(header + err.getErrorMsg());
            return;
        }
        if (action.equalsIgnoreCase("NEW")) {
            VariableManager vm = new VariableManager();
            vm.addProperty("SERVLET_URL", "");
            this.sendHtml(req, res, vm, HTML_TEMPLATE);
            return;
        }
    }

    private Properties getNewConfParameters(HttpServletRequest req) {
        Properties confP = new Properties();
        String conf_name = req.getParameter("conference_name") == null ? "" : req.getParameter("conference_name");
        String forum_name = req.getParameter("forum_name") == null ? "" : req.getParameter("forum_name");
        confP.setProperty("CONF_NAME", conf_name.trim());
        confP.setProperty("FORUM_NAME", forum_name.trim());
        return confP;
    }
}

