/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.chat;

import com.imcode.imcms.servlet.chat.ChatCreator;
import imcode.external.chat.Chat;
import imcode.external.chat.ChatBase;
import imcode.external.chat.ChatGroup;
import imcode.external.chat.ChatMember;
import imcode.external.chat.ChatNormalMessage;
import imcode.external.chat.ChatSystemMessage;
import imcode.external.diverse.VariableManager;
import imcode.server.HTMLConv;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class ChatControl
extends ChatBase {
    private static final String HTML_TEMPLATE = "thechat.htm";
    private static final String SETTINGS_TEMPLATE = "chat_settings.html";
    private static final String ADMIN_GET_RID_OF_A_SESSION = "chat_admin_end_a_session.htm";
    private static final String ADMIN_BUTTON = "chat_admin_button.htm";
    private static final String SETTINGS_BUTTON = "chat_settings_button.html";
    private static final String CHAT_LOGOUT_TEMPLATE = "chat_logout_message.html";
    private static final String CHAT_AUTOLOGOUT_TEMPLATE = "chat_autologout_message.html";
    private Logger log = Logger.getLogger((String)"ChatControl");

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String result;
        Utility.setDefaultHtmlContentType(res);
        HttpSession session = req.getSession(false);
        Properties params = this.getSessionParameters(req);
        UserDomainObject user = this.getUserObj(req);
        if (user == null) {
            this.log("RETURN usern is null");
            return;
        }
        if (!this.isUserAuthorized(req, res, user)) {
            this.log("RETURN user is not authorized");
            return;
        }
        String metaId = params.getProperty("META_ID");
        int meta_Id = Integer.parseInt(metaId);
        ChatMember myMember = (ChatMember)session.getAttribute("theChatMember");
        if (myMember == null) {
            this.log("myMember was null so return");
            return;
        }
        this.log(myMember.toString());
        Chat myChat = myMember.getParent();
        if (myChat == null) {
            this.log("myChat was null so return");
            return;
        }
        String chatName = params.getProperty("chatName");
        if (chatName == null) {
            chatName = "";
        }
        ChatGroup myGroup = myMember.getGroup();
        if (req.getParameter("settings") != null) {
            this.createSettingsPage(req, res, metaId, user, myMember);
            return;
        }
        String alias = myMember.getName();
        String selected = req.getParameter("msgTypes") == null ? "" : req.getParameter("msgTypes").trim();
        String msgTypes = ChatControl.createOptionCode(selected, myChat.getMsgTypes());
        StringBuffer group_members = new StringBuffer("");
        LinkedList _groupMembers = new LinkedList(myGroup.getGroupMembers());
        Collections.sort(_groupMembers);
        Iterator iter = _groupMembers.iterator();
        String selectMemb = req.getParameter("recipient") == null ? "0" : req.getParameter("recipient").trim();
        int selNr = Integer.parseInt(selectMemb);
        while (iter.hasNext()) {
            ChatMember tempMember = (ChatMember)iter.next();
            String sel = "";
            if (tempMember.getMemberId() == selNr) {
                sel = " selected";
            }
            group_members.append("<option value=\"" + tempMember.getMemberId() + "\"" + sel + ">" + tempMember.getName() + "</option>\n");
        }
        String adminButtonKickOut = "";
        String chatAdminLink = "";
        ImcmsServices imcref = Imcms.getServices();
        if (this.userHasAdminRights(imcref, meta_Id, user)) {
            chatAdminLink = this.createAdminButton(req, ADMIN_BUTTON, metaId, chatName, user);
            adminButtonKickOut = this.createAdminButton(req, ADMIN_GET_RID_OF_A_SESSION, metaId, "", user);
        }
        Vector<String> tags = new Vector<String>();
        tags.add("#chatName#");
        tags.add(chatName);
        tags.add("#alias#");
        tags.add(alias);
        tags.add("#MSG_PREFIX#");
        tags.add(msgTypes);
        tags.add("#MSG_RECIVER#");
        tags.add(group_members.toString());
        tags.add("#CHAT_ADMIN_LINK#");
        tags.add(chatAdminLink);
        tags.add("#CHAT_ADMIN_DISCUSSION#");
        tags.add(adminButtonKickOut);
        tags.add("#SETTINGS#");
        if (myChat.settingsPage()) {
            ImcmsServices imcref1 = Imcms.getServices();
            int metaId1 = myChat.getChatId();
            result = imcref1.getTemplateFromSubDirectoryOfDirectory(SETTINGS_BUTTON, user, null, "103", ChatControl.getTemplateSetDirectoryName(metaId1));
        } else {
            result = "&nbsp;";
        }
        tags.add(result);
        this.sendHtml(req, res, tags, HTML_TEMPLATE, null);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        Utility.setDefaultHtmlContentType(res);
        HttpSession session = req.getSession(false);
        Properties params = this.getSessionParameters(req);
        UserDomainObject user = this.getUserObj(req);
        if (user == null) {
            this.log("user is null return");
            return;
        }
        if (!this.isUserAuthorized(req, res, user)) {
            this.log("user is not autorized return");
            return;
        }
        ImcmsServices imcref = Imcms.getServices();
        String metaId = params.getProperty("META_ID");
        int meta_Id = Integer.parseInt(metaId);
        ChatMember myMember = (ChatMember)session.getAttribute("theChatMember");
        this.log(myMember.toString());
        Chat myChat = myMember.getParent();
        ChatGroup myGroup = myMember.getGroup();
        if (req.getParameter("sendMsg") != null) {
            if (myMember.isTimedOut()) {
                String result = ChatControl.getParsedChatLeavePage(myMember, imcref, CHAT_AUTOLOGOUT_TEMPLATE);
                res.getWriter().write(result);
                super.logOutMember(myMember, null, imcref);
                return;
            }
            this.sendMessage(myMember, req, myChat, myGroup, res, metaId);
            return;
        }
        if (req.getParameter("controlOK") != null || req.getParameter("fontInc") != null || req.getParameter("fontDec") != null) {
            super.prepareChatBoardSettings(myMember, req, true);
            RequestDispatcher requestDispatcher = req.getRequestDispatcher("ChatViewer");
            requestDispatcher.forward((ServletRequest)req, (ServletResponse)res);
            return;
        }
        if (req.getParameter("logOut") == null) {
            if (req.getParameter("kickOut") != null && this.userHasAdminRights(imcref, meta_Id, user)) {
                this.kickOut(req, myChat, myGroup, imcref, user, metaId, res);
                return;
            }
            this.log.error((Object)"Fallthrough in ChatControl");
            throw new RuntimeException("Fallthrough in ChatControl");
        }
        this.logOut(session, res, imcref);
    }

    private void logOut(HttpSession session, HttpServletResponse res, ImcmsServices imcref) throws ServletException, IOException {
        ChatMember myMember = (ChatMember)session.getAttribute("theChatMember");
        ChatSystemMessage systemMessage = new ChatSystemMessage(myMember, 2);
        this.logOutMember(myMember, systemMessage, imcref);
        String result = ChatControl.getParsedChatLeavePage(myMember, imcref, CHAT_LOGOUT_TEMPLATE);
        res.getWriter().write(result);
    }

    static String getParsedChatLeavePage(ChatMember myMember, ImcmsServices imcref, String leaveTemplate) {
        int chatMetaId = myMember.getParent().getChatId();
        String templateSetName = ChatControl.getTemplateSetDirectoryName(chatMetaId);
        ArrayList<String> tags = new ArrayList<String>();
        tags.add("#chat_return_meta_id#");
        tags.add(myMember.getReferrerMetaId() + "");
        tags.add("#chat_meta_id#");
        tags.add(chatMetaId + "");
        String result = imcref.getTemplateFromSubDirectoryOfDirectory(leaveTemplate, myMember.getUser(), tags, "103", templateSetName);
        return result;
    }

    private void kickOut(HttpServletRequest req, Chat myChat, ChatGroup myGroup, ImcmsServices imcref, UserDomainObject user, String metaId, HttpServletResponse res) throws ServletException, IOException {
        String memberNrStr = req.getParameter("recipient") == null ? "" : req.getParameter("recipient").trim();
        int idNr = Integer.parseInt(memberNrStr);
        this.kickOutMemberFromGroup(myChat, idNr, myGroup, imcref, user, metaId);
        RequestDispatcher requestDispatcher = req.getRequestDispatcher("ChatViewer");
        requestDispatcher.forward((ServletRequest)req, (ServletResponse)res);
    }

    private void kickOutMemberFromGroup(Chat myChat, int memberToKickOutId, ChatGroup myGroup, ImcmsServices imcref, UserDomainObject user, String metaId) throws ServletException, IOException {
        ChatMember personToKickOut = myChat.getChatMember(memberToKickOutId);
        if (personToKickOut != null) {
            personToKickOut.setKickedOut(true);
            this.createKickOutMessageAndAddToGroup(personToKickOut, myChat, imcref, user, myGroup, metaId);
            myGroup.removeGroupMember(personToKickOut);
        }
    }

    private void sendMessage(ChatMember myMember, HttpServletRequest req, Chat myChat, ChatGroup myGroup, HttpServletResponse res, String metaId) throws ServletException, IOException {
        String newMessage;
        ImcmsServices imcref = Imcms.getServices();
        String string = newMessage = req.getParameter("msg") == null ? "" : req.getParameter("msg").trim();
        if (newMessage.length() != 0) {
            int msgTypeNr;
            int recieverNr;
            newMessage = HTMLConv.toHTMLSpecial(newMessage);
            String recieverNrStr = req.getParameter("recipient") == null ? "0" : req.getParameter("recipient").trim();
            String msgTypeNrStr = req.getParameter("msgTypes") == null ? "0" : req.getParameter("msgTypes").trim();
            try {
                recieverNr = Integer.parseInt(recieverNrStr);
                msgTypeNr = Integer.parseInt(msgTypeNrStr);
            }
            catch (NumberFormatException nfe) {
                this.log("ChatControl, NumberFormatException while try to send msg");
                recieverNr = 0;
                msgTypeNr = 0;
            }
            String msgTypeStr = "";
            if (msgTypeNr != 0) {
                Vector vect = myChat.getMsgTypes();
                for (int i = 0; i < vect.size(); i += 2) {
                    String st = (String)vect.get(i);
                    if (!st.equals(Integer.toString(msgTypeNr))) continue;
                    msgTypeStr = (String)vect.get(i + 1);
                    break;
                }
            }
            String recieverStr = "Alla";
            if (recieverNr != 0) {
                boolean found = false;
                Iterator iter = myGroup.getAllGroupMembers();
                while (iter.hasNext() && !found) {
                    ChatMember memb = (ChatMember)iter.next();
                    if (recieverNr != memb.getMemberId()) continue;
                    recieverStr = memb.getName();
                    found = true;
                }
            }
            if (msgTypeNr == 101 && recieverNr == 0) {
                this.doGet(req, res);
                return;
            }
            ChatNormalMessage newChatMsg = new ChatNormalMessage(newMessage, myMember, recieverNr, recieverStr, msgTypeNr, msgTypeStr);
            myMember.getGroup().addNewMsg(this, newChatMsg, imcref);
            this.chatlog(metaId, newChatMsg.getLogMsg());
        }
        RequestDispatcher requestDispatcher = req.getRequestDispatcher("ChatViewer");
        requestDispatcher.forward((ServletRequest)req, (ServletResponse)res);
    }

    private synchronized void createSettingsPage(HttpServletRequest req, HttpServletResponse res, String metaId, UserDomainObject user, ChatMember member) throws IOException {
        Vector<String> vect = new Vector<String>();
        int metaId1 = this.getMetaId(req);
        ImcmsServices imcref = Imcms.getServices();
        String[] arr = imcref.sqlProcedure("C_GetChatParameters", new String[]{"" + metaId});
        if (arr.length != 7) {
            return;
        }
        StringBuffer reload = new StringBuffer("");
        String templateSetDirectoryName = ChatControl.getTemplateSetDirectoryName(metaId1);
        if (arr[1].equals("3")) {
            boolean autoRefreshEnabled = member.isAutoRefreshEnabled();
            Vector<String> tempV = new Vector<String>();
            tempV.add("#checked#");
            if (autoRefreshEnabled) {
                tempV.add("checked");
            } else {
                tempV.add("");
            }
            reload.append(imcref.getTemplateFromSubDirectoryOfDirectory("checkbox_reload.html", user, tempV, "103", templateSetDirectoryName));
            reload.append(ChatControl.createOptionCode(member.getRefreshTime() + "", ChatCreator.createUpdateTimeV()));
            reload.append("</select> sekund <br>");
        }
        String entrance = "";
        if (arr[2].equals("3")) {
            boolean showEnterAndLeaveMessages = member.isShowEnterAndLeaveMessagesEnabled();
            Vector<String> tempV = new Vector<String>();
            tempV.add("#checked#");
            if (showEnterAndLeaveMessages) {
                tempV.add("checked");
            } else {
                tempV.add("");
            }
            entrance = imcref.getTemplateFromSubDirectoryOfDirectory("checkbox_entrance.html", user, tempV, "103", templateSetDirectoryName);
        }
        String privat = "";
        if (arr[3].equals("3")) {
            boolean showPrivateMessagesEnabled = member.isShowPrivateMessagesEnabled();
            Vector<String> tempV = new Vector<String>();
            tempV.add("#checked#");
            if (showPrivateMessagesEnabled) {
                tempV.add("checked");
            } else {
                tempV.add("");
            }
            privat = imcref.getTemplateFromSubDirectoryOfDirectory("checkbox_private.html", user, tempV, "103", templateSetDirectoryName);
        }
        String datetime = "";
        if (arr[5].equals("3")) {
            boolean showDateTimesEnabled = member.isShowDateTimesEnabled();
            Vector<String> tempV = new Vector<String>();
            tempV.add("#checked#");
            if (showDateTimesEnabled) {
                tempV.add("checked");
            } else {
                tempV.add("");
            }
            datetime = imcref.getTemplateFromSubDirectoryOfDirectory("checkbox_datetime.html", user, tempV, "103", templateSetDirectoryName);
        }
        String font = "";
        if (arr[6].equals("3")) {
            int fontSize = member.getFontSize();
            Vector<String> tempV = new Vector<String>();
            for (int i = 1; i < 8; ++i) {
                tempV.add("#" + i + "#");
                if (i == fontSize) {
                    tempV.add("checked");
                    continue;
                }
                tempV.add("");
            }
            font = imcref.getTemplateFromSubDirectoryOfDirectory("buttons_font.html", user, tempV, "103", templateSetDirectoryName);
        }
        vect.add("#reload#");
        vect.add(reload.toString());
        vect.add("#entrance#");
        vect.add(entrance);
        vect.add("#private#");
        vect.add(privat);
        vect.add("#datetime#");
        vect.add(datetime);
        vect.add("#font#");
        vect.add(font);
        this.sendHtml(req, res, vect, SETTINGS_TEMPLATE, null);
    }

    private synchronized String createAdminButton(HttpServletRequest req, String template, String chatId, String name, UserDomainObject user) {
        VariableManager vm = new VariableManager();
        vm.addProperty("chatId", chatId);
        vm.addProperty("chatName", name);
        return this.getTemplate(template, user, vm.getTagsAndData());
    }

    public void log(String str) {
        this.log.debug((Object)("ChatControl: " + str));
    }
}

