/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.billboard;

import com.imcode.imcms.servlet.billboard.BillBoard;
import com.imcode.imcms.servlet.billboard.BillBoardError;
import imcode.external.diverse.MetaInfo;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import java.io.IOException;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class BillBoardManager
extends BillBoard {
    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        MetaInfo.Parameters params = MetaInfo.getParameters(req);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (user == null) {
            return;
        }
        int testMetaId = params.getMetaId();
        if (!this.isUserAuthorized(res, testMetaId, user, req)) {
            return;
        }
        String action = req.getParameter("action");
        if (action == null) {
            action = "";
            String header = "BillBoardManager servlet. ";
            BillBoardError err = new BillBoardError(req, res, header, 3, user.getLanguageIso639_2(), user);
            this.log(header + err.getErrorMsg());
            return;
        }
        if (action.equalsIgnoreCase("NEW")) {
            HttpSession session = req.getSession(false);
            if (session != null) {
                this.setBillBoardSessionAttributes(session, params);
            }
            res.sendRedirect("BillBoardCreator?action=NEW");
            return;
        }
        if (action.equalsIgnoreCase("VIEW")) {
            String userId = "" + user.getId();
            String loginType = user.getLoginType();
            if (!loginType.equalsIgnoreCase("VERIFY")) {
                HttpSession session = req.getSession(false);
                if (session != null) {
                    this.setBillBoardSessionAttributes(session, params);
                    session.setAttribute("BillBoard.viewedDiscList", (Object)new Properties());
                }
                String loginPage = "BillBoardLogin?login_type=login";
                res.sendRedirect(loginPage);
                return;
            }
            if (!super.prepareUserForBillBoard(req, res, params, userId)) {
                this.log("Error in prepareUserFor Conf");
            }
            return;
        }
        if (action.equalsIgnoreCase("CHANGE")) {
            res.sendRedirect("ChangeExternalDoc2?" + MetaInfo.passMeta(params) + "&metadata=meta");
            return;
        }
    }

    public void log(String msg) {
        super.log("BillBoardManager: " + msg);
    }
}

