/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet.billboard;

import com.imcode.imcms.servlet.billboard.BillBoard;
import com.imcode.imcms.servlet.billboard.BillBoardError;
import imcode.external.diverse.FileManager;
import imcode.external.diverse.MetaInfo;
import imcode.external.diverse.ParsedTextFile;
import imcode.external.diverse.RmiConf;
import imcode.external.diverse.VariableManager;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import imcode.util.Html;
import imcode.util.Utility;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class BillBoardAdmin
extends BillBoard {
    private static final String FORUM_UNADMIN_LINK_TEMPLATE = "billboard_section_unadmin_link.htm";
    private static final String FORUM_TEMPLATE1_UNADMIN_LINK_TEMPLATE = "billboard_section_template1_unadmin_link.htm";
    private static final String FORUM_TEMPLATE2_UNADMIN_LINK_TEMPLATE = "billboard_section_template2_unadmin_link.htm";
    private static final String DISC_UNADMIN_LINK_TEMPLATE = "billboard_disc_unadmin_link.htm";
    private static final String REPLY_UNADMIN_LINK_TEMPLATE = "billboard_reply_unadmin_link.htm";

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (user == null) {
            return;
        }
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        Properties params = this.getStandardParameters(req);
        ImcmsServices imcref = Imcms.getServices();
        if (!this.userHasAdminRights(imcref, Integer.parseInt(params.getProperty("META_ID")), user)) {
            String header = "BillBoardAdmin servlet. ";
            new BillBoardError(req, res, header, 6, user.getLanguageIso639_2(), user);
            return;
        }
        if (req.getParameter("ADMIN_OLD_BILLS") != null) {
            res.sendRedirect("BillBoardAdmin?ADMIN_TYPE=OLD_DISCUSSION");
            return;
        }
        if (req.getParameter("ADMIN_NEW_BILLS") != null) {
            res.sendRedirect("BillBoardAdmin?ADMIN_TYPE=DISCUSSION");
            return;
        }
        if (req.getParameter("REGISTER_TEMPLATE_LIB") != null) {
            String newLibName = req.getParameter("TEMPLATE_LIB_NAME");
            if (newLibName == null) {
                String header = "BillBoardAdmin servlet. ";
                new BillBoardError(req, res, header, 80, user.getLanguageIso639_2(), user);
                return;
            }
            String libNameExists = imcref.sqlProcedureStr("B_FindTemplateLib", new String[]{newLibName = super.verifySqlText(newLibName)});
            if (!libNameExists.equalsIgnoreCase("-1")) {
                String header = "BillBoardAdmin servlet. ";
                new BillBoardError(req, res, header, 84, user.getLanguageIso639_2(), user);
                return;
            }
            imcref.sqlUpdateProcedure("B_AddTemplateLib", new String[]{newLibName});
            int metaId = this.getMetaId(req);
            FileManager fileObj = new FileManager();
            File templateSrc = new File(imcref.getExternalTemplateFolder(metaId, user), "original");
            File imageSrc = new File(RmiConf.getImagePathForExternalDocument(imcref, metaId, user), "original");
            File templateTarget = new File(imcref.getExternalTemplateFolder(metaId, user), newLibName);
            File imageTarget = new File(RmiConf.getImagePathForExternalDocument(imcref, metaId, user), newLibName);
            fileObj.copyDirectory(templateSrc, templateTarget);
            fileObj.copyDirectory(imageSrc, imageTarget);
            res.sendRedirect("BillBoardAdmin?ADMIN_TYPE=META");
            return;
        }
        if (req.getParameter("UPLOAD_CONF") != null) {
            String libName = req.getParameter("TEMPLATE_NAME") == null ? "" : req.getParameter("TEMPLATE_NAME");
            String uploadType = req.getParameter("UPLOAD_TYPE") == null ? "" : req.getParameter("UPLOAD_TYPE");
            params.setProperty("TEMPLATE_NAME", libName);
            params.setProperty("UPLOAD_TYPE", uploadType);
            String url = "BillBoardAdmin?ADMIN_TYPE=META";
            url = url + "&setname=" + libName + "&UPLOAD_TYPE=" + uploadType;
            res.sendRedirect(url);
            return;
        }
        if (req.getParameter("SET_TEMPLATE_LIB") != null) {
            String newLibName = req.getParameter("TEMPLATE_ID");
            if (newLibName == null) {
                String header = "BillBoardAdmin servlet. ";
                new BillBoardError(req, res, header, 80, user.getLanguageIso639_2(), user);
                return;
            }
            String templateId = imcref.sqlProcedureStr("B_GetTemplateIdFromName", new String[]{newLibName});
            if (templateId.equalsIgnoreCase("-1")) {
                String header = "BillBoardAdmin servlet. ";
                new BillBoardError(req, res, header, 81, user.getLanguageIso639_2(), user);
                return;
            }
            imcref.sqlUpdateProcedure("B_SetTemplateLib", new String[]{params.getProperty("META_ID"), newLibName});
            res.sendRedirect("BillBoardAdmin?ADMIN_TYPE=META");
            return;
        }
        if (req.getParameter("DELETE_REPLY") != null) {
            String repliesId = req.getParameter("bill_id");
            if (repliesId != null) {
                imcref.sqlUpdateProcedure("B_DeleteBill", new String[]{repliesId});
            }
            HttpSession session = req.getSession(false);
            String aSectionId = (String)session.getAttribute("BillBoard.section_id");
            String aDiscId = imcref.sqlProcedureStr("B_GetLastDiscussionId", new String[]{params.getProperty("META_ID"), aSectionId});
            session.setAttribute("BillBoard.disc_id", (Object)aDiscId);
            String param = "";
            if (!aDiscId.equals("-1")) {
                param = "?DISC_ID=" + aDiscId;
            }
            res.sendRedirect("BillBoardDiscView" + param);
            return;
        }
        if (req.getParameter("RESAVE_REPLY") != null) {
            String updateId = req.getParameter("bill_id");
            if (updateId != null) {
                String newEmail;
                String newHeader;
                String newText = req.getParameter("TEXT_BOX");
                if (newText.equals("") || newText == null) {
                    BillBoardError err = new BillBoardError();
                    newText = err.getErrorMessage(req, 70);
                }
                if ((newHeader = req.getParameter("REPLY_HEADER")).equals("") || newHeader == null) {
                    BillBoardError err = new BillBoardError();
                    newHeader = err.getErrorMessage(req, 71);
                }
                if ((newEmail = req.getParameter("EPOST")).equals("") || newEmail == null) {
                    BillBoardError err = new BillBoardError();
                    newEmail = err.getErrorMessage(req, 74);
                }
                newHeader = super.verifySqlText(newHeader);
                newText = super.verifySqlText(newText);
                imcref.sqlUpdateProcedure("B_UpdateBill", new String[]{updateId, newHeader, newText, newEmail});
            }
            res.sendRedirect("BillBoardDiscView");
            return;
        }
        if (req.getParameter("DELETE_DISCUSSION") != null) {
            String[] discIds = this.getDelDiscParameters(req);
            if (discIds != null) {
                for (int i = 0; i < discIds.length; ++i) {
                    imcref.sqlUpdateProcedure("B_DeleteBill", new String[]{discIds[i]});
                }
            }
            res.sendRedirect("BillBoardAdmin?ADMIN_TYPE=DISCUSSION");
            return;
        }
        if (req.getParameter("MOVE_BILLS") != null) {
            String redirectParam = req.getParameter("BILLTYPES");
            redirectParam = redirectParam.equalsIgnoreCase("OLD_ONES") ? "OLD_DISCUSSION" : "DISCUSSION";
            String aSectionId = params.getProperty("SECTION_ID");
            String[] discIds = this.getDelDiscParameters(req);
            if (discIds == null) {
                discIds = new String[]{};
            }
            String moveToId = req.getParameter("MOVE_TO_SECTION") == null ? aSectionId : req.getParameter("MOVE_TO_SECTION");
            for (int i = 0; i < discIds.length; ++i) {
                imcref.sqlUpdateProcedure("B_ChangeSection", new String[]{discIds[i] + ", " + moveToId});
            }
            HttpSession session = req.getSession(false);
            String aDiscId = imcref.sqlProcedureStr("B_GetLastDiscussionId", new String[]{params.getProperty("META_ID"), aSectionId});
            session.setAttribute("BillBoard.disc_id", (Object)aDiscId);
            res.sendRedirect("BillBoardAdmin?ADMIN_TYPE=" + redirectParam);
            return;
        }
        if (req.getParameter("MOVE_A_BILL") != null) {
            String aSectionId = params.getProperty("SECTION_ID");
            String repliesId = req.getParameter("bill_id");
            String moveToId = req.getParameter("MOVE_TO_SECTION") == null ? aSectionId : req.getParameter("MOVE_TO_SECTION");
            imcref.sqlUpdateProcedure("B_ChangeSection", new String[]{repliesId, moveToId});
            HttpSession session = req.getSession(false);
            String sqlStr = "B_GetLastDiscussionId";
            String aDiscId = imcref.sqlProcedureStr(sqlStr, new String[]{params.getProperty("META_ID"), aSectionId});
            session.setAttribute("BillBoard.disc_id", (Object)aDiscId);
            res.sendRedirect("BillBoardDiscView");
            return;
        }
        if (req.getParameter("DELETE_SECTION") != null) {
            String aSectionId = (params = this.getDelSectionParameters(req, params)).getProperty("SECTION_ID");
            String[] discs = imcref.sqlProcedure("B_GetAllBillsInSection", new String[]{aSectionId});
            if (discs != null) {
                for (int i = 0; i < discs.length; ++i) {
                    imcref.sqlUpdateProcedure("B_DeleteBill", new String[]{discs[i]});
                }
            }
            imcref.sqlUpdateProcedure("B_DeleteSection", new String[]{params.getProperty("SECTION_ID")});
            String first = imcref.sqlProcedureStr("B_GetFirstSection", new String[]{params.getProperty("META_ID")});
            HttpSession session = req.getSession(false);
            session.setAttribute("BillBoard.section_id", (Object)first);
            this.doGet(req, res);
            return;
        }
        if (req.getParameter("ADD_SECTION") != null) {
            params = this.getAddSectionParameters(req, params);
            String foundIt = imcref.sqlProcedureStr("B_FindSectionName", new String[]{(params = super.verifyForSql(params)).getProperty("META_ID"), params.getProperty("NEW_SECTION_NAME")});
            if (!foundIt.equalsIgnoreCase("-1")) {
                String header = "BillBoardAdmin servlet. ";
                new BillBoardError(req, res, header, 85, user.getLanguageIso639_2(), user);
                return;
            }
            String archiveMode = "A";
            String discussionsToShow = "30";
            String daysToShow = "14";
            imcref.sqlUpdateProcedure("B_AddNewSection", new String[]{params.getProperty("META_ID"), params.getProperty("NEW_SECTION_NAME"), "A", "30", "14"});
            this.doGet(req, res);
            return;
        }
        if (req.getParameter("CHANGE_SECTION_NAME") != null) {
            params = this.getRenameSectionParameters(req, params);
            String foundIt = imcref.sqlProcedureStr("B_FindSectionName", new String[]{(params = super.verifyForSql(params)).getProperty("META_ID"), params.getProperty("NEW_SECTION_NAME")});
            if (!foundIt.equalsIgnoreCase("-1")) {
                String header = "BillBoardAdmin servlet. ";
                new BillBoardError(req, res, header, 85, user.getLanguageIso639_2(), user);
                return;
            }
            imcref.sqlUpdateProcedure("B_RenameSection", new String[]{params.getProperty("SECTION_ID"), params.getProperty("NEW_SECTION_NAME")});
            this.doGet(req, res);
            return;
        }
        if (req.getParameter("CHANGE_SUBJECT_NAME") != null) {
            String meta_id = req.getParameter("meta_id");
            String new_subject = req.getParameter("NEW_SUBJECT_NAME");
            if (meta_id == null || new_subject == null) {
                return;
            }
            String sqlSubjAddQ = "B_SetNewSubjectString";
            imcref.sqlUpdateProcedure(sqlSubjAddQ, new String[]{meta_id, new_subject});
            res.sendRedirect("BillBoardAdmin?ADMIN_TYPE=SECTION");
            return;
        }
        if (req.getParameter("SHOW_DISCUSSION_NBR") != null) {
            params = this.getShowDiscussionNbrParameters(req, params);
            imcref.sqlUpdateProcedure("B_SetNbrOfDiscsToShow", new String[]{params.getProperty("SECTION_ID"), params.getProperty("NBR_OF_DISCS_TO_SHOW")});
            res.sendRedirect("BillBoardAdmin?ADMIN_TYPE=SECTION");
            return;
        }
        if (req.getParameter("SHOW_DISCUSSION_DAYS") != null) {
            params = this.getShowDiscussionDaysParameters(req, params);
            imcref.sqlUpdateProcedure("B_SetNbrOfDaysToShow", new String[]{params.getProperty("SECTION_ID"), params.getProperty("NBR_OF_DAYS_TO_SHOW")});
            res.sendRedirect("BillBoardAdmin?ADMIN_TYPE=SECTION");
            return;
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String allNewRecs;
        Vector tagsV;
        String sectionListStr;
        Vector sectionV;
        String[] sqlSections;
        String[][] sqlAnswerNew;
        File aHrefHtmlFile;
        String aSectionId;
        String aMetaId;
        String adminDiscList;
        String[] sqlAnswer;
        Properties params = this.getStandardParameters(req);
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (user == null) {
            return;
        }
        if (!this.isUserAuthorized(req, res, user)) {
            return;
        }
        ImcmsServices imcref = Imcms.getServices();
        if (!super.userHasAdminRights(imcref, Integer.parseInt(params.getProperty("META_ID")), user)) {
            String header = "BillBoardAdmin servlet. ";
            new BillBoardError(req, res, header, 6, user.getLanguageIso639_2(), user);
            this.log("nu small det i BillBoardAdmin doGet super.getAdminRights");
            return;
        }
        String adminWhat = req.getParameter("ADMIN_TYPE") == null ? "" : req.getParameter("ADMIN_TYPE");
        VariableManager vm = new VariableManager();
        String htmlFile = "";
        if (adminWhat.equalsIgnoreCase("META")) {
            String setName = req.getParameter("setname");
            if (setName != null) {
                String uploadType = req.getParameter("UPLOAD_TYPE");
                if (uploadType == null) {
                    String header = "BillBoardAdmin servlet. ";
                    new BillBoardError(req, res, header, 83, user.getLanguageIso639_2(), user);
                    return;
                }
                String metaId = params.getProperty("META_ID");
                vm.addProperty("UPLOAD_TYPE", uploadType);
                vm.addProperty("FOLDER_NAME", setName);
                vm.addProperty("META_ID", metaId);
                vm.addProperty("UNADMIN_LINK_HTML", FORUM_TEMPLATE2_UNADMIN_LINK_TEMPLATE);
                htmlFile = "billboard_admin_template2.htm";
            } else {
                String currTemplateSet = imcref.sqlProcedureStr("B_GetTemplateLib", new String[]{params.getProperty("META_ID")});
                sqlAnswer = imcref.sqlProcedure("B_GetAllTemplateLibs", new String[0]);
                Vector templateV = super.convert2Vector(sqlAnswer);
                String templateList = Html.createOptionList("", (List)templateV);
                vm.addProperty("TEMPLATE_LIST", templateList);
                vm.addProperty("A_META_ID", params.getProperty("META_ID"));
                vm.addProperty("CURRENT_TEMPLATE_SET", currTemplateSet);
                vm.addProperty("UNADMIN_LINK_HTML", FORUM_TEMPLATE1_UNADMIN_LINK_TEMPLATE);
                htmlFile = "billboard_admin_template1.htm";
            }
        }
        if (adminWhat.equalsIgnoreCase("SECTION")) {
            String[] sqlAnswer2 = imcref.sqlProcedure("B_GetAllSection", new String[]{params.getProperty("META_ID")});
            Vector sectionV2 = super.convert2Vector(sqlAnswer2);
            String forumList = Html.createOptionList("", (List)sectionV2);
            String[] sqlAllDays = imcref.sqlProcedure("B_GetAllNbrOfDaysToShow", new String[]{params.getProperty("META_ID")});
            String subject_name = imcref.sqlProcedureStr("B_GetStartSubjectString", new String[]{params.getProperty("META_ID")});
            if (subject_name == null) {
                subject_name = "";
            }
            Vector sqlAllDaysV = new Vector();
            if (sqlAllDays != null) {
                sqlAllDaysV = super.convert2Vector(sqlAllDays);
            }
            String daysToShowList = Html.createOptionList("", sqlAllDaysV);
            String[] sqlAllDiscs = imcref.sqlProcedure("B_GetAllNbrOfDiscsToShow", new String[]{params.getProperty("META_ID")});
            Vector sqlAllDiscsV = new Vector();
            if (sqlAllDiscs != null) {
                sqlAllDiscsV = super.convert2Vector(sqlAllDiscs);
            }
            String discToShowList = Html.createOptionList("", sqlAllDiscsV);
            vm.addProperty("SUBJECT_NAME", subject_name);
            vm.addProperty("META_ID", params.getProperty("META_ID"));
            vm.addProperty("SECTION_LIST", forumList);
            vm.addProperty("NBR_OF_DISCS_TO_SHOW_LIST", discToShowList);
            vm.addProperty("NBR_OF_DAYS_TO_SHOW_LIST", daysToShowList);
            vm.addProperty("UNADMIN_LINK_HTML", FORUM_UNADMIN_LINK_TEMPLATE);
            htmlFile = "billboard_admin_section.htm";
        }
        if (adminWhat.equalsIgnoreCase("DISCUSSION")) {
            adminDiscList = "billboard_admin_disc_list.htm";
            aMetaId = params.getProperty("META_ID");
            aSectionId = params.getProperty("SECTION_ID");
            aHrefHtmlFile = new File(super.getExternalTemplateFolder(req), adminDiscList);
            sqlAnswerNew = imcref.sqlProcedureMulti("B_GetAllBillsToShow", new String[]{aMetaId, aSectionId});
            sqlSections = imcref.sqlProcedure("B_GetAllSection", new String[]{aMetaId});
            sectionV = super.convert2Vector(sqlSections);
            sectionListStr = Html.createOptionList(aSectionId, (List)sectionV);
            tagsV = this.buildAdminTags();
            allNewRecs = "";
            if (sqlAnswerNew != null && sqlAnswerNew.length > 0) {
                allNewRecs = this.discPreParse(sqlAnswerNew, tagsV, aHrefHtmlFile);
            }
            vm.addProperty("SECTION_LIST", sectionListStr);
            vm.addProperty("NEW_A_HREF_LIST", allNewRecs);
            vm.addProperty("UNADMIN_LINK_HTML", DISC_UNADMIN_LINK_TEMPLATE);
            htmlFile = "billboard_admin_disc.htm";
        }
        if (adminWhat.equalsIgnoreCase("OLD_DISCUSSION")) {
            adminDiscList = "billboard_admin_disc_list.htm";
            aMetaId = params.getProperty("META_ID");
            aSectionId = params.getProperty("SECTION_ID");
            aHrefHtmlFile = new File(super.getExternalTemplateFolder(req), adminDiscList);
            sqlAnswerNew = imcref.sqlProcedureMulti("B_GetAllOldBills", new String[]{aMetaId, aSectionId});
            sqlSections = imcref.sqlProcedure("B_GetAllSection", new String[]{aMetaId});
            sectionV = super.convert2Vector(sqlSections);
            sectionListStr = Html.createOptionList(aSectionId, (List)sectionV);
            tagsV = this.buildAdminTags();
            allNewRecs = "";
            if (sqlAnswerNew != null && sqlAnswerNew.length > 0) {
                allNewRecs = this.discPreParse(sqlAnswerNew, tagsV, aHrefHtmlFile);
            }
            vm.addProperty("SECTION_LIST", sectionListStr);
            vm.addProperty("NEW_A_HREF_LIST", allNewRecs);
            vm.addProperty("UNADMIN_LINK_HTML", DISC_UNADMIN_LINK_TEMPLATE);
            htmlFile = "billboard_admin_disc2.htm";
        }
        if (adminWhat.equalsIgnoreCase("REPLY")) {
            String adminReplyList = "billboard_admin_reply_list.htm";
            this.log("OK, Administrera replies");
            String discId = params.getProperty("DISC_ID");
            sqlAnswer = imcref.sqlProcedureMulti("B_GetAdminBill", new String[]{discId});
            Vector<String> tagsV2 = new Vector<String>();
            tagsV2.add("#REPLY_ID#");
            tagsV2.add("#REPLY_HEADER#");
            tagsV2.add("#REPLY_TEXT#");
            tagsV2.add("#REPLY_COUNT#");
            tagsV2.add("#REPLY_EMAIL#");
            tagsV2.add("#REPLY_DATE#");
            tagsV2.add("#REPLY_IPADR#");
            File templateLib = super.getExternalTemplateFolder(req);
            File aSnippetFile = new File(templateLib, adminReplyList);
            String[] sqlSections2 = imcref.sqlProcedure("B_GetAllSection", new String[]{params.getProperty("META_ID")});
            Vector sectionV3 = super.convert2Vector(sqlSections2);
            String sectionListStr2 = Html.createOptionList(params.getProperty("SECTION_ID"), (List)sectionV3);
            String allRecs = " ";
            if (sqlAnswer != null) {
                allRecs = this.replyPreParse((String[][])sqlAnswer, tagsV2, aSnippetFile);
            }
            vm.addProperty("SECTION_LIST", sectionListStr2);
            vm.addProperty("REPLIES_RECORDS", allRecs);
            vm.addProperty("UNADMIN_LINK_HTML", REPLY_UNADMIN_LINK_TEMPLATE);
            htmlFile = "billboard_admin_reply.htm";
        }
        this.sendHtml(req, res, vm, htmlFile);
    }

    private String replyPreParse(String[][] DBArr, Vector tagsV, File htmlCodeFile) throws IOException {
        return this.discPreParse(DBArr, tagsV, htmlCodeFile);
    }

    private String discPreParse(String[][] DBArr, Vector tagsV, File htmlCodeFile) throws IOException {
        String htmlStr = "";
        for (int i = 0; i < DBArr.length; ++i) {
            Vector<String> dataV = new Vector<String>();
            for (int j = 0; j < DBArr[i].length; ++j) {
                dataV.add(DBArr[i][j]);
            }
            htmlStr = htmlStr + this.parseOneRecord(tagsV, dataV, htmlCodeFile);
        }
        return htmlStr;
    }

    String parseOneRecord(Vector tagsV, Vector dataV, File htmlCodeFile) throws IOException {
        ParsedTextFile parser = new ParsedTextFile(htmlCodeFile, tagsV, dataV);
        String oneRecordsHtmlCode = parser.toString();
        return oneRecordsHtmlCode;
    }

    private Properties getShowDiscussionDaysParameters(HttpServletRequest req, Properties params) {
        if (params == null) {
            params = new Properties();
        }
        String newNbr = req.getParameter("NBR_OF_DAYS_TO_SHOW") == null ? "" : req.getParameter("NBR_OF_DAYS_TO_SHOW");
        String sectionId = req.getParameter("SECTION_ID") == null ? "" : req.getParameter("SECTION_ID");
        params.setProperty("SECTION_ID", sectionId);
        params.setProperty("NBR_OF_DAYS_TO_SHOW", newNbr);
        return params;
    }

    private Properties getShowDiscussionNbrParameters(HttpServletRequest req, Properties params) {
        if (params == null) {
            params = new Properties();
        }
        String newNbr = req.getParameter("NBR_OF_DISCS_TO_SHOW") == null ? "" : req.getParameter("NBR_OF_DISCS_TO_SHOW");
        String sectionId = req.getParameter("SECTION_ID") == null ? "" : req.getParameter("SECTION_ID");
        params.setProperty("SECTION_ID", sectionId);
        params.setProperty("NBR_OF_DISCS_TO_SHOW", newNbr);
        return params;
    }

    private Properties getAddSectionParameters(HttpServletRequest req, Properties params) {
        if (params == null) {
            params = new Properties();
        }
        String newSectionName = req.getParameter("NEW_SECTION_NAME") == null ? "" : req.getParameter("NEW_SECTION_NAME");
        params.setProperty("NEW_SECTION_NAME", newSectionName);
        return params;
    }

    private Properties getRenameSectionParameters(HttpServletRequest req, Properties params) {
        if (params == null) {
            params = new Properties();
        }
        String newConfName = req.getParameter("NEW_SECTION_NAME") == null ? "" : req.getParameter("NEW_SECTION_NAME");
        String renForumId = req.getParameter("SECTION_ID") == null ? "" : req.getParameter("SECTION_ID");
        params.setProperty("NEW_SECTION_NAME", newConfName);
        params.setProperty("SECTION_ID", renForumId);
        return params;
    }

    private Properties getDelSectionParameters(HttpServletRequest req, Properties params) {
        if (params == null) {
            params = new Properties();
        }
        String forumId = req.getParameter("SECTION_ID") == null ? "" : req.getParameter("SECTION_ID");
        params.setProperty("SECTION_ID", forumId);
        return params;
    }

    private String[] getDelDiscParameters(HttpServletRequest req) {
        String[] discId = req.getParameterValues("DISC_DEL_BOX");
        return discId;
    }

    private Properties getStandardParameters(HttpServletRequest req) {
        Properties reqParams = MetaInfo.createPropertiesFromMetaInfoParameters(super.getBillBoardSessionParameters(req));
        HttpSession session = req.getSession(false);
        if (session != null) {
            String sectionId = (String)session.getAttribute("BillBoard.section_id") == null ? "" : (String)session.getAttribute("BillBoard.section_id");
            String discId = (String)session.getAttribute("BillBoard.disc_id") == null ? "" : (String)session.getAttribute("BillBoard.disc_id");
            reqParams.setProperty("SECTION_ID", sectionId);
            reqParams.setProperty("DISC_ID", discId);
        }
        return reqParams;
    }

    private Vector buildAdminTags() {
        Vector<String> tagsV = new Vector<String>();
        tagsV.add("#DISC_DEL_ID#");
        tagsV.add("#HEADLINE#");
        tagsV.add("#COUNT_REPLIES#");
        tagsV.add("#ARCHIVE_DATE#");
        return tagsV;
    }

    public void log(String msg) {
        super.log("BillBoardAdmin: " + msg);
    }
}

