/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import imcode.server.Imcms;
import imcode.server.document.DocumentDomainObject;
import imcode.server.document.DocumentMapper;
import imcode.server.document.XmlDocumentBuilder;
import imcode.util.Utility;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.UnhandledException;
import org.w3c.dom.Document;

public class XmlDoc
extends HttpServlet {
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        int documentId = Integer.parseInt(request.getParameter("meta_id"));
        DocumentMapper documentMapper = Imcms.getServices().getDocumentMapper();
        DocumentDomainObject document = documentMapper.getDocument(documentId);
        if (null == document) {
            response.sendError(404);
        } else if (!Utility.getLoggedOnUser(request).canAccess(document)) {
            response.sendError(403);
        } else {
            XmlDocumentBuilder xmlDocumentBuilder = new XmlDocumentBuilder();
            xmlDocumentBuilder.addDocument(document);
            Document xmlDocument = xmlDocumentBuilder.getXmlDocument();
            this.outputXmlDocument(response, xmlDocument);
        }
    }

    private void outputXmlDocument(HttpServletResponse response, Document xmlDocument) throws IOException {
        response.setContentType("text/xml; charset=UTF-8");
        this.writeXmlDocumentToStream(xmlDocument, (OutputStream)response.getOutputStream());
    }

    private void writeXmlDocumentToStream(Document xmlDocument, OutputStream outputStream) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            StreamResult outputTarget = new StreamResult(outputStream);
            DOMSource xmlSource = new DOMSource(xmlDocument);
            transformer.transform(xmlSource, outputTarget);
        }
        catch (TransformerConfigurationException e) {
            throw new UnhandledException((Throwable)e);
        }
        catch (TransformerException e) {
            throw new UnhandledException((Throwable)e);
        }
    }
}

