/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.servlet;

import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.SystemData;
import imcode.server.user.UserDomainObject;
import imcode.util.Utility;
import imcode.util.net.SMTP;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SendMailServlet
extends HttpServlet {
    private static final String SUBJECT_TEMPLATE = "mail_subject.html";
    private static final String BODY_TEMPLATE = "mail_body.html";
    private static final String BODY_TEMPLATE_TO_ADMIN = "mail_body_to_admin.html";
    private static final String BODY_TEMPLATE_SHOP = "mail_body_shop.html";
    private static final int MAIL_TEXT_COUNT = 100;

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String mailBody;
        String sql;
        String metaId = req.getParameter("metaid");
        String param = req.getParameter("param");
        ImcmsServices imcref = Imcms.getServices();
        SystemData sysData = imcref.getSystemData();
        String webmaster = sysData.getWebMasterAddress();
        String mailTo = req.getParameter("mailTo");
        String mailFrom = req.getParameter("mailFrom");
        if (mailFrom == null) {
            mailFrom = webmaster;
        } else if (mailFrom.trim().equals("")) {
            mailFrom = webmaster;
        }
        String mailSubject = req.getParameter("mailSubject");
        String mailDone = req.getParameter("mailDone");
        String mailError = req.getParameter("mailError");
        String[] mailTextArr = new String[100];
        for (int i = 0; i < 100; ++i) {
            mailTextArr[i] = req.getParameter("mailText" + i) == null ? "" : req.getParameter("mailText" + i);
        }
        StringBuffer url = req.getRequestURL();
        StringTokenizer token = new StringTokenizer(url.toString(), "/", true);
        StringBuffer mailUrl = new StringBuffer();
        while (token.hasMoreElements()) {
            String temp = token.nextToken();
            mailUrl.append(temp);
            if (!temp.equals("servlet")) continue;
            break;
        }
        mailUrl.append("/GetDoc?meta_id=" + mailTextArr[0]);
        Vector<String> mailTextV = new Vector<String>();
        mailTextV.add("#mailSubject#");
        mailTextV.add(mailSubject);
        mailTextV.add("#mailLink#");
        mailTextV.add(mailUrl.toString());
        for (int i = 0; i < 100; ++i) {
            mailTextV.add("#mailText" + i + "#");
            mailTextV.add(mailTextArr[i]);
        }
        UserDomainObject user = Utility.getLoggedOnUser(req);
        if (param != null) {
            sql = "Select text from texts where name = 100 and meta_id = ?";
            mailTo = imcref.sqlQueryStr(sql, new String[]{metaId});
            mailTextV.add("#mailTo#");
            mailTextV.add(mailTo);
            mailTextV.add("#mailFrom#");
            mailTextV.add(mailFrom);
            mailBody = imcref.getAdminTemplate(BODY_TEMPLATE_SHOP, user, mailTextV);
        } else if (mailSubject != null) {
            sql = "Select text from texts \n where name = 100 \n and meta_id = ?";
            mailTo = imcref.sqlQueryStr(sql, new String[]{metaId});
            mailTextV.add("#mailTo#");
            mailTextV.add(mailTo);
            mailTextV.add("#mailFrom#");
            mailTextV.add(mailFrom);
            mailBody = imcref.getAdminTemplate(BODY_TEMPLATE_TO_ADMIN, user, mailTextV);
        } else {
            mailFrom = webmaster;
            mailTextV.add("#mailTo#");
            mailTextV.add(mailTo);
            mailTextV.add("#mailFrom#");
            mailTextV.add(mailFrom);
            mailSubject = imcref.getAdminTemplate(SUBJECT_TEMPLATE, user, mailTextV);
            mailBody = imcref.getAdminTemplate(BODY_TEMPLATE, user, mailTextV);
        }
        if (!this.validateEmail(mailFrom) || !this.validateEmail(mailTo)) {
            if (mailError != null) {
                res.sendRedirect("GetDoc?meta_id=" + mailError);
            } else {
                res.sendRedirect(req.getContextPath() + "/servlet/StartDoc");
            }
            return;
        }
        try {
            SMTP smtp = imcref.getSMTP();
            smtp.sendMail(new SMTP.Mail(mailFrom, new String[]{mailTo}, mailSubject, mailBody));
        }
        catch (ProtocolException ex) {
            this.log("Protocol error while sending mail. " + ex.getMessage());
            if (mailError != null) {
                res.sendRedirect("GetDoc?meta_id=" + mailError);
            } else {
                res.sendRedirect(req.getContextPath() + "/servlet/StartDoc");
            }
            return;
        }
        catch (IOException ex) {
            this.log("The mailservlet probably timed out. " + ex.getMessage());
            if (mailError != null) {
                res.sendRedirect("GetDoc?meta_id=" + mailError);
            } else {
                res.sendRedirect(req.getContextPath() + "/servlet/StartDoc");
            }
            return;
        }
        if (mailDone != null) {
            res.sendRedirect("GetDoc?meta_id=" + mailDone);
        }
    }

    public void log(String msg) {
        if (msg == null) {
            msg = "";
        }
        super.log(msg);
    }

    private boolean validateEmail(String eMail) {
        int stringLength = eMail.length();
        int indexAt = eMail.indexOf("@");
        return indexAt > 0 && indexAt < stringLength - 1;
    }
}

