/*
 * Decompiled with CFR 0.152.
 */
package com.imcode.imcms.api;

import com.imcode.imcms.api.ContentManagementSystemRunnable;
import com.imcode.imcms.api.DatabaseService;
import com.imcode.imcms.api.DefaultContentManagementSystem;
import com.imcode.imcms.api.DocumentService;
import com.imcode.imcms.api.MailService;
import com.imcode.imcms.api.NoPermissionException;
import com.imcode.imcms.api.SecurityChecker;
import com.imcode.imcms.api.TemplateService;
import com.imcode.imcms.api.User;
import com.imcode.imcms.api.UserService;
import imcode.server.Imcms;
import imcode.server.ImcmsServices;
import imcode.server.user.UserDomainObject;
import javax.servlet.ServletRequest;

public abstract class ContentManagementSystem {
    public abstract UserService getUserService();

    public abstract DocumentService getDocumentService();

    public abstract User getCurrentUser();

    public abstract DatabaseService getDatabaseService();

    public abstract TemplateService getTemplateService();

    public abstract MailService getMailService();

    public abstract void runAsSuperadmin(ContentManagementSystemRunnable var1) throws NoPermissionException;

    public static ContentManagementSystem getContentManagementSystem(String userName, String password) {
        ImcmsServices imcref = Imcms.getServices();
        UserDomainObject user = imcref.verifyUser(userName, password);
        DefaultContentManagementSystem cms = DefaultContentManagementSystem.create(imcref, user);
        return cms;
    }

    public static ContentManagementSystem fromRequest(ServletRequest request) {
        return (ContentManagementSystem)request.getAttribute("com.imcode.imcms.ImcmsSystem");
    }

    abstract ImcmsServices getInternal();

    abstract SecurityChecker getSecurityChecker();
}

