/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ddlutils.DynaSqlException;

public abstract class JdbcSupport {
    private final Log _log = LogFactory.getLog((Class)(class$org$apache$ddlutils$util$JdbcSupport == null ? (class$org$apache$ddlutils$util$JdbcSupport = JdbcSupport.class$("org.apache.ddlutils.util.JdbcSupport")) : class$org$apache$ddlutils$util$JdbcSupport));
    private DataSource _dataSource;
    private HashSet _openConnectionNames = new HashSet();
    static /* synthetic */ Class class$org$apache$ddlutils$util$JdbcSupport;

    public JdbcSupport() {
    }

    public JdbcSupport(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this._dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public Connection borrowConnection() throws DynaSqlException {
        try {
            Connection connection = this.getDataSource().getConnection();
            if (this._log.isDebugEnabled()) {
                String connName = connection.toString();
                this._log.debug((Object)("Borrowed connection " + connName + " from data source"));
                this._openConnectionNames.add(connName);
            }
            return connection;
        }
        catch (SQLException ex) {
            throw new DynaSqlException("Could not get a connection from the datasource", ex);
        }
    }

    public void returnConnection(Connection connection) {
        try {
            if (connection != null && !connection.isClosed()) {
                if (this._log.isDebugEnabled()) {
                    String connName = connection.toString();
                    this._openConnectionNames.remove(connName);
                    StringBuffer logMsg = new StringBuffer();
                    logMsg.append("Returning connection ");
                    logMsg.append(connName);
                    logMsg.append(" to data source.\nRemaining connections:");
                    if (this._openConnectionNames.isEmpty()) {
                        logMsg.append(" None");
                    } else {
                        Iterator it = this._openConnectionNames.iterator();
                        while (it.hasNext()) {
                            logMsg.append("\n    ");
                            logMsg.append(it.next().toString());
                        }
                    }
                    this._log.debug((Object)logMsg.toString());
                }
                connection.close();
            }
        }
        catch (Exception e) {
            this._log.warn((Object)"Caught exception while returning connection to pool", (Throwable)e);
        }
    }

    public void closeStatement(Statement statement) {
        if (statement != null) {
            try {
                Connection conn = statement.getConnection();
                if (conn != null && !conn.isClosed()) {
                    statement.close();
                }
            }
            catch (Exception e) {
                this._log.warn((Object)"Ignoring exception closing statement", (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

