/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.task.DatabaseCommand;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class WriteSchemaToDatabaseCommand
extends DatabaseCommand {
    private boolean _alterDb = true;
    private boolean _doDrops = true;

    protected boolean isAlterDatabase() {
        return this._alterDb;
    }

    public void setAlterDatabase(boolean alterTheDb) {
        this._alterDb = alterTheDb;
    }

    protected boolean isDoDrops() {
        return this._doDrops;
    }

    public void setDoDrops(boolean doDrops) {
        this._doDrops = doDrops;
    }

    public void execute(Task task, Database model) throws BuildException {
        if (this.getDataSource() == null) {
            throw new BuildException("No database specified.");
        }
        Platform platform = this.getPlatform();
        try {
            if (this.isAlterDatabase()) {
                platform.alterTables(model, this._doDrops, true, true);
            } else {
                platform.createTables(model, this._doDrops, true);
            }
            task.log("Written schema to database", 2);
        }
        catch (Exception ex) {
            if (this.isFailOnError()) {
                throw new BuildException((Throwable)ex);
            }
            task.log(ex.getLocalizedMessage(), 0);
        }
    }
}

