/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.io.JdbcModelReader;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.task.DatabaseCommand;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class WriteSchemaSqlToFileCommand
extends DatabaseCommand {
    private File _outputFile;
    private boolean _alterDb = true;
    private boolean _doDrops = true;

    public void setOutputFile(File outputFile) {
        this._outputFile = outputFile;
    }

    protected boolean isAlterDatabase() {
        return this._alterDb;
    }

    public void setAlterDatabase(boolean alterTheDb) {
        this._alterDb = alterTheDb;
    }

    protected boolean isDoDrops() {
        return this._doDrops;
    }

    public void setDoDrops(boolean doDrops) {
        this._doDrops = doDrops;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Task task, Database model) throws BuildException {
        if (this._outputFile == null) {
            throw new BuildException("No output file specified");
        }
        if (this._outputFile.exists() && !this._outputFile.canWrite()) {
            throw new BuildException("Cannot overwrite output file " + this._outputFile.getAbsolutePath());
        }
        Platform platform = this.getPlatform();
        Connection connection = null;
        try {
            FileWriter writer = new FileWriter(this._outputFile);
            platform.getSqlBuilder().setWriter(writer);
            if (this.isAlterDatabase()) {
                if (this.getDataSource() == null) {
                    throw new BuildException("No database specified.");
                }
                connection = this.getDataSource().getConnection();
                Database currentModel = new JdbcModelReader(connection).getDatabase();
                platform.getSqlBuilder().alterDatabase(currentModel, model, this._doDrops, true, this.getFilteredParameters(platform.getName()));
            } else {
                platform.getSqlBuilder().createTables(model, this._doDrops, this.getFilteredParameters(platform.getName()));
            }
            writer.close();
            task.log("Written SQL to " + this._outputFile.getAbsolutePath(), 2);
        }
        catch (Exception ex) {
            if (this.isFailOnError()) {
                throw new BuildException((Throwable)ex);
            }
            task.log(ex.getLocalizedMessage(), 0);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException ex) {}
            }
        }
    }
}

