/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils.task;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sql.DataSource;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.io.DataReader;
import org.apache.ddlutils.io.DataToDatabaseSink;
import org.apache.ddlutils.model.Database;
import org.apache.ddlutils.task.DatabaseCommand;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class WriteDataToSpecifiedDatabaseCommand
extends DatabaseCommand {
    private File _singleDataFile = null;
    private ArrayList _fileSets = new ArrayList();

    public void addConfiguredFileset(FileSet fileset) {
        this._fileSets.add(fileset);
    }

    public void setDataFile(File dataFile) {
        this._singleDataFile = dataFile;
    }

    public void execute(Task task, Database model) throws BuildException {
        if (this.getDataSource() == null) {
            throw new BuildException("No database specified.");
        }
        try {
            Platform platform = this.getPlatform();
            DataToDatabaseSink sink = new DataToDatabaseSink(platform, model);
            DataReader reader = new DataReader();
            platform.setDataSource((DataSource)this.getDataSource());
            reader.setModel(model);
            reader.setSink(sink);
            if (this._singleDataFile != null && !this._fileSets.isEmpty()) {
                throw new BuildException("Please use either the datafile attribute or the sub fileset element, but not both");
            }
            if (this._singleDataFile != null) {
                this.readSingleDataFile(task, reader, this._singleDataFile);
            } else {
                Iterator it = this._fileSets.iterator();
                while (it.hasNext()) {
                    FileSet fileSet = (FileSet)it.next();
                    File fileSetDir = fileSet.getDir(task.getProject());
                    DirectoryScanner scanner = fileSet.getDirectoryScanner(task.getProject());
                    String[] files = scanner.getIncludedFiles();
                    for (int idx = 0; files != null && idx < files.length; ++idx) {
                        this.readSingleDataFile(task, reader, new File(fileSetDir, files[idx]));
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new BuildException((Throwable)ex);
        }
    }

    private void readSingleDataFile(Task task, DataReader reader, File schemaFile) {
        if (!schemaFile.exists()) {
            task.log("Could not find data file " + schemaFile.getAbsolutePath(), 0);
        } else if (!schemaFile.isFile()) {
            task.log("Path " + schemaFile.getAbsolutePath() + " does not denote a data file", 0);
        } else if (!schemaFile.canRead()) {
            task.log("Could not read data file " + schemaFile.getAbsolutePath(), 0);
        } else {
            try {
                reader.parse(schemaFile);
                task.log("Read data file " + schemaFile.getAbsolutePath(), 2);
            }
            catch (Exception ex) {
                throw new BuildException("Could not read data file " + schemaFile.getAbsolutePath() + ": " + ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
    }
}

